/**
 * This module adds ajax display functions to the template library page.
 *
 * @module     tool_templatelibrary/display
 * @copyright  2015 Damyon Wiese <damyon@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("tool_templatelibrary/display",["jquery","core/ajax","core/log","core/notification","core/templates","core/config","core/str"],(function($,ajax,log,notification,templates,config,str){var findDocsSection=function(templateSource,templateName){if(!templateSource)return!1;var sections,marker="@template "+templateName,i=0;if(null!==(sections=templateSource.match(/{{!([\s\S]*?)}}/g)))for(i=0;i<sections.length;i++){var section=sections[i],start=section.indexOf(marker);if(-1!==start){var offset=start+marker.length+1;return section=section.substr(offset,section.length-2-offset)}}return!1},loadTemplate=function(templateName){var parts=templateName.split("/"),component=parts.shift(),name=parts.join("/"),promises=ajax.call([{methodname:"core_output_load_template",args:{component:component,template:name,themename:config.theme,includecomments:!0}},{methodname:"tool_templatelibrary_load_canonical_template",args:{component:component,template:name}}],!0,!1);$.when.apply($,promises).done((function(source,originalSource){!function(templateName,source,originalSource){str.get_string("templateselected","tool_templatelibrary",templateName).done((function(s){$('[data-region="displaytemplateheader"]').text(s)})).fail(notification.exception);var docs=findDocsSection(source,templateName);!1===docs&&(docs=findDocsSection(originalSource,templateName)),docs&&(source=docs),$('[data-region="displaytemplatesource"]').text(source);var example=source.match(/Example context \(json\):([\s\S]*)/),context=!1;if(example){var rawJSON=example[1].trim();try{context=$.parseJSON(rawJSON)}catch(e){log.debug("Could not parse json example context for template."),log.debug(e)}}context?templates.render(templateName,context).done((function(html,js){templates.replaceNodeContents($('[data-region="displaytemplateexample"]'),html,js)})).fail(notification.exception):str.get_string("templatehasnoexample","tool_templatelibrary").done((function(s){$('[data-region="displaytemplateexample"]').text(s)})).fail(notification.exception)}(templateName,source,originalSource)})).fail(notification.exception)};return $('[data-region="list-templates"]').on("click","[data-templatename]",(function(e){var templatename=$(this).data("templatename");e.preventDefault(),loadTemplate(templatename)})),{}}));

//# sourceMappingURL=display.min.js.map