<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Sesión Expirada - Escuela Porongo</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f8fafc;
            /* Usamos la misma imagen de fondo que tu panel */
            background-image: url('images/COLEGIO.jpg'); 
            background-size: cover; background-position: center;
            height: 100vh;
            margin: 0;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        /* Capa oscura para que se lea bien el texto */
        body::before {
            content: ""; position: fixed; inset: 0;
            background: rgba(15, 23, 42, 0.6); /* Un poco más oscuro que en el panel */
            z-index: -1;
        }

        .card-timeout {
            background: white;
            padding: 40px;
            border-radius: 16px;
            box-shadow: 0 10px 25px rgba(0,0,0,0.2);
            text-align: center;
            max-width: 400px;
            width: 90%;
            animation: fadeIn 0.5s ease;
        }

        .icon-timeout {
            font-size: 4rem;
            color: #f59e0b; /* Color naranja de alerta */
            margin-bottom: 20px;
        }

        h1 {
            color: #1e293b;
            font-size: 1.5rem;
            margin-bottom: 10px;
        }

        p {
            color: #64748b;
            margin-bottom: 30px;
            line-height: 1.5;
        }

        .btn-login {
            display: inline-block;
            background: #2563eb;
            color: white;
            padding: 12px 30px;
            border-radius: 8px;
            text-decoration: none;
            font-weight: 500;
            transition: all 0.3s ease;
        }

        .btn-login:hover {
            background: #1e40af;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(37, 99, 235, 0.3);
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
    </style>
</head>
<body>

    <div class="card-timeout">
        <div class="icon-timeout">
            <i class="fas fa-hourglass-end"></i>
        </div>
        <h1>Sesión Expirada</h1>
        <p>Tu sesión se ha cerrado automáticamente debido a un periodo de inactividad de 30 minutos por seguridad.</p>
        
        <a href="login.php" class="btn-login">
            <i class="fas fa-sign-in-alt"></i> Volver a Ingresar
        </a>
    </div>

</body>
</html>