<?php
session_start();
header('Content-Type: text/html; charset=utf-8');
include '../includes/db.php';
include '../includes/auth.php';
checkAuth();

$conn->set_charset("utf8");

// --- Función de Log (Tu código original) ---
function registrarActividad($conn, $usuario, $accion, $curso_id, $curso_nombre, $detalle = '', $ip_usuario = '') {
    $accion_completa = $accion;
    if ($detalle !== '') {
        $accion_completa .= ": " . $detalle;
    }
    $stmt = $conn->prepare("INSERT INTO registro_actividad (usuario, accion, curso_id, curso_nombre, fecha, ip_usuario) VALUES (?, ?, ?, ?, NOW(), ?)");
    $stmt->bind_param("ssiss", $usuario, $accion_completa, $curso_id, $curso_nombre, $ip_usuario);
    $stmt->execute();
    $stmt->close();
}
$usuario = $_SESSION['usuario'] ?? 'Desconocido';
$ip_usuario = $_SERVER['REMOTE_ADDR'] ?? 'Desconocida';

// AÑADIDO: Manejo de mensajes de sesión
$message = '';
$message_type = '';
if (isset($_SESSION['message'])) {
    $message = $_SESSION['message'];
    $message_type = $_SESSION['message_type'];
    unset($_SESSION['message'], $_SESSION['message_type']);
}

// Obtener nombre curso (movido al inicio)
$nombre_curso = '';
$curso_id = $_POST['curso_id'] ?? $_GET['curso_id'] ?? null;
if ($curso_id) {
    $curso_id = intval($curso_id);
    $stmt_curso = $conn->prepare("SELECT nombre FROM curso WHERE id = ?");
    $stmt_curso->bind_param("i", $curso_id);
    $stmt_curso->execute();
    $res_curso = $stmt_curso->get_result();
    $row_curso = $res_curso->fetch_assoc();
    $nombre_curso = $row_curso['nombre'] ?? '';
    $stmt_curso->close();
}

// --- Lógica POST (MODIFICADA para usar sesiones) ---

// Eliminar un solo indicador
if (isset($_POST['eliminar_indicador'])) {
    $indicador_id = intval($_POST['indicador_id']); // El ID de la *fila* en notas_indicadores
    
    // ... (Tu lógica de log) ...
    $stmt_info = $conn->prepare("SELECT i.nombre AS indicador_nombre, a.nombre AS asignatura_nombre FROM notas_indicadores ni JOIN indicadores i ON ni.indicador_id = i.id JOIN asignatura a ON ni.asignatura_id = a.id WHERE ni.id = ?");
    $stmt_info->bind_param("i", $indicador_id); $stmt_info->execute(); $stmt_info->bind_result($indicador_nombre, $asignatura_nombre); $stmt_info->fetch(); $stmt_info->close();
    
    $stmt = $conn->prepare("DELETE FROM notas_indicadores WHERE id = ?");
    $stmt->bind_param("i", $indicador_id);
    if ($stmt->execute()) {
        $_SESSION['message'] = "Indicador eliminado exitosamente.";
        $_SESSION['message_type'] = "exito";
        $detalle = "Indicador \"$indicador_nombre\" (Asignatura: \"$asignatura_nombre\") eliminado";
        registrarActividad($conn, $usuario, "Eliminó un indicador individual", $curso_id, $nombre_curso, $detalle, $ip_usuario);
    } else {
        $_SESSION['message'] = "Error al eliminar el indicador: " . $stmt->error;
        $_SESSION['message_type'] = "error";
    }
    $stmt->close();
    header("Location: gestion_notas_indicadores.php?alumno_id={$_POST['alumno_id']}&curso_id={$_POST['curso_id']}");
    exit();
}

// Eliminar múltiples indicadores
if (isset($_POST['eliminar_multiples_indicadores']) && !empty($_POST['indicadores_a_eliminar'])) {
    $indicadores = array_map('intval', $_POST['indicadores_a_eliminar']);
    $placeholders = implode(',', array_fill(0, count($indicadores), '?'));
    $types = str_repeat('i', count($indicadores));
    
    // ... (Tu lógica de log) ...
    $stmt_info = $conn->prepare("SELECT i.nombre AS indicador_nombre, a.nombre AS asignatura_nombre FROM notas_indicadores ni JOIN indicadores i ON ni.indicador_id = i.id JOIN asignatura a ON ni.asignatura_id = a.id WHERE ni.id IN ($placeholders)");
    $stmt_info->bind_param($types, ...$indicadores); $stmt_info->execute(); $result_info = $stmt_info->get_result(); $detalles = []; while ($row = $result_info->fetch_assoc()) { $detalles[] = $row['indicador_nombre'] . " (Asignatura: " . $row['asignatura_nombre'] . ")"; } $stmt_info->close();

    $stmt = $conn->prepare("DELETE FROM notas_indicadores WHERE id IN ($placeholders)");
    $stmt->bind_param($types, ...$indicadores);
    if ($stmt->execute()) {
        $_SESSION['message'] = "Indicadores seleccionados eliminados.";
        $_SESSION['message_type'] = "exito";
        $detalle = "Indicadores eliminados: " . implode(", ", $detalles);
        registrarActividad($conn, $usuario, "Eliminó múltiples indicadores", $curso_id, $nombre_curso, $detalle, $ip_usuario);
    } else {
        $_SESSION['message'] = "Error al eliminar indicadores: " . $stmt->error;
        $_SESSION['message_type'] = "error";
    }
    $stmt->close();
    header("Location: gestion_notas_indicadores.php?alumno_id={$_POST['alumno_id']}&curso_id={$_POST['curso_id']}");
    exit();
}

// Editar indicador
if (isset($_POST['editar_indicador'])) {
    $indicador_id = intval($_POST['indicador_id']); // ID de la fila en notas_indicadores
    $nuevo_indicador_id = intval($_POST['nuevo_indicador_id']); // ID del indicador (MB, B, S, I)
    $nueva_nota = intval($_POST['numero_nota']);
    
    // ... (Tu lógica de log) ...
    $stmt_info = $conn->prepare("SELECT i.nombre AS indicador_actual, a.nombre AS asignatura_nombre FROM notas_indicadores ni JOIN indicadores i ON ni.indicador_id = i.id JOIN asignatura a ON ni.asignatura_id = a.id WHERE ni.id = ?");
    $stmt_info->bind_param("i", $indicador_id); $stmt_info->execute(); $stmt_info->bind_result($indicador_actual, $asignatura_nombre); $stmt_info->fetch(); $stmt_info->close();
    $stmt_nuevo = $conn->prepare("SELECT nombre FROM indicadores WHERE id = ?");
    $stmt_nuevo->bind_param("i", $nuevo_indicador_id); $stmt_nuevo->execute(); $stmt_nuevo->bind_result($nuevo_indicador_nombre); $stmt_nuevo->fetch(); $stmt_nuevo->close();

    $stmt = $conn->prepare("UPDATE notas_indicadores SET indicador_id = ?, numero_nota = ? WHERE id = ?");
    $stmt->bind_param("iii", $nuevo_indicador_id, $nueva_nota, $indicador_id);
    if ($stmt->execute()) {
        $_SESSION['message'] = "Indicador actualizado correctamente.";
        $_SESSION['message_type'] = "exito";
        $detalle = "Indicador editado de \"$indicador_actual\" a \"$nuevo_indicador_nombre\" con nota N°$nueva_nota (Asig: \"$asignatura_nombre\")";
        registrarActividad($conn, $usuario, "Editó un indicador", $curso_id, $nombre_curso, $detalle, $ip_usuario);
    } else {
        $_SESSION['message'] = "Error al actualizar el indicador: " . $stmt->error;
        $_SESSION['message_type'] = "error";
    }
    $stmt->close();
    header("Location: gestion_notas_indicadores.php?alumno_id={$_POST['alumno_id']}&curso_id={$_POST['curso_id']}");
    exit();
}

// --- Lógica GET y de Selección ---
$curso_seleccionado = false;
$alumno_seleccionado = false;
$alumno_id = null;

if (isset($_POST['curso_id'])) {
    $curso_id = intval($_POST['curso_id']);
    $curso_seleccionado = true;
} elseif (isset($_GET['curso_id'])) {
    $curso_id = intval($_GET['curso_id']);
    $curso_seleccionado = true;
}

if (isset($_GET['alumno_id']) && $curso_id) {
    $alumno_id = intval($_GET['alumno_id']);
    $alumno_seleccionado = true;
}

// Obtener indicadores (para el modal)
$indicadores_select = $conn->query("SELECT id, nombre FROM indicadores");
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <link rel="icon" type="image/png" href="../images/logo.png">
    <title>Gestión de Notas por Indicadores</title>

    <link rel="stylesheet" href="../css/admin.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">

    <style>
        .modal-backdrop {
            position: fixed; top: 0; left: 0;
            width: 100%; height: 100%;
            background-color: rgba(0, 0, 0, 0.6);
            z-index: 1040;
            display: none;
        }
        .modal {
            position: fixed; top: 50%; left: 50%;
            transform: translate(-50%, -50%);
            width: 90%;
            max-width: 500px;
            background-color: #fff;
            border-radius: var(--border-radius);
            box-shadow: 0 5px 15px rgba(0,0,0,0.5);
            z-index: 1050;
            display: none;
            flex-direction: column;
        }
        .modal-header {
            padding: 1rem 1.5rem;
            border-bottom: 1px solid var(--grey-medium);
            display: flex; justify-content: space-between; align-items: center;
            background-color: var(--primary-color);
            color: var(--light-color);
            border-top-left-radius: var(--border-radius);
            border-top-right-radius: var(--border-radius);
        }
        .modal-header h2 { margin: 0; font-size: 1.25rem; color: var(--light-color); }
        .modal-close-btn { background: none; border: none; font-size: 1.5rem; color: var(--light-color); cursor: pointer; line-height: 1; }
        .modal-body { padding: 1.5rem; }
        .modal-footer {
            padding: 1rem 1.5rem;
            border-top: 1px solid var(--grey-medium);
            display: flex; justify-content: flex-end; gap: 0.75rem;
            background-color: var(--grey-light);
            border-bottom-left-radius: var(--border-radius);
            border-bottom-right-radius: var(--border-radius);
        }
        .modal.show, .modal-backdrop.show {
            display: flex;
        }
        .indicadores-table td .btn {
            margin-right: 5px;
        }
    </style>
</head>
<body>
    
<header>
    <div class="header-content">
        <img src="../images/INSIGNIA SF.png" alt="Escuela Porongo Insignia">
        <h1>Gestión de Indicadores</h1>
        <nav>
            <ul>
                <li><a href="../index.php"><i class="fas fa-home"></i> Inicio</a></li>
                <li><a href="gestion_notas.php"><i class="fas fa-edit"></i> Gestionar Notas</a></li>
            </ul>
        </nav>
    </div>
</header>
    
<main class="container">

    <?php if ($message): ?>
        <div class="mensaje <?php echo $message_type; ?> show">
            <?php echo htmlspecialchars($message, ENT_QUOTES, 'UTF-8'); ?>
        </div>
    <?php endif; ?>

    <div class="card form-container">
        <h2><i class="fas fa-filter"></i> 1. Seleccionar Curso</h2>
        <form method="POST" action="gestion_notas_indicadores.php">
            <div class="form-group">
                <label for="curso_id"><i class="fas fa-university"></i> Curso:</label>
                <select name="curso_id" id="curso_id" required>
                    <option value="">Seleccione un curso</option>
                    <?php
                    $result_cursos = $conn->query("SELECT id, nombre FROM curso ORDER BY nombre");
                    while ($curso_item = $result_cursos->fetch_assoc()) {
                        $selected = ($curso_item['id'] == $curso_id) ? 'selected' : '';
                        echo "<option value='{$curso_item['id']}' $selected>{$curso_item['nombre']}</option>";
                    }
                    ?>
                </select>
            </div>
            <div class="form-buttons">
                <button type="submit" class="btn btn-primary"><i class="fas fa-users"></i> Ver Alumnos</button>
            </div>
        </form>
    </div>

    <?php if ($curso_seleccionado && !$alumno_seleccionado): ?>
        <div class="card table-container" style="margin-top: 2rem;">
            <h2><i class="fas fa-user-graduate"></i> 2. Alumnos del Curso: <?php echo htmlspecialchars($nombre_curso); ?></h2>
            <?php
            $stmt = $conn->prepare("SELECT u.id, u.nombre, u.apellido_paterno, u.apellido_materno 
                                    FROM usuario u 
                                    JOIN roles r ON u.rol_id = r.id 
                                    WHERE u.curso_id = ? AND r.nombre = 'estudiante' 
                                    ORDER BY u.apellido_paterno, u.apellido_materno, u.nombre");
            $stmt->bind_param("i", $curso_id);
            $stmt->execute();
            $alumnos = $stmt->get_result();
            ?>
            <div class="table-responsive">
                <table>
                    <thead>
                        <tr>
                            <th>Nombre del Alumno</th>
                            <th class="actions">Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if ($alumnos->num_rows > 0): ?>
                            <?php while ($alumno = $alumnos->fetch_assoc()): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars("{$alumno['apellido_paterno']} {$alumno['apellido_materno']}, {$alumno['nombre']}"); ?></td>
                                    <td class="actions">
                                        <a href="?alumno_id=<?php echo $alumno['id']; ?>&curso_id=<?php echo $curso_id; ?>" class="btn btn-primary btn-sm">
                                            <i class="fas fa-eye"></i> Ver Indicadores
                                        </a>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="2" style="text-align: center;">No se encontraron alumnos para este curso.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    <?php endif; ?>

    <?php if ($alumno_seleccionado): ?>
        <?php
        $stmt_alumno = $conn->prepare("SELECT CONCAT(usuario.nombre, ' ', usuario.apellido_paterno, ' ', usuario.apellido_materno) AS nombre_completo, curso.nombre AS curso 
                                 FROM usuario 
                                 JOIN curso ON usuario.curso_id = curso.id 
                                 WHERE usuario.id = ?");
        $stmt_alumno->bind_param("i", $alumno_id);
        $stmt_alumno->execute();
        $info_alumno = $stmt_alumno->get_result()->fetch_assoc();
        ?>
        <div class="card table-container" style="margin-top: 2rem;">
            <h2><i class="fas fa-clipboard-list"></i> Indicadores de: <?php echo htmlspecialchars($info_alumno['nombre_completo']); ?></h2>
            <p style="color: var(--grey-dark); margin-top: -0.5rem; margin-bottom: 1rem;">Curso: <?php echo htmlspecialchars($info_alumno['curso']); ?></p>

            <form method="POST" onsubmit="return confirm('¿Eliminar los indicadores seleccionados?');">
                <input type="hidden" name="alumno_id" value="<?php echo $alumno_id; ?>">
                <input type="hidden" name="curso_id" value="<?php echo $curso_id; ?>">
                
                <div class="table-responsive">
                    <table class="indicadores-table">
                        <thead>
                            <tr>
                                <th><input type="checkbox" onclick="toggleSeleccionMasiva(this)" title="Seleccionar todo"></th>
                                <th>Asignatura</th>
                                <th>Indicador</th>
                                <th>Semestre</th>
                                <th>N° Nota</th>
                                <th class="actions">Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $query_notas = "SELECT ni.id, a.nombre AS asignatura, i.nombre AS indicador, ni.numero_nota, ni.semestre 
                                            FROM notas_indicadores ni 
                                            JOIN asignatura a ON ni.asignatura_id = a.id 
                                            JOIN indicadores i ON ni.indicador_id = i.id  
                                            WHERE ni.usuario_id = ? AND (ni.asignatura_id = 9 OR ni.asignatura_id = 10) 
                                            ORDER BY a.nombre, ni.semestre, ni.numero_nota";
                            $stmt_notas = $conn->prepare($query_notas);
                            $stmt_notas->bind_param("i", $alumno_id);
                            $stmt_notas->execute();
                            $result_notas = $stmt_notas->get_result();

                            if ($result_notas->num_rows > 0):
                                while ($nota = $result_notas->fetch_assoc()):
                            ?>
                                <tr>
                                    <td><input type="checkbox" name="indicadores_a_eliminar[]" value="<?php echo $nota['id']; ?>"></td>
                                    <td><?php echo htmlspecialchars($nota['asignatura']); ?></td>
                                    <td><?php echo htmlspecialchars($nota['indicador']); ?></td>
                                    <td><?php echo htmlspecialchars($nota['semestre']); ?></td>
                                    <td><?php echo htmlspecialchars($nota['numero_nota']); ?></td>
                                    <td class="actions">
                                        <button type="button" class="btn btn-edit btn-sm" onclick="openEditModal(<?php echo $nota['id']; ?>, <?php echo $nota['numero_nota']; ?>)" title="Editar">
                                            <i class="fas fa-pencil-alt"></i>
                                        </button>
                                        <button type="button" class="btn btn-danger btn-sm" onclick="openDeleteModal(<?php echo $nota['id']; ?>)" title="Eliminar">
                                            <i class="fas fa-trash-alt"></i>
                                        </button>
                                    </td>
                                </tr>
                            <?php 
                                endwhile;
                            else: 
                            ?>
                                <tr><td colspan="6" style="text-align: center;">No hay indicadores registrados para este alumno.</td></tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <div class="form-buttons" style="margin-top: 1.5rem; justify-content: flex-start;">
                    <button type="submit" name="eliminar_multiples_indicadores" class="btn btn-danger">
                        <i class="fas fa-trash-alt"></i> Eliminar Seleccionados
                    </button>
                </div>
            </form>
        </div>
    <?php endif; ?>
</main>

<div id="editModal" class="modal">
    <div class="modal-content">
        <form method="POST">
            <div class="modal-header">
                <h2><i class="fas fa-edit"></i> Editar Indicador</h2>
                <button type="button" class="modal-close-btn" onclick="closeModal('editModal')">&times;</button>
            </div>
            <div class="modal-body">
                <input type="hidden" name="indicador_id" id="modal_indicador_id">
                <input type="hidden" name="alumno_id" value="<?php echo $alumno_id; ?>">
                <input type="hidden" name="curso_id" value="<?php echo $curso_id; ?>">
                
                <div class="form-group">
                    <label for="nuevo_indicador_id"><i class="fas fa-tag"></i> Indicador:</label>
                    <select name="nuevo_indicador_id" id="nuevo_indicador_id" required>
                        <?php
                        $indicadores_select->data_seek(0);
                        while ($ind = $indicadores_select->fetch_assoc()) {
                            echo "<option value='{$ind['id']}'>{$ind['nombre']}</option>";
                        }
                        ?>
                    </select>
                </div>
                <div class="form-group">
                    <label for="numero_nota"><i class="fas fa-hashtag"></i> Número de Nota:</label>
                    <input type="number" min="1" max="10" name="numero_nota" id="numero_nota" required>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="closeModal('editModal')">Cancelar</button>
                <button type="submit" name="editar_indicador" class="btn btn-primary"><i class="fas fa-save"></i> Actualizar</button>
            </div>
        </form>
    </div>
</div>

<div id="deleteModal" class="modal">
    <div class="modal-content">
        <form method="POST">
            <div class="modal-header" style="background-color: var(--danger-color);">
                <h2><i class="fas fa-exclamation-triangle"></i> Eliminar Indicador</h2>
                <button type="button" class="modal-close-btn" onclick="closeModal('deleteModal')">&times;</button>
            </div>
            <div class="modal-body">
                <input type="hidden" name="indicador_id" id="delete_indicador_id">
                <input type="hidden" name="alumno_id" value="<?php echo $alumno_id; ?>">
                <input type="hidden" name="curso_id" value="<?php echo $curso_id; ?>">
                <p>¿Estás seguro de que deseas eliminar este indicador? Esta acción es irreversible.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="closeModal('deleteModal')">Cancelar</button>
                <button type="submit" name="eliminar_indicador" class="btn btn-danger"><i class="fas fa-trash-alt"></i> Sí, Eliminar</button>
            </div>
        </form>
    </div>
</div>

<div class="modal-backdrop" id="modalBackdrop"></div>

<script>
    const editModal = document.getElementById("editModal");
    const deleteModal = document.getElementById("deleteModal");
    const backdrop = document.getElementById("modalBackdrop");

    function openModal(modalId) {
        document.getElementById(modalId).classList.add('show');
        backdrop.classList.add('show');
    }
    function closeModal(modalId) {
        document.getElementById(modalId).classList.remove('show');
        backdrop.classList.remove('show');
    }

    function openEditModal(id, numero) {
        document.getElementById('modal_indicador_id').value = id;
        document.getElementById('numero_nota').value = numero;
        // Aquí podrías preseleccionar el indicador si tuvieras el ID, pero lo dejaremos simple por ahora
        openModal('editModal');
    }
    
    function openDeleteModal(id) {
        document.getElementById('delete_indicador_id').value = id;
        openModal('deleteModal');
    }

    backdrop.addEventListener('click', function() {
        closeModal('editModal');
        closeModal('deleteModal');
    });

    function toggleSeleccionMasiva(source) {
        const checkboxes = document.querySelectorAll('input[name="indicadores_a_eliminar[]"]');
        checkboxes.forEach(cb => cb.checked = source.checked);
    }
    
    // AÑADIDO: Script de mensajes de sesión
    window.onload = function() {
        const message = document.querySelector('.mensaje');
        if (message) {
            setTimeout(() => {
                message.classList.remove('show');
            }, 3000);
        }
    };
</script>
</body>
</html>
<?php
$conn->close();
?>