<?php
session_start();
header('Content-Type: text/html; charset=utf-8'); 
include '../includes/db.php'; 
include '../includes/auth.php'; 
checkAuth(); 

$conn->set_charset("utf8");

// --- Función de Log (Tu código original) ---
function registrarAccion($usuario, $accion, $curso_id, $curso_nombre, $ip_usuario) {
    global $conn;
    $stmt = $conn->prepare("INSERT INTO registro_actividad (usuario, curso_id, curso_nombre, accion, fecha, ip_usuario) VALUES (?, ?, ?, ?, NOW(), ?)");
    $stmt->bind_param("sisss", $usuario, $curso_id, $curso_nombre, $accion, $ip_usuario);
    $stmt->execute();
    $stmt->close();
}
$usuario_log = $_SESSION['nombre'] ?? 'Desconocido';
$ip_usuario = $_SERVER['REMOTE_ADDR'] ?? 'Desconocida';

// AÑADIDO: Manejo de mensajes de sesión
$message = '';
$message_type = '';
if (isset($_SESSION['message'])) {
    $message = $_SESSION['message'];
    $message_type = $_SESSION['message_type'];
    unset($_SESSION['message'], $_SESSION['message_type']);
}

// Obtener nombre curso (movido al inicio)
$nombre_curso = '';
$curso_id = $_POST['curso_id'] ?? $_GET['curso_id'] ?? null;
if ($curso_id) {
    $curso_id = intval($curso_id);
    $stmt_curso = $conn->prepare("SELECT nombre FROM curso WHERE id = ?");
    $stmt_curso->bind_param("i", $curso_id);
    $stmt_curso->execute();
    $res_curso = $stmt_curso->get_result();
    $row_curso = $res_curso->fetch_assoc();
    $nombre_curso = $row_curso['nombre'] ?? '';
    $stmt_curso->close();
}

// --- Lógica POST (MODIFICADA para usar sesiones) ---

// Eliminar nota individual
if (isset($_POST['eliminar_nota'])) {
    $nota_id = intval($_POST['nota_id']);
    // ... (Tu lógica de log de asignatura) ...
    $stmt_asig = $conn->prepare("SELECT asignatura.nombre FROM notas JOIN asignatura ON notas.asignatura_id = asignatura.id WHERE notas.id = ?");
    $stmt_asig->bind_param("i", $nota_id); $stmt_asig->execute(); $stmt_asig->bind_result($nombre_asignatura); $stmt_asig->fetch(); $stmt_asig->close();
    
    $stmt = $conn->prepare("DELETE FROM notas WHERE id = ?");
    $stmt->bind_param("i", $nota_id);
    if ($stmt->execute()) {
        $_SESSION['message'] = "Nota eliminada exitosamente.";
        $_SESSION['message_type'] = "exito";
        $accion = "Eliminó nota con ID $nota_id en asignatura \"$nombre_asignatura\" del curso \"$nombre_curso\"";
        registrarAccion($usuario_log, $accion, $curso_id, $nombre_curso, $ip_usuario);
    } else {
        $_SESSION['message'] = "Error al eliminar la nota: " . $stmt->error;
        $_SESSION['message_type'] = "error";
    }
    $stmt->close();
    header("Location: gestion_notas.php?alumno_id={$_POST['alumno_id']}&curso_id={$_POST['curso_id']}");
    exit();
}

// Eliminar múltiples notas
if (isset($_POST['eliminar_multiples_notas'])) {
    $notas_a_eliminar = $_POST['notas_a_eliminar'] ?? [];
    if (!empty($notas_a_eliminar)) {
        $ids = implode(',', array_map('intval', $notas_a_eliminar));
        // ... (Tu lógica de log de asignaturas) ...
        $query_asig = "SELECT asignatura.nombre FROM notas JOIN asignatura ON notas.asignatura_id = asignatura.id WHERE notas.id IN ($ids)";
        $result_asig = $conn->query($query_asig); $asignaturas_eliminadas = []; while ($row = $result_asig->fetch_assoc()) { $asignaturas_eliminadas[] = $row['nombre']; }
        $lista_asignaturas = implode(', ', array_unique($asignaturas_eliminadas));
        
        $query = "DELETE FROM notas WHERE id IN ($ids)";
        if ($conn->query($query)) {
            $_SESSION['message'] = "Notas seleccionadas eliminadas exitosamente.";
            $_SESSION['message_type'] = "exito";
            $accion = "Eliminó múltiples notas [$ids] en asignaturas [$lista_asignaturas] del curso \"$nombre_curso\"";
            registrarAccion($usuario_log, $accion, $curso_id, $nombre_curso, $ip_usuario);
        } else {
            $_SESSION['message'] = "Error al eliminar las notas: " . $conn->error;
            $_SESSION['message_type'] = "error";
        }
        header("Location: gestion_notas.php?alumno_id={$_POST['alumno_id']}&curso_id={$_POST['curso_id']}");
        exit();
    }
}

// Actualizar una nota
if (isset($_POST['editar_nota'])) {
    $nota_id = intval($_POST['nota_id']);
    $nueva_nota = floatval($_POST['nueva_nota']); // Asumir que la validación se hace en el modal/JS
    // ... (Tu lógica de log de asignatura) ...
    $stmt_asig = $conn->prepare("SELECT asignatura.nombre FROM notas JOIN asignatura ON notas.asignatura_id = asignatura.id WHERE notas.id = ?");
    $stmt_asig->bind_param("i", $nota_id); $stmt_asig->execute(); $stmt_asig->bind_result($nombre_asignatura); $stmt_asig->fetch(); $stmt_asig->close();
    
    $stmt = $conn->prepare("UPDATE notas SET nota = ? WHERE id = ?");
    $stmt->bind_param("di", $nueva_nota, $nota_id);
    if ($stmt->execute()) {
        $_SESSION['message'] = "Nota actualizada exitosamente.";
        $_SESSION['message_type'] = "exito";
        $accion = "Editó nota ID $nota_id a $nueva_nota en asignatura \"$nombre_asignatura\" del curso \"$nombre_curso\"";
        registrarAccion($usuario_log, $accion, $curso_id, $nombre_curso, $ip_usuario);
    } else {
        $_SESSION['message'] = "Error al actualizar la nota: " . $stmt->error;
        $_SESSION['message_type'] = "error";
    }
    $stmt->close();
    header("Location: gestion_notas.php?alumno_id={$_POST['alumno_id']}&curso_id={$_POST['curso_id']}");
    exit();
}

// --- Lógica GET y de Selección ---
$curso_seleccionado = false;
$alumno_seleccionado = false;
$alumno_id = null;

if (isset($_POST['curso_id'])) {
    $curso_id = intval($_POST['curso_id']);
    $curso_seleccionado = true;
} elseif (isset($_GET['curso_id'])) {
    $curso_id = intval($_GET['curso_id']);
    $curso_seleccionado = true;
}

if (isset($_GET['alumno_id']) && $curso_id) {
    $alumno_id = intval($_GET['alumno_id']);
    $alumno_seleccionado = true;
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="../images/logo.png">
    <title>Gestión de Notas</title>
    
    <link rel="stylesheet" href="../css/admin.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">

    <style>
        .modal-backdrop {
            position: fixed; top: 0; left: 0;
            width: 100%; height: 100%;
            background-color: rgba(0, 0, 0, 0.6);
            z-index: 1040;
            display: none;
        }
        .modal {
            position: fixed; top: 50%; left: 50%;
            transform: translate(-50%, -50%);
            width: 90%;
            max-width: 500px;
            background-color: #fff;
            border-radius: var(--border-radius);
            box-shadow: 0 5px 15px rgba(0,0,0,0.5);
            z-index: 1050;
            display: none;
            flex-direction: column;
        }
        .modal-header {
            padding: 1rem 1.5rem;
            border-bottom: 1px solid var(--grey-medium);
            display: flex; justify-content: space-between; align-items: center;
            background-color: var(--primary-color);
            color: var(--light-color);
            border-top-left-radius: var(--border-radius);
            border-top-right-radius: var(--border-radius);
        }
        .modal-header h2 { margin: 0; font-size: 1.25rem; color: var(--light-color); }
        .modal-close-btn { background: none; border: none; font-size: 1.5rem; color: var(--light-color); cursor: pointer; line-height: 1; }
        .modal-body { padding: 1.5rem; }
        .modal-footer {
            padding: 1rem 1.5rem;
            border-top: 1px solid var(--grey-medium);
            display: flex; justify-content: flex-end; gap: 0.75rem;
            background-color: var(--grey-light);
            border-bottom-left-radius: var(--border-radius);
            border-bottom-right-radius: var(--border-radius);
        }
        .modal.show, .modal-backdrop.show {
            display: flex;
        }
        /* Estilo para la tabla de notas */
        .notas-table td .btn {
            margin-right: 5px;
        }
    </style>
</head>
<body>
    
<header>
    <div class="header-content">
        <img src="../images/INSIGNIA SF.png" alt="Insignia del Colegio">
        <h1>Gestión de Notas</h1>
        <nav>
            <ul>
                <li><a href="../index.php"><i class="fas fa-home"></i> Inicio</a></li>
                <li><a href="gestion_notas_indicadores.php"><i class="fas fa-tags"></i> Gestionar Indicadores</a></li>
            </ul>
        </nav>
    </div>
</header>
    
<main class="container">
    
    <?php if ($message): ?>
        <div class="mensaje <?php echo $message_type; ?> show">
            <?php echo htmlspecialchars($message, ENT_QUOTES, 'UTF-8'); ?>
        </div>
    <?php endif; ?>

    <div class="card form-container">
        <h2><i class="fas fa-filter"></i> 1. Seleccionar Curso</h2>
        <form method="POST" action="gestion_notas.php">
            <div class="form-group">
                <label for="curso_id"><i class="fas fa-university"></i> Curso:</label>
                <select name="curso_id" id="curso_id" required>
                    <option value="">Seleccione un curso</option>
                    <?php
                    $query_cursos = "SELECT id, nombre FROM curso ORDER BY nombre";
                    $result_cursos = $conn->query($query_cursos);
                    while ($curso_item = $result_cursos->fetch_assoc()) {
                        $selected = ($curso_item['id'] == $curso_id) ? 'selected' : '';
                        echo "<option value='{$curso_item['id']}' $selected>{$curso_item['nombre']}</option>";
                    }
                    ?>
                </select>
            </div>
            <div class="form-buttons">
                <button type="submit" class="btn btn-primary"><i class="fas fa-users"></i> Ver Alumnos</button>
            </div>
        </form>
    </div>

    <?php if ($curso_seleccionado && !$alumno_seleccionado): ?>
        <div class="card table-container" style="margin-top: 2rem;">
            <h2><i class="fas fa-user-graduate"></i> 2. Alumnos del Curso: <?php echo htmlspecialchars($nombre_curso); ?></h2>
            
            <div class="table-responsive">
                <table>
                    <thead>
                        <tr>
                            <th>Nombre del Alumno</th>
                            <th class="actions">Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $query = "SELECT u.id, u.nombre, u.apellido_paterno, u.apellido_materno 
                                  FROM usuario u 
                                  JOIN roles r ON u.rol_id = r.id 
                                  WHERE u.curso_id = ? AND r.nombre = 'estudiante' 
                                  ORDER BY u.apellido_paterno, u.apellido_materno, u.nombre";
                        $stmt_alumnos = $conn->prepare($query);
                        $stmt_alumnos->bind_param("i", $curso_id);
                        $stmt_alumnos->execute();
                        $alumnos = $stmt_alumnos->get_result();
                        
                        if ($alumnos->num_rows > 0): 
                            while ($alumno = $alumnos->fetch_assoc()):
                        ?>
                            <tr>
                                <td><?php echo htmlspecialchars($alumno['apellido_paterno'] . ' ' . $alumno['apellido_materno'] . ', ' . $alumno['nombre']); ?></td>
                                <td class="actions">
                                    <a href="gestion_notas.php?alumno_id=<?php echo $alumno['id']; ?>&curso_id=<?php echo $curso_id; ?>" class="btn btn-primary btn-sm">
                                        <i class="fas fa-eye"></i> Ver Notas
                                    </a>
                                </td>
                            </tr>
                        <?php 
                            endwhile;
                        else: 
                        ?>
                            <tr>
                                <td colspan="2" style="text-align: center;">No se encontraron alumnos para este curso.</td>
                            </tr>
                        <?php 
                        endif;
                        $stmt_alumnos->close(); 
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    <?php endif; ?>

    <?php if ($alumno_seleccionado): ?>
        <?php
        
        // --- *** CORRECCIÓN DEL BUG AQUÍ *** ---
        $stmt_alumno = $conn->prepare("SELECT CONCAT(usuario.nombre, ' ', usuario.apellido_paterno, ' ', usuario.apellido_materno) AS nombre_completo, curso.nombre as curso 
                                         FROM usuario 
                                         JOIN curso ON usuario.curso_id = curso.id 
                                         WHERE usuario.id = ?");
        // --- *** FIN DE LA CORRECCIÓN *** ---
                                         
        $stmt_alumno->bind_param('i', $alumno_id);
        $stmt_alumno->execute();
        $alumno = $stmt_alumno->get_result()->fetch_assoc();
        $stmt_alumno->close();

        $query_notas = "SELECT notas.id AS nota_id, asignatura.nombre AS asignatura, notas.nota, notas.numero_nota, notas.semestre 
                        FROM notas 
                        JOIN asignatura ON notas.asignatura_id = asignatura.id 
                        WHERE notas.usuario_id = ?
                        ORDER BY asignatura.nombre, notas.semestre, notas.numero_nota";
        $stmt_notas = $conn->prepare($query_notas);
        $stmt_notas->bind_param("i", $alumno_id);
        $stmt_notas->execute();
        $notas = $stmt_notas->get_result();
        ?>

        <div class="card table-container" style="margin-top: 2rem;">
            <h2><i class="fas fa-clipboard-list"></i> Notas de: <?php echo htmlspecialchars($alumno['nombre_completo']); ?></h2>
            <p style="color: var(--grey-dark); margin-top: -0.5rem; margin-bottom: 1rem;">Curso: <?php echo htmlspecialchars($alumno['curso']); ?></p>

            <?php if ($notas->num_rows > 0): ?>
                <form method="POST" action="gestion_notas.php" id="deleteMultipleForm">
                    <input type="hidden" name="alumno_id" value="<?php echo $alumno_id; ?>">
                    <input type="hidden" name="curso_id" value="<?php echo $curso_id; ?>">
                    
                    <div class="table-responsive">
                        <table class="notas-table">
                            <thead>
                                <tr>
                                    <th><input type="checkbox" id="selectAllCheckbox" title="Seleccionar todo"></th>
                                    <th>Asignatura</th>
                                    <th>Nota</th>
                                    <th>Semestre</th>
                                    <th>N° Nota</th>
                                    <th class="actions">Acciones</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php while ($nota = $notas->fetch_assoc()): ?>
                                    <tr>
                                        <td>
                                            <input type="checkbox" name="notas_a_eliminar[]" value="<?php echo $nota['nota_id']; ?>">
                                        </td>
                                        <td><?php echo htmlspecialchars($nota['asignatura']); ?></td>
                                        <td><?php echo htmlspecialchars($nota['nota']); ?></td>
                                        <td><?php echo htmlspecialchars($nota['semestre']); ?></td>
                                        <td><?php echo htmlspecialchars($nota['numero_nota']); ?></td>
                                        <td class="actions">
                                            <button type="button" class="btn btn-edit btn-sm" onclick="openModalEdit(<?php echo $nota['nota_id']; ?>, <?php echo htmlspecialchars($nota['nota']); ?>)" title="Editar">
                                                <i class="fas fa-pencil-alt"></i>
                                            </button>
                                            <button type="button" class="btn btn-danger btn-sm" onclick="openModalDelete(<?php echo $nota['nota_id']; ?>)" title="Eliminar">
                                                <i class="fas fa-trash-alt"></i>
                                            </button>
                                        </td>
                                    </tr>
                                <?php endwhile; ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="form-buttons" style="margin-top: 1.5rem; justify-content: flex-start;">
                        <button type="submit" name="eliminar_multiples_notas" class="btn btn-danger" style="display: none;">
                            <i class="fas fa-trash-alt"></i> Eliminar Seleccionados
                        </button>
                    </div>
                </form>
            <?php else: ?>
                <p style="text-align: center;">Este alumno no tiene notas registradas.</p>
            <?php endif; ?>
            <?php $stmt_notas->close(); ?>
        </div>
    <?php endif; ?>
</main>

<div id="editModal" class="modal">
    <div class="modal-content">
        <form method="POST" action="gestion_notas.php">
            <div class="modal-header">
                <h2><i class="fas fa-edit"></i> Editar Nota</h2>
                <button type="button" class="modal-close-btn" onclick="closeModal('editModal')">&times;</button>
            </div>
            <div class="modal-body">
                <input type="hidden" name="nota_id" id="nota_id">
                <input type="hidden" name="alumno_id" value="<?php echo $alumno_id; ?>">
                <input type="hidden" name="curso_id" value="<?php echo $curso_id; ?>">
                <div class="form-group">
                    <label for="nueva_nota">Nueva Nota (ej: 6.5):</label>
                    <input type="number" step="0.1" min="1.0" max="7.0" name="nueva_nota" id="nueva_nota" required>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="closeModal('editModal')">Cancelar</button>
                <button type="submit" name="editar_nota" class="btn btn-primary"><i class="fas fa-save"></i> Actualizar Nota</button>
            </div>
        </form>
    </div>
</div>

<div id="deleteModal" class="modal">
    <div class="modal-content">
        <form method="POST" action="gestion_notas.php">
            <div class="modal-header" style="background-color: var(--danger-color);">
                <h2><i class="fas fa-exclamation-triangle"></i> Eliminar Nota</h2>
                <button type="button" class="modal-close-btn" onclick="closeModal('deleteModal')">&times;</button>
            </div>
            <div class="modal-body">
                <input type="hidden" name="nota_id" id="delete_nota_id">
                <input type="hidden" name="alumno_id" value="<?php echo $alumno_id; ?>">
                <input type="hidden" name="curso_id" value="<?php echo $curso_id; ?>">
                <p>¿Estás seguro de que deseas eliminar esta nota? Esta acción es irreversible.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="closeModal('deleteModal')">Cancelar</button>
                <button type="submit" name="eliminar_nota" class="btn btn-danger"><i class="fas fa-trash-alt"></i> Sí, Eliminar</button>
            </div>
        </form>
    </div>
</div>

<div class="modal-backdrop" id="modalBackdrop"></div>

<script>
    const editModal = document.getElementById("editModal");
    const deleteModal = document.getElementById("deleteModal");
    const backdrop = document.getElementById("modalBackdrop");

    function openModal(modalId) {
        document.getElementById(modalId).classList.add('show');
        backdrop.classList.add('show');
    }
    function closeModal(modalId) {
        document.getElementById(modalId).classList.remove('show');
        backdrop.classList.remove('show');
    }

    function openModalEdit(nota_id, nota_actual) {
        document.getElementById("nota_id").value = nota_id;
        document.getElementById("nueva_nota").value = nota_actual;
        openModal('editModal');
    }

    function openModalDelete(nota_id) {
        document.getElementById("delete_nota_id").value = nota_id;
        openModal('deleteModal');
    }

    backdrop.addEventListener('click', function() {
        closeModal('editModal');
        closeModal('deleteModal');
    });

    document.addEventListener('DOMContentLoaded', function() {
        const selectAll = document.getElementById('selectAllCheckbox');
        const checkboxes = document.querySelectorAll('input[name="notas_a_eliminar[]"]');
        const deleteButton = document.querySelector('button[name="eliminar_multiples_notas"]');

        function toggleDeleteButton() {
            const anyChecked = Array.from(checkboxes).some(checkbox => checkbox.checked);
            deleteButton.style.display = anyChecked ? 'inline-block' : 'none';
        }

        if (selectAll) {
            selectAll.addEventListener('change', () => {
                checkboxes.forEach(checkbox => {
                    checkbox.checked = selectAll.checked;
                });
                toggleDeleteButton();
            });
        }

        checkboxes.forEach(checkbox => {
            checkbox.addEventListener('change', toggleDeleteButton);
        });
    });
    
    window.onload = function() {
        const message = document.querySelector('.mensaje');
        if (message) {
            setTimeout(() => {
                message.classList.remove('show');
            }, 3000);
        }
    };
</script>
</body>
</html>

<?php
$conn->close();
?>