<?php
session_start();
include '../includes/db.php';
include '../includes/auth.php';

// --- Función de Log (Tu código original) ---
function registrarAccion($usuario, $accion, $curso_id = null, $curso_nombre = null) {
    global $conn;
    $stmt = $conn->prepare("INSERT INTO registro_actividad (usuario, accion, curso_id, curso_nombre, fecha) VALUES (?, ?, ?, ?, NOW())");
    $stmt->bind_param("ssis", $usuario, $accion, $curso_id, $curso_nombre);
    $stmt->execute();
    $stmt->close();
}
checkAuth();
// ... (Tu lógica de inactividad es correcta) ...
$limiteInactividad = 30 * 60;
if (isset($_SESSION['ultimoAcceso'])) {
    $inactividad = time() - $_SESSION['ultimoAcceso'];
    if ($inactividad > $limiteInactividad) {
        session_unset(); session_destroy(); header("Location: ../timeout.php"); exit();
    }
}
$_SESSION['ultimoAcceso'] = time();

$rol_id = $_SESSION['rol'] ?? null;
$usuario_id = $_SESSION['usuario_id'] ?? null;
$conn->set_charset("utf8");

// AÑADIDO: Manejo de mensajes de sesión
$message = '';
$message_type = '';
if (isset($_SESSION['message'])) {
    $message = $_SESSION['message'];
    $message_type = $_SESSION['message_type'];
    unset($_SESSION['message'], $_SESSION['message_type']);
}

// Obtener rol estudiante
$rol_query = $conn->prepare("SELECT id FROM roles WHERE nombre = 'estudiante'");
$rol_query->execute();
$rol_query->bind_result($rol_estudiante_id);
$rol_query->fetch();
$rol_query->close();

// Obtener cursos y asignaturas (para los filtros)
$cursos = $conn->query("SELECT id, nombre FROM curso WHERE activo = 1 ORDER BY nombre ASC");
$asignaturas = $conn->query("SELECT id, nombre FROM asignatura WHERE nombre IN ('Orientación', 'Religión') ORDER BY nombre ASC");
$indicadores = $conn->query("SELECT id, nombre FROM indicadores ORDER BY nombre ASC");

// --- Determinar estado actual (desde GET o POST) ---
$curso_id = $_REQUEST['curso_id'] ?? null;
$asignatura_id = $_REQUEST['asignatura_id'] ?? null;
$semestre = $_REQUEST['semestre'] ?? null;
$mostrar_tabla = isset($_REQUEST['mostrar_indicadores']);

// --- Guardar indicadores (MODIFICADO para usar sesiones) ---
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['guardar_multiples_indicadores'])) {
    
    // (Tu lógica de guardado es correcta y se mantiene)
    foreach ($_POST['indicadores'] as $usuario_id_post => $indicadores_post) {
        $delete_stmt = $conn->prepare("DELETE FROM notas_indicadores WHERE usuario_id = ? AND asignatura_id = ? AND semestre = ?");
        $delete_stmt->bind_param("iii", $usuario_id_post, $asignatura_id, $semestre);
        $delete_stmt->execute();
        $delete_stmt->close();

        $numero_nota = 1;
        $stmt_insert = $conn->prepare("INSERT INTO notas_indicadores (usuario_id, asignatura_id, indicador_id, fecha, semestre, numero_nota) VALUES (?, ?, ?, NOW(), ?, ?)");
        
        for ($i = 1; $i <= 10; $i++) {
            if (!empty($indicadores_post["indicador_$i"])) {
                $indicador_id = $indicadores_post["indicador_$i"];
                $stmt_insert->bind_param("iiiii", $usuario_id_post, $asignatura_id, $indicador_id, $semestre, $numero_nota);
                $stmt_insert->execute();
                $numero_nota++;
            }
        }
        $stmt_insert->close();
    }
    
    // --- (Tu lógica de Log es correcta y se mantiene) ---
    $nombre_curso = 'N/A'; $stmt_curso = $conn->prepare("SELECT nombre FROM curso WHERE id = ?"); $stmt_curso->bind_param("i", $curso_id); $stmt_curso->execute(); $stmt_curso->bind_result($nombre_curso); $stmt_curso->fetch(); $stmt_curso->close();
    $nombre_asignatura = 'N/A'; $stmt_asig = $conn->prepare("SELECT nombre FROM asignatura WHERE id = ?"); $stmt_asig->bind_param("i", $asignatura_id); $stmt_asig->execute(); $stmt_asig->bind_result($nombre_asignatura); $stmt_asig->fetch(); $stmt_asig->close();
    $usuario_actual = $_SESSION['usuario'] ?? 'Desconocido';
    $accion = "Guardó/modificó indicadores en: \"$nombre_curso\", Asig: \"$nombre_asignatura\", Sem: $semestre";
    registrarAccion($usuario_actual, $accion, $curso_id, $nombre_curso);

    // MODIFICADO: Guardar en sesión y redirigir
    $_SESSION['message'] = 'Indicadores guardados correctamente.';
    $_SESSION['message_type'] = 'exito';
    header("Location: add_indicadores.php?curso_id=$curso_id&asignatura_id=$asignatura_id&semestre=$semestre&mostrar_indicadores=1");
    exit();
}

// --- Obtener datos para la tabla ---
$estudiantes = [];
if ($curso_id !== null) {
    $stmt = $conn->prepare("SELECT id, CONCAT(apellido_paterno, ' ', apellido_materno, ' ', nombre) AS nombre_completo 
                             FROM usuario 
                             WHERE rol_id = ? AND curso_id = ? AND activo = 1
                             ORDER BY apellido_paterno, apellido_materno, nombre ASC");
    $stmt->bind_param("ii", $rol_estudiante_id, $curso_id);
    $stmt->execute();
    $result = $stmt->get_result();
    while ($fila = $result->fetch_assoc()) {
        $estudiantes[] = $fila;
    }
    $stmt->close();
}

$indicadores_guardados = [];
if ($mostrar_tabla && $curso_id && $asignatura_id && $semestre) {
    // (Tu lógica para obtener indicadores guardados es correcta)
    $stmt = $conn->prepare("SELECT usuario_id, indicador_id, numero_nota FROM notas_indicadores 
                             WHERE asignatura_id = ? AND semestre = ? AND usuario_id IN (
                                 SELECT id FROM usuario WHERE curso_id = ? AND rol_id = ? AND activo = 1
                             )");
    $stmt->bind_param("iiii", $asignatura_id, $semestre, $curso_id, $rol_estudiante_id);
    $stmt->execute();
    $result = $stmt->get_result();
    while ($row = $result->fetch_assoc()) {
        $indicador_usuario_id = $row['usuario_id'];
        $numero = $row['numero_nota'];
        $indicadores_guardados[$indicador_usuario_id]["indicador_$numero"] = $row['indicador_id'];
    }
    $stmt->close();
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Agregar Indicadores</title>
    <link rel="icon" type="image/png" href="../images/logo.png">
    
    <link rel="stylesheet" href="../css/admin.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    
    <style>
        .table-container {
            overflow-x: auto;
        }
        .notas-table {
            width: 100%;
            min-width: 1200px;
            border-collapse: collapse;
        }
        .notas-table th, .notas-table td {
            border: 1px solid var(--grey-medium);
            padding: 0.5rem;
            text-align: center;
            vertical-align: middle;
        }
        .notas-table th {
            background-color: var(--grey-light);
            font-size: 0.9rem;
        }
        .notas-table th:first-child, .notas-table td:first-child {
            text-align: left;
            min-width: 200px;
            font-weight: 500;
            position: sticky;
            left: 0;
            background-color: var(--grey-light);
            z-index: 1;
        }
        .notas-table td:first-child {
            background-color: #fff;
        }
        .notas-table td select {
            width: 100%;
            min-width: 80px;
            padding: 0.5rem;
            border: 1px solid var(--grey-medium);
            border-radius: var(--border-radius);
            font-size: 0.9rem;
        }
        
        /* Estilo para el mensaje estático (Push up) */
        .mensaje-flotante {
            position: fixed;
            top: 100px;
            right: 20px;
            background-color: var(--warning-color);
            color: var(--dark-color);
            padding: 1rem 1.5rem;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            z-index: 1040;
            max-width: 350px;
            opacity: 1;
            transition: opacity 0.5s ease;
            font-size: 0.9rem;
        }
        .mensaje-flotante .cerrar {
            float: right;
            font-size: 1.5rem;
            font-weight: 700;
            line-height: 1;
            color: var(--dark-color);
            opacity: 0.5;
            cursor: pointer;
            margin-left: 1rem;
        }
    </style>
</head>
<body>

<div class="mensaje-flotante" id="mensajeNota">
    <span class="cerrar" onclick="this.parentElement.style.display='none';">&times;</span>
    <strong>Nota importante:</strong><br>
    Los indicadores deben seleccionarse (MB, B, S, I).<br>
    No se permite escribir el indicador.<br>
    Tiempo de inactividad 40 minutos.
</div>

<header>
    <div class="header-content">
        <img src="../images/INSIGNIA SF.png" alt="Escuela Porongo Insignia">
        <h1>Agregar Indicadores</h1>
        <nav>
            <ul>
                <li><a href="../index.php"><i class="fas fa-home"></i> Inicio</a></li>
                <li><a href="add_grade.php"><i class="fas fa-edit"></i> Agregar Notas</a></li>
                <li><a href="gestion_notas.php"><i class="fas fa-eye"></i> Ver Notas</a></li>
            </ul>
        </nav>
    </div>
</header>

<main class="container">
    
    <?php if (!empty($message)): ?>
        <div class="mensaje <?php echo $message_type; ?> show">
            <?php echo htmlspecialchars($message, ENT_QUOTES, 'UTF-8'); ?>
        </div>
    <?php endif; ?>

    <div class="card form-container">
        <h2><i class="fas fa-filter"></i> Seleccionar Filtros</h2>
        <form method="GET" action="add_indicadores.php">
            <div class="form-grid" style="grid-template-columns: 1fr 1fr 1fr;">
                <div class="form-group">
                    <label for="curso_id"><i class="fas fa-university"></i> Curso:</label>
                    <select name="curso_id" id="curso_id" required>
                        <option value="">Seleccione un curso</option>
                        <?php $cursos->data_seek(0); while ($curso = $cursos->fetch_assoc()): ?>
                            <option value="<?php echo $curso['id']; ?>" <?php echo ($curso_id == $curso['id']) ? 'selected' : ''; ?>>
                                <?php echo htmlspecialchars($curso['nombre']); ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>

                <div class="form-group">
                    <label for="asignatura_id"><i class="fas fa-book"></i> Asignatura:</label>
                    <select name="asignatura_id" id="asignatura_id" required>
                        <option value="">Seleccione asignatura</option>
                        <?php $asignaturas->data_seek(0); while ($asignatura = $asignaturas->fetch_assoc()): ?>
                            <option value="<?php echo $asignatura['id']; ?>" <?php echo ($asignatura_id == $asignatura['id']) ? 'selected' : ''; ?>>
                                <?php echo htmlspecialchars($asignatura['nombre']); ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>

                <div class="form-group">
                    <label for="semestre"><i class="fas fa-chart-pie"></i> Semestre:</label>
                    <select name="semestre" id="semestre" required>
                        <option value="1" <?php echo ($semestre == '1') ? 'selected' : ''; ?>>Primer Semestre</option>
                        <option value="2" <?php echo ($semestre == '2') ? 'selected' : ''; ?>>Segundo Semestre</option>
                    </select>
                </div>
            </div>
            
            <div class="form-buttons">
                <button type="submit" name="mostrar_indicadores" value="1" class="btn btn-primary">
                    <i class="fas fa-eye"></i> Mostrar Indicadores
                </button>
            </div>
        </form>
    </div>

    <?php if ($mostrar_tabla && !empty($estudiantes)): ?>
        <div class="card table-container" style="margin-top: 2rem;">
            <form method="POST" action="add_indicadores.php">
                <input type="hidden" name="curso_id" value="<?php echo htmlspecialchars($curso_id); ?>">
                <input type="hidden" name="asignatura_id" value="<?php echo htmlspecialchars($asignatura_id); ?>">
                <input type="hidden" name="semestre" value="<?php echo htmlspecialchars($semestre); ?>">
                
                <div class="table-responsive">
                    <table class="notas-table">
                        <thead>
                            <tr>
                                <th>Estudiantes</th>
                                <?php for ($i = 1; $i <= 10; $i++): ?>
                                    <th>Indicador <?php echo $i; ?></th>
                                <?php endfor; ?>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($estudiantes as $estudiante): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($estudiante['nombre_completo']); ?></td>
                                    <?php for ($i = 1; $i <= 10; $i++): ?>
                                        <?php
                                        $indicadores->data_seek(0);
                                        $sel = $indicadores_guardados[$estudiante['id']]["indicador_$i"] ?? '';
                                        ?>
                                        <td>
                                            <select name="indicadores[<?php echo $estudiante['id']; ?>][indicador_<?php echo $i; ?>]">
                                                <option value="">N/A</option> <?php while ($indicador = $indicadores->fetch_assoc()): ?>
                                                    <option value="<?php echo $indicador['id']; ?>" <?php echo ($sel == $indicador['id']) ? 'selected' : ''; ?>>
                                                        <?php echo htmlspecialchars($indicador['nombre']); ?>
                                                    </option>
                                                <?php endwhile; ?>
                                            </select>
                                        </td>
                                    <?php endfor; ?>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                
                <div class="form-buttons" style="margin-top: 1.5rem;">
                    <button type="submit" name="guardar_multiples_indicadores" class="btn btn-primary">
                        <i class="fas fa-save"></i> Guardar Indicadores
                    </button>
                </div>
            </form>
        </div>
    <?php elseif ($mostrar_tabla): ?>
        <div class="card" style="margin-top: 2rem; padding: 2rem; text-align: center;">
            <p>No hay estudiantes asignados a este curso.</p>
        </div>
    <?php endif; ?>
</main>

<script>
    // Tu script de inactividad (se mantiene)
    const tiempoAdvertencia = 35 * 60 * 1000;
    const tiempoCierreSesion = 5 * 60 * 1000;
    let advertenciaMostrada = false;
    setTimeout(() => {
        if (!advertenciaMostrada) {
            advertenciaMostrada = true;
            const confirmacion = confirm("Has estado inactivo por un tiempo. Tu sesión se cerrará en 5 minutos si no interactúas.");
            if (!confirmacion) {
                setTimeout(() => { window.location.href = "login.php"; }, tiempoCierreSesion);
            }
        }
    }, tiempoAdvertencia);

    // MODIFICADO: window.onload para manejar ambos mensajes
    window.onload = function() {
        // Mensaje de sesión (Dinámico)
        const message = document.querySelector('.mensaje');
        if (message) {
            setTimeout(() => {
                message.classList.remove('show');
            }, 3000);
        }
        
        // Mensaje de nota (Estático)
        const messageNota = document.getElementById('mensajeNota');
        if (messageNota) {
            // No lo ocultamos automáticamente, solo con la 'x'
        }
    };
</script>
</body>
</html>