<?php
session_start();
header('Content-Type: text/html; charset=utf-8');
include '../includes/db.php';
include '../includes/auth.php';

// --- Función de Log (Tu código original) ---
function registrarAccion($usuario, $accion, $curso_id = null, $curso_nombre = null) {
    global $conn;
    $stmt = $conn->prepare("INSERT INTO registro_actividad (usuario, accion, curso_id, curso_nombre, fecha) VALUES (?, ?, ?, ?, NOW())");
    $stmt->bind_param("ssis", $usuario, $accion, $curso_id, $curso_nombre);
    $stmt->execute();
    $stmt->close();
}
checkAuth();
// ... (Tu lógica de inactividad es correcta) ...
$limiteInactividad = 40 * 60;
if (isset($_SESSION['ultimoAcceso'])) {
    $inactividad = time() - $_SESSION['ultimoAcceso'];
    if ($inactividad > $limiteInactividad) {
        session_unset(); session_destroy(); header("Location: ../timeout.php"); exit();
    }
}
$_SESSION['ultimoAcceso'] = time();

$rol_id = $_SESSION['rol'] ?? null;
$usuario_id = $_SESSION['usuario_id'] ?? null;
$conn->set_charset("utf8");

// AÑADIDO: Manejo de mensajes de sesión
$message = '';
$message_type = '';
if (isset($_SESSION['message'])) {
    $message = $_SESSION['message'];
    $message_type = $_SESSION['message_type'];
    unset($_SESSION['message'], $_SESSION['message_type']);
}

// Obtener el ID del rol 'estudiante'
$rol_query = $conn->prepare("SELECT id FROM roles WHERE nombre = 'estudiante'");
$rol_query->execute();
$rol_query->bind_result($rol_estudiante_id);
$rol_query->fetch();
$rol_query->close();

// Inicializar variables
$curso_id = isset($_GET['curso_id']) ? intval($_GET['curso_id']) : (isset($_POST['curso_id']) ? intval($_POST['curso_id']) : null);
$asignatura_seleccionada = isset($_POST['asignatura_id']) ? intval($_POST['asignatura_id']) : null;
$semestre_seleccionado = isset($_POST['semestre']) ? intval($_POST['semestre']) : null;

$notas_existentes = [];

// --- Lógica POST (Guardar o Mostrar) ---
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Estas variables se establecen si se muestra o se guarda
    $curso_id = intval($_POST['curso_id']);
    $asignatura_id = intval($_POST['asignatura_id']);
    $semestre = intval($_POST['semestre']);
    
    $asignatura_seleccionada = $asignatura_id;
    $semestre_seleccionado = $semestre;

    // --- GUARDAR NOTAS (MODIFICADO) ---
    if (isset($_POST['guardar_multiples_notas'])) {
        $error_encontrado = false;
        if (isset($_POST['notas']) && is_array($_POST['notas'])) {
            foreach ($_POST['notas'] as $usuario_id_post => $notas) {
                for ($i = 1; $i <= 10; $i++) {
                    $nota_input = trim($notas["nota_$i"]);
                    if (!empty($nota_input)) {
                        $nota_input = str_replace(',', '.', $nota_input);
                        if (!preg_match('/^[0-6](\.[0-9])?$|^7(\.0)?$/', $nota_input)) {
                            $_SESSION['message'] = "Error: Formato de nota inválido ($nota_input). Use formatos como 6.5 o 7.0.";
                            $_SESSION['message_type'] = 'error';
                            $error_encontrado = true;
                            break 2; // Salir de ambos bucles
                        }
                        
                        $nota = floatval($nota_input);
                        $stmt = $conn->prepare("SELECT id FROM notas WHERE usuario_id = ? AND asignatura_id = ? AND semestre = ? AND numero_nota = ?");
                        $stmt->bind_param("iiii", $usuario_id_post, $asignatura_id, $semestre, $i);
                        $stmt->execute();
                        $result = $stmt->get_result();
                        
                        if ($result->num_rows > 0) {
                            $nota_existente = $result->fetch_assoc();
                            $nota_id = $nota_existente['id'];
                            $stmt->close();
                            $update_stmt = $conn->prepare("UPDATE notas SET nota = ? WHERE id = ?");
                            $update_stmt->bind_param("di", $nota, $nota_id);
                            $update_stmt->execute();
                            $update_stmt->close();
                        } else {
                            $stmt->close();
                            $insert_stmt = $conn->prepare("INSERT INTO notas (usuario_id, asignatura_id, nota, fecha, semestre, numero_nota) VALUES (?, ?, ?, NOW(), ?, ?)");
                            $insert_stmt->bind_param("iidii", $usuario_id_post, $asignatura_id, $nota, $semestre, $i);
                            $insert_stmt->execute();
                            $insert_stmt->close();
                        }
                    }
                }
            }
        }
        
        if (!$error_encontrado) {
            $_SESSION['message'] = 'Notas guardadas correctamente.';
            $_SESSION['message_type'] = 'exito';
            // ... (Tu lógica de registro de log es correcta y se mantiene) ...
            $nombre_curso = 'N/A'; $stmt_curso = $conn->prepare("SELECT nombre FROM curso WHERE id = ?"); $stmt_curso->bind_param("i", $curso_id); $stmt_curso->execute(); $stmt_curso->bind_result($nombre_curso); $stmt_curso->fetch(); $stmt_curso->close();
            $nombre_asignatura = 'N/A'; $stmt_asig = $conn->prepare("SELECT nombre FROM asignatura WHERE id = ?"); $stmt_asig->bind_param("i", $asignatura_id); $stmt_asig->execute(); $stmt_asig->bind_result($nombre_asignatura); $stmt_asig->fetch(); $stmt_asig->close();
            $usuario_log = $_SESSION['usuario'] ?? 'Usuario no identificado';
            $accion = "Guardó/modificó notas en: $nombre_curso, Asig: $nombre_asignatura, Sem: $semestre";
            registrarAccion($usuario_log, $accion, $curso_id, $nombre_curso);
        }

        // Redirigir para mostrar el mensaje de sesión y recargar el estado
        header("Location: add_grade.php?curso_id=" . $curso_id);
        exit();
    }
    
    // --- MOSTRAR NOTAS ---
    if (isset($_POST['mostrar_notas'])) {
        $stmt_notas = $conn->prepare("
            SELECT n.usuario_id, n.numero_nota, n.nota 
            FROM notas n
            JOIN usuario u ON n.usuario_id = u.id
            WHERE u.curso_id = ? AND n.asignatura_id = ? AND n.semestre = ?
        ");
        $stmt_notas->bind_param("iii", $curso_id, $asignatura_id, $semestre);
        $stmt_notas->execute();
        $result = $stmt_notas->get_result();
        while ($row = $result->fetch_assoc()) {
            $notas_existentes[$row['usuario_id']][$row['numero_nota']] = $row['nota'];
        }
        $stmt_notas->close();
    }
}

// --- Obtener datos para los selects ---
$cursos = $conn->query("SELECT id, nombre FROM curso WHERE activo = 1 ORDER BY nombre ASC;");
$asignaturas = $conn->query("SELECT id, nombre FROM asignatura ORDER BY nombre ASC");

$estudiantes = [];
if ($curso_id !== null) {
    $stmt = $conn->prepare("SELECT id, CONCAT(apellido_paterno, ' ', apellido_materno, ' ', nombre) AS nombre_completo 
                             FROM usuario 
                             WHERE rol_id = ? AND curso_id = ? AND activo = 1
                             ORDER BY apellido_paterno, apellido_materno, nombre ASC");
    $stmt->bind_param("ii", $rol_estudiante_id, $curso_id);
    $stmt->execute();
    $estudiantes = $stmt->get_result();
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Agregar Notas</title>
    <link rel="icon" type="image/png" href="../images/logo.png">
    
    <link rel="stylesheet" href="../css/admin.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    
    <style>
        .table-container {
            overflow-x: auto; 
        }
        .notas-table {
            width: 100%;
            min-width: 1200px; 
            border-collapse: collapse;
        }
        .notas-table th, .notas-table td {
            border: 1px solid var(--grey-medium);
            padding: 0.5rem;
            text-align: center;
            vertical-align: middle;
        }
        .notas-table th {
            background-color: var(--grey-light);
            font-size: 0.9rem;
        }
        .notas-table th:first-child, .notas-table td:first-child {
            text-align: left;
            min-width: 200px;
            font-weight: 500;
            position: sticky;
            left: 0;
            background-color: var(--grey-light);
            z-index: 1;
        }
        .notas-table td:first-child {
            background-color: #fff;
        }
        .notas-table td input[type="number"] {
            width: 65px;
            padding: 0.5rem;
            text-align: center;
            border: 1px solid var(--grey-medium);
            border-radius: var(--border-radius);
            font-size: 0.9rem;
        }
        .notas-table input::-webkit-outer-spin-button,
        .notas-table input::-webkit-inner-spin-button {
            -webkit-appearance: none;
            margin: 0;
        }
        .notas-table input[type=number] {
            -moz-appearance: textfield;
        }
        
        /* *** CSS CORREGIDO PARA EL MENSAJE FLOTANTE *** */
        .mensaje-flotante {
            position: fixed;
            /* Se posiciona debajo del mensaje de sesión (que está en top: 20px) */
            top: 100px; 
            right: 20px;
            background-color: var(--warning-color); /* Naranja/Amarillo de advertencia */
            color: var(--dark-color);
            padding: 1rem 1.5rem;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            z-index: 1040; /* Un poco menos que el mensaje de sesión (1050) */
            max-width: 350px;
            opacity: 1;
            transition: opacity 0.5s ease;
            font-size: 0.9rem;
        }
        .mensaje-flotante .cerrar {
            float: right;
            font-size: 1.5rem;
            font-weight: 700;
            line-height: 1;
            color: var(--dark-color);
            opacity: 0.5;
            cursor: pointer;
            margin-left: 1rem;
        }
        .mensaje-flotante .cerrar:hover {
            opacity: 1;
        }
    </style>
</head>
<body>

<div class="mensaje-flotante" id="mensajeNota">
    <span class="cerrar" onclick="this.parentElement.style.display='none';">&times;</span>
    <strong>Nota importante:</strong><br>
    Las notas deben ingresarse con punto decimal. Ejemplo: <strong>7.0</strong><br>
    Tiempo de inactividad 40 minutos, luego se cierra y no guardará nada.
</div>

<header>
    <div class="header-content">
        <img src="../images/INSIGNIA SF.png" alt="Escuela Porongo Insignia">
        <h1>Agregar Notas</h1>
        <nav>
            <ul>
                <li><a href="../index.php"><i class="fas fa-home"></i> Inicio</a></li>
                <li><a href="add_indicadores.php"><i class="fas fa-tags"></i> Agregar Indicadores</a></li>
                <li><a href="gestion_notas.php"><i class="fas fa-eye"></i> Ver Notas</a></li>
            </ul>
        </nav>
    </div>
</header>

<main class="container">

<?php if (!empty($message)): ?>
    <div class="mensaje <?php echo $message_type; ?> show">
        <?php echo htmlspecialchars($message, ENT_QUOTES, 'UTF-8'); ?>
    </div>
<?php endif; ?>

<div class="card form-container">
    <h2><i class="fas fa-filter"></i> Seleccionar Curso y Asignatura</h2>
    
    <form method="GET" action="add_grade.php">
        <div class="form-group">
            <label for="curso_id"><i class="fas fa-university"></i> Curso:</label>
            <select id="curso_id" name="curso_id" onchange="this.form.submit()">
                <option value="">Seleccione un curso</option>
                <?php while ($curso_row = $cursos->fetch_assoc()): ?>
                    <option value="<?php echo $curso_row['id']; ?>" <?php if ($curso_id == $curso_row['id']) echo 'selected'; ?>>
                        <?php echo htmlspecialchars($curso_row['nombre'], ENT_QUOTES, 'UTF-8'); ?>
                    </option>
                <?php endwhile; ?>
            </select>
        </div>
    </form>

    <?php if ($estudiantes && $estudiantes->num_rows > 0): ?>
    <form method="POST" action="add_grade.php" onsubmit="return validarFormulario();">
        <input type="hidden" name="curso_id" value="<?php echo htmlspecialchars($curso_id, ENT_QUOTES, 'UTF-8'); ?>">
        
        <div class="form-grid" style="margin-top: 1rem;">
            <div class="form-group">
                <label for="asignatura_id"><i class="fas fa-book"></i> Asignatura:</label>
                <select id="asignatura_id" name="asignatura_id" required>
                    <option value="">Seleccione una asignatura</option>
                    <?php
                    $asignaturas->data_seek(0);
                    $nombre_curso = '';
                    if ($curso_id) {
                        $stmt_curso = $conn->prepare("SELECT nombre FROM curso WHERE id = ?");
                        $stmt_curso->bind_param("i", $curso_id); $stmt_curso->execute();
                        $stmt_curso->bind_result($nombre_curso); $stmt_curso->fetch(); $stmt_curso->close();
                    }
                    $nombre_curso = strtolower($nombre_curso);
                    $mostrar_lengua = in_array($nombre_curso, ['7° año a', '7° año b', '8° año a', '8° año b']);
                    
                    while ($asignatura = $asignaturas->fetch_assoc()):
                        $nombre_asignatura = strtolower(trim($asignatura['nombre']));
                        if ($nombre_asignatura === 'orientación' || $nombre_asignatura === 'religión') continue;
                        if ($mostrar_lengua) {
                            if ($nombre_asignatura === 'lenguaje y comunicación') continue;
                        } else {
                            if ($nombre_asignatura === 'lengua y literatura') continue;
                        }
                    ?>
                    <option value="<?php echo $asignatura['id']; ?>" <?php if ($asignatura_seleccionada == $asignatura['id']) echo 'selected'; ?>>
                        <?php echo htmlspecialchars($asignatura['nombre'], ENT_QUOTES, 'UTF-8'); ?>
                    </option>
                    <?php endwhile; ?>
                </select>
            </div>
            
            <div class="form-group">
                <label for="semestre"><i class="fas fa-chart-pie"></i> Semestre:</label>
                <select id="semestre" name="semestre" required>
                    <option value="1" <?php if ($semestre_seleccionado == '1') echo 'selected'; ?>>Primer Semestre</option>
                    <option value="2" <?php if ($semestre_seleccionado == '2') echo 'selected'; ?>>Segundo Semestre</option>
                </select>
            </div>
        </div>

        <div class="form-buttons">
            <button type="submit" name="mostrar_notas" class="btn btn-secondary">
                <i class="fas fa-eye"></i> Mostrar Notas Ingresadas
            </button>
            <button type="submit" name="guardar_multiples_notas" class="btn btn-primary">
                <i class="fas fa-save"></i> Guardar Notas
            </button>
        </div>
    
        <div class="card table-container" style="margin-top: 2rem;">
            <div class="table-responsive">
                <table class="notas-table">
                    <thead>
                        <tr>
                            <th>Estudiantes</th>
                            <?php for ($i = 1; $i <= 10; $i++): ?>
                                <th>Nota <?php echo $i; ?></th>
                            <?php endfor; ?>
                            <th>Promedio</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php while ($estudiante = $estudiantes->fetch_assoc()): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($estudiante['nombre_completo'], ENT_QUOTES, 'UTF-8'); ?></td>
                            <?php
                            $sumaNotas = 0;
                            $cantidadNotas = 0;
                            for ($i = 1; $i <= 10; $i++):
                                $notaValor = isset($notas_existentes[$estudiante['id']][$i]) ? $notas_existentes[$estudiante['id']][$i] : '';
                                if ($notaValor !== '') {
                                    $sumaNotas += floatval($notaValor);
                                    $cantidadNotas++;
                                }
                            ?>
                                <td>
                                    <input type="number" step="0.1" min="1.0" max="7.0"
                                           name="notas[<?php echo $estudiante['id']; ?>][nota_<?php echo $i; ?>]"
                                           value="<?php echo htmlspecialchars(str_replace(',', '.', $notaValor), ENT_QUOTES, 'UTF-8'); ?>">
                                </td>
                            <?php endfor; ?>
                            <td><strong><?php echo $cantidadNotas > 0 ? number_format($sumaNotas / $cantidadNotas, 1, '.', '') : '-'; ?></strong></td>
                        </tr>
                    <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </form>
    <?php elseif ($curso_id): ?>
        <p style="text-align: center; margin-top: 1rem;">No hay estudiantes asignados a este curso.</p>
    <?php endif; ?>
</div>

</main>

<script>
    // Tu función de validación (es correcta)
    function validarFormulario() {
        const inputs = document.querySelectorAll('input[type="number"]');
        for (const input of inputs) {
            const valor = input.value.trim().replace(',', '.');
            if (valor === '') continue;
            if (!/^[0-6](\.[0-9])?$|^7(\.0)?$/.test(valor)) {
                alert(`Nota inválida: ${valor}. Usa formatos como 6.5 o 7.0, y no mayores a 7.0.`);
                input.focus();
                return false;
            }
        }
        return true;
    }

    // MODIFICADO: window.onload para manejar el mensaje de sesión
    window.onload = function() {
        // Ocultar el mensaje de sesión (dinámico)
        const message = document.querySelector('.mensaje');
        if (message) {
            setTimeout(() => {
                message.classList.remove('show');
            }, 3000); // 3 segundos
        }
        
        // El mensaje estático (mensajeNota) ya no se oculta automáticamente, 
        // solo con el botón 'x'.
    };
    
    // Tu script de inactividad (se mantiene)
    const tiempoAdvertencia = 35 * 60 * 1000;
    const tiempoCierreSesion = 5 * 60 * 1000;
    let advertenciaMostrada = false;
    setTimeout(() => {
        if (!advertenciaMostrada) {
            advertenciaMostrada = true;
            const confirmacion = confirm("Has estado inactivo por un tiempo. Tu sesión se cerrará en 5 minutos si no interactúas.");
            if (!confirmacion) {
                setTimeout(() => {
                    window.location.href = "login.php";
                }, tiempoCierreSesion);
            }
        }
    }, tiempoAdvertencia);
</script>
</body>
</html>