<?php
header('Content-Type: text/html; charset=utf-8');

include '../includes/db.php'; 
include '../includes/auth.php'; 
checkAuth();

$conn->set_charset("utf8");

$matricula_id = $_GET['id']; 

// --- CONSULTAS SQL (Misma lógica original) ---
$sql_matricula = "SELECT * FROM matricula WHERE id = ?";
$stmt = $conn->prepare($sql_matricula);
$stmt->bind_param("i", $matricula_id);
$stmt->execute();
$matricula = $stmt->get_result()->fetch_assoc();

$sql_prevision = "SELECT tipo_prevision.nombre AS tipo_prevision FROM previsiones_salud JOIN tipo_prevision ON previsiones_salud.tipo_prevision_id = tipo_prevision.id WHERE matricula_id = ?";
$stmt = $conn->prepare($sql_prevision);
$stmt->bind_param("i", $matricula_id);
$stmt->execute();
$prevision = $stmt->get_result()->fetch_assoc();

$sql_alergias = "SELECT alergia FROM alergias_alimentarias WHERE matricula_id = ?";
$stmt = $conn->prepare($sql_alergias);
$stmt->bind_param("i", $matricula_id);
$stmt->execute();
$result_alergias = $stmt->get_result();
$alergias = [];
while ($row = $result_alergias->fetch_assoc()) { $alergias[] = $row['alergia']; }

$sql_informacion_adicional = "SELECT * FROM informacion_adicional WHERE matricula_id = ?";
$stmt = $conn->prepare($sql_informacion_adicional);
$stmt->bind_param("i", $matricula_id);
$stmt->execute();
$informacion_adicional = $stmt->get_result()->fetch_assoc();

$sql_apoderados = "SELECT * FROM apoderados WHERE matricula_id = ?";
$stmt = $conn->prepare($sql_apoderados);
$stmt->bind_param("i", $matricula_id);
$stmt->execute();
$result_apoderados = $stmt->get_result();
$apoderados = [];
while ($row = $result_apoderados->fetch_assoc()) { $apoderados[] = $row; }

$sql_familiares = "SELECT * FROM familiares WHERE matricula_id = ?";
$stmt = $conn->prepare($sql_familiares);
$stmt->bind_param("i", $matricula_id);
$stmt->execute();
$result_familiares = $stmt->get_result();
$familiares = [];
while ($row = $result_familiares->fetch_assoc()) { $familiares[] = $row; }

$sql_curso = "SELECT nombre FROM curso WHERE id = ?";
$stmt = $conn->prepare($sql_curso);
$stmt->bind_param("i", $matricula['curso_id']);
$stmt->execute();
$curso = $stmt->get_result()->fetch_assoc();
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="../images/logo.png">
    <title>Ficha de Matrícula - <?php echo htmlspecialchars($matricula['rut']); ?></title>
    
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">

    <style>
        :root {
            --primary-color: #1a4a7c; /* Azul Institucional */
            --border-color: #cbd5e0;
            --bg-header-table: #f1f5f9;
            --text-color: #2d3748;
        }

        body {
            font-family: 'Roboto', sans-serif;
            background-color: #e2e8f0; /* Fondo gris para la pantalla */
            margin: 0;
            padding: 20px;
            color: var(--text-color);
        }

        .container {
            width: 210mm;
            min-height: 297mm; /* A4 */
            margin: 0 auto;
            padding: 40px;
            background-color: white;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1); /* Efecto hoja levantada */
            box-sizing: border-box;
            position: relative;
        }

        /* --- HEADER --- */
        header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            border-bottom: 2px solid var(--primary-color);
            padding-bottom: 15px;
            margin-bottom: 20px;
        }

        header img {
            width: 90px;
            height: auto;
        }

        header .info {
            text-align: right;
            font-size: 13px;
            line-height: 1.4;
        }
        
        header .info strong {
            color: var(--primary-color);
            font-size: 16px;
        }

        /* --- TITULOS --- */
        .title {
            text-align: center;
            text-transform: uppercase;
            color: var(--primary-color);
            font-size: 22px;
            font-weight: 700;
            margin-bottom: 30px;
            letter-spacing: 1px;
        }

        .section-title {
            background-color: var(--primary-color);
            color: white;
            padding: 5px 10px;
            font-size: 14px;
            font-weight: bold;
            text-transform: uppercase;
            margin-top: 20px;
            margin-bottom: 10px;
            border-radius: 3px;
            -webkit-print-color-adjust: exact; /* Para imprimir el fondo */
            print-color-adjust: exact;
        }

        /* --- TABLAS --- */
        .form-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 12px;
            margin-bottom: 10px;
        }

        .form-table th, .form-table td {
            border: 1px solid var(--border-color);
            padding: 8px;
            vertical-align: middle;
        }

        .form-table th {
            background-color: var(--bg-header-table);
            color: var(--primary-color);
            font-weight: 600;
            text-align: left;
            width: 20%; /* Ancho estándar para etiquetas */
            -webkit-print-color-adjust: exact;
            print-color-adjust: exact;
        }

        .form-table td {
            width: 30%;
        }
        
        /* --- INPUTS ESTILIZADOS PARA IMPRESIÓN --- */
        input[type="text"] {
            width: 100%;
            border: none;
            border-bottom: 1px dashed #999;
            background: transparent;
            padding: 4px 0;
            font-family: inherit;
            font-size: 12px;
            outline: none;
        }
        
        input[type="text"]:focus {
            border-bottom: 1px solid var(--primary-color);
        }

        input[type="checkbox"] {
            transform: scale(1.2);
            margin-right: 5px;
        }

        /* --- FIRMAS --- */
        .signatures-container {
            display: flex;
            justify-content: space-around;
            margin-top: 50px;
            page-break-inside: avoid;
        }

        .signature-box {
            text-align: center;
            width: 40%;
        }

        .signature-line {
            border-top: 1px solid black;
            margin-bottom: 5px;
        }
        
        .signature-text {
            font-size: 12px;
            font-weight: bold;
        }

        /* --- BOTONES --- */
        .button-section {
            position: fixed;
            bottom: 20px;
            right: 20px;
            display: flex;
            gap: 10px;
        }

        .btn {
            padding: 12px 24px;
            font-size: 14px;
            font-weight: bold;
            cursor: pointer;
            border: none;
            border-radius: 50px;
            box-shadow: 0 4px 6px rgba(0,0,0,0.2);
            transition: transform 0.2s, box-shadow 0.2s;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .btn:active { transform: translateY(2px); }

        .btn-print { background-color: var(--primary-color); color: white; }
        .btn-back { background-color: #718096; color: white; }

        /* --- ESTILOS DE IMPRESIÓN --- */
        @media print {
            body {
                background-color: white;
                padding: 0;
            }
            .container {
                width: 100%;
                height: auto;
                box-shadow: none;
                padding: 0;
                margin: 0;
                border: none;
            }
            .button-section {
                display: none !important;
            }
            .section-title {
                color: black !important;
                border-bottom: 2px solid black;
                background-color: transparent !important;
                padding: 5px 0;
                margin-top: 15px;
            }
            .form-table th {
                background-color: #f0f0f0 !important;
                color: black !important;
                border-color: #000 !important;
            }
            .form-table td {
                border-color: #000 !important;
            }
            /* Evitar cortes feos de página */
            table, .signatures-container {
                page-break-inside: avoid;
            }
        }
    </style>
</head>
<body>

    <div class="container">
        <header>
            <img src="../images/INSIGNIA SF 2.0.png" alt="Insignia Escuela">
            <div class="info">
                <strong>Escuela Porongo Cauquenes</strong><br>
                Año Escolar: <?php echo date("Y"); ?><br>
                <div style="margin-top:5px;">
                    Nº Registro: <input type="text" style="width: 60px; display:inline-block; text-align:center;" placeholder="Nº">
                </div>
            </div>
        </header>

        <div class="title">Ficha de Matrícula <?php echo date("Y"); ?></div>

        <div class="section-title">I. Antecedentes del Estudiante</div>
        <table class="form-table">
            <tr>
                <th>Nombre Completo</th>
                <td colspan="3" style="font-weight: bold; font-size: 13px;">
                    <?php echo htmlspecialchars($matricula['nombre'] . ' ' . $matricula['apellido_paterno'] . ' ' . $matricula['apellido_materno']); ?>
                </td>
            </tr>
            <tr>
                <th>RUN</th>
                <td><?php echo htmlspecialchars($matricula['rut']); ?></td>
                <th>Fecha Nacimiento</th>
                <td><?php echo htmlspecialchars(date("d-m-Y", strtotime($matricula['fecha_nac']))); ?></td>
            </tr>
            <tr>
                <th>Curso</th>
                <td><?php echo htmlspecialchars($curso['nombre']); ?></td>
                <th>Procedencia</th>
                <td><?php echo htmlspecialchars($matricula['procedencia']); ?></td>
            </tr>
            <tr>
                <th>Domicilio</th>
                <td colspan="3"><?php echo htmlspecialchars($matricula['dom_alumno']); ?></td>
            </tr>
            <tr>
                <th>Previsión Salud</th>
                <td><?php echo htmlspecialchars($prevision['tipo_prevision'] ?? 'S/I'); ?></td>
                <th>Alergias</th>
                <td><?php echo empty($alergias) ? 'Ninguna' : htmlspecialchars(implode(", ", $alergias)); ?></td>
            </tr>
        </table>

        <div class="section-title">II. Información Adicional</div>
        <table class="form-table">
            <tr>
                <th>¿Es Bicultural?</th>
                <td><?php echo $informacion_adicional['es_bicultural'] ? 'Sí' : 'No'; ?></td>
                <th>Etnia</th>
                <td><?php echo htmlspecialchars($informacion_adicional['etnia'] ?? 'No aplica'); ?></td>
            </tr>
            <tr>
                <th>Problemas Aprendizaje</th>
                <td colspan="3"><?php echo htmlspecialchars($informacion_adicional['problemas_aprendizaje'] ?? 'Ninguno'); ?></td>
            </tr>
            <tr>
                <th>Cursos Repetidos</th>
                <td colspan="3"><?php echo htmlspecialchars($informacion_adicional['cursos_repetidos'] ?? 'Ninguno'); ?></td>
            </tr>
        </table>

        <div class="section-title">III. Antecedentes del Apoderado</div>
        <?php if(!empty($apoderados)): ?>
            <?php foreach ($apoderados as $index => $apoderado): ?>
            <table class="form-table">
                <tr>
                    <th colspan="4" style="background-color: #e2e8f0; text-align: center; font-size: 11px;">Apoderado <?php echo $index + 1; ?></th>
                </tr>
                <tr>
                    <th>Nombre</th>
                    <td colspan="3"><?php echo htmlspecialchars($apoderado['nombre']); ?></td>
                </tr>
                <tr>
                    <th>RUN</th>
                    <td><?php echo htmlspecialchars($apoderado['rut']); ?></td>
                    <th>Parentesco</th>
                    <td><?php echo htmlspecialchars($apoderado['parentesco']); ?></td>
                </tr>
                <tr>
                    <th>Teléfono</th>
                    <td><?php echo htmlspecialchars($apoderado['telefono']); ?></td>
                    <th>Celular</th>
                    <td><?php echo htmlspecialchars($apoderado['celular']); ?></td>
                </tr>
            </table>
            <?php endforeach; ?>
        <?php else: ?>
            <p style="font-size:12px; padding:10px;">No se han registrado apoderados.</p>
        <?php endif; ?>

        <div class="section-title">IV. Grupo Familiar</div>
        <?php if(!empty($familiares)): ?>
            <table class="form-table">
                <thead>
                    <tr>
                        <th style="width: 30%;">Nombre</th>
                        <th style="width: 15%;">Parentesco</th>
                        <th style="width: 20%;">Escolaridad</th>
                        <th style="width: 20%;">Ocupación</th>
                        <th style="width: 15%;">Trabaja</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($familiares as $familiar): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($familiar['nombre'] . ' ' . $familiar['apellido_paterno']); ?></td>
                        <td><?php echo htmlspecialchars($familiar['parentesco']); ?></td>
                        <td><?php echo htmlspecialchars($familiar['escolaridad']); ?></td>
                        <td><?php echo htmlspecialchars($familiar['tipo_trabajo']); ?></td>
                        <td style="text-align:center;"><?php echo htmlspecialchars($familiar['dentro_fuera_hogar']); ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php else: ?>
            <p style="font-size:12px; padding:10px;">No se han registrado otros familiares.</p>
        <?php endif; ?>

        <div class="section-title">V. Autorización de Retiro (Llenado Manual)</div>
        <p style="font-size: 11px; margin-bottom: 10px; font-style: italic;">Complete solo si el estudiante será retirado por alguien distinto al apoderado.</p>
        <table class="form-table">
            <tr>
                <th>Nombre Completo</th>
                <td><input type="text" name="nombre_retiro"></td>
                <th>RUN</th>
                <td><input type="text" name="rut_retiro" style="width: 100px;"></td>
            </tr>
            <tr>
                <th>Parentesco</th>
                <td><input type="text" name="parentesco_retiro"></td>
                <th>Teléfono</th>
                <td><input type="text" name="telefono_retiro"></td>
            </tr>
            <tr>
                <th>Motivo/Causal</th>
                <td colspan="3"><input type="text" name="causal_retiro"></td>
            </tr>
        </table>

        <div style="margin-top: 20px; font-size: 12px; border: 1px solid var(--border-color); padding: 10px; background: #f9fafb;">
            <label style="display: flex; align-items: center; cursor: pointer;">
                <input type="checkbox" name="recibo_certificados"> 
                <span style="margin-left: 8px;">
                    Declaro conocer el reglamento interno del establecimiento y recibir carpeta con certificados de estudios de años anteriores y certificado de nacimiento.
                </span>
            </label>
        </div>

        <div class="signatures-container">
            <div class="signature-box">
                <div class="signature-line"></div>
                <div class="signature-text">Firma Apoderado(a)</div>
            </div>
            <div class="signature-box">
                <div class="signature-line"></div>
                <div class="signature-text">Timbre y Firma Dirección / Encargado</div>
            </div>
        </div>
    </div>

    <div class="button-section">
        <button class="btn btn-back" onclick="window.history.back()">Volver</button>
        <button class="btn btn-print" onclick="window.print()">Imprimir Ficha</button>
    </div>

</body>
</html>