<?php
session_start();
header('Content-Type: text/html; charset=utf-8');
include '../includes/db.php';
include '../includes/auth.php';
checkAuth();
$conn->set_charset("utf8");

// Manejo de mensajes
$message = ''; $message_type = '';
if (isset($_SESSION['message'])) {
    $message = $_SESSION['message']; $message_type = $_SESSION['message_type'];
    unset($_SESSION['message'], $_SESSION['message_type']);
}

// Cargar listas
$cursos_result = $conn->query("SELECT id, nombre FROM curso WHERE activo = 1 ORDER BY nombre ASC");
$previsiones_result = $conn->query("SELECT id, nombre FROM tipo_prevision ORDER BY nombre");

// --- PROCESAMIENTO DEL FORMULARIO ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // 1. Datos Básicos
    $num_centro_apoderados = $_POST['num_centro_apoderados'] ?? null;
    $rut = $_POST['rut'] ?? null;
    $nombres = $_POST['nombres'] ?? null;
    $apellido_paterno = $_POST['apellido_paterno'] ?? null;
    $apellido_materno = $_POST['apellido_materno'] ?? null;
    $fecha_nac = $_POST['fecha_nac'] ?? null;
    $lugar_nac = $_POST['lugar_nac'] ?? null;
    $dom_alumno = $_POST['dom_alumno'] ?? null;
    $curso_id = !empty($_POST['curso_id']) ? intval($_POST['curso_id']) : null;
    $fech_ing_curso = $_POST['fech_ing_curso'] ?? date('Y-m-d');
    $procedencia = $_POST['procedencia'] ?? null;
    $persona_con_quien_vive = isset($_POST['vive_con']) ? implode(', ', $_POST['vive_con']) : null;

    // 2. Datos de Auditoría
    $registrado_por = $_SESSION['usuario_id'];
    $estado = 'Completada';
    
    $opt_religion = isset($_POST['opt_religion']) ? 1 : 0;
    $aut_uso_imagen = isset($_POST['aut_uso_imagen']) ? 1 : 0;
    $aut_salidas = isset($_POST['aut_salidas_pedagogicas']) ? 1 : 0;
    $beneficiario_pae = isset($_POST['beneficiario_pae']) ? 1 : 0;

    // 3. Etnia
    $es_bicultural = isset($_POST['es_bicultural']) ? 1 : 0;
    $etnia = null;
    if ($es_bicultural) {
        $sel = $_POST['etnia_select'] ?? '';
        $etnia = ($sel === 'Otra') ? trim($_POST['etnia_text']) : $sel;
    }

    // 4. Otros
    $prevision_salud = !empty($_POST['prevision_salud']) ? intval($_POST['prevision_salud']) : null;
    $alergias = $_POST['alergico_alimentario'] ?? [];
    $problemas_aprendizaje = $_POST['problemas_aprendizaje'] ?? null;
    $cursos_repetidos = $_POST['cursos_repetidos'] ?? null;

    // 5. Apoderados
    $nombre_apo1 = $_POST['nombre_apoderado1'] ?? null;
    $rut_apo1 = $_POST['rut_apoderado1'] ?? null;
    $tel_apo1 = $_POST['telefono_apoderado1'] ?? null;
    $cel_apo1 = $_POST['celular_apoderado1'] ?? null;
    $par_apo1 = $_POST['parentesco_apoderado1'] ?? null;
    
    $nombre_apo2 = $_POST['nombre_apoderado2'] ?? null;
    $rut_apo2 = $_POST['rut_apoderado2'] ?? null;
    $tel_apo2 = $_POST['telefono_apoderado2'] ?? null;
    $cel_apo2 = $_POST['celular_apoderado2'] ?? null;
    $par_apo2 = $_POST['parentesco_apoderado2'] ?? null;

    $conn->begin_transaction();
    try {
        // A. MATRÍCULA
        $sql = "INSERT INTO matricula (num_centro_apoderados, rut, nombre, apellido_paterno, apellido_materno, curso_id, fecha_nac, lugar_nac, dom_alumno, fech_ing_curso, procedencia, persona_con_quien_vive, opt_religion, aut_uso_imagen, aut_salidas_pedagogicas, beneficiario_pae, registrado_por, estado, fecha_registro) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("issssissssssiiiiis", $num_centro_apoderados, $rut, $nombres, $apellido_paterno, $apellido_materno, $curso_id, $fecha_nac, $lugar_nac, $dom_alumno, $fech_ing_curso, $procedencia, $persona_con_quien_vive, $opt_religion, $aut_uso_imagen, $aut_salidas, $beneficiario_pae, $registrado_por, $estado);
        if (!$stmt->execute()) throw new Exception("Error Matrícula: " . $stmt->error);
        $matricula_id = $conn->insert_id;
        $stmt->close();

        // B. PREVISIÓN
        $stmt = $conn->prepare("INSERT INTO previsiones_salud (matricula_id, tipo_prevision_id) VALUES (?, ?)");
        $stmt->bind_param("ii", $matricula_id, $prevision_salud);
        $stmt->execute();
        $stmt->close();

        // C. ALERGIAS
        if (!empty($alergias)) {
            $stmt = $conn->prepare("INSERT INTO alergias_alimentarias (matricula_id, alergia) VALUES (?, ?)");
            foreach ($alergias as $al) {
                if (!empty(trim($al))) {
                    $stmt->bind_param("is", $matricula_id, $al);
                    $stmt->execute();
                }
            }
            $stmt->close();
        }

        // D. INFO ADICIONAL
        $stmt = $conn->prepare("INSERT INTO informacion_adicional (matricula_id, es_bicultural, etnia, problemas_aprendizaje, cursos_repetidos) VALUES (?, ?, ?, ?, ?)");
        $stmt->bind_param("iisss", $matricula_id, $es_bicultural, $etnia, $problemas_aprendizaje, $cursos_repetidos);
        $stmt->execute();
        $stmt->close();

        // E. FAMILIARES
        function guardarFamiliar($conn, $mid, $sufijo, $parentesco) {
            $rut = $_POST['rut_'.$sufijo] ?? null;
            $nom = $_POST['nombre_'.$sufijo] ?? null;
            $app = $_POST['apellido_paterno_'.$sufijo] ?? null;
            $apm = $_POST['apellido_materno_'.$sufijo] ?? null;
            $dom = $_POST['dom_'.$sufijo] ?? null;
            $esco = $_POST['escolaridad_'.$sufijo] ?? null;
            $trab = isset($_POST['trabaja_'.$sufijo]) ? intval($_POST['trabaja_'.$sufijo]) : 0;
            $tipo = $_POST['tipo_trabajo_'.$sufijo] ?? null;
            $dond = $_POST['dentro_fuera_hogar_'.$sufijo] ?? null;

            if ($rut && $nom) {
                $stmt = $conn->prepare("INSERT INTO familiares (matricula_id, rut, nombre, apellido_paterno, apellido_materno, domicilio, escolaridad, trabaja, tipo_trabajo, dentro_fuera_hogar, parentesco) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                $stmt->bind_param("issssssisss", $mid, $rut, $nom, $app, $apm, $dom, $esco, $trab, $tipo, $dond, $parentesco);
                $stmt->execute();
                $stmt->close();
            }
        }

        if (isset($_POST['vive_con'])) {
            if (in_array('Madre', $_POST['vive_con'])) guardarFamiliar($conn, $matricula_id, 'mama', 'Madre');
            if (in_array('Padre', $_POST['vive_con'])) guardarFamiliar($conn, $matricula_id, 'papa', 'Padre');
            if (in_array('Otro', $_POST['vive_con']))  guardarFamiliar($conn, $matricula_id, 'otro', 'Otro');
        }

        // F. APODERADOS
        $stmt = $conn->prepare("INSERT INTO apoderados (matricula_id, rut, nombre, telefono, celular, parentesco) VALUES (?, ?, ?, ?, ?, ?)");
        if ($nombre_apo1) { $stmt->bind_param("isssss", $matricula_id, $rut_apo1, $nombre_apo1, $tel_apo1, $cel_apo1, $par_apo1); $stmt->execute(); }
        if ($nombre_apo2) { $stmt->bind_param("isssss", $matricula_id, $rut_apo2, $nombre_apo2, $tel_apo2, $cel_apo2, $par_apo2); $stmt->execute(); }
        $stmt->close();

        $conn->commit();
        $_SESSION['message'] = "✅ Matrícula guardada correctamente. Folio: " . str_pad($matricula_id, 4, "0", STR_PAD_LEFT);
        $_SESSION['message_type'] = "exito";

    } catch (Exception $e) {
        $conn->rollback();
        die("<h1>Error al Guardar:</h1><p>" . $e->getMessage() . "</p><br><a href='formulario_matricula.php'>Volver</a>");
    }
    
    header("Location: formulario_matricula.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="../images/logo.png">
    <title>Matrícula 2025 - Escuela Porongo</title>
    
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="stylesheet" href="../css/admin.css">

    <style>
        :root { --primary: #1e3a8a; --secondary: #3b82f6; --bg-light: #f8fafc; --border-color: #cbd5e1; --text-color: #334155; }
        body { font-family: 'Roboto', sans-serif; background-color: #e2e8f0; color: var(--text-color); }
        .container { max-width: 1100px; margin: 40px auto; padding: 0 20px; }
        .form-card { background: white; padding: 40px; border-radius: 12px; box-shadow: 0 10px 25px rgba(0,0,0,0.05); border-top: 5px solid var(--primary); }
        h2.form-title { color: var(--primary); font-size: 1.8rem; margin-bottom: 30px; text-align: center; font-weight: 700; }
        .section-header { font-size: 1.1rem; font-weight: 600; color: var(--primary); margin-top: 35px; margin-bottom: 20px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0; display: flex; align-items: center; gap: 10px; }
        .form-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(280px, 1fr)); gap: 20px; }
        .col-full { grid-column: 1 / -1; }
        .col-3 { grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); }
        .form-group { margin-bottom: 5px; }
        label { display: block; font-weight: 500; font-size: 0.9rem; margin-bottom: 8px; color: #475569; }
        input[type="text"], input[type="date"], input[type="number"], select { width: 100%; padding: 12px 15px; border: 1px solid var(--border-color); border-radius: 8px; font-size: 0.95rem; color: var(--text-color); transition: 0.3s; background-color: #f8fafc; box-sizing: border-box; }
        input:focus, select:focus { outline: none; border-color: var(--secondary); background-color: white; box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1); }
        .radio-group, .checkbox-group { display: flex; gap: 20px; flex-wrap: wrap; margin-top: 5px; }
        .radio-option, .checkbox-option { display: flex; align-items: center; gap: 8px; cursor: pointer; padding: 8px 12px; border: 1px solid var(--border-color); border-radius: 6px; background: white; transition: 0.2s; }
        .radio-option:hover, .checkbox-option:hover { background: #f1f5f9; border-color: var(--secondary); }
        input[type="radio"], input[type="checkbox"] { transform: scale(1.2); cursor: pointer; }
        .btn-submit { width: 100%; padding: 15px; background-color: var(--primary); color: white; border: none; border-radius: 8px; font-size: 1.1rem; font-weight: 600; cursor: pointer; margin-top: 40px; transition: 0.3s; }
        .btn-submit:hover { background-color: #1e40af; transform: translateY(-2px); }
        .conditional-section { background-color: #f8fafc; padding: 25px; border-radius: 10px; border: 1px dashed var(--border-color); margin-top: 20px; animation: fadeIn 0.3s; }
        .hidden { display: none; }
        .admin-info { background: #fdf2f8; padding: 15px; border-radius: 8px; border: 1px solid #fbcfe8; font-size: 0.9rem; color: #be185d; margin-bottom: 20px; text-align: right; }
        .auth-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(220px, 1fr)); gap: 15px; margin-bottom: 20px; }
        .etnia-block { background-color: #fff7ed; border: 1px solid #ffedd5; padding: 20px; border-radius: 8px; margin-top: 15px; animation: fadeIn 0.3s; }
        .alergia-item { display: flex; gap: 10px; margin-bottom: 10px; }
        .btn-icon { background: none; border: none; color: #ef4444; cursor: pointer; font-size: 1.2rem; }
        @keyframes fadeIn { from { opacity: 0; transform: translateY(10px); } to { opacity: 1; transform: translateY(0); } }
    </style>
</head>
<body>

<header>
    <div class="header-content">
        <img src="../images/INSIGNIA SF.png" alt="Logo">
        <h1>Administración Escolar</h1>
        <nav>
            <ul>
                <li><a href="../index.php"><i class="fas fa-home"></i> Inicio</a></li>
                <li><a href="../matriculas/crud_matriculas.php"><i class="fas fa-arrow-left"></i> Volver</a></li>
            </ul>
        </nav>
    </div>
</header>

<main class="container">
    <?php if ($message): ?>
        <div class="mensaje <?php echo $message_type; ?> show" style="margin-bottom: 20px;"><?php echo htmlspecialchars($message); ?></div>
    <?php endif; ?>

    <div class="form-card">
        <div class="admin-info">
            <i class="fas fa-user-shield"></i> Responsable: <strong><?php echo $_SESSION['nombre']; ?></strong> | Fecha: <strong><?php echo date('d-m-Y'); ?></strong>
        </div>

        <h2 class="form-title"><i class="fas fa-file-contract"></i> Ficha de Matrícula 2025</h2>
        
        <form action="formulario_matricula.php" method="POST" id="matriculaForm">
            
            <h3 class="section-header"><i class="fas fa-user-graduate"></i> I. Datos del Estudiante</h3>
            <div class="form-grid">
                <div class="form-group"><label>Nº Matrícula</label><input type="text" name="num_centro_apoderados"></div>
                <div class="form-group"><label>RUN</label><input type="text" name="rut" placeholder="Ej: 12345678-9" required></div>
                <div class="form-group col-full">
                    <div class="form-grid col-3">
                        <div><label>Nombres</label><input type="text" name="nombres" required></div>
                        <div><label>Ap. Paterno</label><input type="text" name="apellido_paterno" required></div>
                        <div><label>Ap. Materno</label><input type="text" name="apellido_materno" required></div>
                    </div>
                </div>
                <div class="form-group"><label>Fecha Nacimiento</label><input type="date" name="fecha_nac" required></div>
                <div class="form-group"><label>Lugar Nacimiento</label><input type="text" name="lugar_nac" required></div>
                <div class="form-group col-full"><label>Domicilio Completo</label><input type="text" name="dom_alumno" required></div>
                <div class="form-group">
                    <label>Curso</label>
                    <select name="curso_id" required>
                        <option value="">-- Seleccione --</option>
                        <?php $cursos_result->data_seek(0); while($c = $cursos_result->fetch_assoc()): ?>
                            <option value="<?= $c['id'] ?>"><?= $c['nombre'] ?></option>
                        <?php endwhile; ?>
                    </select>
                </div>
                <div class="form-group"><label>Fecha Ingreso</label><input type="date" name="fech_ing_curso" value="<?= date('Y-m-d') ?>" required></div>
                <div class="form-group col-full"><label>Procedencia</label><input type="text" name="procedencia" required></div>
            </div>

            <h3 class="section-header"><i class="fas fa-heartbeat"></i> II. Salud y Bienestar</h3>
            <div class="form-grid">
                <div class="form-group">
                    <label>Previsión</label>
                    <select name="prevision_salud" required>
                        <option value="">-- Seleccione --</option>
                        <?php $previsiones_result->data_seek(0); while($p = $previsiones_result->fetch_assoc()): ?>
                            <option value="<?= $p['id'] ?>"><?= $p['nombre'] ?></option>
                        <?php endwhile; ?>
                    </select>
                </div>
                <div class="form-group col-full">
                    <label>Alergias Alimentarias</label>
                    <div id="alergias-container">
                        <div class="alergia-item"><input type="text" name="alergico_alimentario[]" placeholder="Especifique..."></div>
                    </div>
                    <button type="button" onclick="addAlergia()" style="background:none; border:none; color:var(--secondary); font-weight:bold; cursor:pointer;">+ Agregar otra</button>
                </div>
            </div>

            <h3 class="section-header"><i class="fas fa-file-contract"></i> III. Autorizaciones y Declaraciones</h3>
            <div class="auth-grid">
                <label class="checkbox-option"><input type="checkbox" name="opt_religion" value="1" checked> Religión</label>
                <label class="checkbox-option"><input type="checkbox" name="aut_uso_imagen" value="1"> Uso Imagen</label>
                <label class="checkbox-option"><input type="checkbox" name="aut_salidas_pedagogicas" value="1" checked> Salidas Comunales</label>
                <label class="checkbox-option"><input type="checkbox" name="beneficiario_pae" value="1"> Beneficiario PAE</label>
                
                <label class="checkbox-option" style="background-color: #fff7ed; border-color: #ffedd5;">
                    <input type="checkbox" name="es_bicultural" id="check_bicultural" value="1" onchange="toggleEtnia()"> 
                    <span style="color:#c2410c; font-weight:bold;">Es Bicultural / Etnia</span>
                </label>
            </div>

            <div id="container_etnia" class="hidden etnia-block">
                <h4 style="margin:0 0 10px 0; color:#9a3412;">Pueblo Originario:</h4>
                <div class="form-grid">
                    <select name="etnia_select" id="etnia_select" onchange="checkOtraEtnia()">
                        <option value="">-- Seleccione --</option>
                        <option value="Mapuche">Mapuche</option>
                        <option value="Aymara">Aymara</option>
                        <option value="Rapa Nui">Rapa Nui</option>
                        <option value="Quechua">Quechua</option>
                        <option value="Atacameño">Atacameño</option>
                        <option value="Diaguita">Diaguita</option>
                        <option value="Colla">Colla</option>
                        <option value="Kawésqar">Kawésqar</option>
                        <option value="Yagán">Yagán</option>
                        <option value="Chango">Chango</option>
                        <option value="Otra">Otra</option>
                    </select>
                    <input type="text" name="etnia_text" id="etnia_text" class="hidden" placeholder="Especifique cuál...">
                </div>
            </div>

            <div class="form-grid" style="margin-top:20px;">
                <div class="form-group col-full"><label>Diagnósticos / PIE</label><input type="text" name="problemas_aprendizaje"></div>
                <div class="form-group col-full"><label>Cursos Repetidos</label><input type="text" name="cursos_repetidos"></div>
            </div>

            <h3 class="section-header"><i class="fas fa-users"></i> IV. Grupo Familiar</h3>
            <div class="form-group">
                <label>¿Con quién vive el alumno?</label>
                <div class="checkbox-group">
                    <label class="checkbox-option"><input type="checkbox" name="vive_con[]" value="Madre" onclick="toggleSection('sec_madre', this)"> Madre</label>
                    <label class="checkbox-option"><input type="checkbox" name="vive_con[]" value="Padre" onclick="toggleSection('sec_padre', this)"> Padre</label>
                    <label class="checkbox-option"><input type="checkbox" name="vive_con[]" value="Otro" onclick="toggleSection('sec_otro', this)"> Otro</label>
                </div>
            </div>

            <div id="sec_madre" class="conditional-section hidden">
                <h4 style="margin-top:0; color:var(--primary);">Datos Madre</h4>
                <div class="form-grid">
                    <input type="text" name="nombre_mama" placeholder="Nombre">
                    <input type="text" name="apellido_paterno_mama" placeholder="Ap. Paterno">
                    <input type="text" name="apellido_materno_mama" placeholder="Ap. Materno">
                    <input type="text" name="rut_mama" placeholder="RUN">
                    <input type="text" name="dom_mama" placeholder="Domicilio" class="col-full">
                    
                    <div class="form-group">
                        <label>Escolaridad</label>
                        <select name="escolaridad_mama">
                            <option value="">Seleccione</option>
                            <option value="Básica Incompleta">Básica Incompleta</option>
                            <option value="Básica Completa">Básica Completa</option>
                            <option value="Media Incompleta">Media Incompleta</option>
                            <option value="Media Completa">Media Completa</option>
                            <option value="Técnica">Técnica</option>
                            <option value="Superior">Superior</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>¿Trabaja?</label>
                        <div class="radio-group">
                            <label class="radio-option"><input type="radio" name="trabaja_mama" value="1" onclick="toggleTrabajo('mama', true)"> Sí</label>
                            <label class="radio-option"><input type="radio" name="trabaja_mama" value="0" onclick="toggleTrabajo('mama', false)" checked> No</label>
                        </div>
                    </div>
                    <div class="form-group">
                        <label>Tipo Trabajo</label>
                        <select name="tipo_trabajo_mama" id="tipo_trabajo_mama" disabled>
                            <option value="">Seleccione</option>
                            <option value="Dependiente">Dependiente</option>
                            <option value="Independiente">Independiente</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>¿Trabaja dentro o fuera del hogar?</label>
                        <select name="dentro_fuera_hogar_mama" id="dentro_fuera_hogar_mama" disabled>
                            <option value="">Seleccione</option>
                            <option value="Dentro del Hogar">Dentro del Hogar</option>
                            <option value="Fuera del Hogar">Fuera del Hogar</option>
                        </select>
                    </div>
                </div>
            </div>

            <div id="sec_padre" class="conditional-section hidden">
                <h4 style="margin-top:0; color:var(--primary);">Datos Padre</h4>
                <div class="form-grid">
                    <input type="text" name="nombre_papa" placeholder="Nombre">
                    <input type="text" name="apellido_paterno_papa" placeholder="Ap. Paterno">
                    <input type="text" name="apellido_materno_papa" placeholder="Ap. Materno">
                    <input type="text" name="rut_papa" placeholder="RUN">
                    <input type="text" name="dom_papa" placeholder="Domicilio" class="col-full">
                    
                    <div class="form-group">
                        <label>Escolaridad</label>
                        <select name="escolaridad_papa">
                            <option value="">Seleccione</option>
                            <option value="Básica Incompleta">Básica Incompleta</option>
                            <option value="Básica Completa">Básica Completa</option>
                            <option value="Media Incompleta">Media Incompleta</option>
                            <option value="Media Completa">Media Completa</option>
                            <option value="Técnica">Técnica</option>
                            <option value="Superior">Superior</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>¿Trabaja?</label>
                        <div class="radio-group">
                            <label class="radio-option"><input type="radio" name="trabaja_papa" value="1" onclick="toggleTrabajo('papa', true)"> Sí</label>
                            <label class="radio-option"><input type="radio" name="trabaja_papa" value="0" onclick="toggleTrabajo('papa', false)" checked> No</label>
                        </div>
                    </div>
                    <div class="form-group">
                        <label>Tipo Trabajo</label>
                        <select name="tipo_trabajo_papa" id="tipo_trabajo_papa" disabled>
                            <option value="">Seleccione</option>
                            <option value="Dependiente">Dependiente</option>
                            <option value="Independiente">Independiente</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>¿Trabaja dentro o fuera del hogar?</label>
                        <select name="dentro_fuera_hogar_papa" id="dentro_fuera_hogar_papa" disabled>
                            <option value="">Seleccione</option>
                            <option value="Dentro del Hogar">Dentro del Hogar</option>
                            <option value="Fuera del Hogar">Fuera del Hogar</option>
                        </select>
                    </div>
                </div>
            </div>

            <div id="sec_otro" class="conditional-section hidden">
                <h4 style="margin-top:0; color:var(--primary);">Datos Otro Familiar</h4>
                <div class="form-grid">
                    <input type="text" name="nombre_otro" placeholder="Nombre">
                    <input type="text" name="apellido_paterno_otro" placeholder="Ap. Paterno">
                    <input type="text" name="apellido_materno_otro" placeholder="Ap. Materno">
                    <input type="text" name="rut_otro" placeholder="RUN">
                    <input type="text" name="parentesco_otro" placeholder="Parentesco (Ej: Abuela)">
                    <input type="text" name="dom_otro" placeholder="Domicilio" class="col-full">
                    
                    <div class="form-group">
                        <label>Escolaridad</label>
                        <select name="escolaridad_otro">
                            <option value="">Seleccione</option>
                            <option value="Básica Incompleta">Básica Incompleta</option>
                            <option value="Básica Completa">Básica Completa</option>
                            <option value="Media Incompleta">Media Incompleta</option>
                            <option value="Media Completa">Media Completa</option>
                            <option value="Técnica">Técnica</option>
                            <option value="Superior">Superior</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>¿Trabaja?</label>
                        <div class="radio-group">
                            <label class="radio-option"><input type="radio" name="trabaja_otro" value="1" onclick="toggleTrabajo('otro', true)"> Sí</label>
                            <label class="radio-option"><input type="radio" name="trabaja_otro" value="0" onclick="toggleTrabajo('otro', false)" checked> No</label>
                        </div>
                    </div>
                    <div class="form-group">
                        <label>Tipo Trabajo</label>
                        <select name="tipo_trabajo_otro" id="tipo_trabajo_otro" disabled>
                            <option value="">Seleccione</option>
                            <option value="Dependiente">Dependiente</option>
                            <option value="Independiente">Independiente</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>¿Trabaja dentro o fuera del hogar?</label>
                        <select name="dentro_fuera_hogar_otro" id="dentro_fuera_hogar_otro" disabled>
                            <option value="">Seleccione</option>
                            <option value="Dentro del Hogar">Dentro del Hogar</option>
                            <option value="Fuera del Hogar">Fuera del Hogar</option>
                        </select>
                    </div>
                </div>
            </div>

            <h3 class="section-header"><i class="fas fa-user-shield"></i> V. Apoderados</h3>
            <div style="background:#f0f9ff; padding:20px; border-radius:8px; border:1px solid #bae6fd; margin-bottom:20px;">
                <h4 style="margin-top:0; color:#0369a1;">Titular (Obligatorio)</h4>
                <div class="form-grid">
                    <input type="text" name="nombre_apoderado1" placeholder="Nombre Completo" required>
                    <input type="text" name="rut_apoderado1" placeholder="RUN" required>
                    <input type="text" name="telefono_apoderado1" placeholder="Fijo">
                    <input type="text" name="celular_apoderado1" placeholder="Celular" required>
                    <input type="text" name="parentesco_apoderado1" placeholder="Parentesco" required>
                </div>
            </div>
            
            <div style="background:#fdf2f8; padding:20px; border-radius:8px; border:1px solid #fbcfe8;">
                <h4 style="margin-top:0; color:#be185d;">Suplente (Opcional)</h4>
                <div class="form-grid">
                    <input type="text" name="nombre_apoderado2" placeholder="Nombre">
                    <input type="text" name="rut_apoderado2" placeholder="RUN">
                    <input type="text" name="telefono_apoderado2" placeholder="Fijo">
                    <input type="text" name="celular_apoderado2" placeholder="Celular">
                    <input type="text" name="parentesco_apoderado2" placeholder="Parentesco">
                </div>
            </div>

            <button type="submit" class="btn-submit"><i class="fas fa-save"></i> Registrar Matrícula Oficial</button>
        </form>
    </div>
</main>

<script>
    function toggleSection(id, checkbox) {
        document.getElementById(id).style.display = checkbox.checked ? 'block' : 'none';
    }
    
    // Función corregida para habilitar campos de trabajo
    function toggleTrabajo(persona, habilitar) {
        const tipo = document.getElementById('tipo_trabajo_' + persona);
        const donde = document.getElementById('dentro_fuera_hogar_' + persona);
        
        if (tipo) {
            tipo.disabled = !habilitar;
            if(!habilitar) tipo.value = "";
        }
        if (donde) {
            donde.disabled = !habilitar;
            if(!habilitar) donde.value = "";
        }
    }

    function addAlergia() {
        const div = document.createElement('div');
        div.className = 'alergia-item';
        div.innerHTML = `<input type="text" name="alergico_alimentario[]" placeholder="Especifique...">
                         <button type="button" class="btn-icon" onclick="this.parentElement.remove()"><i class="fas fa-times-circle"></i></button>`;
        document.getElementById('alergias-container').appendChild(div);
    }

    function toggleEtnia() {
        const chk = document.getElementById('check_bicultural');
        const box = document.getElementById('container_etnia');
        if(chk.checked) {
            box.classList.remove('hidden');
        } else {
            box.classList.add('hidden');
            document.getElementById('etnia_select').value = "";
            document.getElementById('etnia_text').value = "";
            document.getElementById('group_etnia_text').classList.add('hidden');
        }
    }

    function checkOtraEtnia() {
        const sel = document.getElementById('etnia_select');
        const grp = document.getElementById('group_etnia_text');
        const txt = document.getElementById('etnia_text');
        
        if(sel.value === 'Otra') {
            grp.classList.remove('hidden');
            txt.required = true;
        } else {
            grp.classList.add('hidden');
            txt.required = false;
            txt.value = "";
        }
    }
</script>

</body>
</html>