<?php
session_start(); // Iniciar la sesión
header('Content-Type: text/html; charset=utf-8');

include '../includes/db.php'; // Incluir archivo de conexión a la base de datos
include '../includes/auth.php'; // Incluir archivo de autenticación
checkAuth(); // Verificar si el usuario está autenticado

// AÑADIDO: Manejo de mensajes de sesión
$message = '';
$message_type = '';
if (isset($_SESSION['message'])) {
    $message = $_SESSION['message'];
    $message_type = $_SESSION['message_type'];
    unset($_SESSION['message'], $_SESSION['message_type']);
}

$matricula_id = isset($_GET['id']) ? intval($_GET['id']) : null;

if (!$matricula_id) {
    die("Error: No se proporcionó un ID válido para la matrícula.");
}

// Lógica para actualizar la matrícula
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // ... (Obtención de datos del formulario) ...
    $nombres = $_POST['nombres'];
    $apellido_paterno = $_POST['apellido_paterno'];
    $apellido_materno = $_POST['apellido_materno'];
    $fecha_nac = $_POST['fecha_nac'];
    $lugar_nac = $_POST['lugar_nac'];
    $dom_alumno = $_POST['dom_alumno'];
    $curso_id = $_POST['curso_id'];
    $rut = $_POST['rut'];
    $procedencia = $_POST['procedencia'];
    $vive_con = isset($_POST['vive_con']) ? implode(', ', $_POST['vive_con']) : null;
    $prevision_salud = $_POST['prevision_salud'];
    $es_bicultural = isset($_POST['es_bicultural']) ? 1 : 0;
    $etnia = $_POST['etnia'];
    $problemas_aprendizaje = $_POST['problemas_aprendizaje'];
    $cursos_repetidos = $_POST['cursos_repetidos'];

    $conn->begin_transaction();
    try {
        // Actualizar la matrícula
        $stmt_matricula = $conn->prepare("UPDATE matricula SET nombre = ?, apellido_paterno = ?, apellido_materno = ?, fecha_nac = ?, lugar_nac = ?, dom_alumno = ?, curso_id = ?, rut = ?, procedencia = ?, persona_con_quien_vive = ? WHERE id = ?");
        $stmt_matricula->bind_param("ssssssisssi", $nombres, $apellido_paterno, $apellido_materno, $fecha_nac, $lugar_nac, $dom_alumno, $curso_id, $rut, $procedencia, $vive_con, $matricula_id);
        if (!$stmt_matricula->execute()) throw new Exception("Error al actualizar matrícula: " . $stmt_matricula->error);
        $stmt_matricula->close();

        // Actualizar previsión de salud
        $stmt_prevision = $conn->prepare("UPDATE previsiones_salud SET tipo_prevision_id = ? WHERE matricula_id = ?");
        $stmt_prevision->bind_param("si", $prevision_salud, $matricula_id);
        $stmt_prevision->execute();
        $stmt_prevision->close();

        // Actualizar información adicional
        $stmt_info = $conn->prepare("UPDATE informacion_adicional SET es_bicultural = ?, etnia = ?, problemas_aprendizaje = ?, cursos_repetidos = ? WHERE matricula_id = ?");
        $stmt_info->bind_param("isssi", $es_bicultural, $etnia, $problemas_aprendizaje, $cursos_repetidos, $matricula_id);
        $stmt_info->execute();
        $stmt_info->close();

        // Eliminar alergias actuales
        $stmt_del_alergia = $conn->prepare("DELETE FROM alergias_alimentarias WHERE matricula_id = ?");
        $stmt_del_alergia->bind_param("i", $matricula_id);
        $stmt_del_alergia->execute();
        $stmt_del_alergia->close();

        // Insertar nuevamente las alergias
        $stmt_ins_alergia = $conn->prepare("INSERT INTO alergias_alimentarias (matricula_id, alergia) VALUES (?, ?)");
        if (!empty($_POST['alergico_alimentario'])) {
            foreach ($_POST['alergico_alimentario'] as $alergia) {
                if (!empty(trim($alergia))) { // No insertar alergias vacías
                    $stmt_ins_alergia->bind_param("is", $matricula_id, $alergia);
                    $stmt_ins_alergia->execute();
                }
            }
        }
        $stmt_ins_alergia->close();
        
        // (La lógica para actualizar Madre, Padre, Otro faltaba en tu POST, 
        // pero la estructura de la BD está lista si la añades aquí)

        $conn->commit();
        $_SESSION['message'] = "Matrícula actualizada exitosamente.";
        $_SESSION['message_type'] = "exito"; // MODIFICADO

    } catch (Exception $e) {
        $conn->rollback();
        $_SESSION['message'] = "Error al actualizar la matrícula: " . $e->getMessage();
        $_SESSION['message_type'] = "error";
    }
    
    // MODIFICADO: Redirigir para mostrar el mensaje de sesión
    header("Location: editar_matricula.php?id=" . $matricula_id);
    exit();
}

// --- Obtener datos para el formulario ---
$stmt = $conn->prepare("SELECT * FROM matricula WHERE id = ?");
$stmt->bind_param("i", $matricula_id);
$stmt->execute();
$matricula = $stmt->get_result()->fetch_assoc();
if (!$matricula) {
    die("Error: Matrícula no encontrada.");
}

$info_adicional = $conn->query("SELECT * FROM informacion_adicional WHERE matricula_id = $matricula_id")->fetch_assoc();
$prevision_salud = $conn->query("SELECT * FROM previsiones_salud WHERE matricula_id = $matricula_id")->fetch_assoc();
$alergias = $conn->query("SELECT * FROM alergias_alimentarias WHERE matricula_id = $matricula_id")->fetch_all(MYSQLI_ASSOC);
$cursos_result = $conn->query("SELECT id, nombre FROM curso WHERE activo = 1 ORDER BY nombre ASC");
$madre = $conn->query("SELECT * FROM familiares WHERE matricula_id = $matricula_id AND parentesco = 'Madre'")->fetch_assoc();
$padre = $conn->query("SELECT * FROM familiares WHERE matricula_id = $matricula_id AND parentesco = 'Padre'")->fetch_assoc();
$otro = $conn->query("SELECT * FROM familiares WHERE matricula_id = $matricula_id AND parentesco = 'Otro'")->fetch_assoc();
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="../images/logo.png">
    <title>Editar Matrícula</title>
    
    <link rel="stylesheet" href="../css/admin.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    
    <style>
        .form-grid-2col {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 1.5rem;
        }
        .full-width { grid-column: 1 / -1; }
        .section-header {
            font-size: 1.2rem;
            font-weight: 700;
            color: var(--primary-color);
            margin-top: 2rem;
            margin-bottom: 1rem;
            border-bottom: 2px solid var(--grey-light);
            padding-bottom: 0.5rem;
            grid-column: 1 / -1;
        }
        .checkbox-group {
            display: flex;
            flex-wrap: wrap;
            gap: 1.5rem;
            margin-bottom: 20px;
            grid-column: 1 / -1;
        }
        .checkbox-group label {
            font-weight: 500;
            margin-left: 0.5rem;
        }
        .checkbox-group input[type="checkbox"] {
            width: 18px;
            height: 18px;
        }
        .alergia-item {
            display: flex;
            gap: 10px;
            margin-bottom: 10px;
        }
        .alergia-item input { margin-bottom: 0; }
        .btn-sm { padding: 0.5rem 0.8rem; font-size: 0.8rem; }
        input.error, select.error, textarea.error {
            border-color: var(--danger-color);
            box-shadow: 0 0 5px rgba(231, 76, 60, 0.5);
        }
    </style>
</head>
<body>
    
<header>
    <div class="header-content">
        <img src="../images/INSIGNIA SF.png" alt="Escuela Porongo Insignia">
        <h1>Editar Matrícula</h1>
        <nav>
            <ul>
                <li><a href="../index.php"><i class="fas fa-home"></i> Inicio</a></li>
                <li><a href="crud_matriculas.php"><i class="fas fa-arrow-left"></i> Volver</a></li>
            </ul>
        </nav>
    </div>
</header>

<main class="container">

    <div class="mensaje" id="mensaje-box" style="display: none;"></div>

    <div class="card form-container">
        <h2><i class="fas fa-edit"></i> Editando a: <?php echo htmlspecialchars($matricula['nombre'] . ' ' . $matricula['apellido_paterno']); ?></h2>

        <form action="editar_matricula.php?id=<?php echo $matricula_id; ?>" method="POST">
            
            <div class="form-grid-2col">
                
                <h3 class="section-header"><i class="fas fa-user-graduate"></i> Información del Estudiante</h3>
                
                <div class="form-group">
                    <label for="rut">RUN (ejemplo: 12345678-9):</label>
                    <input type="text" id="rut" name="rut" value="<?php echo htmlspecialchars($matricula['rut'] ?? ''); ?>" required>
                </div>
                <div class="form-group">
                    <label for="nombres">Nombres:</label>
                    <input type="text" id="nombres" name="nombres" value="<?php echo htmlspecialchars($matricula['nombre'] ?? ''); ?>" required>
                </div>
                <div class="form-group">
                    <label for="apellido_paterno">Apellido Paterno:</label>
                    <input type="text" id="apellido_paterno" name="apellido_paterno" value="<?php echo htmlspecialchars($matricula['apellido_paterno'] ?? ''); ?>" required>
                </div>
                <div class="form-group">
                    <label for="apellido_materno">Apellido Materno:</label>
                    <input type="text" id="apellido_materno" name="apellido_materno" value="<?php echo htmlspecialchars($matricula['apellido_materno'] ?? ''); ?>" required>
                </div>
                <div class="form-group">
                    <label for="fecha_nac">Fecha de Nacimiento:</label>
                    <input type="date" id="fecha_nac" name="fecha_nac" value="<?php echo htmlspecialchars($matricula['fecha_nac'] ?? ''); ?>" required>
                </div>
                <div class="form-group">
                    <label for="lugar_nac">Lugar de Nacimiento:</label>
                    <input type="text" id="lugar_nac" name="lugar_nac" value="<?php echo htmlspecialchars($matricula['lugar_nac'] ?? ''); ?>" required>
                </div>
                <div class="form-group">
                    <label for="curso_id">Curso:</label>
                    <select id="curso_id" name="curso_id" required>
                        <?php while ($curso = $cursos_result->fetch_assoc()): ?>
                            <option value="<?php echo htmlspecialchars($curso['id']); ?>" <?php echo ($curso['id'] == $matricula['curso_id']) ? 'selected' : ''; ?>>
                                <?php echo htmlspecialchars($curso['nombre']); ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>
                <div class="form-group">
                    <label for="procedencia">Curso de Procedencia:</label>
                    <input type="text" id="procedencia" name="procedencia" value="<?php echo htmlspecialchars($matricula['procedencia'] ?? ''); ?>" required>
                </div>
                <div class="form-group full-width">
                    <label for="dom_alumno">Domicilio del Alumno:</label>
                    <input type="text" id="dom_alumno" name="dom_alumno" value="<?php echo htmlspecialchars($matricula['dom_alumno'] ?? ''); ?>" required>
                </div>

                <h3 class="section-header"><i class="fas fa-home"></i> Información Familiar (Vive con)</h3>
                <div class="checkbox-group">
                    <div>
                        <input type="checkbox" id="vive_mama" name="vive_con[]" value="Madre" <?php echo (strpos($matricula['persona_con_quien_vive'], 'Madre') !== false) ? 'checked' : ''; ?> onclick="toggleSection('section_mama', this, 'mama')">
                        <label for="vive_mama">Vive con la Madre</label>
                    </div>
                    <div>
                        <input type="checkbox" id="vive_papa" name="vive_con[]" value="Padre" <?php echo (strpos($matricula['persona_con_quien_vive'], 'Padre') !== false) ? 'checked' : ''; ?> onclick="toggleSection('section_papa', this, 'papa')">
                        <label for="vive_papa">Vive con el Padre</label>
                    </div>
                    <div>
                        <input type="checkbox" id="vive_otro" name="vive_con[]" value="Otro" <?php echo (strpos($matricula['persona_con_quien_vive'], 'Otro') !== false) ? 'checked' : ''; ?> onclick="toggleSection('section_otro', this, 'otro')">
                        <label for="vive_otro">Vive con Otro</label>
                    </div>
                </div>

                <div id="section_mama" class="form-grid-2col full-width" style="<?php echo (strpos($matricula['persona_con_quien_vive'], 'Madre') !== false) ? '' : 'display:none;'; ?>">
                    <h3 class="section-header" style="margin-top: 0; color: var(--grey-dark);">Información de la Madre</h3>
                    <div class="form-group"><label for="nombre_mama">Nombre:</label><input type="text" id="nombre_mama" name="nombre_mama" value="<?php echo htmlspecialchars($madre['nombre'] ?? ''); ?>"></div>
                    <div class="form-group"><label for="apellido_paterno_mama">Apellido Paterno:</label><input type="text" id="apellido_paterno_mama" name="apellido_paterno_mama" value="<?php echo htmlspecialchars($madre['apellido_paterno'] ?? ''); ?>"></div>
                    <div class="form-group"><label for="apellido_materno_mama">Apellido Materno:</label><input type="text" id="apellido_materno_mama" name="apellido_materno_mama" value="<?php echo htmlspecialchars($madre['apellido_materno'] ?? ''); ?>"></div>
                    <div class="form-group"><label for="rut_mama">RUN:</label><input type="text" id="rut_mama" name="rut_mama" value="<?php echo htmlspecialchars($madre['rut'] ?? ''); ?>"></div>
                    <div class="form-group full-width"><label for="dom_mama">Domicilio:</label><input type="text" id="dom_mama" name="dom_mama" value="<?php echo htmlspecialchars($madre['domicilio'] ?? ''); ?>"></div>
                </div>

                <div id="section_papa" class="form-grid-2col full-width" style="<?php echo (strpos($matricula['persona_con_quien_vive'], 'Padre') !== false) ? '' : 'display:none;'; ?>">
                    <h3 class="section-header" style="margin-top: 0; color: var(--grey-dark);">Información del Padre</h3>
                    <div class="form-group"><label for="nombre_papa">Nombre:</label><input type="text" id="nombre_papa" name="nombre_papa" value="<?php echo htmlspecialchars($padre['nombre'] ?? ''); ?>"></div>
                    <div class="form-group"><label for="apellido_paterno_papa">Apellido Paterno:</label><input type="text" id="apellido_paterno_papa" name="apellido_paterno_papa" value="<?php echo htmlspecialchars($padre['apellido_paterno'] ?? ''); ?>"></div>
                    <div class="form-group"><label for="apellido_materno_papa">Apellido Materno:</label><input type="text" id="apellido_materno_papa" name="apellido_materno_papa" value="<?php echo htmlspecialchars($padre['apellido_materno'] ?? ''); ?>"></div>
                    <div class="form-group"><label for="rut_papa">RUN:</label><input type="text" id="rut_papa" name="rut_papa" value="<?php echo htmlspecialchars($padre['rut'] ?? ''); ?>"></div>
                    <div class="form-group full-width"><label for="dom_papa">Domicilio:</label><input type="text" id="dom_papa" name="dom_papa" value="<?php echo htmlspecialchars($padre['domicilio'] ?? ''); ?>"></div>
                </div>

                <div id="section_otro" class="form-grid-2col full-width" style="<?php echo (strpos($matricula['persona_con_quien_vive'], 'Otro') !== false) ? '' : 'display:none;'; ?>">
                    <h3 class="section-header" style="margin-top: 0; color: var(--grey-dark);">Información de Otro</h3>
                    <div class="form-group"><label for="nombre_otro">Nombre:</label><input type="text" id="nombre_otro" name="nombre_otro" value="<?php echo htmlspecialchars($otro['nombre'] ?? ''); ?>"></div>
                    <div class="form-group"><label for="apellido_paterno_otro">Apellido Paterno:</label><input type="text" id="apellido_paterno_otro" name="apellido_paterno_otro" value="<?php echo htmlspecialchars($otro['apellido_paterno'] ?? ''); ?>"></div>
                    <div class="form-group"><label for="apellido_materno_otro">Apellido Materno:</label><input type="text" id="apellido_materno_otro" name="apellido_materno_otro" value="<?php echo htmlspecialchars($otro['apellido_materno'] ?? ''); ?>"></div>
                    <div class="form-group"><label for="rut_otro">RUN:</label><input type="text" id="rut_otro" name="rut_otro" value="<?php echo htmlspecialchars($otro['rut'] ?? ''); ?>"></div>
                    <div class="form-group full-width"><label for="dom_otro">Domicilio:</label><input type="text" id="dom_otro" name="dom_otro" value="<?php echo htmlspecialchars($otro['domicilio'] ?? ''); ?>"></div>
                </div>

                <h3 class="section-header"><i class="fas fa-heartbeat"></i> Información de Salud</h3>
                <div class="form-group">
                    <label for="prevision_salud">Previsión de Salud:</label>
                    <select id="prevision_salud" name="prevision_salud" required>
                        <option value="1" <?php echo ($prevision_salud['tipo_prevision_id'] == 1) ? 'selected' : ''; ?>>FONASA</option>
                        <option value="2" <?php echo ($prevision_salud['tipo_prevision_id'] == 2) ? 'selected' : ''; ?>>ISAPRE</option>
                    </select>
                </div>
                
                <div class="form-group full-width">
                    <label for="alergias-container">Alergias Alimentarias:</label>
                    <div id="alergias-container">
                        <?php if (empty($alergias)): ?>
                            <div class="alergia-item">
                                <input type="text" name="alergico_alimentario[]" placeholder="Ingrese una alergia (ej: Maní)">
                                <button type="button" class="btn btn-danger btn-sm" onclick="this.parentNode.remove()" title="Eliminar"><i class="fas fa-trash"></i></button>
                            </div>
                        <?php else: ?>
                            <?php foreach ($alergias as $alergia): ?>
                                <div class="alergia-item">
                                    <input type="text" name="alergico_alimentario[]" value="<?php echo htmlspecialchars($alergia['alergia'] ?? ''); ?>" placeholder="Ingrese una alergia">
                                    <button type="button" class="btn btn-danger btn-sm" onclick="this.parentNode.remove()" title="Eliminar"><i class="fas fa-trash"></i></button>
                                </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                    <button type="button" onclick="addAlergia()" class="btn btn-success btn-sm" style="margin-top: 10px;">
                        <i class="fas fa-plus"></i> Añadir otra alergia
                    </button>
                </div>

                <h3 class="section-header"><i class="fas fa-info-circle"></i> Información Adicional</h3>
                <div class="form-group">
                    <label for="problemas_aprendizaje">Problemas de Aprendizaje:</label>
                    <textarea id="problemas_aprendizaje" name="problemas_aprendizaje"><?php echo htmlspecialchars($info_adicional['problemas_aprendizaje'] ?? ''); ?></textarea>
                </div>
                <div class="form-group">
                    <label for="cursos_repetidos">Cursos Repetidos:</label>
                    <textarea id="cursos_repetidos" name="cursos_repetidos"><?php echo htmlspecialchars($info_adicional['cursos_repetidos'] ?? ''); ?></textarea>
                </div>
                
                <div class="form-group checkbox-group" style="grid-column: 1 / -1; margin-bottom: 0;">
                    <input type="checkbox" id="es_bicultural" name="es_bicultural" <?php echo ($info_adicional['es_bicultural']) ? 'checked' : ''; ?> onchange="toggleCulturaFields(this)">
                    <label for="es_bicultural">¿Es el alumno bicultural?</label>
                </div>
                
                <div class="form-group" style="grid-column: 1 / -1;">
                    <label for="etnia">Cultura:</label>
                    <select id="etnia" name="etnia">
                        <option value="">Seleccione una opción</option>
                        <option value="Aymara" <?php echo ($info_adicional['etnia'] ?? '' == 'Aymara') ? 'selected' : ''; ?>>Aymara</option>
                        <option value="Atacameño o Likan Antai" <?php echo ($info_adicional['etnia'] ?? '' == 'Atacameño o Likan Antai') ? 'selected' : ''; ?>>Atacameño o Likan Antai</option>
                        <option value="Quechua" <?php echo ($info_adicional['etnia'] ?? '' == 'Quechua') ? 'selected' : ''; ?>>Quechua</option>
                        <option value="Collas" <?php echo ($info_adicional['etnia'] ?? '' == 'Collas') ? 'selected' : ''; ?>>Collas</option>
                        <option value="Changos" <?php echo ($info_adicional['etnia'] ?? '' == 'Changos') ? 'selected' : ''; ?>>Changos</option>
                        <option value="Diaguitas" <?php echo ($info_adicional['etnia'] ?? '' == 'Diaguitas') ? 'selected' : ''; ?>>Diaguitas</option>
                        <option value="Rapanui" <?php echo ($info_adicional['etnia'] ?? '' == 'Rapanui') ? 'selected' : ''; ?>>Rapanui</option>
                        <option value="Mapuche" <?php echo ($info_adicional['etnia'] ?? '' == 'Mapuche') ? 'selected' : ''; ?>>Mapuche</option>
                        <option value="Kawésqar" <?php echo ($info_adicional['etnia'] ?? '' == 'Kawésqar') ? 'selected' : ''; ?>>Kawésqar</option>
                        <option value="Selk’nam" <?php echo ($info_adicional['etnia'] ?? '' == 'Selk’nam') ? 'selected' : ''; ?>>Selk’nam</option>
                        <option value="Yaganes" <?php echo ($info_adicional['etnia'] ?? '' == 'Yaganes') ? 'selected' : ''; ?>>Yaganes</option>
                    </select>
                </div>

            </div> <div class="form-buttons" style="margin-top: 2rem;">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Actualizar Matrícula
                </button>
            </div>
        </form>
    </div>
</main>

<script>
    /**
     * Muestra un mensaje flotante (tipo 'exito' o 'error')
     */
    function showJsMessage(message, type) {
        const notification = document.getElementById('mensaje-box');
        notification.textContent = message;
        notification.className = 'mensaje ' + type + ' show';
        notification.style.display = 'block';
        
        setTimeout(() => {
            notification.classList.remove('show');
        }, 3000);
    }

    /**
     * Valida el formulario antes de enviarlo
     */
    function validateForm(event) {
        const requiredFields = [
            'rut', 'nombres', 'apellido_paterno', 'apellido_materno', 'fecha_nac', 'lugar_nac',
            'dom_alumno', 'curso_id', 'procedencia'
        ];
        let valid = true;

        requiredFields.forEach((fieldId) => {
            const field = document.getElementById(fieldId);
            if (!field.value.trim()) {
                field.classList.add('error'); // Añade clase de error CSS
                valid = false;
            } else {
                field.classList.remove('error');
            }
        });

        if (!valid) {
            event.preventDefault(); // Detener el envío
            showJsMessage('Por favor, completa todos los campos obligatorios.', 'error');
        }
    }

    /**
     * Habilita/Deshabilita el campo de etnia
     */
    function toggleCulturaFields(checkbox) {
        const etniaField = document.getElementById('etnia');
        if (checkbox.checked) {
            etniaField.disabled = false;
        } else {
            etniaField.disabled = true;
            etniaField.value = '';
        }
    }

    /**
     * Muestra/Oculta las secciones de familiares
     */
    function toggleSection(sectionId, checkbox) {
        const section = document.getElementById(sectionId);
        if (checkbox.checked) {
            section.style.display = 'grid'; // Mostrar la sección (como grid)
        } else {
            section.style.display = 'none'; // Ocultar la sección
        }
    }

    /**
     * Añade un nuevo campo de alergia con un botón de eliminar
     */
    function addAlergia() {
        const container = document.getElementById('alergias-container');
        const item = document.createElement('div');
        item.className = 'alergia-item';
        
        const input = document.createElement('input');
        input.type = 'text';
        input.name = 'alergico_alimentario[]';
        input.placeholder = 'Ingrese una alergia alimentaria';
        
        const button = document.createElement('button');
        button.type = 'button';
        button.className = 'btn btn-danger btn-sm';
        button.innerHTML = '<i class="fas fa-trash"></i>';
        button.title = "Eliminar";
        button.onclick = function() {
            container.removeChild(item); // Eliminar este item
        };
        
        item.appendChild(input);
        item.appendChild(button);
        container.appendChild(item);
        
        input.focus(); // Poner el foco en el nuevo campo
    }

    // Ejecutar al cargar la página
    document.addEventListener('DOMContentLoaded', function() {
        // Validar formulario al enviar
        const form = document.querySelector('form');
        form.addEventListener('submit', validateForm);
        
        // Asegurar estado inicial de Etnia
        const checkbox = document.getElementById('es_bicultural');
        toggleCulturaFields(checkbox);
        
        // Mostrar mensaje de sesión si existe
        <?php if ($message): ?>
            showJsMessage('<?php echo htmlspecialchars($message, ENT_QUOTES, 'UTF-8'); ?>', '<?php echo htmlspecialchars($message_type, ENT_QUOTES, 'UTF-8'); ?>');
        <?php endif; ?>
    });
</script>
</body>
</html>
<?php
// CORRECCIÓN: Mover el cierre de la conexión al final del script
$conn->close();
?>