<?php
// Iniciar la sesión
session_start();

// Destruir todas las variables de sesión
$_SESSION = [];

// Destruir la sesión
if (session_status() == PHP_SESSION_ACTIVE) {
    // Destruir la cookie de la sesión, si existe
    if (ini_get("session.use_cookies")) {
        $params = session_get_cookie_params();
        setcookie(session_name(), '', time() - 42000,
            $params["path"], $params["domain"],
            $params["secure"], $params["httponly"]
        );
    }
    
    // Finalmente, destruir la sesión
    session_destroy();
}

// Redirigir al usuario a la página de inicio de sesión
header("Location: login.php");
exit();
?>
