<?php
session_start(); // Iniciar la sesión
header('Content-Type: text/html; charset=utf-8');

include '../includes/db.php';
include '../includes/auth.php';
checkAuth();

//if (!isAdmin()) {
    //header("Location: ../index.php");
    // exit();
//}

if (!isset($_SESSION['usuario_id'])) {
    header("Location: ../index.php");
    exit();
}

error_reporting(E_ALL);
ini_set('display_errors', 1);

// Carpeta donde están las imágenes institucionales
$carpeta_imagenes = '../kit/img/';
$imagenes = glob($carpeta_imagenes . '*.{jpg,jpeg,png,gif,webp}', GLOB_BRACE);
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="../images/logo.png">
    <title>Kit Digital</title>
    
    <link rel="stylesheet" href="../css/admin.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    
    <style>
        .kit-gallery {
            display: grid;
            /* Se ajusta automáticamente, mínimo 200px, máximo 1fr */
            grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
            gap: 1.5rem;
            padding-top: 1.5rem; /* Espacio desde el título */
        }
        .kit-card {
            background-color: #fff;
            border: 1px solid var(--grey-medium);
            border-radius: var(--border-radius);
            padding: 1rem;
            text-align: center;
            box-shadow: var(--box-shadow);
            transition: var(--transition-speed);
        }
        .kit-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 6px 12px rgba(0,0,0,0.1);
        }
        .kit-card img {
            max-width: 100%;
            height: 150px; /* Alto fijo para uniformidad */
            object-fit: contain; /* Asegura que la imagen quepa sin deformarse */
            margin-bottom: 1rem;
            border-radius: var(--border-radius);
        }
        .kit-card .btn {
            width: 100%; /* El botón ocupa todo el ancho */
        }
    </style>
</head>
<body>

<header>
    <div class="header-content">
        <img src="../images/INSIGNIA SF.png" alt="Logo de la Empresa">
        <h1>Kit Digital</h1>
        <nav>
            <ul>
                <li><a href="../index.php"><i class="fas fa-home"></i> Inicio</a></li>
            </ul>
        </nav>
    </div>
</header>

<main class="container">
    <div class="card">
        <h2><i class="fas fa-images"></i> Imágenes Institucionales</h2>

        <?php if (count($imagenes) > 0): ?>
            <div class="kit-gallery">
                <?php foreach ($imagenes as $img_path): 
                    $img_nombre = basename($img_path);
                    $url = htmlspecialchars($img_path, ENT_QUOTES, 'UTF-8');
                ?>
                    <div class="kit-card">
                        <img src="<?php echo $url; ?>" alt="<?php echo htmlspecialchars($img_nombre, ENT_QUOTES, 'UTF-8'); ?>">
                        
                        <a class="btn btn-primary" href="<?php echo $url; ?>" download="<?php echo htmlspecialchars($img_nombre, ENT_QUOTES, 'UTF-8'); ?>">
                            <i class="fas fa-download"></i> Descargar
                        </a>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php else: ?>
            <p style="text-align:center; padding: 2rem; color: var(--grey-dark);">
                No se encontraron imágenes en la carpeta del kit digital.
            </p>
        <?php endif; ?>
    </div>
</main>

</body>
</html>