<?php
session_start();
header('Content-Type: text/html; charset=utf-8');
include '../includes/db.php';
include '../includes/auth.php';
checkAuth();
$conn->set_charset("utf8");

$justificativo_id = intval($_GET['id'] ?? 0);
if (!$justificativo_id) {
    die("ID de justificativo no válido.");
}

// Consulta para obtener todos los datos
$sql = "
    SELECT j.*, 
           u.nombre AS alumno_nombre, u.apellido_paterno AS alumno_ap, u.apellido_materno AS alumno_am, u.rut AS alumno_rut,
           c.nombre AS curso_nombre,
           f.nombre AS func_nombre, f.apellido_paterno AS func_ap, f.apellido_materno AS func_am
    FROM justificativos j
    INNER JOIN usuario u ON j.usuario_id = u.id
    INNER JOIN curso c ON j.curso_id = c.id
    LEFT JOIN usuario f ON j.usuario_registro = f.id
    WHERE j.id = ?
";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $justificativo_id);
$stmt->execute();
$j = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$j) {
    die("Justificativo no encontrado.");
}

// Formatear nombres
$alumno_nombre_completo = htmlspecialchars($j['alumno_ap'] . ' ' . $j['alumno_am'] . ', ' . $j['alumno_nombre']);
$funcionario_nombre_completo = htmlspecialchars($j['func_nombre'] . ' ' . $j['func_ap'] . ' ' . $j['func_am']);

// Formatear fecha
setlocale(LC_TIME, 'es_ES.UTF-8', 'es_ES', 'Spanish_Spain', 'es', 'esp');
$fecha_retiro = strftime('%d de %B de %Y a las %H:%M', strtotime($j['fecha']));
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <link rel="icon" type="image/png" href="../images/logo.png">
    <title>Comprobante Justificativo #<?= $j['id'] ?></title>
    
    <link rel="stylesheet" href="../css/certificado.css">
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">

    <style>
        /* Reducimos el margen superior de la vista previa */
        body {
            margin-top: 20px;
            margin-bottom: 20px;
        }
        
        /* Estilos del comprobante */
        .content p {
            font-size: 1.1rem;
            line-height: 2.0; 
            text-align: left;
            margin-bottom: 0.5rem;
        }
        .content b {
            display: inline-block;
            min-width: 180px; 
            font-weight: bold;
            color: #000;
        }
        .footer {
            line-height: 1.5;
        }
        .divider {
            margin: 1.5rem 0;
            border: 0;
            border-top: 1px dashed #999;
        }
        .no-print button[onclick*="../index.php"] {
            display: none;
        }
        
        /* *** AÑADIDO: CSS PARA EL MENSAJE PUSH-UP *** */
        .mensaje-flotante {
            position: fixed;
            top: 20px;
            right: 20px;
            background-color: #3f51b5; /* Azul oscuro */
            color: white;
            padding: 1rem 1.5rem;
            border-radius: 8px; /* Bordes redondeados */
            box-shadow: 0 4px 10px rgba(0,0,0,0.3);
            z-index: 1050;
            max-width: 300px;
            font-size: 0.9rem;
            line-height: 1.5;
            font-family: 'Roboto', sans-serif; /* Fuente moderna para el mensaje */
        }
        .mensaje-flotante .cerrar {
            float: right;
            font-size: 1.5rem;
            font-weight: 700;
            line-height: 1;
            color: white;
            opacity: 0.7;
            cursor: pointer;
            margin-left: 1rem;
        }
        .mensaje-flotante .cerrar:hover {
            opacity: 1;
        }
        /* *** FIN DEL CSS AÑADIDO *** */

        @media print {
            @page {
                size: letter;
                margin: 0.5in; /* Margen reducido */
            }
            body {
                width: 100%;
                margin: 0; 
                padding: 0;
            }
            /* El mensaje flotante ya tiene 'no-print' en el HTML */
        }
    </style>
</head>
<body>

    <div class="mensaje-flotante no-print" id="mensajeNota">
        <span class="cerrar" onclick="this.parentElement.style.display='none';">&times;</span>
        <strong>Nota importante:</strong><br>
        Para que el informe quede en una hoja, debe cambiar la escala de impresión a un <strong>87%</strong>.
    </div>
    <img src="../images/INSIGNIA SF.png" alt="Insignia Escuela" class="insignia">
    <img src="../images/SLEP.jpeg" alt="Logo SLEP" class="insignia right-insignia">

    <div class="header-text" style="line-height: 0.5;">
        <p>REPUBLICA DE CHILE</p>
        <p>PROVINCIA DE CAUQUENES</p>
        <p>SERVICIO LOCAL DE EDUCACIÓN PÚBLICA MAULE COSTA</p>
        <p>ESCUELA “PORONGO” F – 654 CAUQUENES</p>
    </div>
    
    <div class="content">
        <p style="text-align: center; font-weight: bold; font-size: 18px; margin-top: 2rem; margin-bottom: 2rem;">
            COMPROBANTE DE JUSTIFICATIVO DE RETIRO
        </p>
        
        <p style="text-align: right; font-size: 1rem; margin-bottom: 1.5rem; line-height: 1.5;">
            <strong>Comprobante ID:</strong> <?= $j['id'] ?>
        </p>

        <p><b>Fecha y Hora:</b> <?= $fecha_retiro ?></p>
        <p><b>Alumno:</b> <?= $alumno_nombre_completo ?></p>
        <p><b>RUT Alumno:</b> <?= htmlspecialchars($j['alumno_rut'] ?? 'No Registrado') ?></p>
        <p><b>Curso:</b> <?= htmlspecialchars($j['curso_nombre']) ?></p>
        
        <hr class="divider">

        <p><b>Motivo del Retiro:</b> <?= htmlspecialchars($j['motivo']) ?></p>
        <p><b>Retirado por:</b> <?= htmlspecialchars($j['nombre_retirante']) ?> (<?= htmlspecialchars($j['tipo_retirante']) ?>)</p>
        <p><b>RUT Retirante:</b> <?= htmlspecialchars($j['rut_retirante']) ?></p>
        
        <?php if (!empty($j['observaciones'])): ?>
        <p><b>Observaciones:</b> <?= htmlspecialchars($j['observaciones']) ?></p>
        <?php endif; ?>

        <hr class="divider">

        <p style="font-size: 0.9rem; line-height: 1.5;">
            <b>Funcionario que registra:</b> <?= $funcionario_nombre_completo ?>
        </p>
    </div>

    <div class="footer" style="text-align: center; margin-top: 50px;">
        <div>
            <p style="margin-bottom: 0;">______________________________</p>
            <p><b>FIRMA Y TIMBRE</b></p>
            <p><b>INSPECTORÍA / UTP</b></p>
        </div>
    </div>

    <div class="right-align no-print">
        <button onclick="window.print()">Imprimir Comprobante</button>
    </div>
    
    <div class="footer" style="margin-top: 20px; text-align: center;">
        <p>Km 4, camino a Chanco - Cauquenes</p>
        <p>e-mail: porongo@slepmc.cl</p>
        <p>Teléfono: +56442857313</p>
    </div>

    <script>
        // Imprime automáticamente al cargar
        window.onload = function() {
            window.print();
        }
    </script>
</body>
</html>