<?php
session_start();
header('Content-Type: text/html; charset=utf-8');
include '../includes/db.php';
include '../includes/auth.php';
checkAuth(); // Verifica que el usuario esté logueado (profesor, admin, etc.)

$conn->set_charset("utf8");

/* === FILTROS === */
$filtro_rut = trim($_GET['rut'] ?? '');
$filtro_nombre = trim($_GET['nombre'] ?? '');
$filtro_curso = trim($_GET['curso'] ?? '');
$filtro_fecha = trim($_GET['fecha'] ?? '');

$where = [];
$params_where = [];
$types_where = "";

if ($filtro_rut !== '') {
    $where[] = "j.rut_retirante LIKE ?";
    $params_where[] = "%$filtro_rut%";
    $types_where .= "s";
}
if ($filtro_nombre !== '') {
    // Buscar en nombre o apellidos del alumno
    $where[] = "(u.nombre LIKE ? OR u.apellido_paterno LIKE ? OR u.apellido_materno LIKE ?)";
    $params_where[] = "%$filtro_nombre%";
    $params_where[] = "%$filtro_nombre%";
    $params_where[] = "%$filtro_nombre%";
    $types_where .= "sss";
}
if ($filtro_curso !== '') {
    $where[] = "c.id = ?";
    $params_where[] = $filtro_curso;
    $types_where .= "i";
}
if ($filtro_fecha !== '') {
    $where[] = "DATE(j.fecha) = ?";
    $params_where[] = $filtro_fecha;
    $types_where .= "s";
}
$whereSQL = $where ? 'WHERE ' . implode(' AND ', $where) : '';

// Guardar filtros para la URL de paginación
$filter_query_params = array_filter([
    'rut' => $filtro_rut,
    'nombre' => $filtro_nombre,
    'curso' => $filtro_curso,
    'fecha' => $filtro_fecha
]);
$filter_query_string = http_build_query($filter_query_params);


/* === PAGINACIÓN === */
$registrosPorPagina = 20; // Más registros por página para una tabla
$paginaActual = isset($_GET['pagina']) ? max(1, intval($_GET['pagina'])) : 1;
$offset = ($paginaActual - 1) * $registrosPorPagina;

// Conteo total con filtros
$sqlTotal = "
    SELECT COUNT(j.id) AS total
    FROM justificativos j
    INNER JOIN usuario u ON j.usuario_id = u.id
    INNER JOIN curso c ON j.curso_id = c.id
    $whereSQL
";
$stmtTotal = $conn->prepare($sqlTotal);
if (!empty($params_where)) {
    $stmtTotal->bind_param($types_where, ...$params_where);
}
$stmtTotal->execute();
$totalRegistros = $stmtTotal->get_result()->fetch_assoc()['total'];
$totalPaginas = ceil($totalRegistros / $registrosPorPagina);
$stmtTotal->close();

/* === CONSULTA PRINCIPAL === */
$sql = "
    SELECT j.*, 
           u.nombre AS alumno_nombre, u.apellido_paterno AS alumno_ap, u.apellido_materno AS alumno_am,
           c.nombre AS curso_nombre,
           f.nombre AS func_nombre, f.apellido_paterno AS func_ap
    FROM justificativos j
    INNER JOIN usuario u ON j.usuario_id = u.id
    INNER JOIN curso c ON j.curso_id = c.id
    LEFT JOIN usuario f ON j.usuario_registro = f.id
    $whereSQL
    ORDER BY j.fecha DESC
    LIMIT ? OFFSET ?
";
$stmt = $conn->prepare($sql);
// Añadir params de paginación
$params_query = $params_where;
$params_query[] = $registrosPorPagina;
$params_query[] = $offset;
$types_query = $types_where . "ii";

// Usar call_user_func_array para bind_param dinámico si hay parámetros
if (!empty($params_query)) {
    $bind_params = [];
    foreach ($params_query as $key => $value) {
        $bind_params[$key] = &$params_query[$key];
    }
    call_user_func_array([$stmt, 'bind_param'], array_merge([$types_query], $bind_params));
}
$stmt->execute();
$justificativos = $stmt->get_result();
$stmt->close();

// Obtener Cursos para el filtro
$cursos = $conn->query("SELECT id, nombre FROM curso WHERE activo = 1 ORDER BY nombre ASC");
?>
<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="icon" type="image/png" href="../images/logo.png">
<title>Historial de Justificativos</title>

<link rel="stylesheet" href="../css/admin.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">

<style>
    /* Estilos para 4 columnas en el filtro */
    .form-grid-4col {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 1.5rem;
        align-items: flex-end;
    }
</style>
</head>
<body>

<header>
    <div class="header-content">
        <img src="../images/INSIGNIA SF.png" alt="Logo">
        <h1>Historial de Justificativos</h1>
        <nav>
            <ul>
                <li><a href="../index.php"><i class="fas fa-home"></i> Inicio</a></li>
                
            </ul>
        </nav>
    </div>
</header>
    
<main class="container">
    
    <div class="card form-container">
        <h2><i class="fas fa-filter"></i> Filtros de Búsqueda</h2>
        <form method="GET">
            <div class="form-grid-4col">
                <div class="form-group">
                    <label for="rut"><i class="fas fa-id-card"></i> RUT Retirante</label>
                    <input type="text" name="rut" id="rut" class="form-control" value="<?=htmlspecialchars($filtro_rut)?>" placeholder="Ej: 12.345.678-9">
                </div>
                <div class="form-group">
                    <label for="nombre"><i class="fas fa-user-graduate"></i> Nombre Alumno</label>
                    <input type="text" name="nombre" id="nombre" class="form-control" value="<?=htmlspecialchars($filtro_nombre)?>" placeholder="Ej: Juan Pérez">
                </div>
                <div class="form-group">
                    <label for="curso"><i class="fas fa-university"></i> Curso</label>
                    <select name="curso" id="curso" class="form-control">
                        <option value="">Todos</option>
                        <?php $cursos->data_seek(0); while($c = $cursos->fetch_assoc()): ?>
                            <option value="<?=$c['id']?>" <?=($filtro_curso==$c['id'])?'selected':''?>><?=htmlspecialchars($c['nombre'])?></option>
                        <?php endwhile; ?>
                    </select>
                </div>
                <div class="form-group">
                    <label for="fecha"><i class="fas fa-calendar-alt"></i> Fecha</label>
                    <input type="date" name="fecha" id="fecha" class="form-control" value="<?=htmlspecialchars($filtro_fecha)?>">
                </div>
            </div>
            <div class="form-buttons" style="margin-top: 1rem;">
                <button type="submit" class="btn btn-primary"><i class="fas fa-search"></i> Buscar</button>
                <a href="historial_justificativos.php" class="btn btn-secondary"><i class="fas fa-times"></i> Limpiar filtros</a>
            </div>
        </form>
    </div>

    <div class="card table-container" style="margin-top: 2rem;">
        <h2><i class="fas fa-history"></i> Historial (Total: <?= $totalRegistros ?>)</h2>
        <div class="table-responsive">
            <table>
                <thead>
                    <tr>
                        <th>Fecha y Hora</th>
                        <th>Alumno</th>
                        <th>Curso</th>
                        <th>Retirado por</th>
                        <th>RUT Retirante</th>
                        <th>Motivo</th>
                        <th>Obs.</th>
                        <th>Registrado por</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($justificativos->num_rows > 0): ?>
                        <?php while ($j = $justificativos->fetch_assoc()): ?>
                            <tr>
                                <td><?= date('d-m-Y H:i', strtotime($j['fecha'])) ?></td>
                                <td><?= htmlspecialchars($j['alumno_ap'].' '.$j['alumno_am'].', '.$j['alumno_nombre']) ?></td>
                                <td><?= htmlspecialchars($j['curso_nombre']) ?></td>
                                <td><?= htmlspecialchars($j['nombre_retirante'].' ('.$j['tipo_retirante'].')') ?></td>
                                <td><?= htmlspecialchars($j['rut_retirante']) ?></td>
                                <td><?= htmlspecialchars($j['motivo']) ?></td>
                                <td><?= htmlspecialchars($j['observaciones']) ?></td>
                                <td><?= htmlspecialchars($j['func_nombre'].' '.$j['func_ap']) ?></td>
                            </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="8" style="text-align: center;">No se encontraron registros que coincidan con los filtros.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <div class="pagination">
            <?php for ($i = 1; $i <= $totalPaginas; $i++): ?>
                <a href="?pagina=<?= $i ?>&<?= $filter_query_string ?>" class="<?= ($i == $paginaActual) ? 'current-page' : '' ?>"><?= $i ?></a>
            <?php endfor; ?>
        </div>
    </div>
</main>

</body>
</html>