<?php
session_start(); 
header('Content-Type: text/html; charset=utf-8');
include '../includes/db.php';
include '../includes/auth.php';
checkAuth();

$usuarioSesion = $_SESSION['usuario_id'] ?? null;
if(!$usuarioSesion){
    die("No se ha detectado usuario en sesión.");
}

// Manejo de mensajes de sesión
$message = '';
$message_type = '';
if (isset($_SESSION['message'])) {
    $message = $_SESSION['message'];
    $message_type = $_SESSION['message_type'];
    unset($_SESSION['message'], $_SESSION['message_type']);
}

/* === FILTROS === */
$filtro_rut = trim($_GET['rut'] ?? '');
$filtro_nombre = trim($_GET['nombre'] ?? '');
$filtro_curso = trim($_GET['curso'] ?? '');
$filtro_fecha = trim($_GET['fecha'] ?? '');

$where = [];
$params_where = [];
$types_where = "";

if ($filtro_rut !== '') {
    $where[] = "j.rut_retirante LIKE ?";
    $params_where[] = "%$filtro_rut%";
    $types_where .= "s";
}
if ($filtro_nombre !== '') {
    $where[] = "(u.nombre LIKE ? OR u.apellido_paterno LIKE ? OR u.apellido_materno LIKE ?)";
    $params_where[] = "%$filtro_nombre%";
    $params_where[] = "%$filtro_nombre%";
    $params_where[] = "%$filtro_nombre%";
    $types_where .= "sss";
}
if ($filtro_curso !== '') {
    $where[] = "c.id = ?";
    $params_where[] = $filtro_curso;
    $types_where .= "i";
}
if ($filtro_fecha !== '') {
    $where[] = "DATE(j.fecha) = ?";
    $params_where[] = $filtro_fecha;
    $types_where .= "s";
}
$whereSQL = $where ? 'WHERE ' . implode(' AND ', $where) : '';

$filter_query_params = array_filter([
    'rut' => $filtro_rut,
    'nombre' => $filtro_nombre,
    'curso' => $filtro_curso,
    'fecha' => $filtro_fecha
]);
$filter_query_string = http_build_query($filter_query_params);


/* === ELIMINAR JUSTIFICATIVO === */
if (isset($_GET['eliminar_id'])) {
    $id = intval($_GET['eliminar_id']);
    $res = $conn->query("SELECT * FROM justificativos WHERE id=$id");
    $j = $res->fetch_assoc();
    if($j){
        $detalle = "Curso: {$j['curso_id']}\nMotivo: {$j['motivo']}\nTipo: {$j['tipo_retirante']}\nNombre: {$j['nombre_retirante']}";
        $accion = 'ELIMINAR';
        $stmtLog = $conn->prepare("INSERT INTO justificativos_log (justificativo_id, usuario_id, accion, detalle) VALUES (?, ?, ?, ?)");
        $stmtLog->bind_param("iiss", $j['id'], $usuarioSesion, $accion, $detalle);
        $stmtLog->execute(); $stmtLog->close();

        $stmt = $conn->prepare("DELETE FROM justificativos WHERE id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute(); $stmt->close();
        
        $_SESSION['message'] = 'Justificativo eliminado correctamente.';
        $_SESSION['message_type'] = 'exito';
    }
    header("Location: gestion_justificativos.php?" . $filter_query_string);
    exit;
}

/* === EDITAR JUSTIFICATIVO === */
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['editar'])) {
    $id = intval($_POST['id']);
    $usuario_id = intval($_POST['usuario_id']);
    
    $curso_id_post = $_POST['curso_id'] ?? '';
    $curso_id = !empty($curso_id_post) ? (int)$curso_id_post : null;

    $motivo = $_POST['motivo'];
    $tipo_retirante = $_POST['tipo_retirante'];
    $nombre_retirante = $_POST['nombre_retirante'];
    $rut_retirante = $_POST['rut_retirante'];
    $observaciones = $_POST['observaciones'];
    $hora_regreso = !empty($_POST['hora_regreso']) ? $_POST['hora_regreso'] : null;

    $res = $conn->query("SELECT * FROM justificativos WHERE id=$id");
    $j_ant = $res->fetch_assoc();

    if ($curso_id === null) {
         $stmt = $conn->prepare("UPDATE justificativos SET usuario_id=?, curso_id=NULL, motivo=?, tipo_retirante=?, nombre_retirante=?, rut_retirante=?, observaciones=?, hora_regreso=? WHERE id=?");
         $stmt->bind_param("issssssi", $usuario_id, $motivo, $tipo_retirante, $nombre_retirante, $rut_retirante, $observaciones, $hora_regreso, $id);
    } else {
         $stmt = $conn->prepare("UPDATE justificativos SET usuario_id=?, curso_id=?, motivo=?, tipo_retirante=?, nombre_retirante=?, rut_retirante=?, observaciones=?, hora_regreso=? WHERE id=?");
         $stmt->bind_param("iissssssi", $usuario_id, $curso_id, $motivo, $tipo_retirante, $nombre_retirante, $rut_retirante, $observaciones, $hora_regreso, $id);
    }
    
    $stmt->execute(); 
    $stmt->close();
    
    $detalle = "Antes:\nCurso: {$j_ant['curso_id']}\nMotivo: {$j_ant['motivo']}\nHR: {$j_ant['hora_regreso']}\n\n";
    $detalle .= "Después:\nCurso: " . ($curso_id ?? 'NULL') . "\nMotivo: {$motivo}\nHR: {$hora_regreso}";
    $accion = 'MODIFICAR';
    $stmtLog = $conn->prepare("INSERT INTO justificativos_log (justificativo_id, usuario_id, accion, detalle) VALUES (?, ?, ?, ?)");
    $stmtLog->bind_param("iiss", $id, $usuarioSesion, $accion, $detalle);
    $stmtLog->execute(); $stmtLog->close();

    $_SESSION['message'] = 'Justificativo modificado correctamente.';
    $_SESSION['message_type'] = 'exito';

    $query_params_post = array_filter([
        'rut' => $_POST['filtro_rut'] ?? '',
        'nombre' => $_POST['filtro_nombre'] ?? '',
        'curso' => $_POST['filtro_curso'] ?? '',
        'fecha' => $_POST['filtro_fecha'] ?? ''
    ]);
    $filter_query_string = http_build_query($query_params_post);

    header("Location: gestion_justificativos.php?" . $filter_query_string);
    exit;
}

/* === PAGINACIÓN === */
$registrosPorPagina = 12;
$paginaActual = isset($_GET['pagina']) ? max(1, intval($_GET['pagina'])) : 1;
$offset = ($paginaActual - 1) * $registrosPorPagina;

$sqlTotal = "
    SELECT COUNT(j.id) AS total
    FROM justificativos j
    INNER JOIN usuario u ON j.usuario_id = u.id
    LEFT JOIN curso c ON j.curso_id = c.id
    $whereSQL
";
$stmtTotal = $conn->prepare($sqlTotal);
if (!empty($params_where)) {
    $stmtTotal->bind_param($types_where, ...$params_where);
}
$stmtTotal->execute();
$totalRegistros = $stmtTotal->get_result()->fetch_assoc()['total'];
$totalPaginas = ceil($totalRegistros / $registrosPorPagina);
$stmtTotal->close();

/* === CONSULTA PRINCIPAL === */
$sql = "
    SELECT j.*, 
           u.nombre AS usuario_nombre, 
           u.apellido_paterno AS usuario_ap, 
           u.apellido_materno AS usuario_am, 
           u.rol_id AS usuario_rol_id,
           c.nombre AS curso_nombre,
           f.nombre AS func_nombre, f.apellido_paterno AS func_ap, f.apellido_materno AS func_am
    FROM justificativos j
    INNER JOIN usuario u ON j.usuario_id = u.id
    LEFT JOIN curso c ON j.curso_id = c.id
    LEFT JOIN usuario f ON j.usuario_registro = f.id
    $whereSQL
    ORDER BY j.fecha DESC
    LIMIT ? OFFSET ?
";
$stmt = $conn->prepare($sql);
$params_query = $params_where;
$params_query[] = $registrosPorPagina;
$params_query[] = $offset;
$types_query = $types_where . "ii";

$stmt->bind_param($types_query, ...$params_query);
$stmt->execute();
$justificativos = $stmt->get_result();
$stmt->close();

/* === DATOS PARA MODAL === */
$cursos = $conn->query("SELECT id, nombre FROM curso WHERE activo = 1 ORDER BY nombre ASC");

$alumnos_query = $conn->query("SELECT id, nombre, apellido_paterno, apellido_materno, rol_id FROM usuario WHERE rol_id = 3 AND activo = 1");
$docentes_query = $conn->query("SELECT id, nombre, apellido_paterno, apellido_materno, rol_id, rut FROM usuario WHERE rol_id = 2 AND activo = 1");
$all_users = [];
while ($a = $alumnos_query->fetch_assoc()) { $all_users[] = $a; }
while ($d = $docentes_query->fetch_assoc()) { $all_users[] = $d; }
usort($all_users, function($a, $b) {
    return strcmp($a['apellido_paterno'], $b['apellido_paterno']);
});

$docentes_map = [];
$docentes_query->data_seek(0); 
while ($d = $docentes_query->fetch_assoc()) {
    $docentes_map[$d['id']] = [
        'nombre' => htmlspecialchars($d['nombre']),
        'apellidos' => htmlspecialchars($d['apellido_paterno'] . ' ' . $d['apellido_materno']),
        'rut' => htmlspecialchars($d['rut'] ?? '')
    ];
}
$docentes_json = json_encode($docentes_map);
?>

<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="icon" type="image/png" href="../images/logo.png">
<title>Gestión de Justificativos</title>
<link rel="stylesheet" href="../css/admin.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">

<style>
    /* --- AJUSTE PARA ALINEAR BOTONES --- */
    .card-header { 
        display: flex; 
        justify-content: space-between; 
        align-items: center; 
        margin-bottom: 1rem;
        flex-wrap: wrap; /* Permite que baje si la pantalla es minúscula */
        gap: 10px;
    }
    .card-header .actions { 
        display: flex; 
        gap: 0.5rem; 
        flex-wrap: nowrap; /* PROHIBE que los botones se separen */
    }
    /* ---------------------------------- */

    .card-grid-container { display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 1.5rem; }
    .justificativo-card { background-color: #fff; border-radius: var(--border-radius); box-shadow: var(--box-shadow); padding: 1.5rem; transition: transform 0.2s; }
    .justificativo-card:hover { transform: translateY(-5px); }
    .card-body h5 { font-size: 1.2rem; font-weight: 700; color: var(--dark-color); margin-bottom: 0.75rem; }
    .card-body p { margin-bottom: 0.5rem; color: var(--grey-dark); }
    .card-body .retirante { color: var(--primary-color); font-weight: 700; }
    .form-grid-4col { display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 1.5rem; align-items: flex-end; }

    /* Modal Styles con Scroll */
    .modal { position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); width: 90%; max-width: 700px; max-height: 90vh; background-color: #fff; border-radius: var(--border-radius); z-index: 1050; display: none; flex-direction: column; }
    .modal.show { display: flex !important; }
    .modal-content { display: flex; flex-direction: column; height: 100%; overflow: hidden; }
    .modal-header { padding: 1rem 1.5rem; background: var(--primary-color); color: white; border-radius: 8px 8px 0 0; display: flex; justify-content: space-between; align-items: center; flex-shrink: 0; }
    .modal-header h2 { margin: 0; font-size: 1.25rem; color: #fff; }
    .modal-close-btn { background: none; border: none; font-size: 1.5rem; color: #fff; cursor: pointer; }
    .modal-body { padding: 1.5rem; overflow-y: auto; flex: 1; min-height: 0; }
    .modal-body form { display: flex; flex-direction: column; }
    .modal-footer { padding: 1rem 1.5rem; border-top: 1px solid var(--grey-medium); background: var(--grey-light); border-radius: 0 0 8px 8px; display: flex; justify-content: flex-end; gap: 10px; flex-shrink: 0; }
    .modal-backdrop { position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.6); z-index: 1040; display: none; }
    .modal-backdrop.show { display: block; }
    
    @media (max-width: 768px) {
        .modal { width: 95%; max-height: 95vh; }
        .form-grid-4col { grid-template-columns: 1fr; }
    }
    .justificativo-curso { background-color: #fff3cd; border-left: 5px solid #ffc107; }
</style>
</head>
<body>

<header>
    <div class="header-content">
        <img src="../images/INSIGNIA SF.png" alt="Logo">
        <h1>Gestión de Justificativos</h1>
        <nav>
            <ul>
                <li><a href="../index.php"><i class="fas fa-home"></i> Inicio</a></li>
                <li><a href="justificativos.php"><i class="fas fa-plus-circle"></i> Registrar Nuevo</a></li>
                <li><a href="exportar_justificativos.php" class="btn btn-success"><i class="fas fa-file-excel"></i> Exportar</a></li>
            </ul>
        </nav>
    </div>
</header>
    
<main class="container">
    <?php if ($message): ?><div class="mensaje <?php echo $message_type; ?> show"><?php echo htmlspecialchars($message, ENT_QUOTES, 'UTF-8'); ?></div><?php endif; ?>

    <div class="card form-container">
        <h2><i class="fas fa-filter"></i> Filtros de Búsqueda</h2>
        <form method="GET">
            <div class="form-grid-4col">
                <div class="form-group"><label>RUT Retirante</label><input type="text" name="rut" class="form-control" value="<?=htmlspecialchars($filtro_rut)?>"></div>
                <div class="form-group"><label>Nombre Alumno</label><input type="text" name="nombre" class="form-control" value="<?=htmlspecialchars($filtro_nombre)?>"></div>
                <div class="form-group">
                    <label>Curso</label>
                    <select name="curso" class="form-control">
                        <option value="">Todos</option>
                        <option value="docente_only" <?=($filtro_curso=='docente_only')?'selected':''?>>Solo Justificativos de Docente</option>
                        <?php $cursos->data_seek(0); while($c = $cursos->fetch_assoc()): ?>
                            <option value="<?=$c['id']?>" <?=($filtro_curso==$c['id'])?'selected':''?>><?=htmlspecialchars($c['nombre'])?></option>
                        <?php endwhile; ?>
                    </select>
                </div>
                <div class="form-group"><label>Fecha</label><input type="date" name="fecha" class="form-control" value="<?=htmlspecialchars($filtro_fecha)?>"></div>
            </div>
            <div class="form-buttons" style="margin-top: 1rem;">
                <button type="submit" class="btn btn-primary">Buscar</button>
                <a href="gestion_justificativos.php" class="btn btn-secondary">Limpiar</a>
            </div>
        </form>
    </div>

    <div class="card table-container" style="margin-top: 2rem;">
        <h2><i class="fas fa-list-ul"></i> Resultados</h2>
        <div class="card-grid-container">
            <?php if ($justificativos->num_rows > 0): ?>
                <?php $justificativos_data = $justificativos->fetch_all(MYSQLI_ASSOC); ?>
                <?php foreach ($justificativos_data as $j): ?>
                    <?php 
                        $is_docente_justification = ($j['usuario_rol_id'] == 2); 
                        $justificado_nombre = htmlspecialchars($j['usuario_ap'].' '.$j['usuario_am'].', '.$j['usuario_nombre']);
                    ?>
                    <div class="justificativo-card <?= $is_docente_justification ? 'justificativo-curso' : '' ?>">
                        <div class="card-header">
                            <span class="date"><?= date('d-m-Y H:i', strtotime($j['fecha'])) ?></span>
                            <div class="actions">
                                <a href="imprimir_justificativo.php?id=<?= $j['id'] ?>" target="_blank" class="btn btn-secondary btn-sm" title="Imprimir"><i class="fas fa-print"></i></a>
                                <button class="btn btn-edit btn-sm" onclick="openModal('editarModal<?= $j['id'] ?>')" title="Editar"><i class="fas fa-pencil-alt"></i></button>
                                <a href="?eliminar_id=<?= $j['id'] ?>&<?= $filter_query_string ?>" onclick="return confirm('¿Eliminar?');" class="btn btn-danger btn-sm" title="Eliminar"><i class="fas fa-trash-alt"></i></a>
                            </div>
                        </div>
                        <div class="card-body">
                            <?php if ($is_docente_justification): ?>
                                <h5><i class="fas fa-users"></i> CURSO COMPLETO</h5>
                                <p><strong>Docente:</strong> <?= $justificado_nombre ?></p>
                            <?php else: ?>
                                <h5><?= $justificado_nombre ?></h5>
                            <?php endif; ?>
                            
                            <p><strong>Curso:</strong> <?= htmlspecialchars($j['curso_nombre'] ?? 'N/A') ?></p>
                            <p class="retirante"><?= htmlspecialchars($j['nombre_retirante'].' ('.$j['tipo_retirante'].')') ?></p>
                            <p><strong>Motivo:</strong> <?= htmlspecialchars($j['motivo']) ?></p>
                            <?php if (!empty($j['hora_regreso'])): ?>
                                <p style="color: var(--success-color);"><strong>Regresó a las:</strong> <?= date('H:i', strtotime($j['hora_regreso'])) ?></p>
                            <?php endif; ?>
                            <p><small>Funcionario: <?= htmlspecialchars($j['func_nombre'].' '.$j['func_ap']) ?></small></p>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="full-width" style="text-align: center; padding: 2rem;">No se encontraron justificativos.</div>
            <?php endif; ?>
        </div>
    </div>
    
    <div class="pagination">
        <?php for ($i = 1; $i <= $totalPaginas; $i++): ?>
            <a class="page-link" href="?pagina=<?= $i ?>&<?= $filter_query_string ?>" class="<?= ($i == $paginaActual) ? 'current-page' : '' ?>"><?= $i ?></a>
        <?php endfor; ?>
    </div>

    <?php if (isset($justificativos_data)): ?>
        <?php foreach ($justificativos_data as $j): ?>
            <div class="modal" id="editarModal<?= $j['id'] ?>">
                <div class="modal-content"> 
                    <form method="POST">
                        <div class="modal-header">
                            <h2>Editar Justificativo #<?= $j['id'] ?></h2>
                            <button type="button" class="modal-close-btn" onclick="closeModal('editarModal<?= $j['id'] ?>')">&times;</button>
                        </div>
                        <div class="modal-body">
                            <input type="hidden" name="id" value="<?= $j['id'] ?>">
                            
                            <input type="hidden" name="filtro_rut" value="<?= htmlspecialchars($filtro_rut) ?>">
                            <input type="hidden" name="filtro_nombre" value="<?= htmlspecialchars($filtro_nombre) ?>">
                            <input type="hidden" name="filtro_curso" value="<?= htmlspecialchars($filtro_curso) ?>">
                            <input type="hidden" name="filtro_fecha" value="<?= htmlspecialchars($filtro_fecha) ?>">
                            
                            <div class="form-grid">
                                <div class="form-group">
                                    <label>Curso</label>
                                    <select name="curso_id" id="curso_id_<?= $j['id'] ?>">
                                        <option value="" <?= (is_null($j['curso_id']) || $j['curso_id'] === '') ? 'selected' : '' ?>>[Sin Curso]</option>
                                        <?php $cursos->data_seek(0); while($c = $cursos->fetch_assoc()): ?>
                                            <option value="<?= $c['id'] ?>" <?= ($c['id']==$j['curso_id'])?'selected':'' ?>><?= htmlspecialchars($c['nombre']) ?></option>
                                        <?php endwhile; ?>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label>Usuario Justificado</label>
                                    <select name="usuario_id" id="usuario_id_<?= $j['id'] ?>" required>
                                        <option value="">Seleccionar</option>
                                        <?php foreach ($all_users as $u): 
                                            $nombre_comp = htmlspecialchars($u['apellido_paterno'].' '.$u['nombre']);
                                            $rol = ($u['rol_id'] == 3) ? 'Alumno' : 'Docente';
                                        ?>
                                        <option value="<?= $u['id'] ?>" data-rol="<?= $rol ?>" <?= ($u['id']==$j['usuario_id'])?'selected':'' ?>>
                                            <?= $nombre_comp ?> (<?= $rol ?>)
                                        </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>

                            <div class="form-group"><label>Motivo</label><textarea name="motivo" required><?= htmlspecialchars($j['motivo']) ?></textarea></div>
                            
                            <div class="form-grid-3col">
                                <div class="form-group">
                                    <label>Tipo Retirante</label>
                                    <select name="tipo_retirante" id="tipo_retirante_<?= $j['id'] ?>" onchange="handleRetiranteChange(<?= $j['id'] ?>)" required>
                                        <option value="Apoderado Titular" <?= ($j['tipo_retirante']=='Apoderado Titular')?'selected':'' ?>>Apoderado Titular</option>
                                        <option value="Docente" <?= ($j['tipo_retirante']=='Docente')?'selected':'' ?>>Docente</option>
                                        <option value="Otro" <?= ($j['tipo_retirante']=='Otro')?'selected':'' ?>>Otro</option>
                                    </select>
                                </div>
                                <div class="form-group"><label>Nombre Retirante</label><input type="text" id="nombre_retirante_<?= $j['id'] ?>" name="nombre_retirante" value="<?= htmlspecialchars($j['nombre_retirante']) ?>" required></div>
                                <div class="form-group"><label>RUT Retirante</label><input type="text" id="rut_retirante_<?= $j['id'] ?>" name="rut_retirante" value="<?= htmlspecialchars($j['rut_retirante']) ?>"></div>
                            </div>
                            
                            <div class="form-group" style="background:#f0f9ff; padding:10px; border-radius:5px;">
                                <label>Hora Regreso (Opcional)</label>
                                <input type="time" name="hora_regreso" class="form-control" value="<?= $j['hora_regreso'] ?>">
                            </div>
                            <div class="form-group"><label>Observaciones</label><textarea name="observaciones"><?= htmlspecialchars($j['observaciones']) ?></textarea></div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" onclick="closeModal('editarModal<?= $j['id'] ?>')">Cancelar</button>
                            <button type="submit" name="editar" class="btn btn-primary">Guardar</button>
                        </div>
                    </form>
                </div>
            </div>
        <?php endforeach; ?>
    <?php endif; ?>
</div>

<div class="modal-backdrop" id="modalBackdrop"></div>

<script>
    const docentesMap = <?= $docentes_json ?>;

    function handleRetiranteChange(id) {
        const tipoSelect = document.getElementById(`tipo_retirante_${id}`);
        const usuarioSelect = document.getElementById(`usuario_id_${id}`);
        const nombreInput = document.getElementById(`nombre_retirante_${id}`);
        const rutInput = document.getElementById(`rut_retirante_${id}`);
        
        if (tipoSelect.value === 'Docente') {
             const selectedOption = usuarioSelect.options[usuarioSelect.selectedIndex];
             const userId = selectedOption.value;
             if (docentesMap[userId]) {
                 nombreInput.value = docentesMap[userId].nombre + ' ' + docentesMap[userId].apellidos;
                 rutInput.value = docentesMap[userId].rut;
             }
        }
    }

    function openModal(modalId) {
        document.getElementById(modalId).classList.add('show');
        document.getElementById('modalBackdrop').classList.add('show');
    }
    function closeModal(modalId) {
        document.getElementById(modalId).classList.remove('show');
        document.getElementById('modalBackdrop').classList.remove('show');
    }
    document.getElementById('modalBackdrop').addEventListener('click', function() {
        document.querySelectorAll('.modal.show').forEach(modal => { modal.classList.remove('show'); });
        this.classList.remove('show');
    });
    window.onload = function() {
        const message = document.querySelector('.mensaje');
        if (message) { setTimeout(() => { message.classList.remove('show'); }, 3000); }
    };
</script>
</body>
</html>