<?php
header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename=justificativos.csv');

include '../includes/db.php';
include '../includes/auth.php';
checkAuth();

// Filtros
$rut_filtro = isset($_GET['rut']) ? $conn->real_escape_string($_GET['rut']) : '';
$nombre_filtro = isset($_GET['nombre']) ? $conn->real_escape_string($_GET['nombre']) : '';
$curso_filtro = isset($_GET['curso']) ? intval($_GET['curso']) : '';
$fecha_filtro = isset($_GET['fecha']) ? $conn->real_escape_string($_GET['fecha']) : '';

// Filtros SQL
$where = "WHERE 1=1 ";
if ($rut_filtro) $where .= " AND u.rut LIKE '%$rut_filtro%' ";
if ($nombre_filtro) $where .= " AND CONCAT(u.nombre,' ',u.apellido_paterno,' ',u.apellido_materno) LIKE '%$nombre_filtro%' ";
if ($curso_filtro) $where .= " AND j.curso_id = $curso_filtro ";
if ($fecha_filtro) $where .= " AND DATE(j.fecha) = '$fecha_filtro' ";

// Consulta de registros (SE AGREGÓ j.hora_regreso)
$result = $conn->query("
    SELECT j.fecha, j.hora_regreso, u.rut, u.nombre AS alumno_nombre, u.apellido_paterno, u.apellido_materno,
           c.nombre AS curso_nombre, j.tipo_retirante, j.nombre_retirante, j.rut_retirante,
           j.motivo, j.observaciones, f.nombre AS func_nombre, f.apellido_paterno AS func_ap
    FROM justificativos j
    INNER JOIN usuario u ON j.usuario_id = u.id
    INNER JOIN curso c ON j.curso_id = c.id
    LEFT JOIN usuario f ON j.usuario_registro = f.id
    $where
    ORDER BY j.fecha DESC
");

// Abrir output CSV con BOM UTF-8
$output = fopen('php://output', 'w');
fwrite($output, chr(0xEF).chr(0xBB).chr(0xBF)); // BOM UTF-8

// Encabezado con punto y coma (SE AGREGÓ 'Hora Regreso')
fputcsv($output, [
    'Fecha',
    'RUT Alumno',
    'Alumno',
    'Curso',
    'Tipo Retirante',
    'Nombre Retirante',
    'RUT Retirante',
    'Motivo',
    'Observaciones',
    'Hora Regreso',
    'Funcionario'
], ';');

// Filas con punto y coma
while ($row = $result->fetch_assoc()) {
    // Formatear hora de regreso si existe
    $hora_regreso_fmt = !empty($row['hora_regreso']) ? date('H:i', strtotime($row['hora_regreso'])) : '';

    fputcsv($output, [
        date('d-m-Y H:i', strtotime($row['fecha'])),
        $row['rut'],
        $row['apellido_paterno'].' '.$row['apellido_materno'].', '.$row['alumno_nombre'],
        $row['curso_nombre'],
        $row['tipo_retirante'],
        $row['nombre_retirante'],
        $row['rut_retirante'],
        $row['motivo'],
        $row['observaciones'],
        $hora_regreso_fmt, // Dato agregado
        $row['func_nombre'].' '.$row['func_ap']
    ], ';');
}

fclose($output);
exit;
?>