<?php
session_start();
header('Content-Type: text/html; charset=utf-8');
include '../includes/db.php';
include '../includes/auth.php';
checkAuth();

if (!isAdmin()) { /* ... */ }

$conn->set_charset("utf8");

// --- 1. CONFIGURACIÓN DEL CALENDARIO ---
$configuracion_meses = [
    'Agosto'     => [
        'General' => 'Mes Completo'
    ],
    'Septiembre' => [
        'General' => 'Mes Completo'
    ],
    'Octubre'    => [
        'General' => 'Mes Completo'
    ],
    'Noviembre'  => [
        'General'         => 'Mes de Noviembre (Normal)',
        'Recup_Lunes'     => 'Recuperación - Lunes',
        'Recup_Miercoles' => 'Recuperación - Miércoles',
        'Recup_Jueves'    => 'Recuperación - Jueves',
        'Recup_Viernes'   => 'Recuperación - Viernes'
    ]
];

$docentes = $conn->query("SELECT id, nombre, apellido_paterno, apellido_materno FROM usuario WHERE rol_id = 2 AND activo = 1 ORDER BY apellido_paterno ASC");
$docente_id_seleccionado = isset($_REQUEST['docente_id']) ? intval($_REQUEST['docente_id']) : 0;
$message = ''; $msg_type = '';

// --- 2. PROCESAR GUARDADO (POST) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['guardar_horas'])) {
    $docente_id_post = intval($_POST['docente_id']);
    $datos_post = $_POST['horas']; 

    if ($docente_id_post > 0) {
        $stmt = $conn->prepare("INSERT INTO registro_horas_manual (usuario_id, mes, dia, h_planificadas, h_realizadas, h_no_realizadas) 
                                VALUES (?, ?, ?, ?, ?, ?) 
                                ON DUPLICATE KEY UPDATE h_planificadas=?, h_realizadas=?, h_no_realizadas=?");
        
        $error = false;

        foreach ($configuracion_meses as $mes => $dias_array) {
            foreach ($dias_array as $dia_key => $dia_label) {
                
                $p_h = intval($datos_post[$mes][$dia_key]['plan']['h'] ?? 0);
                $p_m = intval($datos_post[$mes][$dia_key]['plan']['m'] ?? 0);
                
                $r_h = intval($datos_post[$mes][$dia_key]['real']['h'] ?? 0);
                $r_m = intval($datos_post[$mes][$dia_key]['real']['m'] ?? 0);
                
                $n_h = intval($datos_post[$mes][$dia_key]['noreal']['h'] ?? 0);
                $n_m = intval($datos_post[$mes][$dia_key]['noreal']['m'] ?? 0);

                // Convertir a MINUTOS
                $total_plan = ($p_h * 60) + $p_m;
                $total_real = ($r_h * 60) + $r_m;
                $total_noreal = ($n_h * 60) + $n_m;

                $stmt->bind_param("issiiiiii", 
                    $docente_id_post, $mes, $dia_key, 
                    $total_plan, $total_real, $total_noreal, 
                    $total_plan, $total_real, $total_noreal
                );
                
                if (!$stmt->execute()) $error = true;
            }
        }
        $stmt->close();

        if (!$error) {
            $message = "✅ Datos guardados correctamente.";
            $msg_type = "success";
        } else {
            $message = "❌ Error al guardar.";
            $msg_type = "error";
        }
        $docente_id_seleccionado = $docente_id_post;
    }
}

// --- 3. OBTENER DATOS GUARDADOS ---
$datos_db = [];
$nombre_docente = "";
// Bandera para saber si hay datos de recuperación y mostrar el botón expandido al cargar
$hay_recuperacion = false; 

if ($docente_id_seleccionado > 0) {
    $resName = $conn->query("SELECT nombre, apellido_paterno FROM usuario WHERE id = $docente_id_seleccionado");
    if ($r = $resName->fetch_assoc()) $nombre_docente = $r['nombre'] . " " . $r['apellido_paterno'];

    $sql = "SELECT mes, dia, h_planificadas, h_realizadas, h_no_realizadas FROM registro_horas_manual WHERE usuario_id = $docente_id_seleccionado";
    $res = $conn->query($sql);
    while ($row = $res->fetch_assoc()) {
        $datos_db[$row['mes']][$row['dia']] = [
            'plan_h' => floor($row['h_planificadas'] / 60),
            'plan_m' => $row['h_planificadas'] % 60,
            'real_h' => floor($row['h_realizadas'] / 60),
            'real_m' => $row['h_realizadas'] % 60,
            'noreal_h' => floor($row['h_no_realizadas'] / 60),
            'noreal_m' => $row['h_no_realizadas'] % 60,
        ];
        
        // Detectar si hay datos en recuperación para abrir el acordeón automáticamente
        if (strpos($row['dia'], 'Recup') !== false && ($row['h_planificadas'] > 0 || $row['h_realizadas'] > 0)) {
            $hay_recuperacion = true;
        }
    }
}

function renderInputs($mes, $dia_key, $tipo, $data) {
    $val_h = $data[$mes][$dia_key][$tipo.'_h'] ?? '';
    $val_m = $data[$mes][$dia_key][$tipo.'_m'] ?? '';
    if ($val_h === 0) $val_h = '';
    if ($val_m === 0) $val_m = '';

    $border = ($tipo == 'plan') ? '#1976d2' : (($tipo == 'real') ? '#388e3c' : '#d32f2f');
    $bg_style = (strpos($dia_key, 'Recup') !== false) ? 'background-color: #f3e5f5;' : 'background-color: #fff;';

    echo '<div class="time-group" style="border-left: 3px solid '.$border.'; '.$bg_style.'">';
    echo '<input type="number" name="horas['.$mes.']['.$dia_key.']['.$tipo.'][h]" placeholder="H" value="'.$val_h.'" min="0" class="input-calc">';
    echo '<span>:</span>';
    echo '<input type="number" name="horas['.$mes.']['.$dia_key.']['.$tipo.'][m]" placeholder="M" value="'.$val_m.'" min="0" max="59" class="input-calc">';
    echo '</div>';
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="../images/logo.png">
    <title>Asignar Horas</title>
    <link rel="stylesheet" href="../css/admin.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    
    <style>
        .time-group { display: flex; align-items: center; padding: 2px 5px; border-radius: 4px; border: 1px solid #ddd; }
        .time-group input { width: 45px; border: none; text-align: center; font-size: 0.95rem; outline: none; background: transparent; }
        .time-group span { font-weight: bold; margin: 0 2px; color: #666; }
        
        .tabla-horas { width: 100%; border-collapse: collapse; margin-top: 15px; box-shadow: 0 2px 5px rgba(0,0,0,0.05); }
        .tabla-horas th, .tabla-horas td { border: 1px solid #e0e0e0; padding: 10px; text-align: center; vertical-align: middle; }
        .tabla-horas th { color: white; font-weight: 500; }
        
        .mes-header { background-color: #37474f; color: #fff !important; text-align: left !important; padding: 12px 15px !important; }
        .mes-header-content { display: flex; justify-content: space-between; align-items: center; width: 100%; }
        
        .dia-label { font-weight: 600; text-align: left !important; padding-left: 20px !important; background-color: #fafafa; width: 220px; color: #455a64; }
        
        .row-recuperacion td { background-color: #f3e5f5 !important; border-top: 1px solid #e1bee7; }
        .row-recuperacion .dia-label { color: #7b1fa2; }

        .sticky-btn { position: fixed; bottom: 30px; right: 30px; z-index: 100; box-shadow: 0 4px 20px rgba(0,0,0,0.3); padding: 15px 30px; font-size: 1.1rem; border-radius: 30px; }
        nav ul li a.btn-nav { margin-left: 5px; background-color: rgba(255,255,255,0.2); padding: 5px 10px; border-radius: 4px; transition: 0.3s; }
        nav ul li a.btn-nav:hover { background-color: rgba(255,255,255,0.4); }

        /* Botón Recuperación */
        .btn-toggle-recup {
            background-color: #9c27b0; 
            color: white; 
            border: none; 
            padding: 5px 12px; 
            border-radius: 15px; 
            font-size: 0.8rem; 
            cursor: pointer; 
            transition: 0.3s;
            display: flex;
            align-items: center;
            gap: 5px;
        }
        .btn-toggle-recup:hover { background-color: #7b1fa2; }
    </style>
</head>
<body>

<header>
    <div class="header-content">
        <img src="../images/INSIGNIA SF.png" alt="Logo">
        <h1>Asignación de Horas</h1>
        <nav>
            <ul>
                <li><a href="../index.php"><i class="fas fa-home"></i> Inicio</a></li>
                <li><a href="gestion_horas_manuales.php" class="btn-nav"><i class="fas fa-list-check"></i> Gestionar</a></li>
                <li><a href="resumen_horas_docentes.php" class="btn-nav"><i class="fas fa-chart-pie"></i> Ver Resumen</a></li>
            </ul>
        </nav>
    </div>
</header>

<main class="container">
    <?php if ($message): ?>
        <div class="mensaje <?= ($msg_type=='success')?'exito':'error' ?> show">
            <?= $message ?>
        </div>
        <script>setTimeout(() => document.querySelector('.mensaje').remove(), 3000);</script>
    <?php endif; ?>

    <div class="card form-container">
        <h2><i class="fas fa-user-tie"></i> Seleccionar Docente</h2>
        <form method="GET" action="">
            <div class="form-group" style="display: flex; gap: 10px; align-items: center;">
                <select name="docente_id" class="form-control" onchange="this.form.submit()" required>
                    <option value="">Seleccione un Docente</option>
                    <?php $docentes->data_seek(0); while($d = $docentes->fetch_assoc()): ?>
                        <option value="<?= $d['id'] ?>" <?= ($docente_id_seleccionado == $d['id']) ? 'selected' : '' ?>>
                            <?= htmlspecialchars($d['apellido_paterno'] . ' ' . $d['apellido_materno'] . ', ' . $d['nombre']) ?>
                        </option>
                    <?php endwhile; ?>
                </select>
                <button type="submit" class="btn btn-primary">Cargar</button>
            </div>
        </form>
    </div>

    <?php if ($docente_id_seleccionado > 0): ?>
        <div class="card table-container" style="margin-top: 20px; padding-bottom: 80px;">
            <h3 style="margin-bottom: 15px; color: var(--primary-color);">
                Ingresando datos para: <span style="color: #333; text-decoration: underline;"><?= htmlspecialchars($nombre_docente) ?></span>
            </h3>

            <form method="POST">
                <input type="hidden" name="docente_id" value="<?= $docente_id_seleccionado ?>">
                
                <table class="tabla-horas">
                    <thead>
                        <tr>
                            <th>Mes / Día</th>
                            <th style="background-color: #1976d2; width: 25%;">Planificadas (H:M)</th>
                            <th style="background-color: #388e3c; width: 25%;">Realizadas (H:M)</th>
                            <th style="background-color: #d32f2f; width: 25%;">No Realizadas (H:M)</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($configuracion_meses as $mes => $dias_array): ?>
                            <tr>
                                <td colspan="4" class="mes-header" style="padding: 0;">
                                    <div class="mes-header-content">
                                        <span><i class="far fa-calendar-alt"></i> <?= $mes ?></span>
                                        
                                        <?php if ($mes == 'Noviembre'): ?>
                                            <button type="button" class="btn-toggle-recup" onclick="toggleRecuperacion()">
                                                <i class="fas fa-history"></i> Agregar Recuperación
                                            </button>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>

                            <?php foreach ($dias_array as $dia_key => $dia_label): 
                                $isRecup = (strpos($dia_key, 'Recup') !== false);
                                
                                // Ocultar por defecto si es recuperación, excepto si ya hay datos guardados ($hay_recuperacion)
                                $styleDisplay = '';
                                if ($isRecup) {
                                    $styleDisplay = $hay_recuperacion ? '' : 'display: none;';
                                }
                                
                                $extraClass = $isRecup ? 'row-recuperacion row-recup-target' : '';
                            ?>
                                <tr class="<?= $extraClass ?>" style="background-color: #fff; <?= $styleDisplay ?>">
                                    <td class="dia-label">
                                        <?= $dia_label ?>
                                    </td>
                                    <td><?php renderInputs($mes, $dia_key, 'plan', $datos_db); ?></td>
                                    <td><?php renderInputs($mes, $dia_key, 'real', $datos_db); ?></td>
                                    <td><?php renderInputs($mes, $dia_key, 'noreal', $datos_db); ?></td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endforeach; ?>
                    </tbody>
                </table>

                <button type="submit" name="guardar_horas" class="btn btn-primary sticky-btn">
                    <i class="fas fa-save"></i> Guardar Todo
                </button>
            </form>
        </div>
    <?php endif; ?>
</main>

<script>
    function toggleRecuperacion() {
        const rows = document.querySelectorAll('.row-recup-target');
        rows.forEach(row => {
            if (row.style.display === 'none' || row.style.display === '') {
                row.style.display = 'table-row';
            } else {
                row.style.display = 'none';
                // Opcional: ¿Borrar datos al ocultar?
                // row.querySelectorAll('input').forEach(i => i.value = ''); 
            }
        });
    }
</script>

</body>
</html>