<?php
session_start();
header('Content-Type: text/html; charset=utf-8');
include '../includes/db.php';
include '../includes/auth.php';
checkAuth();

$conn->set_charset("utf8");

// --- (Lógica de PHP para obtener $usuarios, $bloques, etc. se mantiene IGUAL) ---
$usuario_id = $_SESSION['usuario_id'];
$rol_id = $_SESSION['rol'] ?? null;
$conn->set_charset("utf8");
$usuarios = [];
if (isAdmin()) {
    $result = $conn->query("SELECT id, nombre, apellido_paterno, apellido_materno FROM usuario WHERE rol_id IN (1, 2)");
    while ($row = $result->fetch_assoc()) {
        $usuarios[] = $row;
    }
} else {
    $stmt_user = $conn->prepare("SELECT id, nombre, apellido_paterno, apellido_materno FROM usuario WHERE id = ?");
    $stmt_user->bind_param("i", $usuario_id);
    $stmt_user->execute();
    $result_user = $stmt_user->get_result();
    if ($row = $result_user->fetch_assoc()) {
        $usuarios[] = $row;
    }
    $stmt_user->close();
}
$bloques = [
    "mañana" => [["08:20:00", "09:05:00"], ["09:05:00", "09:50:00"], ["10:10:00", "10:55:00"], ["10:55:00", "11:40:00"], ["12:00:00", "12:45:00"], ["12:45:00", "13:30:00"]],
    "tarde" => [["14:15:00", "15:00:00"], ["15:00:00", "15:45:00"]]
];
$message = '';
$message_type = '';
if (isset($_GET['message'])) {
    $message = urldecode($_GET['message']);
    $message_type = urldecode($_GET['type'] ?? 'exito');
}
// --- (Lógica de descarga de Excel) ---
if (isset($_GET['download']) && isAdmin()) {
    $result = $conn->query("SELECT horario.*, curso.nombre AS curso_nombre, CONCAT_WS(' ', usuario.nombre, usuario.apellido_paterno, usuario.apellido_materno) AS usuario_nombre 
                            FROM horario 
                            LEFT JOIN curso ON horario.curso_id = curso.id 
                            JOIN usuario ON horario.usuario_id = usuario.id");
    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment; filename="horas_agendadas.xls"');
    echo "<table><tr><th>ID</th><th>Fecha</th><th>Hora Inicio</th><th>Hora Fin</th><th>Curso</th><th>Usuario</th></tr>";
    while ($row = $result->fetch_assoc()) {
        echo "<tr>
                <td>" . htmlspecialchars($row['id']) . "</td>
                <td>" . htmlspecialchars($row['fecha']) . "</td>
                <td>" . htmlspecialchars($row['hora_inicio']) . "</td>
                <td>" . htmlspecialchars($row['hora_fin']) . "</td>
                <td>" . htmlspecialchars($row['curso_nombre']) . "</td>
                <td>" . htmlspecialchars($row['usuario_nombre']) . "</td>
              </tr>";
    }
    echo "</table>";
    exit();
}
// --- (Lógica POST de Agendar/Eliminar) ---
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['eliminar']) && isAdmin()) {
        $horario_id = $_POST['horario_id'];
        $stmt = $conn->prepare("DELETE FROM horario WHERE id = ?");
        $stmt->bind_param("i", $horario_id);
        if ($stmt->execute()) {
            $message = "Hora eliminada correctamente.";
            $message_type = 'exito';
        } else {
            $message = "Error al eliminar la hora.";
            $message_type = 'error';
        }
        $stmt->close();
    } else {
        $fecha = $_POST['fecha'];
        list($hora_inicio, $hora_fin) = explode(',', $_POST['bloque']);
        $usuario_id_post = $_POST['usuario_id'];
        $curso_id = $_POST['curso_id'];

        // Validar que no sea una fecha/hora pasada (solo para no-admin)
        if (!isAdmin()) {
            $fecha_hora_inicio = $fecha . ' ' . $hora_inicio;
            $ahora = date('Y-m-d H:i:s');
            if ($fecha_hora_inicio < $ahora) {
                $message = "No puedes agendar clases en fechas u horas pasadas.";
                $message_type = 'error';
                header("Location: schedule.php?message=" . urlencode($message) . "&type=" . urlencode($message_type));
                exit();
            }
        }

        $stmt = $conn->prepare("SELECT COUNT(*) FROM horario WHERE fecha = ? AND hora_inicio = ? AND hora_fin = ?");
        $stmt->bind_param("sss", $fecha, $hora_inicio, $hora_fin);
        $stmt->execute();
        $stmt->bind_result($count);
        $stmt->fetch();
        $stmt->close();
        if ($count == 0) {
            $stmt = $conn->prepare("INSERT INTO horario (usuario_id, fecha, hora_inicio, hora_fin, curso_id) VALUES (?, ?, ?, ?, ?)");
            $stmt->bind_param("isssi", $usuario_id_post, $fecha, $hora_inicio, $hora_fin, $curso_id);
            if ($stmt->execute()) {
                $message = "Hora agendada correctamente.";
                $message_type = 'exito';
            } else {
                $message = "Error al agendar la hora: " . $stmt->error;
                $message_type = 'error';
            }
            $stmt->close();
        } else {
            $message = "Este bloque ya está ocupado. Por favor, selecciona otro.";
            $message_type = 'error';
        }
    }
    header("Location: schedule.php?message=" . urlencode($message) . "&type=" . urlencode($message_type));
    exit();
}

// --- (Lógica de obtener eventos - CORREGIDA para seguridad visual) ---
$result = $conn->query("
    SELECT horario.*, 
           COALESCE(curso.nombre, 'Reunión') AS curso_nombre, 
           CONCAT_WS(' ', usuario.nombre, usuario.apellido_paterno, usuario.apellido_materno) AS usuario_nombre 
    FROM horario 
    LEFT JOIN curso ON horario.curso_id = curso.id 
    JOIN usuario ON horario.usuario_id = usuario.id
");
$eventos = [];
while ($row = $result->fetch_assoc()) {
    $eventos[] = [
        'id' => $row['id'],
        'title' => $row['usuario_nombre'] . ' - ' . $row['curso_nombre'], // Formato más limpio
        'start' => $row['fecha'] . 'T' . $row['hora_inicio'],
        'end' => $row['fecha'] . 'T' . $row['hora_fin'],
        'extendedProps' => [
            'curso_nombre' => $row['curso_nombre'],
            'usuario_nombre' => $row['usuario_nombre'],
            'fecha' => $row['fecha'],
            'hora_inicio' => substr($row['hora_inicio'], 0, 5), // Cortar segundos
            'hora_fin' => substr($row['hora_fin'], 0, 5),
        ],
        // Color diferente para reuniones vs clases
        'backgroundColor' => ($row['curso_id'] == 0) ? '#f59e0b' : '#3b82f6',
        'borderColor' => ($row['curso_id'] == 0) ? '#f59e0b' : '#3b82f6',
    ];
}
$result->free();
$cursos = $conn->query("SELECT id, nombre FROM curso WHERE activo = 1 ORDER BY nombre ASC;");
if ($cursos === FALSE) {
    die("Error al obtener los cursos: " . $conn->error);
}
?>

<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="../images/logo.png">
    <title>Agendar Horas - Escuela Porongo</title>

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

    <link href='https://cdn.jsdelivr.net/npm/fullcalendar@5.11.0/main.min.css' rel='stylesheet' />
    <script src='https://cdn.jsdelivr.net/npm/fullcalendar@5.11.0/main.min.js'></script>
    <script src='https://cdn.jsdelivr.net/npm/fullcalendar@5.11.0/locales/es.js'></script>

    <style>
        :root {
            --primary: #4f46e5;
            /* Indigo 600 */
            --primary-light: #818cf8;
            /* Indigo 400 */
            --secondary: #0ea5e9;
            /* Sky 500 */
            --dark: #0f172a;
            /* Slate 900 */
            --light: #f8fafc;
            /* Slate 50 */
            --gray: #64748b;
            /* Slate 500 */
            --success: #10b981;
            --danger: #ef4444;
            --glass-bg: rgba(255, 255, 255, 0.85);
            /* Slightly more opaque for readability */
            --glass-border: rgba(255, 255, 255, 0.5);
            --shadow: 0 10px 40px -10px rgba(0, 0, 0, 0.1);
        }

        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(135deg, #e0f2fe 0%, #eef2ff 100%);
            margin: 0;
            padding-top: 90px;
            color: var(--dark);
            min-height: 100vh;
        }

        /* --- Header Estilizado --- */
        .header-content {
            background: rgba(15, 23, 42, 0.95);
            backdrop-filter: blur(12px);
            -webkit-backdrop-filter: blur(12px);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            color: white;
            padding: 0 5%;
            height: 80px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            z-index: 1000;
            box-shadow: 0 4px 30px rgba(0, 0, 0, 0.1);
            box-sizing: border-box;
        }

        .header-left {
            display: flex;
            align-items: center;
            gap: 20px;
        }

        .header-left img {
            height: 50px;
            width: auto;
            filter: drop-shadow(0 2px 4px rgba(0, 0, 0, 0.2));
        }

        .header-left h1 {
            font-size: 1.5rem;
            font-weight: 600;
            margin: 0;
            letter-spacing: -0.5px;
        }

        .header-nav ul {
            list-style: none;
            display: flex;
            gap: 30px;
            margin: 0;
            padding: 0;
            align-items: center;
        }

        .header-nav a {
            color: #94a3b8;
            text-decoration: none;
            font-size: 0.95rem;
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 10px;
            transition: all 0.3s ease;
        }

        .header-nav a:hover {
            color: white;
            transform: translateY(-2px);
        }

        .btn-download {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            color: white !important;
            padding: 10px 24px;
            border-radius: 50px;
            box-shadow: 0 4px 15px rgba(16, 185, 129, 0.3);
            font-weight: 600 !important;
        }

        .btn-download:hover {
            box-shadow: 0 6px 20px rgba(16, 185, 129, 0.4);
            transform: translateY(-2px);
            background: linear-gradient(135deg, #34d399 0%, #10b981 100%);
        }

        /* --- Contenedor Principal --- */
        main {
            max-width: 1400px;
            margin: 0 auto 40px;
            padding: 30px;
            background: var(--glass-bg);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            border-radius: 24px;
            border: 1px solid var(--glass-border);
            box-shadow: var(--shadow);
        }

        /* --- FullCalendar Personalización --- */
        #calendar {
            max-width: 100%;
            margin: 0 auto;
        }

        .fc {
            font-family: 'Poppins', sans-serif;
        }

        .fc-toolbar-title {
            font-size: 1.75em !important;
            font-weight: 700;
            color: var(--dark);
            letter-spacing: -1px;
        }

        /* Botones del Calendario */
        .fc-button-primary {
            background: var(--primary) !important;
            border: none !important;
            border-radius: 12px !important;
            padding: 10px 24px !important;
            font-weight: 600 !important;
            text-transform: capitalize;
            box-shadow: 0 4px 6px -1px rgba(79, 70, 229, 0.2);
            transition: all 0.2s ease !important;
        }

        .fc-button-primary:hover {
            background: #4338ca !important;
            transform: translateY(-2px);
            box-shadow: 0 10px 15px -3px rgba(79, 70, 229, 0.3);
        }

        .fc-button-primary:disabled {
            background: #cbd5e1 !important;
            box-shadow: none;
            transform: none;
        }

        .fc-col-header-cell {
            background: #f8fafc;
            padding: 15px 0;
            border: none !important;
            border-bottom: 2px solid #e2e8f0 !important;
        }

        .fc-col-header-cell-cushion {
            color: var(--gray);
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            font-size: 0.85rem;
        }

        .fc-scrollgrid {
            border: none !important;
        }

        .fc-scrollgrid-section>td {
            border: none !important;
        }

        .fc-timegrid-slot {
            border-bottom: 1px dashed #e2e8f0 !important;
            height: 6em !important;
            /* Aumentado para que quepa toda la info */
        }

        .fc-timegrid-slot-label {
            border-right: none !important;
            font-size: 0.8rem;
            color: var(--gray);
            font-weight: 500;
        }

        .fc-theme-standard td,
        .fc-theme-standard th {
            border-color: #f1f5f9;
        }

        /* Eventos */
        .fc-event {
            border: none !important;
            border-radius: 6px;
            padding: 2px 4px;
            /* Menos padding para más espacio de texto */
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.05);
            transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
            margin: 1px 2px;
            overflow: hidden;
            /* Asegurar que no se salga */
        }

        .fc-event:hover {
            transform: scale(1.02);
            z-index: 50;
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
        }

        .fc-event-main {
            font-weight: 500;
            font-size: 0.9rem;
            /* Tamaño más grande para desktop */
            padding: 2px;
            white-space: normal !important;
            /* Permitir salto de línea */
            overflow: hidden;
            display: flex;
            flex-direction: column;
            justify-content: center;
            line-height: 1.2;
            /* Líneas más juntas */
            height: 100%;
        }

        /* Indicador de hora actual */
        .fc-timegrid-now-indicator-line {
            border-color: var(--danger);
            border-width: 2px;
        }

        .fc-timegrid-now-indicator-arrow {
            border-color: var(--danger);
            border-width: 6px;
        }

        /* --- Tooltip Moderno --- */
        .tooltip {
            position: absolute;
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(8px);
            border: 1px solid rgba(255, 255, 255, 1);
            border-radius: 12px;
            padding: 16px;
            box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 8px 10px -6px rgba(0, 0, 0, 0.1);
            font-size: 0.9rem;
            z-index: 2000;
            display: none;
            pointer-events: none;
            color: var(--gray);
            min-width: 220px;
            animation: fadeIn 0.2s ease;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(5px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .tooltip strong {
            color: var(--primary);
            display: inline-block;
            width: 80px;
            font-weight: 600;
        }

        /* --- Modal (Formulario) --- */
        .modal-overlay {
            position: fixed;
            inset: 0;
            background: rgba(15, 23, 42, 0.6);
            backdrop-filter: blur(5px);
            z-index: 2000;
            display: none;
            justify-content: center;
            align-items: center;
            opacity: 0;
            transition: all 0.3s ease;
        }

        .modal-overlay.active {
            display: flex;
            opacity: 1;
        }

        .modal-card {
            background: white;
            width: 90%;
            max-width: 480px;
            border-radius: 20px;
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
            overflow: hidden;
            transform: scale(0.95) translateY(10px);
            transition: all 0.3s cubic-bezier(0.34, 1.56, 0.64, 1);
        }

        .modal-overlay.active .modal-card {
            transform: scale(1) translateY(0);
        }

        .modal-header {
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-light) 100%);
            color: white;
            padding: 20px 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .modal-header h3 {
            margin: 0;
            font-size: 1.3rem;
            font-weight: 600;
        }

        .btn-close {
            background: rgba(255, 255, 255, 0.2);
            border: none;
            width: 32px;
            height: 32px;
            border-radius: 50%;
            color: white;
            font-size: 1.2rem;
            cursor: pointer;
            transition: 0.2s;
            display: grid;
            place-items: center;
        }

        .btn-close:hover {
            background: rgba(255, 255, 255, 0.4);
            transform: rotate(90deg);
        }

        .modal-body {
            padding: 30px;
        }

        /* --- Formulario --- */
        .form-group {
            margin-bottom: 24px;
        }

        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: var(--dark);
            font-size: 0.9rem;
        }

        .form-control {
            width: 100%;
            padding: 12px 16px;
            border: 2px solid #e2e8f0;
            border-radius: 10px;
            font-family: inherit;
            font-size: 0.95rem;
            transition: all 0.2s;
            box-sizing: border-box;
            background-color: #f8fafc;
        }

        .form-control:focus {
            outline: none;
            border-color: var(--primary);
            background-color: white;
            box-shadow: 0 0 0 4px rgba(79, 70, 229, 0.1);
        }

        .btn-submit {
            width: 100%;
            padding: 14px;
            background-color: var(--dark);
            color: white;
            border: none;
            border-radius: 10px;
            font-size: 1rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.2s;
            margin-top: 10px;
            box-shadow: 0 4px 6px -1px rgba(15, 23, 42, 0.2);
        }

        .btn-submit:hover {
            background-color: #334155;
            transform: translateY(-2px);
            box-shadow: 0 10px 15px -3px rgba(15, 23, 42, 0.25);
        }

        /* Mensajes de Alerta */
        .mensaje {
            position: fixed;
            top: 100px;
            right: 20px;
            padding: 16px 24px;
            border-radius: 12px;
            color: white;
            font-weight: 600;
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
            z-index: 3000;
            display: none;
            backdrop-filter: blur(4px);
            animation: slideIn 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        }

        .mensaje.show {
            display: block;
        }

        .mensaje.exito {
            background-color: rgba(16, 185, 129, 0.95);
        }

        .mensaje.error {
            background-color: rgba(239, 68, 68, 0.95);
        }

        @keyframes slideIn {
            from {
                transform: translateX(100px);
                opacity: 0;
            }

            to {
                transform: translateX(0);
                opacity: 1;
            }
        }

        /* --- RESPONSIVE DESIGN --- */

        /* Tablets (landscape) */
        @media (max-width: 1024px) {
            main {
                max-width: 95%;
                padding: 20px;
                margin: 0 auto 30px;
            }

            .header-left h1 {
                font-size: 1.2rem;
            }

            .fc-toolbar-title {
                font-size: 1.4em !important;
            }
        }

        /* Tablets (portrait) and large phones */
        @media (max-width: 768px) {
            body {
                padding-top: 70px;
            }

            .header-content {
                height: 70px;
                padding: 0 3%;
            }

            .header-left {
                gap: 12px;
            }

            .header-left img {
                height: 40px;
            }

            .header-left h1 {
                font-size: 1rem;
            }

            .header-nav ul {
                gap: 15px;
            }

            .header-nav a {
                font-size: 0.85rem;
            }

            .btn-download {
                padding: 8px 16px;
                font-size: 0.85rem;
            }

            main {
                padding: 15px;
                border-radius: 16px;
            }

            .fc-toolbar-title {
                font-size: 1.2em !important;
            }

            .fc-button-primary {
                padding: 8px 16px !important;
                font-size: 0.85rem !important;
            }

            .fc-timegrid-slot {
                height: 5em !important;
            }

            .fc-event-main {
                font-size: 0.7rem;
            }

            .modal-card {
                max-width: 90%;
            }

            .modal-body {
                padding: 20px;
            }
        }

        /* Mobile devices */
        @media (max-width: 480px) {
            body {
                padding-top: 60px;
            }

            .header-content {
                height: 60px;
                padding: 0 2%;
                flex-wrap: wrap;
            }

            .header-left {
                gap: 8px;
            }

            .header-left img {
                height: 35px;
            }

            .header-left h1 {
                font-size: 0.9rem;
            }

            .header-nav ul {
                gap: 10px;
            }

            .header-nav a {
                font-size: 0.75rem;
                gap: 5px;
            }

            .header-nav a i {
                display: none;
                /* Ocultar iconos en móvil para ahorrar espacio */
            }

            .btn-download {
                padding: 6px 12px;
                font-size: 0.75rem;
            }

            main {
                padding: 10px;
                border-radius: 12px;
                margin: 0 auto 20px;
            }

            .fc-toolbar-title {
                font-size: 1em !important;
            }

            .fc-button-primary {
                padding: 6px 12px !important;
                font-size: 0.75rem !important;
                border-radius: 8px !important;
            }

            .fc-col-header-cell {
                padding: 10px 0;
            }

            .fc-col-header-cell-cushion {
                font-size: 0.7rem;
            }

            .fc-timegrid-slot {
                height: 4.5em !important;
            }

            .fc-timegrid-slot-label {
                font-size: 0.7rem;
            }

            .fc-event {
                padding: 1px 3px;
                border-radius: 4px;
            }

            .fc-event-main {
                font-size: 0.65rem;
                line-height: 1.1;
            }

            .modal-card {
                width: 95%;
                border-radius: 16px;
            }

            .modal-header {
                padding: 15px 20px;
            }

            .modal-header h3 {
                font-size: 1.1rem;
            }

            .modal-body {
                padding: 15px;
            }

            .form-group {
                margin-bottom: 18px;
            }

            .form-control {
                padding: 10px 12px;
                font-size: 0.9rem;
            }

            .btn-submit {
                padding: 12px;
                font-size: 0.95rem;
            }

            .mensaje {
                top: 70px;
                right: 10px;
                left: 10px;
                padding: 12px 16px;
                font-size: 0.85rem;
            }

            .tooltip {
                min-width: 180px;
                padding: 12px;
                font-size: 0.8rem;
            }
        }
    </style>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            var calendarEl = document.getElementById('calendar');
            var tooltip = document.createElement('div');
            tooltip.className = 'tooltip';
            document.body.appendChild(tooltip);

            // Funciones del Modal
            window.abrirModal = function () {
                var overlay = document.getElementById('modal-agenda');
                overlay.classList.add('active'); // Usar clase active para display flex
            };

            window.cerrarFormulario = function () {
                var overlay = document.getElementById('modal-agenda');
                overlay.classList.remove('active');
                setTimeout(() => {
                    // Limpiar formulario si es necesario
                }, 300);
            };

            // Cerrar modal al hacer clic fuera
            document.getElementById('modal-agenda').addEventListener('click', function (e) {
                if (e.target === this) window.cerrarFormulario();
            });

            var calendar = new FullCalendar.Calendar(calendarEl, {
                initialView: 'timeGridWeek',
                locale: 'es',
                slotDuration: '00:45:00',
                slotMinTime: '08:20:00',
                slotMaxTime: '16:45:00', // Un poco más de margen
                hiddenDays: [0, 6],
                allDaySlot: false,
                navLinks: false, // Desactivar click en día para evitar cambio de vista
                dayHeaderFormat: { weekday: 'long', day: 'numeric' }, // Formato cabecera más completo
                slotLabelFormat: {
                    hour: '2-digit', minute: '2-digit',
                    omitZeroMinute: false, meridiem: false
                },
                eventTimeFormat: {
                    hour: '2-digit', minute: '2-digit',
                    omitZeroMinute: false, meridiem: false
                },
                events: <?php echo json_encode($eventos); ?>,
                dateClick: function (info) {
                    var fecha = info.dateStr.split("T")[0];
                    var horaClic = info.dateStr.split("T")[1].substring(0, 8);

                    <?php if (!isAdmin()): ?>
                        // Validar que no sea una fecha/hora pasada (solo para no-admin)
                        var fechaHoraClick = new Date(info.dateStr);
                        var ahora = new Date();
                        if (fechaHoraClick < ahora) {
                            // Mostrar popup de error
                            var messageDiv = document.createElement('div');
                            messageDiv.className = 'mensaje error show';
                            messageDiv.textContent = 'No puedes agendar clases en fechas u horas pasadas.';
                            document.body.appendChild(messageDiv);
                            setTimeout(() => {
                                messageDiv.classList.remove('show');
                                setTimeout(() => messageDiv.remove(), 500);
                            }, 3000);
                            return; // Salir sin abrir el modal
                        }
                    <?php endif; ?>

                    // Lógica para obtener bloques (Simulada, mantener la tuya ajax si es compleja)
                    // Aquí llamamos a tu función original vía AJAX
                    var bloques = getAvailableBlocks(fecha);

                    var select = document.getElementById('bloque');
                    select.innerHTML = ''; // Limpiar

                    bloques.forEach(function (bloque) {
                        var option = document.createElement('option');
                        option.value = bloque[0] + ',' + bloque[1];
                        option.text = bloque[0].substring(0, 5) + ' - ' + bloque[1].substring(0, 5);
                        if (bloque[0] === horaClic) option.selected = true;
                        select.appendChild(option);
                    });

                    document.getElementById('fecha').value = fecha;
                    window.abrirModal();
                },
                eventClick: function (info) {
                    <?php if (isAdmin()): ?>
                        if (confirm("¿Desea eliminar la hora de " + info.event.extendedProps.usuario_nombre + "?")) {
                            document.getElementById('horario_id').value = info.event.id;
                            document.getElementById('form-eliminar').submit();
                        }
                    <?php endif; ?>
                },
                eventContent: function (arg) {
                    var props = arg.event.extendedProps;
                    var timeText = props.hora_inicio + ' - ' + props.hora_fin;

                    var container = document.createElement('div');
                    container.style.display = 'flex';
                    container.style.flexDirection = 'column';
                    container.style.gap = '2px';

                    var timeEl = document.createElement('div');
                    timeEl.innerHTML = '<b>' + timeText + '</b>';
                    timeEl.style.fontSize = '0.85em';

                    var userEl = document.createElement('div');
                    userEl.innerText = props.usuario_nombre;
                    userEl.style.fontWeight = '600';

                    var courseEl = document.createElement('div');
                    courseEl.innerText = props.curso_nombre;
                    courseEl.style.fontSize = '0.9em';
                    courseEl.style.opacity = '0.9';

                    container.appendChild(timeEl);
                    container.appendChild(userEl);
                    container.appendChild(courseEl);

                    return { domNodes: [container] };
                },
                eventMouseEnter: function (info) {
                    var props = info.event.extendedProps;
                    tooltip.innerHTML = `
                        <strong>Docente:</strong> ${props.usuario_nombre}<br>
                        <strong>Curso:</strong> ${props.curso_nombre}<br>
                        <strong>Hora:</strong> ${props.hora_inicio} - ${props.hora_fin}
                    `;
                    tooltip.style.display = 'block';
                    tooltip.style.left = (info.jsEvent.pageX + 15) + 'px';
                    tooltip.style.top = (info.jsEvent.pageY + 15) + 'px';
                },
                eventMouseLeave: function () {
                    tooltip.style.display = 'none';
                },
                height: 'auto',
                contentHeight: 'auto',
                headerToolbar: {
                    start: 'title',
                    center: '',
                    end: 'today prev,next' // Botones más limpios a la derecha
                },
                buttonText: {
                    today: 'Hoy',
                    month: 'Mes',
                    week: 'Semana',
                    day: 'Día',
                    list: 'Lista'
                }
            });
            calendar.render();

            // Mensajes Toast
            const params = new URLSearchParams(window.location.search);
            const message = params.get('message');
            const type = params.get('type');
            if (message && type) {
                const messageDiv = document.createElement('div');
                messageDiv.className = 'mensaje ' + type + ' show';
                messageDiv.textContent = decodeURIComponent(message);
                document.body.appendChild(messageDiv);
                setTimeout(() => {
                    messageDiv.classList.remove('show');
                    setTimeout(() => messageDiv.remove(), 500);
                }, 3000);
            }
        });

        // Tu función AJAX original (manteniendo la lógica)
        function getAvailableBlocks(date) {
            var bloques = <?php echo json_encode($bloques); ?>;
            var bloques_ocupados = [];
            var xhr = new XMLHttpRequest();
            xhr.open('GET', 'get_occupied_blocks.php?date=' + date, false); // Síncrono por simplicidad aquí
            xhr.send();
            if (xhr.status == 200) {
                try { bloques_ocupados = JSON.parse(xhr.responseText); } catch (e) { }
            }

            var bloques_disponibles = [];
            var bloques_todo = bloques["mañana"].concat(bloques["tarde"]);

            for (var i = 0; i < bloques_todo.length; i++) {
                var bloque = bloques_todo[i];
                var ocupado = false;
                for (var j = 0; j < bloques_ocupados.length; j++) {
                    if (bloque[0] == bloques_ocupados[j].hora_inicio && bloque[1] == bloques_ocupados[j].hora_fin) {
                        ocupado = true; break;
                    }
                }
                if (!ocupado) bloques_disponibles.push(bloque);
            }
            return bloques_disponibles;
        }
    </script>
</head>

<body>

    <div class="header-content">
        <div class="header-left">
            <img src="../images/INSIGNIA SF.png" alt="Escuela Porongo">
            <h1>Agendar Horas</h1>
        </div>
        <nav class="header-nav">
            <ul>
                <li><a href="../index.php"><i class="fas fa-home"></i> Inicio</a></li>
                <?php if (isAdmin()): ?>
                    <li><a href="export_schedule.php" class="btn-download"><i class="fas fa-file-excel"></i> Descargar
                            Excel</a></li>
                <?php endif; ?>
            </ul>
        </nav>
    </div>

    <div id="modal-agenda" class="modal-overlay">
        <div class="modal-card">
            <div class="modal-header">
                <h3><i class="fas fa-calendar-plus"></i> Nueva Clase</h3>
                <button class="btn-close" onclick="cerrarFormulario()">&times;</button>
            </div>
            <div class="modal-body">
                <form method="POST" action="">
                    <input type="hidden" name="fecha" id="fecha">

                    <div class="form-group">
                        <label for="bloque">Bloque Horario:</label>
                        <select name="bloque" id="bloque" class="form-control"></select>
                    </div>

                    <?php if (isAdmin()): ?>
                        <div class="form-group">
                            <label for="usuario_id">Docente:</label>
                            <select name="usuario_id" class="form-control" required>
                                <option value="" selected disabled>Seleccione...</option>
                                <?php foreach ($usuarios as $usuario): ?>
                                    <option value="<?= $usuario['id'] ?>">
                                        <?= $usuario['nombre'] . ' ' . $usuario['apellido_paterno'] . ' ' . $usuario['apellido_materno'] ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    <?php else: ?>
                        <input type="hidden" name="usuario_id" value="<?= $_SESSION['usuario_id'] ?>">
                    <?php endif; ?>

                    <div class="form-group">
                        <label for="curso_id">Asignatura / Curso:</label>
                        <select id="curso_id" name="curso_id" class="form-control" required>
                            <option value="" disabled selected>Seleccione...</option>
                            <?php
                            $cursos->data_seek(0);
                            while ($curso = $cursos->fetch_assoc()): ?>
                                <option value="<?php echo $curso['id']; ?>">
                                    <?php echo htmlspecialchars($curso['nombre'], ENT_QUOTES, 'UTF-8'); ?>
                                </option>
                            <?php endwhile; ?>
                            <?php if (isAdmin()): ?>
                                <option value="0">Reunión / Otro</option>
                            <?php endif; ?>
                        </select>
                    </div>

                    <button type="submit" class="btn-submit">Confirmar Agenda</button>
                </form>
            </div>
        </div>
    </div>

    <form id="form-eliminar" method="POST" style="display:none;">
        <input type="hidden" name="eliminar" value="1">
        <input type="hidden" name="horario_id" id="horario_id">
    </form>

    <main>
        <div id='calendar'></div>
    </main>

</body>

</html>