<?php
session_start();
include '../includes/db.php'; // Incluir la conexión a la base de datos
include '../includes/auth.php'; // Incluir autenticación
checkAuth(); // Verificar autenticación
require '../vendor/autoload.php'; // Asegúrate de incluir el autoloader de Composer
use PhpOffice\PhpSpreadsheet\IOFactory;

$message = '';
$message_type = '';

// Procesar el formulario
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_FILES['excel_equipo'])) {
    if ($_FILES['excel_equipo']['error'] === UPLOAD_ERR_OK) {
        $file = $_FILES['excel_equipo']['tmp_name'];
        $spreadsheet = IOFactory::load($file);
        $sheetData = $spreadsheet->getActiveSheet()->toArray(null, true, true, true);

        $conn->begin_transaction();
        
        try {
            // AÑADIDO: Omitir la primera fila (encabezado)
            $isHeader = true;
            foreach ($sheetData as $row) {
                if ($isHeader) {
                    $isHeader = false;
                    continue;
                }

                // Asegúrate de que tu Excel tenga el formato correcto
                list($nombre_equipo, $ubicacion, $estado_equipo_id, $marca, $modelo, $numero_serie, $procesador, $memoria_ram, $almacenamiento, $tarjeta_grafica, $sistema_operativo, $version_so, $programas_instalados, $observaciones, $fecha_ultimo_mantenimiento, $detalles_mantenimiento, $proxima_fecha_mantenimiento) = $row;

                // Validación básica: omitir filas vacías
                if (empty($nombre_equipo)) continue;

                // Insertar datos en la tabla equipo
                $sql_equipo = "INSERT INTO equipo (nombre_equipo, ubicacion, estado_equipo_id) VALUES (?, ?, ?)";
                $stmt_equipo = $conn->prepare($sql_equipo);
                $stmt_equipo->bind_param("ssi", $nombre_equipo, $ubicacion, $estado_equipo_id);
                $stmt_equipo->execute();
                $equipo_id = $stmt_equipo->insert_id; // Obtener el ID del equipo insertado

                // Insertar los detalles del equipo en la tabla detalles_equipo
                $sql_detalles = "INSERT INTO detalles_equipo (equipo_id, marca, modelo, numero_serie, procesador, memoria_ram, almacenamiento, tarjeta_grafica, sistema_operativo, version_so) 
                                 VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                $stmt_detalles = $conn->prepare($sql_detalles);
                $stmt_detalles->bind_param("isssssssss", $equipo_id, $marca, $modelo, $numero_serie, $procesador, $memoria_ram, $almacenamiento, $tarjeta_grafica, $sistema_operativo, $version_so);
                $stmt_detalles->execute();

                // Insertar los datos del mantenimiento en la tabla mantenimiento_equipo
                $sql_mantenimiento = "INSERT INTO mantenimiento_equipo (equipo_id, fecha_ultimo_mantenimiento, detalles_mantenimiento, proxima_fecha_mantenimiento, observaciones) 
                                      VALUES (?, ?, ?, ?, ?)";
                $stmt_mantenimiento = $conn->prepare($sql_mantenimiento);
                $stmt_mantenimiento->bind_param("issss", $equipo_id, $fecha_ultimo_mantenimiento, $detalles_mantenimiento, $proxima_fecha_mantenimiento, $observaciones);
                $stmt_mantenimiento->execute();
            }

            // Confirmar la transacción
            $conn->commit();
            $message = "Equipos cargados exitosamente.";
            $message_type = 'exito'; // MODIFICADO
        } catch (Exception $e) {
            // Revertir la transacción en caso de error
            $conn->rollback();
            $message = "Error: " . $e->getMessage();
            $message_type = 'error';
        }
    } else {
        $message = "Error al subir el archivo.";
        $message_type = 'error';
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="../images/logo.png">
    <title>Cargar Equipos desde Excel</title>

    <link rel="stylesheet" href="../css/admin.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    
    <style>
        .form-group input[type="file"] {
            width: 100%;
            padding: 0.65rem; 
            border: 1px solid var(--grey-medium);
            border-radius: var(--border-radius);
            font-size: 0.9rem;
            background-color: #fff;
            transition: var(--transition-speed);
        }
        .form-group input[type="file"]:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 5px rgba(52, 152, 219, 0.5);
            outline: none;
        }
        .form-group input[type="file"]::file-selector-button {
            background-color: var(--grey-dark);
            color: var(--light-color);
            border: none;
            padding: 0.5rem 1rem;
            border-radius: var(--border-radius);
            cursor: pointer;
            margin-right: 1rem;
            transition: var(--transition-speed);
        }
        .form-group input[type="file"]::file-selector-button:hover {
            background-color: var(--dark-color);
        }
    </style>
</head>
<body>
    
<header>
    <div class="header-content">
        <img src="../images/INSIGNIA SF.png" alt="Escuela Porongo Insignia">
        <h1>Cargar Equipos (Excel)</h1>
        <nav>
            <ul>
                <li><a href="../index.php"><i class="fas fa-home"></i> Inicio</a></li>
                <li><a href="equipos.php"><i class="fas fa-arrow-left"></i> Volver</a></li>
            </ul>
        </nav>
    </div>
</header>
    
<main class="container">
    
    <?php if ($message): ?>
        <div class="mensaje <?php echo htmlspecialchars($message_type, ENT_QUOTES, 'UTF-8'); ?> show">
            <?php echo htmlspecialchars($message, ENT_QUOTES, 'UTF-8'); ?>
        </div>
    <?php endif; ?>

    <div class="card form-container">
        <h2><i class="fas fa-file-excel"></i> Cargar Equipos desde Excel</h2>
        <p style="margin-bottom: 1.5rem; color: var(--grey-dark);">
            Seleccione un archivo .xlsx o .xls con los datos de los equipos. <br>
            Asegúrese de que las columnas estén en el orden correcto y que la primera fila sea el encabezado (será omitida).
        </p>

        <form action="" method="POST" enctype="multipart/form-data">
            <div class="form-group">
                <label for="excel_equipo"><i class="fas fa-upload"></i> Seleccionar archivo Excel:</label>
                <input type="file" id="excel_equipo" name="excel_equipo" accept=".xlsx, .xls" required>
            </div>
            
            <div class="form-buttons">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-check-circle"></i> Cargar Equipos
                </button>
            </div>
        </form>
    </div>
</main>
    
<script>
window.onload = function() {
    const message = document.querySelector('.mensaje');
    if (message) {
        setTimeout(() => {
            message.classList.remove('show');
        }, 3000); // 3 segundos
    }
};
</script>
    
</body>
</html>

<?php
$conn->close();
?>