<?php
// AÑADIDO: session_start() al inicio
session_start();
include '../includes/db.php';
include '../includes/auth.php';
checkAuth();

// Obtener el ID del equipo a visualizar
$id = intval($_GET['id']);

if ($id <= 0) {
    die("ID de equipo inválido.");
}

// Obtener los datos básicos del equipo
$stmt = $conn->prepare("SELECT * FROM equipo WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$equipo = $result->fetch_assoc();
$stmt->close();

if (!$equipo) {
    // MODIFICADO: Redirección más amigable
    $_SESSION['mensaje'] = "Equipo no encontrado.";
    $_SESSION['mensaje_tipo'] = "error";
    header("Location: crud_equipos.php");
    exit;
}

// Obtener los detalles del equipo
$stmt = $conn->prepare("SELECT * FROM detalles_equipo WHERE equipo_id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$detalles = $stmt->get_result()->fetch_assoc();
$stmt->close();

// Obtener el mantenimiento del equipo
$stmt = $conn->prepare("SELECT * FROM mantenimiento_equipo WHERE equipo_id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$mantenimiento = $stmt->get_result()->fetch_assoc();
$stmt->close();

// Obtener el software instalado en el equipo
$stmt = $conn->prepare("SELECT * FROM software_instalado WHERE equipo_id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$software = $stmt->get_result()->fetch_assoc();
$stmt->close();

// Obtener el estado del equipo
$stmt = $conn->prepare("SELECT nombre_estado FROM estado_equipo WHERE id = ?");
$stmt->bind_param("i", $equipo['estado_equipo_id']);
$stmt->execute();
$estado_equipo = $stmt->get_result()->fetch_assoc();
$stmt->close();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="../images/logo.png">
    <title>Detalles del Equipo</title>
    
    <link rel="stylesheet" href="../css/admin.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    
    <style>
        .details-grid {
            display: grid;
            /* Columna de imagen (fija) y columna de especificaciones (flexible) */
            grid-template-columns: 300px 1fr;
            gap: 2rem;
            margin-top: 1.5rem;
        }
        .equipo-imagen img {
            width: 100%;
            height: auto;
            border-radius: var(--border-radius);
            border: 1px solid var(--grey-medium);
        }
        .no-imagen {
            width: 100%;
            height: 200px;
            display: flex;
            align-items: center;
            justify-content: center;
            background-color: var(--grey-light);
            color: var(--grey-dark);
            border-radius: var(--border-radius);
            border: 1px dashed var(--grey-medium);
        }

        /* Lista de especificaciones (reemplaza la tabla) */
        .spec-list {
            list-style: none;
            padding: 0;
            margin: 0;
        }
        .spec-list li {
            display: flex;
            justify-content: space-between;
            padding: 0.8rem 0;
            border-bottom: 1px solid var(--grey-light);
            gap: 1rem;
        }
        .spec-list li strong {
            color: var(--dark-color);
            flex-shrink: 0; /* Evita que el label se encoja */
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
        }
        .spec-list li span {
            color: var(--grey-dark);
            text-align: right;
            white-space: pre-wrap; /* Mantiene saltos de línea */
            word-break: break-word; /* Evita desbordamiento */
        }
        .spec-list li:last-child {
            border-bottom: none;
        }
        
        /* Subtítulos para secciones de la lista */
        .spec-list-header {
            font-size: 1.2rem;
            font-weight: 700;
            color: var(--primary-color);
            margin-top: 1.5rem;
            margin-bottom: 0.5rem;
            border-bottom: 2px solid var(--grey-light);
            padding-bottom: 0.5rem;
        }

        /* Responsividad */
        @media (max-width: 900px) {
            .details-grid {
                grid-template-columns: 1fr; /* Apilar en pantallas pequeñas */
            }
            .equipo-imagen img, .no-imagen {
                max-width: 400px; /* Limitar tamaño de imagen en móvil */
                margin: 0 auto;
            }
            .spec-list li {
                flex-direction: column;
                align-items: flex-start;
                gap: 0.25rem;
            }
            .spec-list li span {
                text-align: left;
                padding-left: 1.75rem; /* Indentación para la respuesta */
            }
        }
    </style>
</head>
<body>
    
<header>
    <div class="header-content">
        <img src="../images/INSIGNIA SF.png" alt="Escuela Porongo Insignia">
        <h1>Detalles del Equipo</h1>
        <nav>
            <ul>
                <li><a href="../index.php"><i class="fas fa-home"></i> Inicio</a></li>
                <li><a href="crud_equipos.php"><i class="fas fa-arrow-left"></i> Volver a la lista</a></li>
            </ul>
        </nav>
    </div>
</header>
    
<main class="container">
    <div class="card">
        <h2>
            <i class="fas fa-laptop-house"></i> 
            <?php echo htmlspecialchars($equipo['nombre_equipo'], ENT_QUOTES, 'UTF-8'); ?>
        </h2>

        <div class="details-grid">
            
            <div class="equipo-imagen">
                <?php if (!empty($detalles['imagen'])): ?>
                    <img src="<?php echo htmlspecialchars($detalles['imagen'], ENT_QUOTES, 'UTF-8'); ?>" alt="Imagen del Equipo">
                <?php else: ?>
                    <div class="no-imagen"><i class="fas fa-camera" style="margin-right: 10px;"></i> No hay imagen</div>
                <?php endif; ?>
            </div>

            <div class="equipo-specs">
                
                <h3 class="spec-list-header">Especificaciones</h3>
                <ul class="spec-list">
                    <li><strong><i class="fas fa-map-marker-alt"></i> Ubicación:</strong> <span><?php echo htmlspecialchars($equipo['ubicacion'] ?? 'N/A', ENT_QUOTES, 'UTF-8'); ?></span></li>
                    <li><strong><i class="fas fa-copyright"></i> Marca:</strong> <span><?php echo htmlspecialchars($detalles['marca'] ?? 'N/A', ENT_QUOTES, 'UTF-8'); ?></span></li>
                    <li><strong><i class="fas fa-laptop"></i> Modelo:</strong> <span><?php echo htmlspecialchars($detalles['modelo'] ?? 'N/A', ENT_QUOTES, 'UTF-8'); ?></span></li>
                    <li><strong><i class="fas fa-barcode"></i> N° Serie:</strong> <span><?php echo htmlspecialchars($detalles['numero_serie'] ?? 'N/A', ENT_QUOTES, 'UTF-8'); ?></span></li>
                    <li><strong><i class="fas fa-toggle-on"></i> Estado:</strong> <span><?php echo htmlspecialchars($estado_equipo['nombre_estado'] ?? 'N/A', ENT_QUOTES, 'UTF-8'); ?></span></li>
                </ul>

                <h3 class="spec-list-header">Hardware y Software</h3>
                <ul class="spec-list">
                    <li><strong><i class="fas fa-microchip"></i> Procesador:</strong> <span><?php echo htmlspecialchars($detalles['procesador'] ?? 'N/A', ENT_QUOTES, 'UTF-8'); ?></span></li>
                    <li><strong><i class="fas fa-memory"></i> Memoria RAM:</strong> <span><?php echo htmlspecialchars($detalles['memoria_ram'] ?? 'N/A', ENT_QUOTES, 'UTF-8'); ?></span></li>
                    <li><strong><i class="fas fa-hdd"></i> Almacenamiento:</strong> <span><?php echo htmlspecialchars($detalles['almacenamiento'] ?? 'N/A', ENT_QUOTES, 'UTF-8'); ?></span></li>
                    <li><strong><i class="fas fa-gamepad"></i> T. Gráfica:</strong> <span><?php echo htmlspecialchars($detalles['tarjeta_grafica'] ?? 'N/A', ENT_QUOTES, 'UTF-8'); ?></span></li>
                    <li><strong><i class="fab fa-windows"></i> S. Operativo:</strong> <span><?php echo htmlspecialchars($detalles['sistema_operativo'] ?? 'N/A', ENT_QUOTES, 'UTF-8'); ?></span></li>
                    <li><strong><i class="fas fa-code-branch"></i> Versión SO:</strong> <span><?php echo htmlspecialchars($detalles['version_so'] ?? 'N/A', ENT_QUOTES, 'UTF-8'); ?></span></li>
                    <li><strong><i class="fas fa-cogs"></i> Programas:</strong> <span><?php echo nl2br(htmlspecialchars($software['programas_instalados'] ?? 'N/A', ENT_QUOTES, 'UTF-8')); ?></span></li>
                </ul>
                
                <h3 class="spec-list-header">Mantenimiento</h3>
                <ul class="spec-list">
                    <li><strong><i class="fas fa-calendar-alt"></i> Último Mantenimiento:</strong> <span><?php echo htmlspecialchars($mantenimiento['fecha_ultimo_mantenimiento'] ?? 'No registrado', ENT_QUOTES, 'UTF-8'); ?></span></li>
                    <li><strong><i class="fas fa-calendar-check"></i> Próximo Mantenimiento:</strong> <span><?php echo htmlspecialchars($mantenimiento['proxima_fecha_mantenimiento'] ?? 'No programado', ENT_QUOTES, 'UTF-8'); ?></span></li>
                    <li><strong><i class="fas fa-tools"></i> Detalles Mantenimiento:</strong> <span><?php echo nl2br(htmlspecialchars($mantenimiento['detalles_mantenimiento'] ?? 'N/A', ENT_QUOTES, 'UTF-8')); ?></span></li>
                    <li><strong><i class="fas fa-file-alt"></i> Observaciones:</strong> <span><?php echo nl2br(htmlspecialchars($mantenimiento['observaciones'] ?? 'Ninguna', ENT_QUOTES, 'UTF-8')); ?></span></li>
                </ul>
                
            </div>
        </div>
    </div>
</main>
</body>
</html>