<?php
session_start();  
include '../includes/db.php'; 
include '../includes/auth.php'; 
checkAuth(); 

$usuario_id = $_SESSION['usuario_id'];
$message = ''; 
$message_type = ''; 

// Obtener estados
$stmt_estados = $conn->prepare("SELECT id, nombre_estado FROM estado_equipo");
$stmt_estados->execute();
$result_estados = $stmt_estados->get_result();
$estados = [];
while ($row = $result_estados->fetch_assoc()) {
    $estados[] = $row;
}

$stmt_equipo = null;
$stmt_detalles = null;
$stmt_mantenimiento = null;
$stmt_software = null;

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // ... (Tu lógica de POST para obtener variables es correcta) ...
    $tipo_equipo = $_POST['tipo_equipo'];
    $nombre_equipo = trim($_POST['nombre_equipo']);
    $ubicacion = trim($_POST['ubicacion']);
    $estado_equipo_id = $_POST['estado_equipo_id'] ?? null;
    $marca = trim($_POST['marca']);
    $modelo = trim($_POST['modelo']);
    $numero_serie = trim($_POST['numero_serie']);
    $procesador = $tipo_equipo === 'PC' ? trim($_POST['procesador']) : null;
    $memoria_ram = $tipo_equipo === 'PC' ? trim($_POST['memoria_ram']) : null;
    $almacenamiento = $tipo_equipo === 'PC' ? trim($_POST['almacenamiento']) : null;
    $tarjeta_grafica = $tipo_equipo === 'PC' ? trim($_POST['tarjeta_grafica']) : null;
    $sistema_operativo = $tipo_equipo === 'PC' ? trim($_POST['sistema_operativo']) : null;
    $version_so = $tipo_equipo === 'PC' ? trim($_POST['version_so']) : null;
    $programas_instalados = $tipo_equipo === 'PC' ? trim($_POST['programas_instalados']) : null;
    $fecha_ultimo_mantenimiento = trim($_POST['fecha_ultimo_mantenimiento']);
    $detalles_mantenimiento = trim($_POST['detalles_mantenimiento']);
    $proxima_fecha_mantenimiento = trim($_POST['proxima_fecha_mantenimiento']);
    $observaciones = trim($_POST['observaciones']);

    // ... (Tu lógica de subida de imagen es correcta) ...
    $ruta_imagen_final = null;
    if (isset($_FILES['imagen_equipo']) && $_FILES['imagen_equipo']['error'] === UPLOAD_ERR_OK) {
        $imagen_equipo = $_FILES['imagen_equipo'];
        $nombre_imagen_unico = uniqid('', true) . "." . pathinfo($imagen_equipo['name'], PATHINFO_EXTENSION);
        $directorio_destino = '../uploads/equipos/';
        if (!file_exists($directorio_destino)) {
            mkdir($directorio_destino, 0777, true); // Asegurarse de que el directorio exista
        }
        if (move_uploaded_file($imagen_equipo['tmp_name'], $directorio_destino . $nombre_imagen_unico)) {
            $ruta_imagen_final = $directorio_destino . $nombre_imagen_unico;
        }
    }

    $conn->begin_transaction();
    try {
        $sql_equipo = "INSERT INTO equipo (nombre_equipo, ubicacion, estado_equipo_id) VALUES (?, ?, ?)";
        $stmt_equipo = $conn->prepare($sql_equipo);
        $stmt_equipo->bind_param("ssi", $nombre_equipo, $ubicacion, $estado_equipo_id);
        if ($stmt_equipo->execute()) {
            $equipo_id = $stmt_equipo->insert_id;
            
            $sql_detalles = "INSERT INTO detalles_equipo (equipo_id, marca, modelo, numero_serie, procesador, memoria_ram, almacenamiento, tarjeta_grafica, sistema_operativo, version_so, imagen) 
                             VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            $stmt_detalles = $conn->prepare($sql_detalles);
            $stmt_detalles->bind_param("issssssssss", $equipo_id, $marca, $modelo, $numero_serie, $procesador, $memoria_ram, $almacenamiento, $tarjeta_grafica, $sistema_operativo, $version_so, $ruta_imagen_final);
            if (!$stmt_detalles->execute()) throw new Exception("Error detalles: ".$stmt_detalles->error);

            $sql_mantenimiento = "INSERT INTO mantenimiento_equipo (equipo_id, fecha_ultimo_mantenimiento, detalles_mantenimiento, proxima_fecha_mantenimiento, observaciones) 
                                  VALUES (?, ?, ?, ?, ?)";
            $stmt_mantenimiento = $conn->prepare($sql_mantenimiento);
            $stmt_mantenimiento->bind_param("issss", $equipo_id, $fecha_ultimo_mantenimiento, $detalles_mantenimiento, $proxima_fecha_mantenimiento, $observaciones);
            if (!$stmt_mantenimiento->execute()) throw new Exception("Error mantenimiento: ".$stmt_mantenimiento->error);

            if ($tipo_equipo === 'PC') {
                $sql_software = "INSERT INTO software_instalado (equipo_id, programas_instalados) VALUES (?, ?)";
                $stmt_software = $conn->prepare($sql_software);
                $stmt_software->bind_param("is", $equipo_id, $programas_instalados);
                if (!$stmt_software->execute()) throw new Exception("Error software: ".$stmt_software->error);
            }
            $conn->commit();
            $message = "Equipo guardado exitosamente.";
            $message_type = 'exito'; // MODIFICADO: 'exito'
        } else {
            throw new Exception("Error al guardar equipo: ".$stmt_equipo->error);
        }
    } catch (Exception $e) {
        $conn->rollback();
        $message = $e->getMessage();
        $message_type = 'error';
    }

    if ($stmt_equipo) $stmt_equipo->close();
    if ($stmt_detalles) $stmt_detalles->close();
    if ($stmt_mantenimiento) $stmt_mantenimiento->close();
    if ($stmt_software) $stmt_software->close();
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="icon" type="image/png" href="../images/logo.png">
<title>Registro de Equipos</title>

<link rel="stylesheet" href="../css/admin.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">

<style>
    /* Usar .form-grid de admin.css pero con más columnas */
    .equipo-form-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 1.5rem;
    }
    .full-width {
        grid-column: 1 / -1; /* Span full width */
    }
    .pc-field {
        display: none; /* Oculto por defecto */
    }
    
    /* Estilo para el input[file] (de /admin/respaldos/datos.php) */
    input[type="file"] {
        width: 100%;
        padding: 0.65rem; 
        border: 1px solid var(--grey-medium);
        border-radius: var(--border-radius);
        font-size: 0.9rem;
        background-color: #fff;
    }
    input[type="file"]::file-selector-button {
        background-color: var(--grey-dark);
        color: var(--light-color);
        border: none;
        padding: 0.5rem 1rem;
        border-radius: var(--border-radius);
        cursor: pointer;
        margin-right: 1rem;
    }
</style>

</head>
<body>

<header>
    <div class="header-content">
        <img src="../images/INSIGNIA SF.png" alt="Escuela Porongo Insignia">
        <h1>Registro de Equipos</h1>
        <nav>
            <ul>
                <li><a href="../index.php"><i class="fas fa-home"></i> Inicio</a></li>
                <li><a href="crud_equipos.php"><i class="fas fa-list"></i> Ver Equipos</a></li>
            </ul>
        </nav>
    </div>
</header>

<main class="container">

    <?php if ($message): ?>
        <div class="mensaje <?php echo $message_type; ?> show">
            <?php echo htmlspecialchars($message, ENT_QUOTES, 'UTF-8'); ?>
        </div>
    <?php endif; ?>

    <div class="card form-container">
        <h2><i class="fas fa-laptop-medical"></i> Registrar Nuevo Equipo</h2>
        
        <form method="POST" enctype="multipart/form-data">
            <div class="equipo-form-grid">
                
                <div class="form-group">
                    <label for="tipo_equipo"><i class="fas fa-desktop"></i> Tipo de Equipo:</label>
                    <select id="tipo_equipo" name="tipo_equipo" onchange="togglePCFields()" required>
                        <option value="">Seleccionar</option>
                        <option value="PC">PC</option>
                        <option value="Otro">Otro</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="nombre_equipo"><i class="fas fa-tag"></i> Nombre del Equipo:</label>
                    <input type="text" id="nombre_equipo" name="nombre_equipo" required>
                </div>
                <div class="form-group">
                    <label for="ubicacion"><i class="fas fa-map-marker-alt"></i> Ubicación:</label>
                    <input type="text" id="ubicacion" name="ubicacion" required>
                </div>
                <div class="form-group">
                    <label for="marca"><i class="fas fa-copyright"></i> Marca:</label>
                    <input type="text" id="marca" name="marca">
                </div>
                <div class="form-group">
                    <label for="modelo"><i class="fas fa-laptop"></i> Modelo:</label>
                    <input type="text" id="modelo" name="modelo">
                </div>
                <div class="form-group">
                    <label for="numero_serie"><i class="fas fa-barcode"></i> Número de Serie:</label>
                    <input type="text" id="numero_serie" name="numero_serie">
                </div>

                <div class="form-group pc-field">
                    <label for="procesador"><i class="fas fa-microchip"></i> Procesador:</label>
                    <input type="text" id="procesador" name="procesador">
                </div>
                <div class="form-group pc-field">
                    <label for="memoria_ram"><i class="fas fa-memory"></i> Memoria RAM:</label>
                    <input type="text" id="memoria_ram" name="memoria_ram">
                </div>
                <div class="form-group pc-field">
                    <label for="almacenamiento"><i class="fas fa-hdd"></i> Almacenamiento:</label>
                    <input type="text" id="almacenamiento" name="almacenamiento">
                </div>
                <div class="form-group pc-field">
                    <label for="tarjeta_grafica"><i class="fas fa-gamepad"></i> Tarjeta Gráfica:</label>
                    <input type="text" id="tarjeta_grafica" name="tarjeta_grafica">
                </div>
                <div class="form-group pc-field">
                    <label for="sistema_operativo"><i class="fab fa-windows"></i> Sistema Operativo:</label>
                    <input type="text" id="sistema_operativo" name="sistema_operativo">
                </div>
                <div class="form-group pc-field">
                    <label for="version_so"><i class="fas fa-code-branch"></i> Versión SO:</label>
                    <input type="text" id="version_so" name="version_so">
                </div>
                <div class="form-group pc-field full-width">
                    <label for="programas_instalados"><i class="fas fa-cogs"></i> Programas Instalados:</label>
                    <textarea id="programas_instalados" name="programas_instalados"></textarea>
                </div>

                <div class="form-group">
                    <label for="estado_equipo_id"><i class="fas fa-toggle-on"></i> Estado:</label>
                    <select id="estado_equipo_id" name="estado_equipo_id" required>
                        <option value="">Seleccione un estado</option>
                        <?php foreach($estados as $estado): ?>
                        <option value="<?php echo $estado['id']; ?>"><?php echo $estado['nombre_estado']; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="form-group full-width">
                    <label for="observaciones"><i class="fas fa-file-alt"></i> Observaciones:</label>
                    <textarea id="observaciones" name="observaciones"></textarea>
                </div>
                <div class="form-group">
                    <label for="fecha_ultimo_mantenimiento"><i class="fas fa-calendar-alt"></i> Fecha Último Mantenimiento:</label>
                    <input type="date" id="fecha_ultimo_mantenimiento" name="fecha_ultimo_mantenimiento">
                </div>
                <div class="form-group">
                    <label for="proxima_fecha_mantenimiento"><i class="fas fa-calendar-check"></i> Próxima Fecha Mantenimiento:</label>
                    <input type="date" id="proxima_fecha_mantenimiento" name="proxima_fecha_mantenimiento">
                </div>
                <div class="form-group full-width">
                    <label for="detalles_mantenimiento"><i class="fas fa-tools"></i> Detalles del Mantenimiento:</label>
                    <textarea id="detalles_mantenimiento" name="detalles_mantenimiento"></textarea>
                </div>
                <div class="form-group full-width">
                    <label for="imagen_equipo"><i class="fas fa-image"></i> Imagen:</label>
                    <input type="file" id="imagen_equipo" name="imagen_equipo" accept="image/*">
                </div>
            </div> <div class="form-buttons">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Guardar Equipo
                </button>
            </div>
        </form>
    </div> </main>

<script>
    function togglePCFields() {
        const tipo = document.getElementById('tipo_equipo').value;
        // Selecciona todos los .form-group que también son .pc-field
        document.querySelectorAll('.form-group.pc-field').forEach(f => {
            f.style.display = tipo === 'PC' ? 'block' : 'none';
        });
    }

    window.onload = function() {
        // Ocultar mensaje de alerta después de 3 segundos
        const message = document.querySelector('.mensaje');
        if (message) {
            setTimeout(() => {
                message.classList.remove('show');
            }, 3000);
        }
        
        // Ejecutar el toggle al cargar la página
        togglePCFields();
    }
</script>
</body>
</html>