<?php
// AÑADIDO: session_start() al inicio
session_start();
include '../includes/db.php';
include '../includes/auth.php';
checkAuth();

$id = intval($_GET['id']);
$message = ''; // Variable para almacenar el mensaje
$message_type = ''; // Variable para el tipo de mensaje (success o error)

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // ... (Obtención de variables POST es correcta) ...
    $nombre_equipo = $_POST['nombre_equipo'];
    $ubicacion = $_POST['ubicacion'];
    $marca = $_POST['marca'];
    $modelo = $_POST['modelo'];
    $numero_serie = $_POST['numero_serie'];
    $procesador = $_POST['procesador'];
    $memoria_ram = $_POST['memoria_ram'];
    $almacenamiento = $_POST['almacenamiento'];
    $tarjeta_grafica = $_POST['tarjeta_grafica'];
    $sistema_operativo = $_POST['sistema_operativo'];
    $version_so = $_POST['version_so'];
    $programas_instalados = $_POST['programas_instalados'];
    $estado_equipo_id = intval($_POST['estado_equipo_id']);
    $observaciones = $_POST['observaciones'];
    $fecha_ultimo_mantenimiento = $_POST['fecha_ultimo_mantenimiento'];
    $detalles_mantenimiento = $_POST['detalles_mantenimiento'];
    $proxima_fecha_mantenimiento = $_POST['proxima_fecha_mantenimiento'];

    // ... (Lógica de subida de imagen es correcta) ...
    $ruta_imagen_final = null;
    $stmt_img = $conn->prepare("SELECT imagen FROM detalles_equipo WHERE equipo_id = ?");
    $stmt_img->bind_param("i", $id);
    $stmt_img->execute();
    $detalles_img = $stmt_img->get_result()->fetch_assoc();
    $stmt_img->close();
    $ruta_imagen_final = $detalles_img['imagen'] ?? null; // Mantener la imagen existente por defecto

    if (isset($_FILES['imagen']) && $_FILES['imagen']['error'] === UPLOAD_ERR_OK) {
        $imagen = $_FILES['imagen'];
        $nombre_imagen_unico = uniqid('', true) . "." . pathinfo($imagen['name'], PATHINFO_EXTENSION);
        $directorio_destino = '../uploads/equipos/';
        
        if (!file_exists($directorio_destino)) {
            mkdir($directorio_destino, 0777, true);
        }

        if (move_uploaded_file($imagen['tmp_name'], $directorio_destino . $nombre_imagen_unico)) {
            // Si la subida es exitosa, actualizar la ruta
            $ruta_imagen_final = $directorio_destino . $nombre_imagen_unico;
            
            // Eliminar la imagen anterior si existía y es diferente de la nueva
            if (!empty($detalles_img['imagen']) && file_exists($detalles_img['imagen']) && $detalles_img['imagen'] != $ruta_imagen_final) {
                unlink($detalles_img['imagen']);
            }
        }
    }

    // *** INICIO BLOQUE PHP CORREGIDO ***
    $conn->begin_transaction();
    try {
        // 1. Actualizar la tabla equipo
        $sql_equipo = "UPDATE equipo SET nombre_equipo = ?, ubicacion = ?, estado_equipo_id = ? WHERE id = ?";
        $stmt_equipo = $conn->prepare($sql_equipo);
        $stmt_equipo->bind_param("ssii", $nombre_equipo, $ubicacion, $estado_equipo_id, $id);
        if (!$stmt_equipo->execute()) throw new Exception("Error en tabla 'equipo': " . $stmt_equipo->error);
        $stmt_equipo->close();

        // 2. Actualizar la tabla detalles_equipo
        $sql_detalles = "UPDATE detalles_equipo SET marca = ?, modelo = ?, numero_serie = ?, procesador = ?, memoria_ram = ?, almacenamiento = ?, tarjeta_grafica = ?, sistema_operativo = ?, version_so = ?, imagen = ? WHERE equipo_id = ?";
        $stmt_detalles = $conn->prepare($sql_detalles);
        $stmt_detalles->bind_param("ssssssssssi", $marca, $modelo, $numero_serie, $procesador, $memoria_ram, $almacenamiento, $tarjeta_grafica, $sistema_operativo, $version_so, $ruta_imagen_final, $id);
        if (!$stmt_detalles->execute()) throw new Exception("Error en tabla 'detalles_equipo': " . $stmt_detalles->error);
        $stmt_detalles->close();

        // 3. Actualizar la tabla mantenimiento_equipo
        $sql_mantenimiento = "UPDATE mantenimiento_equipo SET fecha_ultimo_mantenimiento = ?, detalles_mantenimiento = ?, proxima_fecha_mantenimiento = ?, observaciones = ? WHERE equipo_id = ?";
        $stmt_mantenimiento = $conn->prepare($sql_mantenimiento);
        $stmt_mantenimiento->bind_param("ssssi", $fecha_ultimo_mantenimiento, $detalles_mantenimiento, $proxima_fecha_mantenimiento, $observaciones, $id);
        if (!$stmt_mantenimiento->execute()) throw new Exception("Error en tabla 'mantenimiento_equipo': " . $stmt_mantenimiento->error);
        $stmt_mantenimiento->close();

        // 4. Actualizar la tabla software_instalado
        $sql_software = "UPDATE software_instalado SET programas_instalados = ? WHERE equipo_id = ?";
        $stmt_software = $conn->prepare($sql_software);
        $stmt_software->bind_param("si", $programas_instalados, $id);
        if (!$stmt_software->execute()) throw new Exception("Error en tabla 'software_instalado': " . $stmt_software->error);
        $stmt_software->close();

        // Si todo fue bien
        $conn->commit();
        $message = "Equipo actualizado exitosamente.";
        $message_type = "exito"; // MODIFICADO
    } catch (Exception $e) {
        $conn->rollback();
        $message = "Error al actualizar el equipo: " . $e->getMessage();
        $message_type = "error";
    }
    // *** FIN BLOQUE PHP CORREGIDO ***
}

// Obtener los datos (la lógica de carga de datos es correcta)
$stmt = $conn->prepare("SELECT * FROM equipo WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$equipo = $result->fetch_assoc();
$stmt->close();

if (!$equipo) {
    $_SESSION['message'] = "Equipo no encontrado.";
    $_SESSION['message_type'] = "error";
    header("Location: crud_equipos.php");
    exit;
}

$stmt = $conn->prepare("SELECT * FROM detalles_equipo WHERE equipo_id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$detalles = $result->fetch_assoc();
$stmt->close();

$stmt = $conn->prepare("SELECT * FROM mantenimiento_equipo WHERE equipo_id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$mantenimiento = $result->fetch_assoc();
$stmt->close();

$stmt = $conn->prepare("SELECT * FROM software_instalado WHERE equipo_id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$software = $result->fetch_assoc();
$stmt->close();

$estados_result = $conn->query("SELECT * FROM estado_equipo");
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="../images/logo.png">
    <title>Editar Equipo</title>

    <link rel="stylesheet" href="../css/admin.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    
    <style>
        .equipo-form-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 1.5rem;
        }
        .full-width {
            grid-column: 1 / -1;
        }
        
        /* Estilo para el input[file] */
        input[type="file"] {
            width: 100%;
            padding: 0.65rem; 
            border: 1px solid var(--grey-medium);
            border-radius: var(--border-radius);
            font-size: 0.9rem;
            background-color: #fff;
        }
        input[type="file"]::file-selector-button {
            background-color: var(--grey-dark);
            color: var(--light-color);
            border: none;
            padding: 0.5rem 1rem;
            border-radius: var(--border-radius);
            cursor: pointer;
            margin-right: 1rem;
        }

        /* Estilo para la imagen de previsualización */
        .img-preview {
            max-width: 200px;
            height: auto;
            margin-top: 10px;
            border-radius: var(--border-radius);
            border: 1px solid var(--grey-medium);
        }
        
        /* Estilo para validación de error */
        input.error, select.error, textarea.error {
            border-color: var(--danger-color);
            box-shadow: 0 0 5px rgba(231, 76, 60, 0.5);
        }
    </style>
</head>
<body>
    
<header>
    <div class="header-content">
        <img src="../images/INSIGNIA SF.png" alt="Escuela Porongo Insignia">
        <h1>Editar Equipo</h1>
        <nav>
            <ul>
                <li><a href="../index.php"><i class="fas fa-home"></i> Inicio</a></li>
                <li><a href="crud_equipos.php"><i class="fas fa-arrow-left"></i> Volver a la Lista</a></li>
            </ul>
        </nav>
    </div>
</header>
    
<main class="container">

    <div class="mensaje" id="mensaje-box" style="display: none;"></div>
    
    <div class="card form-container">
        <h2><i class="fas fa-edit"></i> Formulario de Edición</h2>
        
        <form action="editar_equipo.php?id=<?php echo htmlspecialchars($id, ENT_QUOTES, 'UTF-8'); ?>" method="POST" enctype="multipart/form-data">
            
            <div class="equipo-form-grid">
                <div class="form-group">
                    <label for="nombre_equipo"><i class="fas fa-tag"></i> Nombre del Equipo:</label>
                    <input type="text" id="nombre_equipo" name="nombre_equipo" value="<?php echo htmlspecialchars($equipo['nombre_equipo'] ?? '', ENT_QUOTES, 'UTF-8'); ?>" required>
                </div>
                <div class="form-group">
                    <label for="ubicacion"><i class="fas fa-map-marker-alt"></i> Ubicación:</label>
                    <input type="text" id="ubicacion" name="ubicacion" value="<?php echo htmlspecialchars($equipo['ubicacion'] ?? '', ENT_QUOTES, 'UTF-8'); ?>" required>
                </div>
                <div class="form-group">
                    <label for="marca"><i class="fas fa-copyright"></i> Marca:</label>
                    <input type="text" id="marca" name="marca" value="<?php echo htmlspecialchars($detalles['marca'] ?? '', ENT_QUOTES, 'UTF-8'); ?>" required>
                </div>
                <div class="form-group">
                    <label for="modelo"><i class="fas fa-laptop"></i> Modelo:</label>
                    <input type="text" id="modelo" name="modelo" value="<?php echo htmlspecialchars($detalles['modelo'] ?? '', ENT_QUOTES, 'UTF-8'); ?>" required>
                </div>
                <div class="form-group">
                    <label for="numero_serie"><i class="fas fa-barcode"></i> Número de Serie:</label>
                    <input type="text" id="numero_serie" name="numero_serie" value="<?php echo htmlspecialchars($detalles['numero_serie'] ?? '', ENT_QUOTES, 'UTF-8'); ?>">
                </div>
                <div class="form-group">
                    <label for="procesador"><i class="fas fa-microchip"></i> Procesador:</label>
                    <input type="text" id="procesador" name="procesador" value="<?php echo htmlspecialchars($detalles['procesador'] ?? '', ENT_QUOTES, 'UTF-8'); ?>">
                </div>
                <div class="form-group">
                    <label for="memoria_ram"><i class="fas fa-memory"></i> Memoria RAM:</label>
                    <input type="text" id="memoria_ram" name="memoria_ram" value="<?php echo htmlspecialchars($detalles['memoria_ram'] ?? '', ENT_QUOTES, 'UTF-8'); ?>">
                </div>
                <div class="form-group">
                    <label for="almacenamiento"><i class="fas fa-hdd"></i> Almacenamiento:</label>
                    <input type="text" id="almacenamiento" name="almacenamiento" value="<?php echo htmlspecialchars($detalles['almacenamiento'] ?? '', ENT_QUOTES, 'UTF-8'); ?>">
                </div>
                <div class="form-group">
                    <label for="tarjeta_grafica"><i class="fas fa-gamepad"></i> Tarjeta Gráfica:</label>
                    <input type="text" id="tarjeta_grafica" name="tarjeta_grafica" value="<?php echo htmlspecialchars($detalles['tarjeta_grafica'] ?? '', ENT_QUOTES, 'UTF-8'); ?>">
                </div>
                <div class="form-group">
                    <label for="sistema_operativo"><i class="fab fa-windows"></i> Sistema Operativo:</label>
                    <input type="text" id="sistema_operativo" name="sistema_operativo" value="<?php echo htmlspecialchars($detalles['sistema_operativo'] ?? '', ENT_QUOTES, 'UTF-8'); ?>" required>
                </div>
                <div class="form-group">
                    <label for="version_so"><i class="fas fa-code-branch"></i> Versión del SO:</label>
                    <input type="text" id="version_so" name="version_so" value="<?php echo htmlspecialchars($detalles['version_so'] ?? '', ENT_QUOTES, 'UTF-8'); ?>">
                </div>
                <div class="form-group">
                    <label for="estado_equipo_id"><i class="fas fa-toggle-on"></i> Estado del Equipo:</label>
                    <select id="estado_equipo_id" name="estado_equipo_id" required>
                        <?php while ($estado = $estados_result->fetch_assoc()): ?>
                            <option value="<?php echo htmlspecialchars($estado['id'], ENT_QUOTES, 'UTF-8'); ?>" <?php if ($equipo['estado_equipo_id'] == $estado['id']) echo 'selected'; ?>>
                                <?php echo htmlspecialchars($estado['nombre_estado'], ENT_QUOTES, 'UTF-8'); ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>
                <div class="form-group full-width">
                    <label for="programas_instalados"><i class="fas fa-cogs"></i> Programas Instalados:</label>
                    <textarea id="programas_instalados" name="programas_instalados" rows="4"><?php echo htmlspecialchars($software['programas_instalados'] ?? '', ENT_QUOTES, 'UTF-8'); ?></textarea>
                </div>
                <div class="form-group full-width">
                    <label for="observaciones"><i class="fas fa-file-alt"></i> Observaciones:</label>
                    <textarea id="observaciones" name="observaciones" rows="4"><?php echo htmlspecialchars($mantenimiento['observaciones'] ?? '', ENT_QUOTES, 'UTF-8'); ?></textarea>
                </div>
                <div class="form-group">
                    <label for="fecha_ultimo_mantenimiento"><i class="fas fa-calendar-alt"></i> Fecha de Último Mantenimiento:</label>
                    <input type="date" id="fecha_ultimo_mantenimiento" name="fecha_ultimo_mantenimiento" value="<?php echo htmlspecialchars($mantenimiento['fecha_ultimo_mantenimiento'] ?? '', ENT_QUOTES, 'UTF-8'); ?>">
                </div>
                <div class="form-group">
                    <label for="proxima_fecha_mantenimiento"><i class="fas fa-calendar-check"></i> Próxima Fecha Mantenimiento:</label>
                    <input type="date" id="proxima_fecha_mantenimiento" name="proxima_fecha_mantenimiento" value="<?php echo htmlspecialchars($mantenimiento['proxima_fecha_mantenimiento'] ?? '', ENT_QUOTES, 'UTF-8'); ?>">
                </div>
                <div class="form-group full-width">
                    <label for="detalles_mantenimiento"><i class="fas fa-tools"></i> Detalles del Mantenimiento:</label>
                    <textarea id="detalles_mantenimiento" name="detalles_mantenimiento" rows="4"><?php echo htmlspecialchars($mantenimiento['detalles_mantenimiento'] ?? '', ENT_QUOTES, 'UTF-8'); ?></textarea>
                </div>
                <div class="form-group full-width">
                    <label for="imagen"><i class="fas fa-image"></i> Imagen del Equipo (Subir nueva para reemplazar):</label>
                    <input type="file" id="imagen" name="imagen" accept="image/*">
                    <?php if (!empty($detalles['imagen'])): ?>
                        <p style="margin-top: 10px; font-weight: 500;">Imagen actual:</p>
                        <img src="<?php echo htmlspecialchars($detalles['imagen'] ?? '', ENT_QUOTES, 'UTF-8'); ?>" alt="Imagen del Equipo" class="img-preview">
                    <?php endif; ?>
                </div>
            </div>
            
            <div class="form-buttons">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Guardar Cambios
                </button>
            </div>
        </form>
    </div>
</main>
    
<script>
    /**
     * Muestra un mensaje flotante (tipo 'exito' o 'error')
     */
    function showJsMessage(message, type) {
        const notification = document.getElementById('mensaje-box');
        notification.textContent = message;
        // Quitar clases antiguas, poner las nuevas
        notification.className = 'mensaje ' + type + ' show';
        notification.style.display = 'block';
        
        setTimeout(() => {
            notification.classList.remove('show');
        }, 3000);
    }

    /**
     * Valida el formulario antes de enviarlo
     */
    function validateForm(event) {
        // Campos requeridos
        const requiredFields = [
            'nombre_equipo', 'ubicacion', 'marca', 'modelo', 'sistema_operativo', 'estado_equipo_id'
        ];
        let valid = true;

        requiredFields.forEach(fieldId => {
            const field = document.getElementById(fieldId);
            if (!field.value.trim()) {
                field.classList.add('error'); // Añade clase de error CSS
                valid = false;
            } else {
                field.classList.remove('error');
            }
        });

        if (!valid) {
            event.preventDefault(); // Detener el envío
            showJsMessage('Por favor completa todos los campos obligatorios.', 'error');
        }
    }

    // Añadir el listener de validación al formulario
    document.addEventListener("DOMContentLoaded", function() {
        const form = document.querySelector('form');
        form.addEventListener('submit', validateForm);
    });

    // Mostrar el mensaje de PHP (si existe) al cargar la página
    <?php if ($message): ?>
    window.onload = function() {
        showJsMessage('<?php echo htmlspecialchars($message, ENT_QUOTES, 'UTF-8'); ?>', '<?php echo htmlspecialchars($message_type, ENT_QUOTES, 'UTF-8'); ?>');
    }
    <?php endif; ?>
</script>
</body>
</html>