<?php
session_start();
header('Content-Type: text/html; charset=utf-8');

include '../includes/db.php';
include '../includes/auth.php';
checkAuth();

if (!isAdmin()) {
    header("Location: ../index.php");
    exit();
}

$conn->set_charset("utf8mb4");

// Obtener el ID del rol 'estudiante'
$rol_estudiante_id = null;
$rol_stmt = $conn->prepare("SELECT id FROM roles WHERE nombre = 'estudiante'");
$rol_stmt->execute();
$rol_stmt->bind_result($rol_estudiante_id);
$rol_stmt->fetch();
$rol_stmt->close();

// Manejo de mensajes de sesión
$message = '';
$message_type = '';
if (isset($_SESSION['message'])) {
    $message = $_SESSION['message'];
    $message_type = $_SESSION['message_type'];
    unset($_SESSION['message'], $_SESSION['message_type']);
}

// Obtener la lista de cursos activos (se usará en varios lugares)
$cursos = $conn->query("SELECT id, nombre FROM curso WHERE activo = 1 ORDER BY nombre ASC;");

// Obtener la lista de alumnos si un curso ha sido seleccionado
$alumnos = [];
$curso_id_seleccionado = null;
if (isset($_GET['curso_id'])) {
    $curso_id_seleccionado = intval($_GET['curso_id']);
    $stmt = $conn->prepare("SELECT id, CONCAT(nombre, ' ', apellido_paterno, ' ', apellido_materno) AS nombre_completo, rut FROM usuario WHERE curso_id = ? AND rol_id = ? ORDER BY apellido_paterno");
    $stmt->bind_param("ii", $curso_id_seleccionado, $rol_estudiante_id);
    $stmt->execute();
    $alumnos = $stmt->get_result();
    $stmt->close();
}

// ---------------------------------------------------------
// 1. LÓGICA: PROMOVER ALUMNO (Individual)
// ---------------------------------------------------------
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['promover_alumno'])) {
    $alumno_id = intval($_POST['alumno_id']);
    $curso_nuevo_id = intval($_POST['curso_nuevo_id']);
    $curso_actual_id = intval($_POST['curso_actual_id']);
    
    if ($curso_nuevo_id != $curso_actual_id) {
        $stmt = $conn->prepare("UPDATE usuario SET curso_id = ? WHERE id = ? AND rol_id = ?");
        $stmt->bind_param("iii", $curso_nuevo_id, $alumno_id, $rol_estudiante_id);
        if ($stmt->execute()) {
            $_SESSION['message'] = 'El alumno ha sido promovido correctamente.';
            $_SESSION['message_type'] = 'exito';
        } else {
            $_SESSION['message'] = 'Error al promover el alumno.';
            $_SESSION['message_type'] = 'error';
        }
        $stmt->close();
    } else {
        $_SESSION['message'] = 'El nuevo curso debe ser diferente al curso actual.';
        $_SESSION['message_type'] = 'error';
    }
    
    header("Location: view_courses.php?curso_id=" . $curso_actual_id);
    exit();
}

// ---------------------------------------------------------
// 2. LÓGICA: ACCIONES MASIVAS (Egresar y Promover)
// ---------------------------------------------------------
if ($_SERVER['REQUEST_METHOD'] == 'POST' && (isset($_POST['egresar_individual']) || isset($_POST['egresar_masivo']) || isset($_POST['promover_masivo']))) {
    
    $ids_seleccionados = [];
    
    // Recolectar IDs (Individual o Masivo)
    if (isset($_POST['egresar_individual'])) {
        $ids_seleccionados[] = intval($_POST['egresar_individual']);
    } elseif (!empty($_POST['alumnos_seleccionados']) && is_array($_POST['alumnos_seleccionados'])) {
        $ids_seleccionados = array_map('intval', $_POST['alumnos_seleccionados']);
    }

    if (!empty($ids_seleccionados)) {
        $ids_string = implode(',', $ids_seleccionados);
        $cantidad = count($ids_seleccionados);

        // --- CASO A: EGRESAR ---
        if (isset($_POST['egresar_masivo']) || isset($_POST['egresar_individual'])) {
            $rol_egresado_id = 10; 
            $sql = "UPDATE usuario SET rol_id = $rol_egresado_id, curso_id = NULL WHERE id IN ($ids_string)";
            
            if ($conn->query($sql)) {
                $_SESSION['message'] = "$cantidad alumno(s) marcado(s) como egresado(s).";
                $_SESSION['message_type'] = 'exito';
            } else {
                $_SESSION['message'] = 'Error en la base de datos al egresar.';
                $_SESSION['message_type'] = 'error';
            }
        }
        
        // --- CASO B: PROMOVER MASIVAMENTE ---
        elseif (isset($_POST['promover_masivo'])) {
            $curso_destino = intval($_POST['curso_destino_masivo']);
            
            // Validar que se haya seleccionado un curso destino válido
            if ($curso_destino > 0 && $curso_destino != $curso_id_seleccionado) {
                $sql = "UPDATE usuario SET curso_id = $curso_destino WHERE id IN ($ids_string)";
                
                if ($conn->query($sql)) {
                    $_SESSION['message'] = "$cantidad alumno(s) promovido(s) correctamente al nuevo curso.";
                    $_SESSION['message_type'] = 'exito';
                } else {
                    $_SESSION['message'] = 'Error en la base de datos al promover.';
                    $_SESSION['message_type'] = 'error';
                }
            } else {
                $_SESSION['message'] = 'Error: Debes seleccionar un curso de destino válido y diferente al actual.';
                $_SESSION['message_type'] = 'error';
            }
        }

    } else {
        $_SESSION['message'] = 'No seleccionaste ningún alumno.';
        $_SESSION['message_type'] = 'error';
    }
    
    header("Location: view_courses.php?curso_id=" . $curso_id_seleccionado);
    exit();
}

?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="../images/logo.png">
    <title>Ver Cursos y Promover Alumnos</title>
    
    <link rel="stylesheet" href="../css/admin.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    
    <style>
        /* Estilos adicionales para la barra de acciones masivas */
        .mass-actions-bar {
            background-color: #f8f9fa;
            border: 1px solid #ddd;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            gap: 15px;
        }
        .mass-group {
            display: flex;
            align-items: center;
            gap: 10px;
        }
        .mass-group select {
            padding: 8px;
            border-radius: 4px;
            border: 1px solid #ccc;
        }
    </style>
</head>
<body>
    
<header>
    <div class="header-content">
        <img src="../images/INSIGNIA SF.png" alt="Escuela Porongo Insignia">
        <h1>Gestión de Alumnos</h1>
        <nav>
            <ul>
                <li><a href="../index.php"><i class="fas fa-home"></i> Inicio</a></li>
            </ul>
        </nav>
    </div>
</header>
    
<main class="container">

    <?php if ($message): ?>
        <div class="mensaje <?php echo $message_type; ?> show">
            <?php echo htmlspecialchars($message, ENT_QUOTES, 'UTF-8'); ?>
        </div>
    <?php endif; ?>

    <div class="card form-container">
        <h2><i class="fas fa-filter"></i> Filtrar por Curso</h2>
        <form method="GET" action="view_courses.php">
            <div class="form-group">
                <label for="curso_id">Seleccione el curso actual:</label>
                <select id="curso_id" name="curso_id" onchange="this.form.submit()">
                    <option value="">Seleccionar</option>
                    <?php 
                    $cursos->data_seek(0);
                    while ($curso = $cursos->fetch_assoc()): 
                    ?>
                        <option value="<?php echo htmlspecialchars($curso['id'], ENT_QUOTES, 'UTF-8'); ?>" <?php if ($curso_id_seleccionado == $curso['id']) echo 'selected'; ?>>
                            <?php echo htmlspecialchars($curso['nombre'], ENT_QUOTES, 'UTF-8'); ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>
        </form>
    </div>
        
    <?php if ($alumnos && $alumnos->num_rows > 0): ?>
        
        <form method="POST" action="view_courses.php?curso_id=<?php echo $curso_id_seleccionado; ?>" id="form-tabla-alumnos">
            
            <div class="card">
                <h3><i class="fas fa-tasks"></i> Acciones Masivas</h3>
                <p class="text-muted" style="margin-bottom: 10px;">Seleccione alumnos en la tabla de abajo y elija una acción.</p>
                
                <div class="mass-actions-bar">
                    <div class="mass-group" style="border-right: 1px solid #ccc; padding-right: 20px;">
                        <label for="curso_destino_masivo"><strong>Promover seleccionados a:</strong></label>
                        <select name="curso_destino_masivo" id="curso_destino_masivo">
                            <option value="">Elegir curso destino</option>
                            <?php 
                            $cursos->data_seek(0); // Reiniciar puntero para reutilizar lista
                            while ($curso = $cursos->fetch_assoc()): 
                                // Opcional: No mostrar el curso actual en el destino
                                if ($curso['id'] == $curso_id_seleccionado) continue; 
                            ?>
                                <option value="<?php echo $curso['id']; ?>">
                                    <?php echo htmlspecialchars($curso['nombre']); ?>
                                </option>
                            <?php endwhile; ?>
                        </select>
                        <button type="submit" name="promover_masivo" class="btn btn-primary" onclick="return validarPromocionMasiva()">
                            <i class="fas fa-arrow-up"></i> Promover
                        </button>
                    </div>

                    <div class="mass-group">
                        <button type="submit" name="egresar_masivo" class="btn btn-danger" onclick="return confirm('¿Está seguro de EGRESAR a los alumnos seleccionados? Se quitarán del sistema activo.');">
                            <i class="fas fa-user-graduate"></i> Egresar Seleccionados
                        </button>
                    </div>
                    
                    <div class="mass-group" style="margin-left: auto;">
                         <a href="export_students.php?curso_id=<?= $curso_id_seleccionado ?>" class="btn btn-success">
                            <i class="fas fa-file-excel"></i> Excel
                        </a>
                    </div>
                </div>
            </div>

            <div class="card table-container">
                <div style="margin-bottom: 1rem;">
                    <h2>Lista de Alumnos (<?php echo $alumnos->num_rows; ?>)</h2>
                </div>

                <div class="table-responsive">
                    <table>
                        <thead>
                            <tr>
                                <th style="width: 40px; text-align: center;">
                                    <input type="checkbox" id="select_all" onclick="toggleSelectAll(this)">
                                </th>
                                <th>Nombre</th>
                                <th>RUT</th>
                                <th class="actions">Acciones Individuales</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while ($alumno = $alumnos->fetch_assoc()): ?>
                                <tr>
                                    <td style="text-align: center;">
                                        <input type="checkbox" name="alumnos_seleccionados[]" value="<?php echo $alumno['id']; ?>" class="alumno-checkbox">
                                    </td>
                                    <td><?php echo htmlspecialchars($alumno['nombre_completo'], ENT_QUOTES, 'UTF-8'); ?></td>
                                    <td><?php echo htmlspecialchars($alumno['rut'], ENT_QUOTES, 'UTF-8'); ?></td>
                                    <td class="actions">
                                        <button type="button" class="btn btn-primary btn-sm" title="Promover solo a este" onclick="promoverAlumno('<?php echo $alumno['id']; ?>', '<?php echo htmlspecialchars($alumno['nombre_completo'], ENT_QUOTES, 'UTF-8'); ?>', '<?php echo $curso_id_seleccionado; ?>')">
                                            <i class="fas fa-graduation-cap"></i>
                                        </button>
                                        
                                        <button type="submit" name="egresar_individual" value="<?php echo $alumno['id']; ?>" class="btn btn-success btn-sm" title="Egresar solo a este" onclick="return confirm('¿Egresar a este alumno?');">
                                            <i class="fas fa-user-graduate"></i>
                                        </button>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </form>
        <?php elseif ($curso_id_seleccionado): ?>
        <div class="card"><p style="text-align: center;">No hay alumnos matriculados en este curso.</p></div>
    <?php endif; ?>
        
    <div class="card form-container" id="form-promover" style="display:none; border: 2px solid var(--primary-color);">
        <h2 id="form-titulo"><i class="fas fa-arrow-up"></i> Promover Alumno (Individual)</h2>
        
        <form method="POST" action="view_courses.php">
            <input type="hidden" name="alumno_id" id="alumno_id">
            <input type="hidden" name="curso_actual_id" id="curso_actual_id">

            <div class="form-grid">
                <div class="form-group">
                    <label for="nombre_alumno">Nombre del Alumno:</label>
                    <input type="text" id="nombre_alumno" name="nombre_alumno" readonly style="background-color: var(--grey-light);">
                </div>

                <div class="form-group">
                    <label for="curso_nuevo_id">Nuevo Curso:</label>
                    <select id="curso_nuevo_id" name="curso_nuevo_id" required>
                        <option value="">Seleccione un curso</option>
                        <?php 
                        $cursos->data_seek(0);
                        while ($curso = $cursos->fetch_assoc()): 
                        ?>
                            <option value="<?php echo $curso['id']; ?>">
                                <?php echo htmlspecialchars($curso['nombre']); ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>
            </div>
            
            <div class="form-buttons">
                <button type="submit" name="promover_alumno" class="btn btn-primary">
                    <i class="fas fa-check"></i> Confirmar
                </button>
                <button type="button" onclick="cancelarPromocion()" class="btn btn-secondary">
                    <i class="fas fa-times"></i> Cancelar
                </button>
            </div>
        </form>
    </div>
</main>

<script>
    // Seleccionar/Deseleccionar todos
    function toggleSelectAll(source) {
        checkboxes = document.getElementsByClassName('alumno-checkbox');
        for(var i=0, n=checkboxes.length;i<n;i++) {
            checkboxes[i].checked = source.checked;
        }
    }

    // Validación antes de enviar promoción masiva
    function validarPromocionMasiva() {
        // Verificar si hay curso seleccionado
        var selectCurso = document.getElementById('curso_destino_masivo');
        if (selectCurso.value === "") {
            alert("Por favor, selecciona un 'Curso Destino' antes de promover.");
            return false;
        }

        // Verificar si hay alumnos seleccionados
        var checkboxes = document.querySelectorAll('.alumno-checkbox:checked');
        if (checkboxes.length === 0) {
            alert("Por favor, selecciona al menos un alumno de la lista.");
            return false;
        }

        return confirm('¿Estás seguro de mover a estos ' + checkboxes.length + ' alumnos al nuevo curso?');
    }

    // Modal Promoción Individual
    function promoverAlumno(id, nombre_completo, curso_actual_id) {
        document.getElementById('alumno_id').value = id;
        document.getElementById('nombre_alumno').value = nombre_completo;
        document.getElementById('curso_actual_id').value = curso_actual_id;

        const formPromover = document.getElementById('form-promover');
        formPromover.style.display = 'block';
        formPromover.scrollIntoView({ behavior: 'smooth', block: 'start' });
    }
    
    function cancelarPromocion() {
        document.getElementById('form-promover').style.display = 'none';
    }

    window.onload = function() {
        const message = document.querySelector('.mensaje');
        if (message) {
            setTimeout(() => {
                message.classList.remove('show');
            }, 4000);
        }
    };
</script>
</body>
</html>