<?php
session_start();
// Ajusta estas rutas según tu estructura de carpetas
include '../includes/db.php';
include '../includes/auth.php';

// Verificar si existe la librería (Ajusta la ruta si es necesario, ej: ../../vendor/autoload.php)
if (file_exists('../vendor/autoload.php')) {
    require '../vendor/autoload.php';
} else {
    die("Error: No se encuentra la librería PhpSpreadsheet en '../vendor/autoload.php'. Asegúrate de haber instalado las dependencias con Composer.");
}

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

checkAuth();

if (!isAdmin()) {
    header("Location: ../index.php");
    exit();
}

$conn->set_charset("utf8mb4");

// Validar que venga el ID del curso
if (!isset($_GET['curso_id'])) {
    die("Error: Falta el ID del curso.");
}

$curso_id = intval($_GET['curso_id']);

// 1. Obtener nombre del curso para el nombre del archivo
$stmt_curso = $conn->prepare("SELECT nombre FROM curso WHERE id = ?");
$stmt_curso->bind_param("i", $curso_id);
$stmt_curso->execute();
$res_curso = $stmt_curso->get_result();
$nombre_curso_archivo = ($row = $res_curso->fetch_assoc()) ? $row['nombre'] : 'Curso';
$stmt_curso->close();

// 2. Obtener el ID del rol 'estudiante'
$rol_stmt = $conn->prepare("SELECT id FROM roles WHERE nombre = 'estudiante'");
$rol_stmt->execute();
$rol_stmt->bind_result($rol_estudiante_id);
$rol_stmt->fetch();
$rol_stmt->close();

// 3. Crear nuevo archivo de Excel
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// Configurar metadatos del documento (Opcional)
$spreadsheet->getProperties()->setCreator("Escuela Porongo")
                             ->setTitle("Lista de Alumnos - " . $nombre_curso_archivo);

// 4. Encabezados de columna (Según tu requerimiento)
$sheet->setCellValue('A1', 'Nombre');
$sheet->setCellValue('B1', 'Apellido Paterno');
$sheet->setCellValue('C1', 'Apellido Materno');
$sheet->setCellValue('D1', 'RUT');
$sheet->setCellValue('E1', 'Contraseña');

// Estilo para los encabezados (Negrita)
$sheet->getStyle('A1:E1')->getFont()->setBold(true);

// 5. Consulta de alumnos
$sql = "SELECT nombre, apellido_paterno, apellido_materno, rut 
        FROM usuario 
        WHERE curso_id = ? AND rol_id = ? 
        ORDER BY apellido_paterno, apellido_materno, nombre";

$stmt = $conn->prepare($sql);
$stmt->bind_param("ii", $curso_id, $rol_estudiante_id);
$stmt->execute();
$result = $stmt->get_result();

// 6. Llenar datos
$row = 2;
while ($alumno = $result->fetch_assoc()) {
    $sheet->setCellValue("A$row", $alumno['nombre']);
    $sheet->setCellValue("B$row", $alumno['apellido_paterno']);
    $sheet->setCellValue("C$row", $alumno['apellido_materno']);
    $sheet->setCellValue("D$row", $alumno['rut']);
    $sheet->setCellValue("E$row", 'esp@2025'); // Contraseña fija para todos
    $row++;
}

// Ajustar ancho de columnas automáticamente
foreach (range('A', 'E') as $columnID) {
    $sheet->getColumnDimension($columnID)->setAutoSize(true);
}

// 7. Descargar archivo
$filename = "Lista_Alumnos_" . preg_replace('/[^a-zA-Z0-9]/', '_', $nombre_curso_archivo) . ".xlsx";

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="' . $filename . '"');
header('Cache-Control: max-age=0');

$writer = new Xlsx($spreadsheet);
$writer->save('php://output');
exit();
?>