<?php
header('Content-Type: text/html; charset=utf-8'); // Establecer la codificación de caracteres

include 'includes/db.php';
include 'includes/auth.php';
checkAuth();
if (!isAdmin()) {
    header("Location: index.php");
    exit();
}

// Establecer la codificación de caracteres para la conexión de la base de datos
$conn->set_charset("utf8");

// Eliminar curso
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['eliminar'])) {
    $curso_id = $_POST['curso_id'];

    // Usar consultas preparadas para evitar inyecciones SQL
    $stmt = $conn->prepare("DELETE FROM cursos WHERE id = ?");
    $stmt->bind_param('i', $curso_id);
    $stmt->execute();
    $stmt->close();

    header("Location: delete_course.php");
    exit();
}

// Obtener la lista de cursos
$cursos = $conn->query("SELECT * FROM cursos");
?>
<!DOCTYPE html>
<html>
<head>
    <title>Eliminar Cursos</title>
    <link rel="stylesheet" type="text/css" href="css/style.css">
    <link rel="icon" type="image/png" href="../images/logo.png">
    <meta charset="UTF-8"> <!-- Establecer la codificación de caracteres en HTML -->
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            padding: 8px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }
        th {
            background-color: #f2f2f2;
        }
        button {
            background-color: #f44336;
            color: white;
            border: none;
            padding: 5px 10px;
            cursor: pointer;
            border-radius: 4px;
        }
        button:hover {
            background-color: #d32f2f;
        }
    </style>
</head>
<body>
    <header>
        <h1>Eliminar Cursos</h1>
    </header>
    <nav>
        <ul>
            <li><a href="index.php">Inicio</a></li>
            <li><a href="schedule.php">Agendar Horas</a></li>
            <li><a href="logout.php">Cerrar Sesión</a></li>
            <?php if (isAdmin()): ?>
                <li><a href="admin.php">Administrar Usuarios</a></li>
                <li><a href="reports.php">Generar Informes</a></li>
                <li><a href="add_subject.php">Agregar Asignaturas</a></li>
                <li><a href="delete_subject.php">Eliminar Asignaturas</a></li>
                <li><a href="add_course.php">Agregar Curso</a></li>
                <li><a href="delete_course.php">Eliminar Cursos</a></li>
                <li><a href="add_grade.php">Agregar Notas</a></li>
            <?php endif; ?>
        </ul>
    </nav>
    <main>
        <table>
            <thead>
                <tr>
                    <th>Nombre del Curso</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php while ($curso = $cursos->fetch_assoc()): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($curso['nombre'], ENT_QUOTES, 'UTF-8'); ?></td>
                        <td>
                            <form method="POST" action="delete_course.php" style="display:inline;" onsubmit="return confirm('¿Está seguro de que desea eliminar este curso?');">
                                <input type="hidden" name="curso_id" value="<?php echo $curso['id']; ?>">
                                <button type="submit" name="eliminar">Eliminar</button>
                            </form>
                        </td>
                    </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </main>
</body>
</html>
