<?php
header('Content-Type: text/html; charset=utf-8');
// AÑADIDO: Iniciar sesión (buena práctica, aunque no se use para mensajes aquí)
session_start(); 
include '../includes/db.php';
include '../includes/auth.php';
checkAuth();

if (!isAdmin()) { header("Location: ../index.php"); exit(); }
$conn->set_charset("utf8mb4");

$message = '';
$message_type = '';

function guardarCurso($conn, $nombre, $profesor_jefe_id, $id = null) {
    global $message, $message_type;

    if ($id) {
        $stmt = $conn->prepare("UPDATE curso SET nombre = ?, profesor_jefe_id = ? WHERE id = ?");
        $stmt->bind_param("sii", $nombre, $profesor_jefe_id, $id);
    } else {
        $stmt = $conn->prepare("INSERT INTO curso (nombre, profesor_jefe_id) VALUES (?, ?)");
        $stmt->bind_param("si", $nombre, $profesor_jefe_id);
    }

    if ($stmt->execute()) {
        $message = $id ? 'Curso modificado' : 'Curso agregado';
        $message_type = 'exito'; // MODIFICADO: 'exito' en lugar de 'success'
    } else {
        $message = 'Error al guardar el curso: ' . $stmt->error;
        $message_type = 'error';
    }

    $stmt->close();
}

function eliminarCurso($conn, $curso_id) {
    global $message, $message_type;
    $stmt = $conn->prepare("DELETE FROM curso WHERE id = ?");
    $stmt->bind_param("i", $curso_id);
    
    if ($stmt->execute()) {
        $message = 'Curso eliminado';
        $message_type = 'exito'; // MODIFICADO: 'exito'
    } else {
        $message = 'Error al eliminar curso: ' . $stmt->error;
        $message_type = 'error';
    }
    
    $stmt->close();
}

function cambiarEstadoCurso($conn, $curso_id, $estado) {
    global $message, $message_type;
    $stmt = $conn->prepare("UPDATE curso SET activo = ? WHERE id = ?");
    $stmt->bind_param("ii", $estado, $curso_id);
    
    if ($stmt->execute()) {
        $message = 'Estado del curso actualizado';
        $message_type = 'exito'; // MODIFICADO: 'exito'
    } else {
        $message = 'Error al cambiar el estado del curso: ' . $stmt->error;
        $message_type = 'error';
    }
    
    $stmt->close();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['eliminar'])) {
        $curso_id = intval($_POST['curso_id'] ?? '');
        if ($curso_id) eliminarCurso($conn, $curso_id);
    } elseif (isset($_POST['estado'])) {
        $curso_id = intval($_POST['curso_id'] ?? '');
        $estado = intval($_POST['estado']);
        if ($curso_id) cambiarEstadoCurso($conn, $curso_id, $estado);
    } else {
        $nombre = trim($_POST['nombre'] ?? '');
        $profesor_jefe_id = intval($_POST['profesor_jefe_id'] ?? 0);
        if ($nombre && $profesor_jefe_id) {
            $curso_id = isset($_POST['curso_id']) && !empty($_POST['curso_id']) ? intval($_POST['curso_id']) : null;
            guardarCurso($conn, $nombre, $profesor_jefe_id, $curso_id);
        } else {
            $message = 'Error: El nombre del curso y el profesor jefe no pueden estar vacíos.';
            $message_type = 'error';
        }
    }
    // NOTA: Este script no redirige, muestra el mensaje en la misma carga.
}

$profesores = $conn->query("SELECT id, nombre, apellido_paterno, apellido_materno FROM usuario WHERE rol_id = 2 ORDER BY nombre ASC");
$cursos = $conn->query("SELECT curso.id, curso.nombre, curso.profesor_jefe_id, usuario.nombre AS profesor_nombre, usuario.apellido_paterno AS profesor_apellido_paterno, usuario.apellido_materno AS profesor_apellido_materno, curso.activo FROM curso LEFT JOIN usuario ON curso.profesor_jefe_id = usuario.id ORDER BY curso.nombre ASC");
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="../images/logo.png">
    <title>Agregar/Editar Curso</title>
    
    <link rel="stylesheet" href="../css/admin.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    
    </head>
<body>
    
<header>
    <div class="header-content">
        <img src="../images/INSIGNIA SF.png" alt="Escuela Porongo Insignia">
        <h1>Gestión de Cursos</h1>
        <nav>
            <ul>
                <li><a href="../index.php"><i class="fas fa-home"></i> Inicio</a></li>
            </ul>
        </nav>
    </div>
</header>
    
<main class="container">

    <?php if ($message): ?>
        <div class="mensaje <?php echo $message_type; ?> show">
            <?php echo htmlspecialchars($message, ENT_QUOTES, 'UTF-8'); ?>
        </div>
    <?php endif; ?>

    <div class="card form-container">
        <h2 id="form-titulo"><i class="fas fa-university"></i> Agregar Curso</h2>
        
        <form id="formulario-curso" method="POST" action="add_course.php" onsubmit="return validarFormulario()">
            <input type="hidden" name="curso_id" id="curso_id">
            
            <div class="form-grid">
                <div class="form-group">
                    <label for="nombre"><i class="fas fa-tag"></i> Nombre del Curso:</label>
                    <input type="text" id="nombre" name="nombre" required>
                </div>
                
                <div class="form-group">
                    <label for="profesor_jefe_id"><i class="fas fa-user-tie"></i> Profesor Jefe:</label>
                    <select id="profesor_jefe_id" name="profesor_jefe_id" required>
                        <option value="">Seleccione un profesor</option>
                        <?php while ($profesor = $profesores->fetch_assoc()): ?>
                            <option value="<?php echo htmlspecialchars($profesor['id'], ENT_QUOTES, 'UTF-8'); ?>">
                                <?php echo htmlspecialchars($profesor['nombre'] . ' ' . $profesor['apellido_paterno'] . ' ' . $profesor['apellido_materno'], ENT_QUOTES, 'UTF-8'); ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>
            </div> <div class="form-buttons">
                <button type="submit" name="crear" id="crear" class="btn btn-primary">
                    <i class="fas fa-plus-circle"></i> Crear Curso
                </button>
                <button type="submit" name="modificar" id="modificar" class="btn btn-primary" style="display:none;">
                    <i class="fas fa-save"></i> Modificar Curso
                </button>
                <button type="button" id="cancelar" class="btn btn-secondary" style="display:none;" onclick="cancelarEdicion()">
                    <i class="fas fa-times-circle"></i> Cancelar
                </button>
            </div>
        </form>
    </div>

    <div class="card table-container">
        <h2><i class="fas fa-list-ul"></i> Cursos Existentes</h2>
        
        <div class="table-responsive">
            <table>
                <thead>
                    <tr>
                        <th>Nombre del Curso</th>
                        <th>Profesor Jefe</th>
                        <th>Estado</th>
                        <th class="actions">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($cursos->num_rows > 0): ?>
                        <?php while ($curso = $cursos->fetch_assoc()): ?>
                            <tr class="<?php echo $curso['activo'] ? 'status-active' : 'status-inactive'; ?>">
                                <td><?php echo htmlspecialchars($curso['nombre'], ENT_QUOTES, 'UTF-8'); ?></td>
                                <td><?php echo htmlspecialchars($curso['profesor_nombre'] . ' ' . $curso['profesor_apellido_paterno'] . ' ' . $curso['profesor_apellido_materno'], ENT_QUOTES, 'UTF-8'); ?></td>
                                <td>
                                    <span class="status-badge <?php echo $curso['activo'] ? 'status-active-badge' : 'status-inactive-badge'; ?>">
                                        <?php echo $curso['activo'] ? 'Activo' : 'Inactivo'; ?>
                                    </span>
                                </td>
                                <td class="actions">
                                    
                                    <button class="btn btn-edit" title="Editar" onclick="editarCurso('<?php echo htmlspecialchars($curso['id'], ENT_QUOTES, 'UTF-8'); ?>', '<?php echo htmlspecialchars($curso['nombre'], ENT_QUOTES, 'UTF-8'); ?>', '<?php echo htmlspecialchars($curso['profesor_jefe_id'], ENT_QUOTES, 'UTF-8'); ?>')">
                                        <i class="fas fa-pencil-alt"></i>
                                    </button>
                                    
                                    <form method="POST" action="add_course.php" style="display:inline;">
                                        <input type="hidden" name="curso_id" value="<?php echo htmlspecialchars($curso['id'], ENT_QUOTES, 'UTF-8'); ?>">
                                        <button type="submit" name="estado" value="<?php echo $curso['activo'] ? 0 : 1; ?>" class="btn <?php echo $curso['activo'] ? 'btn-danger' : 'btn-success'; ?>" title="<?php echo $curso['activo'] ? 'Desactivar' : 'Activar'; ?>">
                                            <?php echo $curso['activo'] ? '<i class="fas fa-toggle-off"></i>' : '<i class="fas fa-toggle-on"></i>'; ?>
                                        </button>
                                    </form>
                                    
                                    <form method="POST" action="add_course.php" style="display:inline;" onsubmit="return confirm('¿Estás seguro de que deseas eliminar este curso?');">
                                        <input type="hidden" name="curso_id" value="<?php echo htmlspecialchars($curso['id'], ENT_QUOTES, 'UTF-8'); ?>">
                                        <button type="submit" name="eliminar" class="btn btn-danger" title="Eliminar">
                                            <i class="fas fa-trash-alt"></i>
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="4" style="text-align: center;">No hay cursos creados.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</main>

<script>
    function validarFormulario() {
        if (document.getElementById('nombre').value.trim() === '') {
            alert('El nombre del curso no puede estar vacío o contener solo espacios.');
            return false;
        }
        return true;
    }

    function editarCurso(id, nombre, profesor_jefe_id) {
        document.getElementById('form-titulo').innerHTML = '<i class="fas fa-edit"></i> Editar Curso';
        document.getElementById('curso_id').value = id;
        document.getElementById('nombre').value = nombre;
        document.getElementById('profesor_jefe_id').value = profesor_jefe_id;
        document.getElementById('crear').style.display = 'none';
        document.getElementById('modificar').style.display = 'inline-block';
        document.getElementById('cancelar').style.display = 'inline-block'; // AÑADIDO

        // Mover la vista al formulario
        document.getElementById('formulario-curso').scrollIntoView({
            behavior: 'smooth',
            block: 'start'
        });
    }
    
    // AÑADIDO: Función para cancelar
    function cancelarEdicion() {
        document.getElementById('form-titulo').innerHTML = '<i class="fas fa-university"></i> Agregar Curso';
        document.getElementById('formulario-curso').reset(); // Limpia el formulario
        document.getElementById('curso_id').value = '';
        
        document.getElementById('crear').style.display = 'inline-block';
        document.getElementById('modificar').style.display = 'none';
        document.getElementById('cancelar').style.display = 'none';
    }

    // MODIFICADO: Lógica de window.onload
    window.onload = function() {
        // Apunta a .mensaje en lugar de #message
        const message = document.querySelector('.mensaje');
        if (message) {
            // Se asegura que 'show' esté presente para la animación
            message.classList.add('show'); 
            setTimeout(() => {
                message.classList.remove('show');
            }, 3000); // 3 segundos
        }
    };
</script>
</body>
</html>