<?php
header('Content-Type: text/html; charset=utf-8');
include '../includes/db.php';
include '../includes/auth.php';

$conn->set_charset("utf8mb4");

// Obtener el ID del rol 'Estudiante'
$rol_estudiante_id = null;
$rol_stmt = $conn->prepare("SELECT id FROM roles WHERE nombre = 'Estudiante' LIMIT 1");
$rol_stmt->execute();
$rol_stmt->bind_result($rol_estudiante_id);
$rol_stmt->fetch();
$rol_stmt->close();

if (!$rol_estudiante_id) {
    die("No se encontró el rol 'Estudiante' en la base de datos.");
}

// Funciones para limpiar y validar RUT
function limpiarRut($rut) {
    return strtoupper(str_replace('.', '', trim($rut)));
}

function validarRutChileno($rut) {
    $rut = limpiarRut($rut);
    if (strpos($rut, '-') === false) return false;
    list($numero, $dv) = explode('-', $rut);
    $numero = strrev($numero);
    $factor = 2;
    $suma = 0;
    for ($i = 0; $i < strlen($numero); $i++) {
        $suma += $numero[$i] * $factor;
        $factor = ($factor == 7) ? 2 : $factor + 1;
    }
    $resto = $suma % 11;
    $dv_calculado = 11 - $resto;
    if ($dv_calculado == 11) $dv_calculado = '0';
    elseif ($dv_calculado == 10) $dv_calculado = 'K';
    else $dv_calculado = (string)$dv_calculado;

    return strtoupper($dv) === $dv_calculado;
}

// Inicializamos variables
$mensaje = '';
$alumno = null;

// Si se envió el formulario con RUT
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['rut'])) {
    $rutIngresado = $_POST['rut'];
    $rutLimpio = limpiarRut($rutIngresado);

    if (empty($rutLimpio)) {
        $mensaje = "Ingrese un RUT válido.";
    } elseif (!validarRutChileno($rutIngresado)) {
        $mensaje = "El RUT ingresado no es válido (revise el dígito verificador).";
    } else {
        $sql = "SELECT u.nombre, u.apellido_paterno, u.apellido_materno, u.rut, c.nombre AS curso_nombre
                FROM usuario u
                LEFT JOIN curso c ON u.curso_id = c.id
                WHERE REPLACE(u.rut, '.', '') = ?
                  AND u.rol_id = ?
                  AND u.activo = 1
                LIMIT 1";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param('si', $rutLimpio, $rol_estudiante_id);
        $stmt->execute();
        $resultado = $stmt->get_result();
        $alumno = $resultado->fetch_assoc();
        $stmt->close();

        if (!$alumno) {
            $mensaje = "No se encontró ningún alumno matriculado con ese RUT.";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <link rel="icon" type="image/png" href="../images/logo.png">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta charset="UTF-8">
<title>Validación de Estudiante - Escuela Porongo</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
html, body {
    height: 100%;
    margin: 0;
    display: flex;
    flex-direction: column;
}
body {
    background-color: #f9f9f9;
}

/* Contenedor principal */
.container {
    flex: 1; /* Ocupa todo el espacio disponible */
}

/* Header */
.header {
    background-color: #004080;
    padding: 15px 0;
    text-align: center;
}
.header a {
    color: #fff;
    margin: 0 15px;
    text-decoration: none;
    font-weight: bold;
}
.header a:hover {
    text-decoration: underline;
}
.header .logo {
    max-width: 120px;
    display: block;
    margin: 0 auto 10px;
}

/* Footer sticky */
.footer {
    background-color: #004080;
    color: #fff;
    padding: 20px 0;
    text-align: center;
}

/* Otros estilos */
.alert-success {
    font-size: 1.2rem;
    text-align: center;
}
.volver-btn {
    display: block;
    width: 200px;
    margin: 20px auto;
}
</style>

</head>
<body>

<!-- Header con navegación -->
<nav class="header text-center">
    <img src="../images/logo.png" alt="Logo Escuela Porongo" class="logo mb-2">
    <div>
        <a href="https://inicio.escuelaporongo.cl">Inicio</a>
    </div>
</nav>

<div class="container mt-5 text-center">

    <h2 class="mb-4">Validación de Alumno</h2>

    <!-- Indicaciones -->
    <div class="alert alert-info mx-auto w-75">
        <strong>Instrucciones:</strong><br>
        - Ingrese el RUT del alumno con el formato correcto: <strong>12345678-9</strong><br>
        - Asegúrese de ingresar el dígito verificador correcto.
    </div>

    <form method="post" class="mb-4 mx-auto w-50">
        <input type="text" name="rut" id="rut" class="form-control mb-3" placeholder="Ej: 12345678-9" required
               value="<?= htmlspecialchars($_POST['rut'] ?? '') ?>">
        <button type="submit" class="btn btn-primary w-100">Validar</button>
    </form>

    <?php if ($mensaje): ?>
        <div class="alert alert-warning"><?= htmlspecialchars($mensaje) ?></div>
    <?php endif; ?>

    <?php if ($alumno): ?>
        <div class="alert alert-success">
            ✅ El alumno <strong><?= htmlspecialchars($alumno['nombre'] . ' ' . $alumno['apellido_paterno'] . ' ' . $alumno['apellido_materno']) ?></strong><br>
            RUT: <strong><?= htmlspecialchars($alumno['rut']) ?></strong><br>
            Curso: <strong><?= htmlspecialchars($alumno['curso_nombre'] ?? 'Sin curso asignado') ?></strong><br>
            se encuentra matriculado en la Escuela Porongo.
        </div>
    <?php endif; ?>

    <!-- Botón de volver al inicio -->
    <a href="https://inicio.escuelaporongo.cl" class="btn btn-secondary volver-btn">Volver al inicio</a>

</div>

<!-- Footer -->
<footer class="footer">
    &copy; <?= date('Y') ?> Escuela Porongo. Todos los derechos reservados.
</footer>

</body>
</html>
