<?php
header('Content-Type: text/html; charset=utf-8');
// session_start() está en auth.php
include '../includes/db.php';
include '../includes/auth.php';
checkAuth();

$conn->set_charset("utf8");

// Obtener cursos
$cursos = $conn->query("SELECT id, nombre FROM curso WHERE activo = 1 ORDER BY nombre ASC");

// Variables
$alumnos = [];
$nombre = $apellido_paterno = $apellido_materno = $rut = $curso = $numero_matricula = "";
$anio = date("Y");
$meses = [
    1 => 'enero', 2 => 'febrero', 3 => 'marzo', 4 => 'abril',
    5 => 'mayo', 6 => 'junio', 7 => 'julio', 8 => 'agosto',
    9 => 'septiembre', 10 => 'octubre', 11 => 'noviembre', 12 => 'diciembre'
];
$mes_actual = $meses[(int)date("m")];

// Obtener alumnos según curso
if (isset($_GET['curso_id'])) {
    $curso_id = filter_input(INPUT_GET, 'curso_id', FILTER_VALIDATE_INT);
    if ($curso_id) {
        $alumnos_query = $conn->prepare("
            SELECT id, CONCAT(apellido_paterno, ' ', apellido_materno, ' ', nombre) AS nombre_completo, rut 
            FROM usuario 
            WHERE curso_id = ? 
            AND rol_id = (SELECT id FROM roles WHERE nombre = 'estudiante') 
            ORDER BY apellido_paterno, apellido_materno, nombre
        ");
        $alumnos_query->bind_param("i", $curso_id);
        $alumnos_query->execute();
        $alumnos = $alumnos_query->get_result();
        $alumnos_query->close();
    }
}

// Generar certificado si se envía el formulario
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['alumno_id'])) {
    $alumno_id = filter_input(INPUT_POST, 'alumno_id', FILTER_VALIDATE_INT);
    $porcentaje_asistencia = filter_input(INPUT_POST, 'porcentaje_asistencia', FILTER_SANITIZE_SPECIAL_CHARS);
    $nuevo_colegio = filter_input(INPUT_POST, 'nuevo_colegio', FILTER_SANITIZE_SPECIAL_CHARS);
    $nombre_apoderado = filter_input(INPUT_POST, 'nombre_apoderado', FILTER_SANITIZE_SPECIAL_CHARS);
    $rut_apoderado = filter_input(INPUT_POST, 'rut_apoderado', FILTER_SANITIZE_SPECIAL_CHARS);
    $fecha_certificado = filter_input(INPUT_POST, 'fecha_certificado', FILTER_SANITIZE_SPECIAL_CHARS);
    $titulo_apoderado = filter_input(INPUT_POST, 'titulo_apoderado', FILTER_SANITIZE_SPECIAL_CHARS);
    $tipo_establecimiento = filter_input(INPUT_POST, 'tipo_establecimiento', FILTER_SANITIZE_SPECIAL_CHARS);
    $ciudad = filter_input(INPUT_POST, 'ciudad', FILTER_SANITIZE_SPECIAL_CHARS);
    $otra_ciudad = ($ciudad === "Otra") 
        ? filter_input(INPUT_POST, 'otra_ciudad', FILTER_SANITIZE_SPECIAL_CHARS) 
        : "";

    // Obtener los datos del alumno
    $stmt = $conn->prepare("SELECT nombre, apellido_paterno, apellido_materno, rut, (SELECT nombre FROM curso WHERE id = curso_id) AS curso 
                            FROM usuario WHERE id = ?");
    $stmt->bind_param("i", $alumno_id);
    $stmt->execute();
    $stmt->bind_result($nombre, $apellido_paterno, $apellido_materno, $rut, $curso);
    $stmt->fetch();
    $stmt->close();
    
    // Almacenar el HTML del certificado en una variable
    ob_start();
    ?>
    <!DOCTYPE html>
    <html lang="es">
    <head>
        <meta charset="UTF-8">
        <title>Certificado de Traslado</title>
        <link rel="stylesheet" href="../css/certificado_traslado.css">
    </head>
    <body>
        <img src="../images/INSIGNIA SF.png" alt="Escuela Porongo Insignia" class="insignia">
        <img src="../images/SLEP.jpeg" alt="Escuela Porongo Insignia" class="insignia right-insignia">

        <div class="header-text" style="line-height: 0.5;">
            <p>REPUBLICA DE CHILE</p>
            <p>PROVINCIA DE CAUQUENES</p>
            <p>SERVICIO LOCAL DE EDUCACIÓN PÚBLICA MAULE COSTA</p>
            <p>ESCUELA “PORONGO” F – 654 CAUQUENES</p>
            <p>EBG/emp /24.-</p>
        </div>

        <div class="content">
            <p style="text-align: center; font-weight: bold; font-size: 18px;">
                CERTIFICADO DE TRASLADO
            </p>
            <p style="line-height: 1.5; text-align: justify;">
                La Directora de la Escuela Porongo F-654 quién suscribe, certifica que 
                <b><?= htmlspecialchars(strtoupper($nombre . " " . $apellido_paterno . " " . $apellido_materno), ENT_QUOTES, 'UTF-8'); ?></b>, 
                R.U.N.: <b><?= htmlspecialchars($rut, ENT_QUOTES, 'UTF-8'); ?></b>, actualmente se encuentra matriculado(a) en este establecimiento educacional en 
                <b><?= htmlspecialchars($curso, ENT_QUOTES, 'UTF-8'); ?></b>, 
                para el registro <b><?= $anio; ?></b>, y con fecha 
                <b><?= date("d", strtotime($fecha_certificado)) . " de " . $meses[(int)date("m", strtotime($fecha_certificado))] . " de " . date("Y", strtotime($fecha_certificado)); ?></b>, su apoderado(a), 
                <b><?= htmlspecialchars($titulo_apoderado . ' ' . $nombre_apoderado, ENT_QUOTES, 'UTF-8'); ?></b>, 
                R.U.N.: <b><?= htmlspecialchars($rut_apoderado, ENT_QUOTES, 'UTF-8'); ?></b>, ha solicitado la cancelación de matrícula, aduciendo como motivo el cambio de establecimiento educacional, 
                <b><?= htmlspecialchars($tipo_establecimiento . " " . $nuevo_colegio, ENT_QUOTES, 'UTF-8'); ?></b> 
                <?php if ($ciudad === "Esta"): ?>
                    de esta ciudad.
                <?php else: ?>
                    en la ciudad de <b><?= htmlspecialchars($otra_ciudad, ENT_QUOTES, 'UTF-8'); ?></b>.
                <?php endif; ?>
                <br>La asistencia en lo que va corrido del año, es del <b><?= htmlspecialchars($porcentaje_asistencia, ENT_QUOTES, 'UTF-8'); ?>%</b>.
            </p>
        </div>

        <div class="footer" style="text-align: center; margin-top: 60px;">
            <div>
                <p style="margin-bottom: 0;">______________________________</p>
                <p><b>ELBA BARRUETO GARRO</b></p>
                <p><b>DIRECTOR(A)</b></p>
                <p><b>ESCUELA PORONGO</b></p>
            </div>
        </div>

        <div class="footer" style="text-align: left;">
            <p>Cauquenes, <?= date("d", strtotime($fecha_certificado)) . " de " . $meses[(int)date("m", strtotime($fecha_certificado))] . " de " . $anio; ?>.</p>
        </div>

        <div class="right-align no-print" style="text-align:center; margin-top:30px;">
            <button onclick="window.print()">🖨️ Imprimir Certificado</button>
            <button onclick="window.close()">❌ Cerrar Ventana</button>
        </div>

        <div class="footer" style="margin-top: 20px; text-align: center;">
            <p>Km 4, camino a Chanco - Cauquenes</p>
            <p>e-mail: porongo@slepmc.cl</p>
            <p>Teléfono: +56 44 285 7313</p>
        </div>
        
        <script>
            window.onload = function() {
                window.print(); // Lanza impresión automáticamente
            }
        </script>
    </body>
    </html>
    <?php
    $certificado_html = ob_get_clean();
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="../images/logo.png">
    <title>Certificado de Traslado</title>

    <link rel="stylesheet" href="../css/admin.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    
    <style>
        .form-grid-3col {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1.5rem;
        }
    </style>
</head>
<body>

<header>
    <div class="header-content">
        <img src="../images/INSIGNIA SF.png" alt="Escuela Porongo Insignia">
        <h1>Generar Certificado de Traslado</h1>
        <nav>
            <ul>
                <li><a href="../index.php"><i class="fas fa-home"></i> Inicio</a></li>
            </ul>
        </nav>
    </div>
</header>

<main class="container" style="margin-top: 2rem;">
    <div class="card form-container">
        <h2><i class="fas fa-file-export"></i> Generar Certificado</h2>

        <form method="GET" action="">
            <div class="form-group">
                <label for="curso_id"><i class="fas fa-university"></i> 1. Seleccionar Curso:</label>
                <select id="curso_id" name="curso_id" onchange="this.form.submit()" required>
                    <option value="">Seleccione un curso</option>
                    <?php 
                    $cursos->data_seek(0);
                    while ($curso_row = $cursos->fetch_assoc()): 
                    ?>
                        <option value="<?php echo htmlspecialchars($curso_row['id'], ENT_QUOTES, 'UTF-8'); ?>" 
                            <?php if (isset($_GET['curso_id']) && $_GET['curso_id'] == $curso_row['id']) echo 'selected'; ?>>
                            <?php echo htmlspecialchars($curso_row['nombre'], ENT_QUOTES, 'UTF-8'); ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>
            <noscript>
                <div class="form-buttons">
                    <button type="submit" class="btn btn-primary">Cargar Alumnos</button>
                </div>
            </noscript>
        </form>

        <?php if ($alumnos && $alumnos->num_rows > 0): ?>
        <hr style="margin: 2rem 0;">
        <form method="POST" action="">
            
            <h3 style="margin-bottom: 1.5rem; border-bottom: 2px solid var(--grey-light); padding-bottom: 0.5rem;">
                <i class="fas fa-user-edit"></i> 2. Completar Datos del Certificado
            </h3>
            
            <div class="form-grid-3col">
                <div class="form-group">
                    <label for="alumno_id"><i class="fas fa-user-graduate"></i> Alumno:</label>
                    <select id="alumno_id" name="alumno_id" required>
                        <option value="">Seleccione un alumno</option>
                        <?php while ($alumno = $alumnos->fetch_assoc()): ?>
                            <option value="<?php echo htmlspecialchars($alumno['id'], ENT_QUOTES, 'UTF-8'); ?>">
                                <?php echo htmlspecialchars($alumno['nombre_completo'], ENT_QUOTES, 'UTF-8'); ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>
                
                <div class="form-group">
                    <label for="titulo_apoderado"><i class="fas fa-user-tie"></i> Título Apoderado:</label>
                    <select id="titulo_apoderado" name="titulo_apoderado" required>
                        <option value="">Seleccione</option>
                        <option value="Sra.">Sra.</option>
                        <option value="Srta.">Srta.</option>
                        <option value="Sr.">Sr.</option>
                    </select>
                </div>
                
                <div class="form-group">
                    <label for="nombre_apoderado"><i class="fas fa-user-tie"></i> Nombre Apoderado:</label>
                    <input type="text" name="nombre_apoderado" id="nombre_apoderado" required>
                </div>

                <div class="form-group">
                    <label for="rut_apoderado"><i class="fas fa-id-card"></i> RUT Apoderado:</label>
                    <input type="text" name="rut_apoderado" id="rut_apoderado" required>
                </div>

                <div class="form-group">
                    <label for="porcentaje_asistencia"><i class="fas fa-percentage"></i> Porcentaje de Asistencia:</label>
                    <input type="number" name="porcentaje_asistencia" id="porcentaje_asistencia" min="0" max="100" required>
                </div>
                
                <div class="form-group">
                    <label for="fecha_certificado"><i class="fas fa-calendar-alt"></i> Fecha del Certificado:</label>
                    <input type="date" name="fecha_certificado" id="fecha_certificado" value="<?= date('Y-m-d') ?>" required>
                </div>

                <div class="form-group">
                    <label for="nuevo_colegio"><i class="fas fa-school"></i> Nuevo Establecimiento:</label>
                    <input type="text" name="nuevo_colegio" id="nuevo_colegio" required>
                </div>

                <div class="form-group">
                    <label for="tipo_establecimiento"><i class="fas fa-building"></i> Tipo de Establecimiento:</label>
                    <select id="tipo_establecimiento" name="tipo_establecimiento" required>
                        <option value="">Seleccione</Moption>
                        <option value="Escuela">Escuela</option>
                        <option value="Colegio">Colegio</option>
                        <option value="Liceo">Liceo</option>
                    </select>
                </div>

                <div class="form-group">
                    <label for="ciudad"><i class="fas fa-map-marker-alt"></i> Ciudad destino:</label>
                    <select id="ciudad" name="ciudad" required>
                        <option value="">Seleccione</option>
                        <option value="Esta">Esta ciudad (Cauquenes)</option>
                        <option value="Otra">Otra ciudad</option>
                    </select>
                </div>
            </div>
            
            <div class="form-group" id="otra_ciudad_container" style="display:none;">
                <label for="otra_ciudad"><i class="fas fa-city"></i> Especifique la ciudad:</label>
                <input type="text" name="otra_ciudad" id="otra_ciudad" placeholder="Ingrese la ciudad">
            </div>

            <div class="form-buttons">
                <button type="submit" class="btn btn-primary"><i class="fas fa-print"></i> Generar y Abrir Certificado</button>
            </div>
        </form>
        <?php endif; ?>

    </div>
</main>

<script>
    document.addEventListener("DOMContentLoaded", function() {
        const ciudadSelect = document.getElementById("ciudad");
        const otraCiudadContainer = document.getElementById("otra_ciudad_container");
        const otraCiudadInput = document.getElementById("otra_ciudad");

        function toggleOtraCiudad() {
            if (ciudadSelect.value === "Otra") {
                otraCiudadContainer.style.display = "block";
                otraCiudadInput.required = true;
            } else {
                otraCiudadContainer.style.display = "none";
                otraCiudadInput.required = false;
                otraCiudadInput.value = ""; // Limpiar el campo
            }
        }

        // Vincular el evento
        ciudadSelect.addEventListener('change', toggleOtraCiudad);
        
        // Ejecutar al cargar por si hay datos precargados (aunque en este form no aplica, es buena práctica)
        toggleOtraCiudad();
    });
</script>


<?php if (!empty($certificado_html)): ?>
    <script>
    // Abrir el certificado en una nueva ventana emergente
    var ventana = window.open('', '_blank', 'width=900,height=650,scrollbars=yes');
    ventana.document.write(<?= json_encode($certificado_html) ?>); // Usar json_encode para pasar el HTML de forma segura
    ventana.document.close();
    ventana.focus();
    // La impresión se activa por el script dentro del HTML del certificado
    </script>
<?php endif; ?>

</body>
</html>