<?php
header('Content-Type: text/html; charset=utf-8'); // Establecer la codificación de caracteres a UTF-8

include '../includes/db.php'; // Incluir la conexión a la base de datos
include '../includes/auth.php'; // Incluir funciones de autenticación
checkAuth(); // Verificar si el usuario está autenticado, redirigiendo si no lo está

// Obtener la lista de cursos en los que hay estudiantes activos
$stmt = $conn->prepare("SELECT DISTINCT curso.id, curso.nombre 
                        FROM usuario 
                        JOIN curso ON usuario.curso_id = curso.id 
                        WHERE usuario.rol_id = (SELECT id FROM roles WHERE nombre = 'estudiante')
                        AND usuario.activo = 1
                        AND curso.activo = 1
                        ORDER BY curso.nombre ASC"); // Ordenar por el nombre del curso en orden ascendente
$stmt->execute(); // Ejecutar la consulta
$cursos = $stmt->get_result(); // Obtener los resultados

// Obtener la lista de años en los que hay notas
$stmt_years = $conn->prepare("SELECT DISTINCT YEAR(fecha) AS anio FROM notas ORDER BY anio DESC");
$stmt_years->execute();
$years = $stmt_years->get_result(); // Obtener los resultados de los años

// Obtener la lista de alumnos si un curso ha sido seleccionado
$alumnos = [];
if (isset($_GET['curso_id'])) { // Verificar si se ha seleccionado un curso
    $curso_id = filter_input(INPUT_GET, 'curso_id', FILTER_VALIDATE_INT); // Validar el ID del curso
    if ($curso_id) { // Si el ID del curso es válido
        // Ajustar la consulta para ordenar por apellido paterno, luego materno y al final nombre
        $stmt_alumnos = $conn->prepare("SELECT id, CONCAT(apellido_paterno, ' ', apellido_materno, ' ', nombre) AS nombre_completo 
                                 FROM usuario 
                                 WHERE curso_id = ? 
                                 AND rol_id = (SELECT id FROM roles WHERE nombre = 'estudiante') 
                                 AND activo = 1
                                 ORDER BY apellido_paterno, apellido_materno, nombre"); // Agregar ordenamiento
        $stmt_alumnos->bind_param("i", $curso_id); // Vincular el parámetro del curso
        $stmt_alumnos->execute(); // Ejecutar la consulta
        $alumnos = $stmt_alumnos->get_result(); // Obtener los resultados
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="../images/logo.png">
    <title>Generar Informes</title>
    
    <link rel="stylesheet" href="../css/admin.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    
    <style>
        .form-grid-3col {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1.5rem;
        }
    </style>
</head>
<body>
    
<header>
    <div class="header-content">
        <img src="../images/INSIGNIA%20SF.png" alt="Logo de la Empresa">
        <h1>Generar Informe de Notas</h1>
        <nav>
            <ul>
                <li><a href="../index.php"><i class="fas fa-home"></i> Inicio</a></li>
            </ul>
        </nav>
    </div>
</header>

<main class="container">
    
    <div class="card form-container">
        <h2><i class="fas fa-filter"></i> Paso 1: Seleccionar Curso</h2>
        <form method="GET" action="select_report.php">
            <div class="form-group">
                <label for="curso_id"><i class="fas fa-university"></i> Curso:</label>
                <select id="curso_id" name="curso_id" onchange="this.form.submit()">
                    <option value="">Seleccione un curso</option>
                    <?php while ($curso = $cursos->fetch_assoc()): ?>
                        <option value="<?php echo htmlspecialchars($curso['id'], ENT_QUOTES, 'UTF-8'); ?>" <?php if (isset($_GET['curso_id']) && $_GET['curso_id'] == $curso['id']) echo 'selected'; ?>>
                            <?php echo htmlspecialchars($curso['nombre'], ENT_QUOTES, 'UTF-8'); ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>
            <noscript>
                <div class="form-buttons">
                    <button type="submit" class="btn btn-primary">Cargar Alumnos</button>
                </div>
            </noscript>
        </form>
    </div>

    <?php if ($alumnos && $alumnos->num_rows > 0): ?>
        <div class="card form-container" style="margin-top: 2rem;">
            <h2><i class="fas fa-user-graduate"></i> Opción A: Informe Individual</h2>
            <form method="GET" action="reports.php">
                <input type="hidden" name="curso_id" value="<?php echo htmlspecialchars($_GET['curso_id'], ENT_QUOTES, 'UTF-8'); ?>">

                <div class="form-grid-3col">
                    <div class="form-group">
                        <label for="alumno"><i class="fas fa-user"></i> Seleccionar Alumno:</label>
                        <select id="alumno" name="alumno_id" required>
                            <option value="">Seleccione un alumno</option>
                            <?php while ($alumno = $alumnos->fetch_assoc()): ?>
                                <option value="<?php echo htmlspecialchars($alumno['id'], ENT_QUOTES, 'UTF-8'); ?>"><?php echo htmlspecialchars($alumno['nombre_completo'], ENT_QUOTES, 'UTF-8'); ?></option>
                            <?php endwhile; ?>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="semestre_ind"><i class="fas fa-chart-pie"></i> Seleccionar Semestre:</label>
                        <select id="semestre_ind" name="semestre" required>
                            <option value="1">Primer Semestre</option>
                            <option value="2">Segundo Semestre</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="anio_ind"><i class="fas fa-calendar-alt"></i> Seleccionar Año:</label>
                        <select id="anio_ind" name="anio" required>
                            <option value="">Seleccione un año</option>
                            <?php 
                            $stmt_years->execute(); // Re-ejecutar para el loop
                            $years_loop1 = $stmt_years->get_result();
                            while ($year = $years_loop1->fetch_assoc()): 
                            ?>
                                <option value="<?php echo htmlspecialchars($year['anio'], ENT_QUOTES, 'UTF-8'); ?>"><?php echo htmlspecialchars($year['anio'], ENT_QUOTES, 'UTF-8'); ?></option>
                            <?php endwhile; ?>
                        </select>
                    </div>
                </div>

                <div class="form-buttons">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-file-pdf"></i> Generar Informe Individual
                    </button>
                </div>
            </form>
        </div>
    <?php endif; ?>

    <?php if ($alumnos && $alumnos->num_rows > 0): ?>
        <div class="card form-container" style="margin-top: 2rem;">
            <h2><i class="fas fa-users"></i> Opción B: Informe Grupal</h2>
            <form method="GET" action="reports_all.php">
                <input type="hidden" name="curso_id" value="<?php echo htmlspecialchars($_GET['curso_id'], ENT_QUOTES, 'UTF-8'); ?>">
                
                <div class="form-grid">
                    <div class="form-group">
                        <label for="semestre_all"><i class="fas fa-chart-pie"></i> Seleccionar Semestre:</label>
                        <select id="semestre_all" name="semestre" required>
                            <option value="1">Primer Semestre</option>
                            <option value="2">Segundo Semestre</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="anio_all"><i class="fas fa-calendar-alt"></i> Seleccionar Año:</label>
                        <select id="anio_all" name="anio" required>
                            <option value="">Seleccione un año</option>
                            <?php 
                            $stmt_years->execute(); // Re-ejecutar para el loop
                            $years_loop2 = $stmt_years->get_result();
                            while ($year = $years_loop2->fetch_assoc()): 
                            ?>
                                <option value="<?php echo htmlspecialchars($year['anio'], ENT_QUOTES, 'UTF-8'); ?>"><?php echo htmlspecialchars($year['anio'], ENT_QUOTES, 'UTF-8'); ?></option>
                            <?php endwhile; ?>
                        </select>
                    </div>
                </div>

                <div class="form-buttons">
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-file-archive"></i> Generar Todos los Informes (PDF)
                    </button>
                </div>
            </form>
        </div>
    <?php endif; ?>
        
</div>
</body>
</html>