<?php
session_start();
header('Content-Type: text/html; charset=utf-8');
setlocale(LC_TIME, 'es_ES.UTF-8', 'es_ES', 'Spanish_Spain', 'es', 'esp');
include '../includes/db.php';
include '../includes/auth.php';
checkAuth();

$conn->set_charset("utf8");

// AÑADIDO: Manejo de mensajes de sesión
$message = '';
$message_type = '';
if (isset($_SESSION['message'])) {
    $message = $_SESSION['message'];
    $message_type = $_SESSION['message_type'];
    unset($_SESSION['message'], $_SESSION['message_type']);
}

$curso_id = isset($_GET['curso_id']) ? intval($_GET['curso_id']) : null;
$semestre = isset($_GET['semestre']) ? $_GET['semestre'] : 'all';

if (!$curso_id) {
    die('No se proporcionó un ID de curso');
}

// Obtener los estudiantes del curso
$stmt = $conn->prepare("SELECT usuario.id AS alumno_id, 
                               usuario.rut, 
                               CONCAT(usuario.nombre, ' ', usuario.apellido_paterno, ' ', usuario.apellido_materno) AS nombre_completo, 
                               curso.nombre AS curso
                        FROM usuario 
                        JOIN curso ON usuario.curso_id = curso.id
                        WHERE usuario.rol_id = (SELECT id FROM roles WHERE nombre = 'estudiante')
                        AND curso.id = ?");
$stmt->bind_param('i', $curso_id);
$stmt->execute();
$estudiantes = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt->close();

if (!$estudiantes) {
    die('No se encontraron estudiantes en este curso');
}

// Obtener el nombre completo del profesor jefe
$stmt = $conn->prepare("SELECT CONCAT(usuario.nombre, ' ', usuario.apellido_paterno, ' ', usuario.apellido_materno) AS nombre_completo 
                        FROM usuario 
                        JOIN curso ON curso.profesor_jefe_id = usuario.id 
                        WHERE curso.id = ?");
$stmt->bind_param('i', $curso_id);
$stmt->execute();
$profesor_jefe = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$profesor_jefe) {
    die('Profesor jefe no encontrado');
}

// Obtener las notas de todos los estudiantes
$notas_por_estudiante = [];
foreach ($estudiantes as $estudiante) {
    $alumno_id = $estudiante['alumno_id'];
    $sql = "
    SELECT asignatura.nombre AS asignatura, 
           notas.nota, 
           NULL AS indicador, 
           notas.numero_nota, 
           notas.semestre 
    FROM notas 
    JOIN asignatura ON notas.asignatura_id = asignatura.id 
    WHERE notas.usuario_id = ? AND notas.semestre = ? 
    UNION
    SELECT asignatura.nombre AS asignatura, 
           NULL AS nota, 
           indicadores.nombre AS indicador, 
           notas_indicadores.numero_nota, 
           notas_indicadores.semestre 
    FROM notas_indicadores 
    JOIN asignatura ON notas_indicadores.asignatura_id = asignatura.id 
    JOIN indicadores ON notas_indicadores.indicador_id = indicadores.id 
    WHERE notas_indicadores.usuario_id = ? AND notas_indicadores.semestre = ? 
    ORDER BY asignatura, numero_nota";

    if ($semestre === 'all') {
        $stmt = $conn->prepare($sql);
        $stmt->bind_param('ii', $alumno_id, $alumno_id);
    } else {
        $stmt = $conn->prepare($sql);
        $stmt->bind_param('iiii', $alumno_id, $semestre, $alumno_id, $semestre);
    }
    $stmt->execute();
    $notas = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
    $stmt->close();

    foreach ($notas as $nota) {
        $notas_por_estudiante[$alumno_id][$nota['asignatura']][$nota['semestre']][$nota['numero_nota']] = $nota['nota'] ?? $nota['indicador'];
    }
}

// Función para calcular promedios (Tu lógica original)
function calcular_promedio($notas) {
    $notas = array_filter($notas, 'is_numeric');
    if (count($notas) === 0) return 0;
    return number_format(array_sum($notas) / count($notas), 1);
}
function promedio_indicadores($indicadores) {
    $puntajes = [];
    foreach ($indicadores as $indicador) {
        switch ($indicador) {
            case 'MB': $puntajes[] = 7.0; break;
            case 'B':  $puntajes[] = 5.5; break;
            case 'S':  $puntajes[] = 4.5; break;
            case 'I':  $puntajes[] = 2.5; break;
        }
    }
    if (empty($puntajes)) return 'I';
    $promedio = array_sum($puntajes) / count($puntajes);
    if ($promedio >= 6.0) return 'MB';
    elseif ($promedio >= 5.0) return 'B';
    elseif ($promedio >= 4.0) return 'S';
    else return 'I';
}

// --- Lógica de Fecha (Tu lógica original) ---
$meses = ['January' => 'Enero', 'February' => 'Febrero', 'March' => 'Marzo', 'April' => 'Abril', 'May' => 'Mayo', 'June' => 'Junio', 'July' => 'Julio', 'August' => 'Agosto', 'September' => 'Septiembre', 'October' => 'Octubre', 'November' => 'Noviembre', 'December' => 'Diciembre'];
$dias = ['Monday' => 'Lunes', 'Tuesday' => 'Martes', 'Wednesday' => 'Miércoles', 'Thursday' => 'Jueves', 'Friday' => 'Viernes', 'Saturday' => 'Sábado', 'Sunday' => 'Domingo'];
$dia_semana = $dias[date('l')];
$dia_numero = date('d');
$mes_actual = $meses[date('F')];
$anio_actual = date('Y');
setlocale(LC_TIME, 'es_ES.UTF-8', 'es_ES', 'Spanish_Spain', 'es', 'esp');
$fecha_actual = ucfirst(strftime('%A, %e de %B de %Y'));

// --- Lógica POST (MODIFICADA con mensajes de sesión y redirección) ---
if (isset($_POST['calcular_asistencia'])) {
    $alumno_id = $_POST['calcular_asistencia'];
    $dias_totales = isset($_POST['dias_totales_' . $alumno_id]) ? intval($_POST['dias_totales_' . $alumno_id]) : 0;
    $dias_asistidos = isset($_POST['dias_asistidos_' . $alumno_id]) ? intval($_POST['dias_asistidos_' . $alumno_id]) : 0;
    $dias_no_asistidos = $dias_totales - $dias_asistidos;
    $porcentaje_asistencia = $dias_totales > 0 ? number_format(($dias_asistidos / $dias_totales) * 100, 2) : 0;

    $_SESSION['asistencias'][$alumno_id] = [
        'dias_totales' => $dias_totales,
        'dias_asistidos' => $dias_asistidos,
        'dias_no_asistidos' => $dias_no_asistidos,
        'porcentaje' => $porcentaje_asistencia,
    ];
    
    $_SESSION['message'] = 'Asistencia calculada para el alumno ' . $alumno_id;
    $_SESSION['message_type'] = 'exito';
    header("Location: " . $_SERVER['REQUEST_URI']);
    exit();
}

if (isset($_POST['guardar_observacion'])) {
    $alumno_id = $_POST['guardar_observacion'];
    $observacion = isset($_POST['observaciones_' . $alumno_id]) ? trim($_POST['observaciones_' . $alumno_id]) : '';
    $_SESSION['observaciones'][$alumno_id] = $observacion;
    
    $_SESSION['message'] = 'Observación guardada para el alumno ' . $alumno_id;
    $_SESSION['message_type'] = 'exito';
    header("Location: " . $_SERVER['REQUEST_URI']);
    exit();
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="../images/logo.png">
    <title>Informe de Notas (Curso Completo)</title>

    <link rel="stylesheet" href="../css/admin.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">

    <link rel="stylesheet" href="../css/certificado_notas.css">
    
    <style>
        @media print {
            header.no-imprimir { display: none !important; }
            main.container { margin: 0 !important; padding: 0 !important; background: none !important; }
            div.card { box-shadow: none !important; border: none !important; padding: 0 !important; background: none !important; }
            .no-imprimir { display: none !important; }
            .mensaje-flotante { display: none !important; }
            .alumno-informe { page-break-before: always; }
            .alumno-informe:first-child { page-break-before: auto; }
            body { background-color: #fff !important; }
        }
    </style>
</head>
<body>
    
<div class="mensaje-flotante no-imprimir" id="mensajeNota">
    <span class="cerrar" onclick="this.parentElement.style.display='none';">&times;</span>
    <strong>Nota importante:</strong><br>
    Para que el informe quede en una hoja, debe cambiar la escala de impresión a un <strong>75%</strong>
</div>

<header class="header-doble-logo no-imprimir">
    <div class="header-content">
        <img src="../images/INSIGNIA%20SF.png" alt="Logo Izquierdo">
        <h1>Informe de Notas (Curso Completo)</h1>
        <nav>
            <ul>
                <li><a href="../index.php"><i class="fas fa-home"></i> Inicio</a></li>
                <li><a href="select_report.php"><i class="fas fa-arrow-left"></i> Volver</a></li>
            </ul>
        </nav>
    </div>
</header>
    
<main class="container">
    <div class="card" style="padding: 2rem;">

        <?php if ($message): ?>
            <div class="mensaje <?php echo $message_type; ?> show no-imprimir">
                <?php echo htmlspecialchars($message, ENT_QUOTES, 'UTF-8'); ?>
            </div>
        <?php endif; ?>

        <div class="right-align no-imprimir" style="text-align: right; margin-bottom: 2rem;">
            <button onclick="window.print()" class="btn btn-primary">
                <i class="fas fa-print"></i> Imprimir Todos los Informes
            </button>
        </div>

        <?php foreach ($estudiantes as $estudiante): 
            $promedios_finales = []; // Reinicia por estudiante
            $alumno_id_loop = $estudiante['alumno_id'];
        ?>
        <div class="alumno-informe">
            <div class="header-doble-logo" style="display:flex; align-items:center; justify-content:space-between; margin-bottom: 15px;">
                <div class="logo-izquierdo"><img src="../images/INSIGNIA%20SF.png" alt="Logo Izquierdo" style="height: 60px;"></div>
                <div class="titulo-centro" style="text-align:center; flex-grow:1;"><h1 style="margin:0;">Informe de Notas</h1></div>
                <div class="logo-derecho"><img src="../images/SLEP.jpeg" alt="Logo Derecho" style="height: 60px;"></div>
            </div>
            
            <div class="header-impresion">
                <div class="info-alumno">
                    <strong>RUT:</strong> <?php echo htmlspecialchars($estudiante['rut'], ENT_QUOTES, 'UTF-8'); ?><br>
                    <strong>Alumno:</strong> <?php echo htmlspecialchars($estudiante['nombre_completo'], ENT_QUOTES, 'UTF-8'); ?><br>
                    <strong>Curso:</strong> <?php echo htmlspecialchars($estudiante['curso'], ENT_QUOTES, 'UTF-8'); ?><br>
                    <strong>Profesor Jefe:</strong> <?php echo htmlspecialchars($profesor_jefe['nombre_completo'], ENT_QUOTES, 'UTF-8'); ?>
                </div>
                <div class="info-semestre">
                    <strong>Notas Parciales:</strong> <?php echo ($semestre == 2) ? 'Segundo Semestre' : 'Primer Semestre'; ?><br>
                    <div class="ocultar-fecha">
                        <strong>Fecha:</strong> <?php echo $fecha_actual; ?><br> 
                    </div>
                </div>
            </div>
            
            <table>
                <thead>
                    <tr>
                        <th>Asignaturas</th>
                        <?php for ($i = 1; $i <= 10; $i++): ?>
                            <th>N<?php echo $i; ?></th>
                        <?php endfor; ?>
                        <th>Promedio Parcial</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $orden_asignaturas = [
                        'Lengua y Literatura', 'Lenguaje y Comunicación', 'Inglés', 'Matemática',
                        'Ciencias Naturales', 'Historia, Geografía y Ciencias Sociales', 'Tecnología',
                        'Artes Visuales', 'Música', 'Educación Física y Salud', 'Orientación', 'Religión' 
                    ];
                    $notas_ordenadas = [];
                    foreach ($orden_asignaturas as $asig_nombre) {
                        if (isset($notas_por_estudiante[$alumno_id_loop][$asig_nombre])) {
                            $notas_ordenadas[$asig_nombre] = $notas_por_estudiante[$alumno_id_loop][$asig_nombre];
                        }
                    }

                    foreach ($notas_ordenadas as $asignatura => $semestres):
                    ?>
                        <tr>
                            <td><?php echo htmlspecialchars($asignatura, ENT_QUOTES, 'UTF-8'); ?></td>
                            <?php 
                            $notas_semestre_actual = isset($semestres[$semestre]) ? $semestres[$semestre] : [];
                            $promedio_final = '';
                            $es_indicador = (in_array($asignatura, ['Religión', 'Orientación']));

                            for ($i = 1; $i <= 10; $i++): ?>
                                <td>
                                    <?php echo isset($notas_semestre_actual[$i]) ? htmlspecialchars($notas_semestre_actual[$i], ENT_QUOTES, 'UTF-8') : '—'; ?>
                                </td>
                            <?php endfor; ?>
                            
                            <td>
                                <?php
                                if ($es_indicador) {
                                    $promedio_final = promedio_indicadores($notas_semestre_actual);
                                    echo htmlspecialchars($promedio_final, ENT_QUOTES, 'UTF-8');
                                } else {
                                    $promedio_final = calcular_promedio($notas_semestre_actual);
                                    echo htmlspecialchars($promedio_final, ENT_QUOTES, 'UTF-8');
                                    if ($promedio_final > 0) {
                                        $promedios_finales[] = $promedio_final;
                                    }
                                }
                                ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
                <tfoot>
                    <tr>
                        <td><strong>Promedio Total</strong></td>
                        <td colspan="10"></td>
                        <td><strong><?php echo calcular_promedio($promedios_finales); ?></strong></td>
                    </tr>
                </tfoot>
            </table>
            
            <div class="asistencia-info no-imprimir" style="margin-top: 2rem;">
                <h3 style="font-size: 1.1rem; font-weight: 700;">Registro de Asistencia (Para <?php echo htmlspecialchars($estudiante['nombre_completo']); ?>)</h3>
                <form method="POST" action="">
                    <div class="form-grid" style="grid-template-columns: 1fr 1fr 1fr; align-items: flex-end;">
                        <div class="form-group">
                            <label for="dias_totales_<?php echo $alumno_id_loop; ?>"><i class="fas fa-calendar-day"></i> Días Totales:</label>
                            <input type="number" name="dias_totales_<?php echo $alumno_id_loop; ?>" id="dias_totales_<?php echo $alumno_id_loop; ?>" value="<?php echo $_SESSION['asistencias'][$alumno_id_loop]['dias_totales'] ?? '0'; ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="dias_asistidos_<?php echo $alumno_id_loop; ?>"><i class="fas fa-user-check"></i> Días Asistidos:</label>
                            <input type="number" name="dias_asistidos_<?php echo $alumno_id_loop; ?>" id="dias_asistidos_<?php echo $alumno_id_loop; ?>" value="<?php echo $_SESSION['asistencias'][$alumno_id_loop]['dias_asistidos'] ?? '0'; ?>" required>
                        </div>
                        <div class="form-buttons">
                            <button type="submit" name="calcular_asistencia" value="<?= $alumno_id_loop ?>" class="btn btn-primary">
                                <i class="fas fa-calculator"></i> Calcular
                            </button>
                        </div>
                    </div>
                </form>
            </div>

            <?php if (isset($_SESSION['asistencias'][$alumno_id_loop])): 
                $datos = $_SESSION['asistencias'][$alumno_id_loop]; 
            ?>
            <div class="asistencia-results" style="margin-top: 1rem;">
                <p>Días Totales: <?= $datos['dias_totales'] ?> | Días Asistidos: <?= $datos['dias_asistidos'] ?> | Días No Asistidos: <?= $datos['dias_no_asistidos'] ?> | <strong>Porcentaje: <?= $datos['porcentaje'] ?>%</strong></p>
            </div>
            <?php endif; ?>

            <form method="POST" action="" class="no-imprimir">
                <div class="observation-section" style="margin-top: 1.5rem;">
                    <div class="form-group">
                        <label for="observaciones_<?php echo $alumno_id_loop; ?>"><i class="fas fa-edit"></i> Observaciones (Para <?php echo htmlspecialchars($estudiante['nombre_completo']); ?>):</label>
                        <textarea id="observaciones_<?php echo $alumno_id_loop; ?>" name="observaciones_<?php echo $alumno_id_loop; ?>" placeholder="Escribe aquí cualquier observación..."><?php 
                            echo isset($_SESSION['observaciones'][$alumno_id_loop]) 
                                ? htmlspecialchars($_SESSION['observaciones'][$alumno_id_loop], ENT_QUOTES, 'UTF-8') 
                                : ''; 
                        ?></textarea>
                    </div>
                    <div class="form-buttons">
                        <button type="submit" name="guardar_observacion" value="<?= $alumno_id_loop ?>" class="btn btn-secondary">
                            <i class="fas fa-save"></i> Guardar Observación
                        </button>
                    </div>
                </div>
            </form>

            <div class="signature-section">
                <strong>Cauquenes, <?php echo $fecha_actual; ?></strong>
            </div>
            <div class="signatures">
                <div class="signature">
                    <strong>_________________________</strong><br>
                    <strong>Firma del Profesor Jefe</strong>
                </div>
                <div class="utp-signature">
                    <strong>Visto Bueno UTP</strong>
                </div>
            </div>

        </div> <?php endforeach; ?>
        
        <div class="right-align no-imprimir" style="text-align: right; margin-top: 2rem; border-top: 2px solid var(--grey-light); padding-top: 2rem;">
            <button onclick="window.print()" class="btn btn-primary">
                <i class="fas fa-print"></i> Imprimir Todos los Informes
            </button>
        </div>
        
    </div> </main> 

<script>
window.onload = function() {
    const message = document.querySelector('.mensaje');
    if (message) {
        setTimeout(() => {
            message.classList.remove('show');
        }, 3000);
    }
};
</script>
</body>
</html>