<?php
header('Content-Type: text/html; charset=utf-8');
include '../includes/db.php';
include '../includes/auth.php';
checkAuth();

// Establecer la codificación de caracteres para la conexión de la base de datos
$conn->set_charset("utf8");

$alumno_id = isset($_GET['alumno_id']) ? intval($_GET['alumno_id']) : null;
$curso_id = isset($_GET['curso_id']) ? intval($_GET['curso_id']) : null;
$semestre = isset($_GET['semestre']) ? $_GET['semestre'] : 'all';

if (!$alumno_id || !$curso_id) {
    die('No se proporcionó un ID de alumno o curso');
}

// Obtener información completa del alumno
$stmt = $conn->prepare("SELECT usuario.rut, 
                                CONCAT(usuario.nombre, ' ', usuario.apellido_paterno, ' ', usuario.apellido_materno) AS nombre_completo, 
                                curso.nombre as curso
                        FROM usuario 
                        JOIN curso ON usuario.curso_id = curso.id
                        WHERE usuario.id = ? 
                        AND usuario.rol_id = (SELECT id FROM roles WHERE nombre = 'estudiante')");
$stmt->bind_param('i', $alumno_id);
$stmt->execute();
$alumno = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$alumno) {
    die('Alumno no encontrado');
}

// Obtener el nombre completo del profesor jefe
$stmt = $conn->prepare("SELECT CONCAT(usuario.nombre, ' ', usuario.apellido_paterno, ' ', usuario.apellido_materno) AS nombre_completo 
                        FROM usuario 
                        JOIN curso ON curso.profesor_jefe_id = usuario.id 
                        WHERE curso.id = ?");
$stmt->bind_param('i', $curso_id);
$stmt->execute();
$profesor_jefe = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$profesor_jefe) {
    die('Profesor jefe no encontrado');
}

// --- Lógica de Notas (Tu código original, es complejo y se mantiene) ---
$where_clause = $semestre === 'all' ? '' : "AND (notas.semestre = ? OR notas_indicadores.semestre = ?)";

$sql = "
    SELECT * FROM (
        SELECT asignatura.nombre AS asignatura, 
               notas.nota, 
               NULL AS indicador, 
               notas.numero_nota, 
               notas.semestre 
        FROM notas 
        JOIN asignatura ON notas.asignatura_id = asignatura.id 
        WHERE notas.usuario_id = ? AND notas.semestre = ?

        UNION

        SELECT asignatura.nombre AS asignatura, 
               NULL AS nota, 
               indicadores.nombre AS indicador, 
               notas_indicadores.numero_nota, 
               notas_indicadores.semestre 
        FROM notas_indicadores 
        JOIN asignatura ON notas_indicadores.asignatura_id = asignatura.id 
        JOIN indicadores ON notas_indicadores.indicador_id = indicadores.id 
        WHERE notas_indicadores.usuario_id = ? AND notas_indicadores.semestre = ?
    ) AS combined_results
    ORDER BY asignatura, numero_nota";

if ($semestre === 'all') {
    $stmt = $conn->prepare($sql);
    $stmt->bind_param('ii', $alumno_id, $alumno_id);
} else {
    $stmt = $conn->prepare($sql);
    $stmt->bind_param('iiii', $alumno_id, $semestre, $alumno_id, $semestre);
}
$stmt->execute();
$notas = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt->close();

// Organizar las notas
$notas_por_asignatura = [];
foreach ($notas as $nota) {
    $notas_por_asignatura[$nota['asignatura']][$nota['semestre']][$nota['numero_nota']] = $nota['nota'] ?? $nota['indicador'];
}

// Funciones de cálculo (Tu código original)
function calcular_promedio($notas) {
    if (empty($notas)) {
        return 0;
    }
    // Filtrar solo valores numéricos (ignora 'MB', 'B', 'S', 'I')
    $notas_numericas = array_filter($notas, 'is_numeric');
    if (empty($notas_numericas)) {
        return 0;
    }
    return number_format(array_sum($notas_numericas) / count($notas_numericas), 1);
}
function promedio_indicadores($indicadores) {
    $puntajes = [];
    foreach ($indicadores as $indicador) {
        switch ($indicador) {
            case 'MB': $puntajes[] = 7.0; break;
            case 'B':  $puntajes[] = 5.5; break;
            case 'S':  $puntajes[] = 4.5; break;
            case 'I':  $puntajes[] = 2.5; break;
        }
    }
    if (empty($puntajes)) return 'I'; // Default si no hay indicadores
    $promedio = array_sum($puntajes) / count($puntajes);

    if ($promedio >= 6.0) return 'MB';
    elseif ($promedio >= 5.0) return 'B';
    elseif ($promedio >= 4.0) return 'S';
    else return 'I';
}

// ... (Tu lógica de fecha y asistencia) ...
$meses = ['January'=>'Enero', 'February'=>'Febrero', 'March'=>'Marzo', 'April'=>'Abril', 'May'=>'Mayo', 'June'=>'Junio', 'July'=>'Julio', 'August'=>'Agosto', 'September'=>'Septiembre', 'October'=>'Octubre', 'November'=>'Noviembre', 'December'=>'Diciembre'];
$dias = ['Monday'=>'Lunes', 'Tuesday'=>'Martes', 'Wednesday'=>'Miércoles', 'Thursday'=>'Jueves', 'Friday'=>'Viernes', 'Saturday'=>'Sábado', 'Sunday'=>'Domingo'];
$dia_semana = $dias[date('l')];
$dia_numero = date('d');
$mes_actual = $meses[date('F')];
$anio_actual = date('Y');
$fecha_actual = "$dia_semana, $dia_numero de $mes_actual de $anio_actual";

$dias_totales = 0;
$dias_asistidos = 0;
$dias_no_asistidos = 0;

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $dias_totales = intval($_POST['dias_totales']);
    $dias_asistidos = intval($_POST['dias_asistidos']);
    $dias_no_asistidos = $dias_totales - $dias_asistidos;
}
$porcentaje_asistencia = $dias_totales > 0 ? number_format(($dias_asistidos / $dias_totales) * 100, 2) : 0;
setlocale(LC_TIME, 'es_ES.UTF-8');
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="../images/logo.png">
    <title>Informe de Notas</title>
    
    <link rel="stylesheet" href="../css/admin.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">

    <link rel="stylesheet" href="../css/certificado_notas.css">
    
    <style>
        /* Ocultar el header de admin.css y el mensaje flotante al imprimir */
        @media print {
            /* Ocultar la barra de navegación oscura */
            header {
                display: none !important;
            }
            /* Ocultar el contenedor <main> y la tarjeta, mostrar solo el informe */
            main.container {
                margin: 0 !important;
                padding: 0 !important;
            }
            div.card {
                box-shadow: none !important;
                border: none !important;
                padding: 0 !important;
            }
            /* Ocultar elementos de UI */
            .no-imprimir {
                display: none !important;
            }
            .mensaje-flotante {
                display: none !important;
            }
            /* Mostrar el encabezado del informe (logos) */
            .header-doble-logo {
                display: flex !important;
            }
            /* Asegurar que el salto de página ocurra antes de cada estudiante (si aplicara) */
            .alumno-informe {
                page-break-before: always;
            }
        }
    </style>
</head>
<body>

<div class="mensaje-flotante no-imprimir" id="mensajeNota">
    <span class="cerrar" onclick="this.parentElement.style.display='none';">&times;</span>
    <strong>Nota importante:</strong><br>
    Para que el informe quede en una hoja, debe cambiar la escala de impresión a un <strong>66%</strong><br>
    De lo contrario el informe ocupará 2 hojas.
</div>

<header class="no-imprimir">
    <div class="header-content">
        <img src="../images/INSIGNIA%20SF.png" alt="Logo de la Empresa">
        <h1>Informe de Notas</h1>
        <nav>
            <ul>
                <li><a href="../index.php"><i class="fas fa-home"></i> Inicio</a></li>
                <li><a href="select_report.php"><i class="fas fa-arrow-left"></i> Volver</a></li>
            </ul>
        </nav>
    </div>
</header>

<main class="container">
    <div class="card" style="padding: 2rem;">
    
        <div class="header-doble-logo" style="display:flex; align-items:center; justify-content:space-between; margin-bottom: 15px;">
            <div class="logo-izquierdo">
                <img src="../images/INSIGNIA%20SF.png" alt="Logo Izquierdo" style="height: 60px;">
            </div>
            <div class="titulo-centro" style="text-align:center; flex-grow:1;">
                <h1 style="margin:0;">Informe de Notas</h1>
            </div>
            <div class="logo-derecho">
                <img src="../images/SLEP.jpeg" alt="Logo Derecho" style="height: 60px;">
            </div>
        </div>
        
        <div class="header-impresion">
            <div class="info-alumno">
                <strong>RUT:</strong> <?php echo htmlspecialchars($alumno['rut'], ENT_QUOTES, 'UTF-8'); ?><br>
                <strong>Alumno:</strong> <?php echo htmlspecialchars($alumno['nombre_completo'], ENT_QUOTES, 'UTF-8'); ?><br>
                <strong>Curso:</strong> <?php echo htmlspecialchars($alumno['curso'], ENT_QUOTES, 'UTF-8'); ?><br>
                <strong>Profesor Jefe:</strong> <?php echo htmlspecialchars($profesor_jefe['nombre_completo'], ENT_QUOTES, 'UTF-8'); ?>
            </div>
            <div class="info-semestre">
                <strong>Notas Parciales:</strong> <?php echo ($semestre == 2) ? 'Segundo Semestre' : 'Primer Semestre'; ?><br>
                <div class="ocultar-fecha">
                    <strong>Fecha:</strong> <?php echo ucfirst(strftime('%A, %e de %B de %Y')); ?><br> 
                </div>
            </div>
        </div>
        
        <table>
            <thead>
                <tr>
                    <th>Asignaturas</th>
                    <?php for ($i = 1; $i <= 10; $i++): ?>
                        <th>N<?php echo $i; ?></th>
                    <?php endfor; ?>
                    <th>Promedio Parcial</th>
                </tr>
            </thead>
            <tbody>
                <?php
                // Orden deseado de las asignaturas
                $orden_asignaturas = [
                    'Lengua y Literatura', 'Lenguaje y Comunicación', 'Inglés', 'Matemática',
                    'Ciencias Naturales', 'Historia, Geografía y Ciencias Sociales', 'Tecnología',
                    'Artes Visuales', 'Música', 'Educación Física y Salud', 'Orientación', 'Religión' 
                ];

                // Reordenar las asignaturas
                $notas_ordenadas = [];
                foreach ($orden_asignaturas as $asig_nombre) {
                    if (isset($notas_por_asignatura[$asig_nombre])) {
                        $notas_ordenadas[$asig_nombre] = $notas_por_asignatura[$asig_nombre];
                    }
                }
                
                $promedios_finales = [];
                foreach ($notas_ordenadas as $asignatura => $semestres): 
                ?>
                    <tr>
                        <td><?php echo htmlspecialchars($asignatura, ENT_QUOTES, 'UTF-8'); ?></td>
                        <?php 
                        $notas_semestre_actual = isset($semestres[$semestre]) ? $semestres[$semestre] : [];
                        $promedio_final = '';
                        $es_indicador = (in_array($asignatura, ['Religión', 'Orientación']));

                        // Llenar las 10 notas
                        for ($i = 1; $i <= 10; $i++): ?>
                            <td>
                                <?php echo isset($notas_semestre_actual[$i]) ? htmlspecialchars($notas_semestre_actual[$i], ENT_QUOTES, 'UTF-8') : '—'; ?>
                            </td>
                        <?php endfor; ?>
                        
                        <td>
                            <?php
                            if ($es_indicador) {
                                $promedio_final = promedio_indicadores($notas_semestre_actual);
                                echo htmlspecialchars($promedio_final, ENT_QUOTES, 'UTF-8');
                            } else {
                                $promedio_final = calcular_promedio($notas_semestre_actual);
                                echo htmlspecialchars($promedio_final, ENT_QUOTES, 'UTF-8');
                                if ($promedio_final > 0) { // Solo promediar si hay notas
                                    $promedios_finales[] = $promedio_final;
                                }
                            }
                            ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
            <tfoot>
                <tr>
                    <td><strong>Promedio Total</strong></td>
                    <td colspan="10"></td>
                    <td><strong><?php echo calcular_promedio($promedios_finales); ?></strong></td>
                </tr>
            </tfoot>
        </table>

        <div class="asistencia-info no-imprimir" style="margin-top: 2rem;">
            <h3>Registro de Asistencia (Solo Vista Previa)</h3>
            <form method="POST" action="">
                <div class="form-grid" style="grid-template-columns: 1fr 1fr 1fr; align-items: flex-end;">
                    <div class="form-group">
                        <label for="dias_totales"><i class="fas fa-calendar-day"></i> Días Totales:</label>
                        <input type="number" name="dias_totales" id="dias_totales" value="<?php echo $dias_totales; ?>" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="dias_asistidos"><i class="fas fa-user-check"></i> Días Asistidos:</label>
                        <input type="number" name="dias_asistidos" id="dias_asistidos" value="<?php echo $dias_asistidos; ?>" required>
                    </div>
                    
                    <div class="form-buttons">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-calculator"></i> Calcular
                        </button>
                    </div>
                </div>
            </form>
        </div>

        <div class="asistencia-results" style="margin-top: 1rem;">
            <h3>Resultados de Asistencia</h3>
            <p>Días Totales: <?php echo $dias_totales; ?></p>
            <p>Días Asistidos: <?php echo $dias_asistidos; ?></p>
            <p>Días No Asistidos: <?php echo $dias_no_asistidos; ?></p>
            <p>Porcentaje de Asistencia: <?php echo $porcentaje_asistencia; ?>%</p>
        </div>

        <div class="observation-section">
            <label for="observaciones">Observaciones:</label>
            <textarea id="observaciones" name="observaciones" placeholder="Escribe aquí cualquier observación..."></textarea>
        </div>

        <div class="signature-section">
            <strong>Cauquenes, <?php echo $fecha_actual; ?></strong>
        </div>
        <div class="signatures">
            <div class="signature">
                <strong>_________________________</strong><br>
                <strong>Firma del Profesor Jefe</strong>
            </div>
            <div class="utp-signature">
                <strong>Visto Bueno UTP</strong>
            </div>
        </div>

        <div class="right-align no-imprimir" style="text-align: right; margin-top: 2rem;">
            <button onclick="window.print()" class="btn btn-primary">
                <i class="fas fa-print"></i> Imprimir Informe
            </button>
        </div>

        </div>
</main>
</body>
</html>