<?php
header('Content-Type: text/html; charset=utf-8');
// session_start() está en auth.php
include '../includes/db.php';
include '../includes/auth.php';
checkAuth();

$conn->set_charset("utf8");

// Obtener cursos
$cursos = $conn->query("SELECT id, nombre FROM curso WHERE activo = 1 ORDER BY nombre ASC");

$alumnos = [];
// Obtener alumnos según curso
if (isset($_GET['curso_id'])) {
    $curso_id = filter_input(INPUT_GET, 'curso_id', FILTER_VALIDATE_INT);
    if ($curso_id) {
        $alumnos_query = $conn->prepare("
            SELECT id, CONCAT(apellido_paterno, ' ', apellido_materno, ' ', nombre) AS nombre_completo, rut 
            FROM usuario 
            WHERE curso_id = ? 
            AND rol_id = (SELECT id FROM roles WHERE nombre = 'estudiante') 
            ORDER BY apellido_paterno, apellido_materno, nombre
        ");
        $alumnos_query->bind_param("i", $curso_id);
        $alumnos_query->execute();
        $alumnos = $alumnos_query->get_result();
        $alumnos_query->close();
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="../images/logo.png">
    <title>Generar Certificado</title>

    <link rel="stylesheet" href="../css/admin.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
</head>
<body>

<header>
    <div class="header-content">
        <img src="../images/INSIGNIA SF.png" alt="Logo de la Empresa">
        <h1>Generar Certificado</h1>
        <nav>
            <ul>
                <li><a href="../index.php"><i class="fas fa-home"></i> Inicio</a></li>
            </ul>
        </nav>
    </div>
</header>

<main class="container" style="margin-top: 2rem;">
    <div class="card form-container">
        <h2><i class="fas fa-certificate"></i> Generar Certificado de Matrícula</h2>
        
        <form method="GET" action="">
            <div class="form-group">
                <label for="curso_id"><i class="fas fa-university"></i> 1. Seleccionar Curso:</label>
                <select id="curso_id" name="curso_id" onchange="this.form.submit()" required>
                    <option value="">Seleccione un curso</option>
                    <?php 
                    $cursos->data_seek(0);
                    while ($curso_row = $cursos->fetch_assoc()): 
                    ?>
                        <option value="<?= htmlspecialchars($curso_row['id']) ?>"
                            <?= (isset($_GET['curso_id']) && $_GET['curso_id'] == $curso_row['id']) ? 'selected' : '' ?>>
                            <?= htmlspecialchars($curso_row['nombre']) ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>
            <noscript>
                <div class="form-buttons">
                    <button type="submit" class="btn btn-primary">Cargar Alumnos</button>
                </div>
            </noscript>
        </form>

        <?php if ($alumnos && $alumnos->num_rows > 0): ?>
            <hr style="margin: 2rem 0;">
            <form method="POST" action="imprimir_certificadom.php" target="_blank">
                
                <input type="hidden" name="curso_id" value="<?= htmlspecialchars($_GET['curso_id']) ?>">

                <div class="form-group">
                    <label for="alumno_id"><i class="fas fa-user-graduate"></i> 2. Seleccionar Alumno:</label>
                    <select id="alumno_id" name="alumno_id" required>
                        <option value="">Seleccione un alumno</option>
                        <?php while ($alumno = $alumnos->fetch_assoc()): ?>
                            <option value="<?= htmlspecialchars($alumno['id']) ?>">
                                <?= htmlspecialchars($alumno['nombre_completo']) ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>

                <div class="form-buttons">
                    <button type="submit" class="btn btn-primary"><i class="fas fa-print"></i> Generar y Abrir Certificado</button>
                </div>
            </form>
        <?php endif; ?>
    </div>
</main>

</body>
</html>