<?php
header('Content-Type: text/html; charset=utf-8');

// session_start() está en auth.php
include '../includes/db.php';
include '../includes/auth.php';
checkAuth(); // Importante: Asegurarse de que esté logueado

$conn->set_charset("utf8");

// Variables
$nombre = $apellido_paterno = $apellido_materno = $rut = $curso = $numero_matricula = "";
$anio = date("Y");
$meses = [
    1 => 'enero', 2 => 'febrero', 3 => 'marzo', 4 => 'abril',
    5 => 'mayo', 6 => 'junio', 7 => 'julio', 8 => 'agosto',
    9 => 'septiembre', 10 => 'octubre', 11 => 'noviembre', 12 => 'diciembre'
];
$mes_actual = $meses[(int)date("m")];

// Obtener datos del alumno seleccionado (ahora desde POST)
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['alumno_id'])) {
    $alumno_id = filter_input(INPUT_POST, 'alumno_id', FILTER_VALIDATE_INT);
    $numero_matricula = filter_input(INPUT_POST, 'numero_matricula', FILTER_SANITIZE_SPECIAL_CHARS);

    $stmt = $conn->prepare("
        SELECT nombre, apellido_paterno, apellido_materno, rut, 
               (SELECT nombre FROM curso WHERE id = curso_id) AS curso 
        FROM usuario 
        WHERE id = ?
    ");
    $stmt->bind_param("i", $alumno_id);
    $stmt->execute();
    $stmt->bind_result($nombre, $apellido_paterno, $apellido_materno, $rut, $curso);
    $stmt->fetch();
    $stmt->close();
} else {
    die("No se proporcionaron datos válidos.");
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="../images/logo.png">
    <title>Certificado de Alumno Regular - <?= htmlspecialchars($rut) ?></title>
    
    <link rel="stylesheet" href="../css/certificado.css">
</head>
<body>

    <img src="../images/INSIGNIA SF.png" alt="Insignia Escuela" class="insignia">
    <img src="../images/SLEP.jpeg" alt="Logo SLEP" class="insignia right-insignia">

    <div class="header-text" style="line-height: 0.5;">
        <p>REPUBLICA DE CHILE</p>
        <p>PROVINCIA DE CAUQUENES</p>
        <p>SERVICIO LOCAL DE EDUCACIÓN PÚBLICA MAULE COSTA</p>
        <p>ESCUELA “PORONGO” F – 654 CAUQUENES</p>
        <p>EBG/emp /24.-</p>
    </div>
    
    <h1 class="no-print">Certificado de Alumno Regular</h1>


    <?php if (!empty($nombre)): ?>
        <div class="content">
            <p style="text-align: center; font-weight: bold; font-size: 18px;">CERTIFICADO DE ALUMNO REGULAR</p>
            <p>
                La Directora de la <b>Escuela Porongo F – 654</b> (RBD 3549-1) de Cauquenes, quien suscribe, certifica que:
            </p>
            <p>
                Don(a): <b><?= strtoupper(htmlspecialchars("$nombre $apellido_paterno $apellido_materno")) ?></b>, 
                R.U.N.: <b><?= htmlspecialchars($rut) ?></b>, se encuentra matriculado(a) en este Establecimiento Educacional 
                y asiste regularmente a clases en el curso: <b><?= htmlspecialchars($curso) ?></b>, 
                con el Nº <b><?= htmlspecialchars($numero_matricula) ?></b> del Registro Escolar, Año <b><?= $anio ?></b>.
            </p>
            <p>Se extiende el presente Certificado a petición del interesado(a), para los fines que estime conveniente.</p>
        </div>

        <div class="footer" style="text-align: center; margin-top: 60px;">
            <div>
                <p style="margin-bottom: 0;">______________________________</p>
                <p><b>ELBA BARRUETO GARRO</b></p>
                <p><b>DIRECTOR(A)</b></p>
                <p><b>ESCUELA PORONGO</b></p>
            </div>
        </div>

        <div class="footer" style="text-align: left;">
            <p>Cauquenes, <?= date("d") . " de " . $mes_actual .  " del " . $anio ?>.</p>
        </div>

        <div class="right-align no-print">
            <button onclick="window.print()">Imprimir Certificado</button>
            <button onclick="window.close()">Cerrar</button>
        </div>
    <?php endif; ?>

    <div class="footer" style="margin-top: 20px; text-align: center;">
        <p>Km 4, camino a Chanco - Cauquenes</p>
        <p>e-mail: porongo@slepmc.cl</p>
        <p>Teléfono: +56442857313</p>
    </div>
    
    <script>
        window.onload = function() {
            window.print();
        }
    </script>
</body>
</html>