<?php
// AÑADIDO: session_start() debe estar al inicio
session_start();
header('Content-Type: text/html; charset=utf-8');

include '../includes/db.php';
include '../includes/auth.php';
checkAuth();

$conn->set_charset("utf8mb4");

// AÑADIDO: Lógica de mensajes de sesión
$message = '';
$message_type = '';
if (isset($_SESSION['message'])) {
    $message = $_SESSION['message'];
    $message_type = $_SESSION['message_type'];
    unset($_SESSION['message'], $_SESSION['message_type']);
}


// Procesar la creación o modificación de asignaturas
if ($_SERVER['REQUEST_METHOD'] == 'POST' && (isset($_POST['crear']) || isset($_POST['modificar']))) {
    $nombre = trim($_POST['nombre']); // Eliminar espacios en blanco del inicio y fin

    if (empty($nombre)) {
        $message = "Error: El nombre de la asignatura no puede estar vacío o contener solo espacios.";
        $message_type = 'error';
    } else {
        if (isset($_POST['crear'])) {
            // Inserción de una nueva asignatura
            $stmt = $conn->prepare("INSERT INTO asignatura (nombre) VALUES (?)");
            $stmt->bind_param("s", $nombre);
            if ($stmt->execute()) {
                $message = "Asignatura agregada correctamente.";
                $message_type = 'exito';
            } else {
                $message = "Error al agregar la asignatura: " . $stmt->error;
                $message_type = 'error';
            }
        } else if (isset($_POST['modificar'])) {
            // Modificación de una asignatura existente
            $id = intval($_POST['asignatura_id']);
            $stmt = $conn->prepare("UPDATE asignatura SET nombre = ? WHERE id = ?");
            $stmt->bind_param("si", $nombre, $id);
            if ($stmt->execute()) {
                $message = "Asignatura modificada correctamente.";
                $message_type = 'exito';
            } else {
                $message = "Error al modificar la asignatura: " . $stmt->error;
                $message_type = 'error';
            }
        }
        $stmt->close();
    }
    
    // MODIFICADO: Usar sesión para mensajes
    $_SESSION['message'] = $message;
    $_SESSION['message_type'] = $message_type;
    header("Location: add_subject.php");
    exit();
}

// Procesar la eliminación de asignaturas
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['eliminar'])) {
    $asignatura_id = intval($_POST['asignatura_id']);
    
    // (Opcional pero recomendado) Verificar si la asignatura está en uso
    // $stmt_check = $conn->prepare("SELECT COUNT(*) FROM notas WHERE asignatura_id = ?");
    // ... si (total > 0) -> $message = "Error: La asignatura está en uso y no se puede eliminar.";
    
    $stmt = $conn->prepare("DELETE FROM asignatura WHERE id = ?");
    $stmt->bind_param("i", $asignatura_id);
    if ($stmt->execute()) {
        $message = "Asignatura eliminada correctamente.";
        $message_type = 'exito';
    } else {
        $message = "Error al eliminar la asignatura: " . $stmt->error;
        $message_type = 'error';
    }
    $stmt->close();
    
    // MODIFICADO: Usar sesión para mensajes
    $_SESSION['message'] = $message;
    $_SESSION['message_type'] = $message_type;
    header("Location: add_subject.php");
    exit();
}

// Obtener todas las asignaturas
$asignaturas = $conn->query("SELECT * FROM asignatura ORDER BY nombre ASC");
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="../../images/logo.png">
    <title>Agregar/Editar Asignaturas</title>
    
    <link rel="stylesheet" href="../css/admin.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    
    </head>
<body>
    
<header>
    <div class="header-content">
        <img src="../images/INSIGNIA SF.png" alt="Escuela Porongo Insignia">
        <h1>Gestión de Asignaturas</h1>
        <nav>
            <ul>
                <li><a href="../index.php"><i class="fas fa-home"></i> Inicio</a></li>
            </ul>
        </nav>
    </div>
</header>
    
<main class="container">
    
    <?php if ($message): ?>
        <div class="mensaje <?php echo $message_type; ?> show">
            <?php echo htmlspecialchars($message, ENT_QUOTES, 'UTF-8'); ?>
        </div>
    <?php endif; ?>

    <div class="card form-container">
        <h2 id="form-titulo"><i class="fas fa-book"></i> Agregar Asignatura</h2>
        
        <form method="POST" action="add_subject.php" onsubmit="return validarFormulario()">
            <input type="hidden" name="asignatura_id" id="asignatura_id">
            
            <div class="form-grid">
                <div class="form-group">
                    <label for="nombre"><i class="fas fa-tag"></i> Nombre de la Asignatura:</label>
                    <input type="text" id="nombre" name="nombre" required>
                </div>
            </div>

            <div class="form-buttons">
                <button type="submit" name="crear" id="crear" class="btn btn-primary">
                    <i class="fas fa-plus-circle"></i> Agregar Asignatura
                </button>
                <button type="submit" name="modificar" id="modificar" class="btn btn-primary" style="display:none;">
                    <i class="fas fa-save"></i> Modificar Asignatura
                </button>
                <button type="button" id="cancelar" class="btn btn-secondary" style="display:none;" onclick="cancelarEdicion()">
                    <i class="fas fa-times-circle"></i> Cancelar
                </button>
            </div>
        </form>
    </div>

    <div class="card table-container">
        <h2><i class="fas fa-list-ul"></i> Asignaturas Existentes</h2>
        
        <div class="table-responsive">
            <table>
                <thead> <tr>
                        <th>Nombre</th>
                        <th class="actions">Acciones</th>
                    </tr>
                </thead>
                <tbody> <?php if ($asignaturas->num_rows > 0): ?>
                        <?php while ($row = $asignaturas->fetch_assoc()): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($row['nombre'], ENT_QUOTES, 'UTF-8'); ?></td>
                                <td class="actions">
                                    
                                    <button class="btn btn-edit" title="Editar" onclick="editarAsignatura('<?php echo htmlspecialchars($row['id'], ENT_QUOTES, 'UTF-8'); ?>', '<?php echo htmlspecialchars($row['nombre'], ENT_QUOTES, 'UTF-8'); ?>')">
                                        <i class="fas fa-pencil-alt"></i>
                                    </button>
                                    
                                    <form method="POST" action="add_subject.php" style="display:inline;">
                                        <input type="hidden" name="asignatura_id" value="<?php echo $row['id']; ?>">
                                        <button type="submit" name="eliminar" class="btn btn-danger" title="Eliminar" onclick="return confirm('¿Estás seguro de que deseas eliminar esta asignatura?');">
                                            <i class="fas fa-trash-alt"></i>
                                        </button>
                                    </form>
                                    
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="2" style="text-align: center;">No hay asignaturas creadas.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</main>
    
<script>
    function editarAsignatura(id, nombre) {
        document.getElementById('form-titulo').innerHTML = '<i class="fas fa-edit"></i> Editar Asignatura';
        document.getElementById('asignatura_id').value = id;
        document.getElementById('nombre').value = nombre;
        document.getElementById('crear').style.display = 'none';
        document.getElementById('modificar').style.display = 'inline-block'; // Corregido a inline-block
        document.getElementById('cancelar').style.display = 'inline-block'; // AÑADIDO

        // Mover la vista al formulario
        document.getElementById('formulario-asignatura').scrollIntoView({
            behavior: 'smooth',
            block: 'start'
        });
    }

    // AÑADIDO: Función para cancelar la edición
    function cancelarEdicion() {
        document.getElementById('form-titulo').innerHTML = '<i class="fas fa-book"></i> Agregar Asignatura';
        document.getElementById('asignatura_id').value = '';
        document.getElementById('nombre').value = '';
        document.getElementById('crear').style.display = 'inline-block';
        document.getElementById('modificar').style.display = 'none';
        document.getElementById('cancelar').style.display = 'none';
    }

    // ELIMINADO: Función eliminarAsignatura() (reemplazada por formulario)

    // Validación de formulario (se mantiene, es buena)
    function validarFormulario() {
        var nombre = document.getElementById('nombre').value.trim();
        if (nombre === '') {
            alert('El campo de nombre no puede estar vacío o contener solo espacios.');
            return false;
        }
        return true;
    }

    // Mostrar el mensaje flotante
    window.onload = function() {
        const message = document.querySelector('.mensaje');
        if (message) {
            setTimeout(() => {
                message.classList.remove('show');
            }, 3000); // 3 segundos
        }
    };
</script>
</body>
</html>