<?php
session_start();
include '../../includes/auth.php';
include '../../includes/db.php';
checkAuth();

if (!isAdmin()) {
    header("Location: ../index.php");
    exit();
}

// Incluir PhpSpreadsheet
require '../../vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// Crear nuevo archivo de Excel
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// Encabezados de columna
$sheet->setCellValue('A1', 'ID');
$sheet->setCellValue('B1', 'RUT');
$sheet->setCellValue('C1', 'Nombre');
$sheet->setCellValue('D1', 'Apellido Paterno');
$sheet->setCellValue('E1', 'Apellido Materno');
$sheet->setCellValue('F1', 'Rol');
$sheet->setCellValue('G1', 'Curso');
$sheet->setCellValue('H1', 'Activo');

// Consulta usuarios con nombres de rol y curso
$sql = "SELECT u.id, u.rut, u.nombre, u.apellido_paterno, u.apellido_materno, 
               r.nombre AS rol_nombre, c.nombre AS curso_nombre, u.activo
        FROM usuario u
        LEFT JOIN roles r ON u.rol_id = r.id
        LEFT JOIN curso c ON u.curso_id = c.id";

$result = $conn->query($sql);

$row = 2;
while ($usuario = $result->fetch_assoc()) {
    $sheet->setCellValue("A$row", $usuario['id']);
    $sheet->setCellValue("B$row", $usuario['rut']);
    $sheet->setCellValue("C$row", $usuario['nombre']);
    $sheet->setCellValue("D$row", $usuario['apellido_paterno']);
    $sheet->setCellValue("E$row", $usuario['apellido_materno']);
    $sheet->setCellValue("F$row", $usuario['rol_nombre'] ?? '');     // Nombre del rol
    $sheet->setCellValue("G$row", $usuario['curso_nombre'] ?? '');   // Nombre del curso
    $sheet->setCellValue("H$row", $usuario['activo'] ? 'Sí' : 'No');
    $row++;
}

// Encabezados para descarga
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="usuarios.xlsx"');
header('Cache-Control: max-age=0');

$writer = new Xlsx($spreadsheet);
$writer->save('php://output');
exit();
?>
