<?php
// Carpeta de respaldos
$carpetaRespaldos = __DIR__ . '/respaldos/';

// Obtener todos los archivos .sql de la carpeta
$archivos = glob($carpetaRespaldos . '*.sql'); // Cambia la extensión si es .zip u otra

// Ordenar los archivos por fecha de modificación, del más reciente al más antiguo
usort($archivos, function($a, $b) {
    return filemtime($b) - filemtime($a);
});
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="../../images/logo.png">
    <title>Lista Recuperación de Datos</title>
    
    <link rel="stylesheet" href="../../css/admin.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">

    </head>
<body>
    
<header>
    <div class="header-content">
        <img src="../../images/INSIGNIA%20SF.png" alt="Escuela Porongo Insignia">
        <h1>Lista de Respaldos</h1>
        <nav>
            <ul>
                <li><a href="../../index.php"><i class="fas fa-home"></i> Inicio</a></li>
                <li><a href="datos.php"><i class="fas fa-arrow-left"></i> Volver</a></li>
            </ul>
        </nav>
    </div>
</header>
    
<main class="container">
    <div class="card table-container">
        <h2><i class="fas fa-list"></i> Listado de Respaldos Disponibles</h2>

        <?php if (!empty($archivos)): ?>
            <div class="table-responsive">
                <table>
                    <thead>
                        <tr>
                            <th>Nombre del Archivo</th>
                            <th>Tamaño</th>
                            <th>Fecha de Creación</th>
                            <th class="actions">Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($archivos as $archivo): ?>
                            <tr>
                                <td><?php echo htmlspecialchars(basename($archivo)); ?></td>
                                <td><?php echo round(filesize($archivo) / 1024, 2) . " KB"; ?></td>
                                <td><?php echo date("d-m-Y H:i:s", filemtime($archivo)); ?></td>
                                <td class="actions">
                                    <a class="btn btn-success" href="respaldos/<?php echo basename($archivo); ?>" download title="Descargar">
                                        <i class="fas fa-download"></i>
                                    </a>
                                    <a class="btn btn-danger" href="eliminar_backup.php?file=<?php echo basename($archivo); ?>" onclick="return confirm('⚠ ¿Seguro que deseas eliminar este respaldo?')" title="Eliminar">
                                        <i class="fas fa-trash-alt"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <p style="text-align: center; margin-top: 1rem; padding: 1rem;">
                No hay respaldos disponibles.
            </p>
        <?php endif; ?>
    </div>
</main>
</body>
</html>