<?php
session_start();

// 🔹 Solo administradores
if (!isset($_SESSION['rol']) || $_SESSION['rol'] != 1) {
    header("Location: ../../index.php");
    exit();
}

// 🔹 Verifica que se haya recibido el archivo
if (isset($_GET['file'])) {
    $archivo = basename($_GET['file']); // Seguridad
    $ruta = __DIR__ . '/respaldos/' . $archivo;

    if (file_exists($ruta)) {
        // Intentar eliminar el archivo
        if (@unlink($ruta)) {
            $mensaje = "Respaldo '$archivo' eliminado correctamente.";
        } else {
            $mensaje = "Error: No se pudo eliminar el respaldo '$archivo'. Verifica permisos de la carpeta 'respaldos'.";
        }
    } else {
        $mensaje = "Error: El archivo '$archivo' no existe.";
    }
} else {
    $mensaje = "Error: No se especificó ningún archivo.";
}

// Redirige de vuelta con mensaje
header("Location: datos.php?msg=" . urlencode($mensaje));
exit();
?>
