<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="../../images/logo.png">
    <title>Respaldo y Recuperación de Datos</title>
    
    <link rel="stylesheet" href="../../css/admin.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    
    <style>
        /* Contenedor para los botones de acción de respaldo */
        .action-buttons {
            display: flex;
            flex-wrap: wrap;
            gap: 1rem;
            margin-bottom: 2rem; /* Espacio antes de la sección de restauración */
            border-bottom: 2px solid var(--grey-light); /* Separador visual */
            padding-bottom: 2rem;
        }
        .action-buttons form {
            margin: 0; /* Los formularios no deben añadir margen extra */
        }
        
        /* Contenedor para el formulario de restauración */
        .restore-form {
            /* Usar un grid simple para alinear el input y el botón */
            display: grid;
            grid-template-columns: 1fr auto; /* El input ocupa el espacio, el botón se ajusta */
            gap: 1rem;
            align-items: center;
        }

        /* Estilo personalizado para el input[type=file] */
        .restore-form input[type="file"] {
            width: 100%;
            padding: 0.65rem; /* Ajustar padding para alinear verticalmente con el botón */
            border: 1px solid var(--grey-medium);
            border-radius: var(--border-radius);
            font-size: 0.9rem;
            background-color: #fff;
            transition: var(--transition-speed);
        }
        .restore-form input[type="file"]:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 5px rgba(52, 152, 219, 0.5);
            outline: none;
        }

        /* Estilo para el botón "Elegir archivo" (depende del navegador) */
        .restore-form input[type="file"]::file-selector-button {
            background-color: var(--grey-dark);
            color: var(--light-color);
            border: none;
            padding: 0.5rem 1rem;
            border-radius: var(--border-radius);
            cursor: pointer;
            margin-right: 1rem;
            transition: var(--transition-speed);
        }
        .restore-form input[type="file"]::file-selector-button:hover {
            background-color: var(--dark-color);
        }

        /* Responsividad para el formulario de restauración */
        @media (max-width: 768px) {
            .restore-form {
                grid-template-columns: 1fr; /* Apilar en móvil */
            }
        }
    </style>
</head>
<body>
    
<header>
    <div class="header-content">
        <img src="../../images/INSIGNIA%20SF.png" alt="Escuela Porongo Insignia">
        <h1>Respaldo y Recuperación</h1>
        <nav>
            <ul>
                <li><a href="../../index.php"><i class="fas fa-home"></i> Inicio</a></li>
            </ul>
        </nav>
    </div>
</header>
    
<main class="container">
    <div class="card">
        <h2><i class="fas fa-database"></i> Acciones de Base de Datos</h2>
        
        <h3 style="margin-top: 1.5rem;"><i class="fas fa-download"></i> Acciones de Respaldo</h3>
        <div class="action-buttons">
            <form action="lista_respaldo.php" method="POST">
                <button type="submit" name="backup" class="btn btn-primary">
                    <i class="fas fa-list"></i> Lista de Respaldo
                </button>
            </form>
            <form action="backup.php" method="POST">
                <button type="submit" name="backup" class="btn btn-primary">
                    <i class="fas fa-box-archive"></i> Realizar Respaldo
                </button>
            </form>
            <form action="descargar_backup.php" method="POST">
                <button type="submit" name="download" class="btn btn-success">
                    <i class="fas fa-cloud-download-alt"></i> Descargar Respaldo
                </button>
            </form>
        </div>

        <h3><i class="fas fa-upload"></i> Restauración de Datos</h3>
        <p style="color: var(--grey-dark); margin-bottom: 1rem; font-size: 0.9rem;">
            Seleccione un archivo de respaldo (.sql) para restaurar la base de datos. <br>
            <strong style="color: var(--danger-color);">¡Atención! Esta acción sobrescribirá todos los datos actuales.</strong>
        </p>

        <form class="restore-form" action="restore.php" method="POST" enctype="multipart/form-data">
            <input type="file" name="backup_file" required accept=".sql">
            <button type="submit" name="restore" class="btn btn-danger" onclick="return confirm('¿Estás seguro de que quieres restaurar la base de datos? Se perderán todos los datos actuales.');">
                <i class="fas fa-upload"></i> Restaurar Ahora
            </button>
        </form>
    </div>
</main>

</body>
</html>