<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="../../images/logo.png">
    <title>Respaldo de Base de Datos</title>

    <link rel="stylesheet" href="../../css/admin.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    
    <style>
        .card-content {
            text-align: center;
            padding: 2rem 0;
        }
        .progress-container {
            /* Oculto por defecto, el JS lo muestra */
            display: none; 
            width: 100%;
            background-color: var(--grey-light);
            border-radius: var(--border-radius);
            margin: 2rem 0;
            overflow: hidden;
            border: 1px solid var(--grey-medium);
            position: relative; 
            height: 35px; /* Alto fijo para la barra y el texto */
        }
        .progress-bar {
            width: 0%;
            height: 100%;
            background-color: var(--primary-color);
            transition: width 0.4s ease;
        }
        .progress-text {
            /* Texto superpuesto */
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            text-align: center;
            line-height: 35px;
            font-weight: 700;
            color: var(--dark-color);
        }
        /* Ajuste para el botón de respaldo */
        #backupForm .btn {
            font-size: 1.2rem;
            padding: 0.8rem 2rem;
        }
    </style>
</head>
<body>

<header>
    <div class="header-content">
        <img src="../../images/INSIGNIA%20SF.png" alt="Escuela Porongo Insignia">
        <h1>Respaldo de Base de Datos</h1>
        <nav>
            <ul>
                <li><a href="../../index.php"><i class="fas fa-home"></i> Inicio</a></li>
                <li><a href="datos.php"><i class="fas fa-arrow-left"></i> Volver</a></li>
            </ul>
        </nav>
    </div>
</header>
    
<main class="container">
    <div class="card">
        <div class="card-content"> <form id="backupForm">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-database"></i> Realizar Respaldo
                </button>
            </form>

            <div class="progress-container" id="progressContainer">
                <div class="progress-bar" id="progressBar"></div>
                <div class="progress-text" id="progressText">0%</div>
            </div>

            <div class="mensaje" id="resultMessage" style="display: none;"></div> 

        </div>
    </div>
</main>

    <script>
        document.getElementById('backupForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const progressBar = document.getElementById('progressBar');
            const progressText = document.getElementById('progressText');
            const progressContainer = document.getElementById('progressContainer');
            
            // MODIFICADO: Apuntar al nuevo div de mensaje
            const resultMessage = document.getElementById('resultMessage');

            // Preparar UI
            progressContainer.style.display = 'block';
            progressBar.style.width = '0%';
            progressText.textContent = '0%';
            
            // Limpiar y ocultar el mensaje
            resultMessage.textContent = '';
            resultMessage.style.display = 'none'; 
            resultMessage.className = 'mensaje'; // Clase base

            let progress = 0;
            const simulateProgress = setInterval(() => {
                if (progress < 90) {
                    progress += Math.floor(Math.random() * 4) + 1;
                    progressBar.style.width = progress + '%';
                    progressText.textContent = progress + '%';
                }
            }, 150);

            fetch('hacer_respaldo.php')
                .then(response => response.json())
                .then(data => {
                    clearInterval(simulateProgress);
                    progressBar.style.width = '100%';
                    progressText.textContent = '100%';

                    // Mostrar mensaje
                    resultMessage.textContent = data.message;
                    resultMessage.style.display = 'block'; // Mostrarlo

                    if (data.type === 'error') {
                        resultMessage.classList.add('error');
                    } else {
                        // MODIFICADO: Usar clase 'exito' para el éxito
                        resultMessage.classList.add('exito'); 
                    }

                    setTimeout(() => {
                        window.location.href = '/admin/respaldos/datos.php';
                    }, 3000);
                })
                .catch(error => {
                    clearInterval(simulateProgress);
                    resultMessage.textContent = 'Error en la solicitud: ' + error;
                    resultMessage.style.display = 'block'; // Mostrarlo
                    resultMessage.classList.add('error');
                });
        });
    </script>
</body>
</html>