<?php
session_start();
include '../../includes/auth.php';
include '../../includes/db.php';
checkAuth();

$conn->set_charset("utf8");

// AÑADIDO: Manejo de mensajes flash
$message = '';
$message_type = '';
if (isset($_SESSION['message'])) {
    $message = $_SESSION['message'];
    $message_type = $_SESSION['message_type'];
    unset($_SESSION['message'], $_SESSION['message_type']);
}

// Obtener todos los roles
$stmt_roles = $conn->prepare("SELECT id, nombre FROM roles ORDER BY nombre ASC");
$stmt_roles->execute();
$result_roles = $stmt_roles->get_result();

// Obtener todos los usuarios (excluyendo estudiantes)
$stmt_usuarios = $conn->prepare("SELECT id, nombre, apellido_paterno, apellido_materno FROM usuario WHERE id NOT IN (SELECT id FROM usuario WHERE rol_id = (SELECT id FROM roles WHERE nombre = 'Estudiante')) ORDER BY nombre ASC");
$stmt_usuarios->execute();
$result_usuarios = $stmt_usuarios->get_result();

// Obtener todos los permisos
$stmt_permisos = $conn->prepare("SELECT id, nombre FROM permisos ORDER BY nombre ASC");
$stmt_permisos->execute();
$result_permisos = $stmt_permisos->get_result();

// Obtener permisos asignados a un rol o usuario
$permisos_asignados = [];
$rol_id = null;
$usuario_id = null;

// Esta lógica se activa cuando se selecciona algo en el formulario
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    if (isset($_POST['rol_id']) && !empty($_POST['rol_id'])) {
        $rol_id = intval($_POST['rol_id']);
        $stmt_permiso_rol = $conn->prepare("SELECT permiso_id FROM roles_permisos WHERE rol_id = ?");
        $stmt_permiso_rol->bind_param("i", $rol_id);
        $stmt_permiso_rol->execute();
        $result_permiso_rol = $stmt_permiso_rol->get_result();

        while ($row = $result_permiso_rol->fetch_assoc()) {
            $permisos_asignados[] = $row['permiso_id'];
        }
    }

    if (isset($_POST['usuario_id']) && !empty($_POST['usuario_id'])) {
        $usuario_id = intval($_POST['usuario_id']);
        $stmt_permiso_usuario = $conn->prepare("SELECT permiso_id FROM usuario_permisos WHERE usuario_id = ?");
        $stmt_permiso_usuario->bind_param("i", $usuario_id);
        $stmt_permiso_usuario->execute();
        $result_permiso_usuario = $stmt_permiso_usuario->get_result();

        while ($row = $result_permiso_usuario->fetch_assoc()) {
            $permisos_asignados[] = $row['permiso_id'];
        }
    }

    // Guardar permisos asignados
    if (isset($_POST['guardar_permisos'])) {
        $permisos = isset($_POST['permisos']) ? $_POST['permisos'] : [];

        if ($rol_id) {
            $stmt_eliminar = $conn->prepare("DELETE FROM roles_permisos WHERE rol_id = ?");
            $stmt_eliminar->bind_param("i", $rol_id);
            $stmt_eliminar->execute();

            $stmt_insertar = $conn->prepare("INSERT INTO roles_permisos (rol_id, permiso_id) VALUES (?, ?)");
            foreach ($permisos as $permiso_id) {
                $stmt_insertar->bind_param("ii", $rol_id, $permiso_id);
                $stmt_insertar->execute();
            }
            $stmt_insertar->close();
        }

        if ($usuario_id) {
            $stmt_eliminar = $conn->prepare("DELETE FROM usuario_permisos WHERE usuario_id = ?");
            $stmt_eliminar->bind_param("i", $usuario_id);
            $stmt_eliminar->execute();

            $stmt_insertar = $conn->prepare("INSERT INTO usuario_permisos (usuario_id, permiso_id) VALUES (?, ?)");
            foreach ($permisos as $permiso_id) {
                $stmt_insertar->bind_param("ii", $usuario_id, $permiso_id);
                $stmt_insertar->execute();
            }
            $stmt_insertar->close();
        }

        // MODIFICADO: Usar sesión para el mensaje
        $_SESSION['message'] = "Permisos actualizados correctamente";
        $_SESSION['message_type'] = "exito"; // Clase 'exito' en lugar de 'success' para admin.css
        
        // Redirigir para limpiar el POST y mostrar el mensaje
        header("Location: permisos.php");
        exit();
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="../../images/logo.png">
    <title>Gestión de Permisos</title>
    
    <link rel="stylesheet" href="../../css/admin.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">

    <style>
        .permisos-list {
            list-style-type: none;
            padding: 0;
            margin-top: 1rem;
            max-height: 300px;
            overflow-y: auto;
            border: 1px solid var(--grey-medium);
            border-radius: var(--border-radius);
            padding: 1rem;
            background-color: var(--grey-light);
        }
        .permisos-list li {
            display: flex;
            align-items: center;
            padding: 0.5rem;
        }
        .permisos-list li label {
            margin: 0;
            font-weight: 500;
            cursor: pointer;
        }
        .permisos-list li input[type="checkbox"] {
            width: 18px;
            height: 18px;
            margin-right: 1rem;
            cursor: pointer;
        }
        .permisos-list li:not(:last-child) {
            border-bottom: 1px solid var(--grey-medium);
        }
    </style>
</head>
<body>

<header>
    <div class="header-content">
        <img src="../../images/INSIGNIA%20SF.png" alt="Logo de la Empresa">
        <h1>Gestión de Permisos</h1>
        <nav>
            <ul>
                <li><a href="../../index.php"><i class="fas fa-home"></i> Inicio</a></li>
            </ul>
        </nav>
    </div>
</header>

<main class="container">

    <?php if ($message): ?>
        <div class="mensaje <?php echo $message_type; ?> show">
            <?php if ($message_type == 'exito'): ?>
                <i class="fas fa-check-circle"></i>
            <?php endif; ?>
            <?php echo htmlspecialchars($message, ENT_QUOTES, 'UTF-8'); ?>
        </div>
    <?php endif; ?>

    <div class="card form-container">
        <h2><i class="fas fa-shield-alt"></i> Asignar Permisos</h2>
        
        <form method="POST" action="permisos.php">
            <div class="form-grid">
                <div class="form-group">
                    <label for="rol_id"><i class="fas fa-user-tag"></i> Seleccionar Rol:</label>
                    <select name="rol_id" id="rol_id" onchange="this.form.submit()">
                        <option value="">Seleccione un rol</option>
                        <?php
                        $result_roles->data_seek(0);
                        while ($rol = $result_roles->fetch_assoc()) {
                            $selected = isset($rol_id) && $rol['id'] == $rol_id ? 'selected' : '';
                            echo "<option value='" . $rol['id'] . "' $selected>" . htmlspecialchars($rol['nombre'], ENT_QUOTES, 'UTF-8') . "</option>";
                        }
                        ?>
                    </select>
                </div>

                <div class="form-group">
                    <label for="usuario_id"><i class="fas fa-user"></i> Seleccionar Usuario (Opcional):</label>
                    <select name="usuario_id" id="usuario_id" onchange="this.form.submit()">
                        <option value="">Seleccione un usuario</option>
                        <?php
                        $result_usuarios->data_seek(0);
                        while ($usuario = $result_usuarios->fetch_assoc()) {
                            $selected = isset($usuario_id) && $usuario['id'] == $usuario_id ? 'selected' : '';
                            $nombre_completo = htmlspecialchars($usuario['nombre'] . " " . $usuario['apellido_paterno'] . " " . $usuario['apellido_materno'], ENT_QUOTES, 'UTF-8');
                            echo "<option value='" . $usuario['id'] . "' $selected>" . $nombre_completo . "</option>";
                        }
                        ?>
                    </select>
                </div>
            </div> <?php if ($rol_id || $usuario_id): ?>
                
                <h2 style="margin-top: 2rem; border-top: 2px solid var(--grey-light); padding-top: 1.5rem;">
                    <i class="fas fa-list-check"></i> Permisos Asignados
                </h2>
                
                <ul class="permisos-list">
                    <?php
                    $result_permisos->data_seek(0);
                    while ($permiso = $result_permisos->fetch_assoc()) {
                        $checked = in_array($permiso['id'], $permisos_asignados) ? 'checked' : '';
                        $permiso_id_html = 'permiso_' . $permiso['id'];
                        
                        echo '<li>';
                        echo '<input type="checkbox" name="permisos[]" id="' . $permiso_id_html . '" value="' . $permiso['id'] . '" ' . $checked . '>';
                        // AÑADIDO: <label> para mejor accesibilidad
                        echo '<label for="' . $permiso_id_html . '">' . htmlspecialchars($permiso['nombre'], ENT_QUOTES, 'UTF-8') . '</label>';
                        echo '</li>';
                    }
                    ?>
                </ul>
                
                <div class="form-buttons" style="margin-top: 1.5rem;">
                    <button type="submit" name="guardar_permisos" class="btn btn-primary">
                        <i class="fas fa-save"></i> Guardar Permisos
                    </button>
                </div>
            <?php endif; ?>

        </form>
    </div> </main>

<script>
    window.onload = function() {
        const message = document.querySelector('.mensaje');
        if (message) {
            setTimeout(() => {
                message.classList.remove('show');
            }, 3000); // El mensaje desaparece después de 3 segundos
        }
    };
</script>

</body>
</html>