<?php
session_start();
include '../../includes/auth.php';
include '../../includes/db.php';
checkAuth();

// Solo usuarios autorizados deben ver esto (ajusta según tu sistema de roles)
if ($_SESSION['rol'] != 1) { // por ejemplo, rol 1 = administrador
    header("Location: ../index.php");
    exit();
}

$conn->set_charset("utf8");
$result = $conn->query("SELECT * FROM registro_actividad ORDER BY fecha DESC");

// AÑADIDO: Verificación para mostrar mensaje si no hay filas
$has_results = ($result && $result->num_rows > 0);
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="../../images/logo.png">
    <title>Historial de Notas</title>

    <link rel="stylesheet" href="../../css/admin.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    
    </head>
<body>

<header>
    <div class="header-content">
        <img src="../../images/INSIGNIA%20SF.png" alt="Logo de la Empresa">
        <h1>Historial de Notas</h1>
        <nav>
            <ul>
                <li><a href="../../index.php"><i class="fas fa-home"></i> Inicio</a></li>
            </ul>
        </nav>
    </div>
</header>

<main class="container">
    <div class="card table-container">
        <h2><i class="fas fa-clipboard-list"></i> Historial de Notas de Usuarios</h2>
        
        <div class="table-responsive">
            <table>
                <thead>
                    <tr>
                        <th>Usuario</th>
                        <th>Acción</th>
                        <th>Fecha y Hora</th>
                        <th>IP</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if($has_results): ?>
                        <?php while($row = $result->fetch_assoc()): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($row['usuario']); ?></td>
                                <td><?php echo htmlspecialchars($row['accion']); ?></td>
                                <td><?php echo $row['fecha']; ?></td>
                                <td><?php echo htmlspecialchars($row['ip_usuario']); ?></td>
                            </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="4" style="text-align:center;">No hay registros de notas.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div> </div> </main> </body>
</html>