<?php
session_start();
include '../../includes/auth.php';
include '../../includes/db.php';
checkAuth();

// Solo administradores pueden ver esto
if ($_SESSION['rol'] != 1) { // rol 1 = administrador
    header("Location: ../index.php");
    exit();
}

$conn->set_charset("utf8");

// Obtenemos los registros de actividad y el nombre del usuario que realizó cada acción
$query = "SELECT a.id, u.nombre, u.apellido_paterno, u.apellido_materno, a.accion, a.descripcion, a.fecha
          FROM actividad a
          JOIN usuario u ON a.usuario_id = u.id
          ORDER BY a.fecha DESC";
$result = $conn->query($query);
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Historial de Actividades</title>
    <link rel="icon" type="image/png" href="../../images/logo.png">
    
    <link rel="stylesheet" href="../../css/admin.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    
    </head>
<body>

<header>
    <div class="header-content">
        <img src="../../images/INSIGNIA%20SF.png" alt="Logo de la Empresa">
        <h1>Historial de Actividades</h1>
        <nav>
            <ul>
                <li><a href="../../index.php"><i class="fas fa-home"></i> Inicio</a></li>
            </ul>
        </nav>
    </div>
</header>

<main class="container">
    <div class="card table-container">
        <h2><i class="fas fa-history"></i> Registros de Actividad</h2>
        
        <div class="table-responsive">
            <table>
                <thead>
                    <tr>
                        <th>Usuario</th>
                        <th>Acción</th>
                        <th>Descripción</th>
                        <th>Fecha y Hora</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if($result && $result->num_rows > 0): ?>
                        <?php while($row = $result->fetch_assoc()): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($row['nombre'] . ' ' . $row['apellido_paterno'] . ' ' . $row['apellido_materno']); ?></td>
                                <td><?php echo htmlspecialchars($row['accion']); ?></td>
                                <td><?php echo htmlspecialchars($row['descripcion']); ?></td>
                                <td><?php echo $row['fecha']; ?></td>
                            </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="4" style="text-align:center;">No hay registros de actividad.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div> </div> </main> </body>
</html>