<?php 
session_start();

if (!isset($_SESSION['nombre_usuario'])) {
    header("Location: ../login.php");
    exit();
}

require_once "../config/conexion.php";

// Obtener los últimos 5 libros
$sql = "SELECT titulo, autor FROM libros ORDER BY id DESC LIMIT 5";
$resultado = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <title>Panel Funcionario - Biblioteca</title>
    <link rel="stylesheet" href="/css/dashboard_funcionario.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<!-- Menú lateral -->
<div class="sidebar">
    <img src="/img/INSIGNIA SF.png" alt="Logo" class="logo" />
    <h2>Biblioteca - Escuela Porongo</h2>
    <a href="../controllers/lista_libros.php">Catálogo de Libros</a>
    <a href="../views/prestamos.php">Gestión de Préstamos</a>
    <a href="../views/historial.php">Historial de Préstamos</a>
    <a href="../controllers/registro_libros.php">Registro de Libros</a>
    <a href="../controllers/lista_usuarios.php">Visualizar Usuarios</a>
    <a href="/logout.php">Cerrar Sesión</a>
</div>

<!-- Contenido principal -->
<div class="main p-4">
    <h1>Bienvenido/a, <?php echo htmlspecialchars($_SESSION['nombre_usuario']); ?> 👋</h1>  

    <!-- Card catálogo -->
    <div class="card p-3 shadow-sm mb-4">
        <h3>Listado de Libros Disponibles</h3>
        <p>Consulta los últimos libros registrados para préstamo o referencia.</p>
        
        <div class="libros">
            <?php if ($resultado->num_rows > 0): ?>
                <ul class="list-group list-group-flush">
                    <?php while ($libro = $resultado->fetch_assoc()): ?>
                        <li class="list-group-item">
                            <?php echo htmlspecialchars($libro['titulo']); ?> - <?php echo htmlspecialchars($libro['autor']); ?>
                        </li>
                    <?php endwhile; ?>
                </ul>
            <?php else: ?>
                <p>No hay libros registrados actualmente.</p>
            <?php endif; ?>
        </div>

        <div class="mt-3">
            <a href="../controllers/lista_libros.php" class="btn btn-primary">📚 Ver más</a>
        </div>
    </div>

    <!-- Carrusel de imágenes -->
    <div class="carousel-wrapper mx-auto mb-4" style="max-width: 800px;">
        <div id="carouselLibros" class="carousel slide" data-bs-ride="carousel">
            <div class="carousel-indicators">
                <button type="button" data-bs-target="#carouselLibros" data-bs-slide-to="0" class="active"></button>
                <button type="button" data-bs-target="#carouselLibros" data-bs-slide-to="1"></button>
                <button type="button" data-bs-target="#carouselLibros" data-bs-slide-to="2"></button>
            </div>
            <div class="carousel-inner rounded shadow">
                <div class="carousel-item active">
                    <img src="/img/Bibiana_y_su_mundo.jpg" class="d-block w-100" alt="Imagen 1">
                </div>
                <div class="carousel-item">
                    <img src="/img/Cuentos_de_la_selva.jpg" class="d-block w-100" alt="Imagen 2">
                </div>
                <div class="carousel-item">
                    <img src="/img/El_gato_y_la_gaviota.jpg" class="d-block w-100" alt="Imagen 3">
                </div>
            </div>
            <button class="carousel-control-prev" type="button" data-bs-target="#carouselLibros" data-bs-slide="prev">
                <span class="carousel-control-prev-icon"></span>
            </button>
            <button class="carousel-control-next" type="button" data-bs-target="#carouselLibros" data-bs-slide="next">
                <span class="carousel-control-next-icon"></span>
            </button>
        </div>
    </div>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>