<?php 
session_start();

if (!isset($_SESSION['nombre_usuario'])) {
    header("Location: login.php");
    exit();
}

require_once "config/conexion.php";

// Obtener libros (limitado)
$sql = "SELECT id, titulo, autor FROM libros LIMIT 5";
$resultado = $conn->query($sql);

// Alerta para préstamos activos si es alumno
$alerta = "";

if ($_SESSION['id_rol'] == 3) {
    $usuario_id = $_SESSION['usuario_id'];
    $sql_prestamos = "
        SELECT l.estado, p.fecha_devolucion 
        FROM prestamos p
        LEFT JOIN libros l ON p.libro_id = l.id
        WHERE p.usuario_id = ? AND l.estado = 'prestado'
    ";
    $stmt = $conn->prepare($sql_prestamos);
    $stmt->bind_param("i", $usuario_id);
    $stmt->execute();
    $resultado_prestamos = $stmt->get_result();

    $hoy = new DateTime();
    while ($row = $resultado_prestamos->fetch_assoc()) {
        $fecha_devolucion = new DateTime($row['fecha_devolucion']);
        $dias_restantes = $hoy->diff($fecha_devolucion)->format('%r%a');

        if ((int)$dias_restantes >= 0) {
            $alerta .= "<li>📚 Te quedan <strong>$dias_restantes días</strong> para devolver un libro.</li>";
        } else {
            $alerta .= "<li>⚠️ Tienes un libro <strong>vencido</strong>.</li>";
        }
    }
}

// Últimos préstamos (opcional si lo usas más abajo)
$sql_ultimos_prestamos = "
    SELECT 
        p.usuario_id,
        COALESCE(a.nombre, u.nombre) AS nombre_usuario,
        c.nivel,
        c.seccion,
        l.titulo,
        p.fecha_prestamo,
        p.fecha_devolucion
    FROM prestamos p
    LEFT JOIN alumnos a ON p.usuario_id = a.id
    LEFT JOIN cursos c ON a.cursos_id = c.id
    LEFT JOIN usuarios u ON p.usuario_id = u.id
    LEFT JOIN libros l ON p.libro_id = l.id
    WHERE l.estado = 'prestado'
    ORDER BY p.fecha_prestamo DESC
    LIMIT 5
";
$resultado_prestamos_ultimos = $conn->query($sql_ultimos_prestamos);
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Gestión Biblioteca</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="css/dashboard_admin.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" />
</head>
<body>

<div class="sidebar">
    <img src="/img/INSIGNIA SF.png" alt="Logo" class="logo" />
    <h2>Biblioteca - Escuela Porongo</h2>

    <a href="views/prestamos.php">Préstamos</a>
    <a href="views/historial.php">Historial de Préstamos</a>
    <a href="controllers/registro_usuarios.php">Registro Usuarios/Alumnos</a>
    <a href="controllers/lista_libros.php">Lista de Libros</a>
    <a href="controllers/registro_libros.php">Registro de Libros Nuevos</a>
    <a href="logout.php">Cerrar Sesión</a>
</div>

<div class="main p-4">
    <h1 class="mb-4">Bienvenido, <?php echo $_SESSION['nombre_usuario']; ?> 👋</h1>  

    <!-- Catálogo de libros -->
    <div class="card p-3 shadow-sm mb-4">
        <h3>Catálogo de Libros</h3>
        <p>Explora el catálogo completo de libros disponibles en la biblioteca.</p>

        <div class="libros">
            <?php if ($resultado->num_rows > 0): ?>
                <ul class="list-group list-group-flush">
                    <?php while ($libro = $resultado->fetch_assoc()): ?>
                        <li class="list-group-item">
                            <?php echo htmlspecialchars($libro['titulo']); ?> - <?php echo htmlspecialchars($libro['autor']); ?>
                        </li>
                    <?php endwhile; ?>
                </ul>
                <a href="controllers/lista_libros.php" class="btn btn-primary mt-3">Ver más</a>
            <?php else: ?>
                <p>No hay libros disponibles.</p>
            <?php endif; ?>
        </div>
    </div>

    <!-- Carrusel de imágenes -->
    <div class="carousel-wrapper mx-auto mb-4" style="max-width: 800px;">
        <div id="carouselExampleIndicators" class="carousel slide" data-bs-ride="carousel">
            <div class="carousel-indicators">
                <button type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide-to="0" class="active"></button>
                <button type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide-to="1"></button>
                <button type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide-to="2"></button>
            </div>
            <div class="carousel-inner rounded shadow">
                <div class="carousel-item active">
                    <img src="img/Bibiana_y_su_mundo.jpg" class="d-block w-100" alt="Imagen 1">
                </div>
                <div class="carousel-item">
                    <img src="img/Cuentos_de_la_selva.jpg" class="d-block w-100" alt="Imagen 2">
                </div>
                <div class="carousel-item">
                    <img src="img/El_gato_y_la_gaviota.jpg" class="d-block w-100" alt="Imagen 3">
                </div>
            </div>
            <button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide="prev">
                <span class="carousel-control-prev-icon"></span>
            </button>
            <button class="carousel-control-next" type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide="next">
                <span class="carousel-control-next-icon"></span>
            </button>
        </div>
    </div>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>