<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once "../config/conexion.php";

$mensaje = "";

// Registrar nuevo usuario
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['action']) && $_POST['action'] == 'register') {
    $usuario = trim($_POST['nombre_usuario']);
    $rut = trim($_POST['rut_usuario']);
    $correo = trim($_POST['correo']);
    $clave = $_POST['contraseña'];
    $rol = $_POST['id_rol'];

    // Si el correo está vacío, se guarda como NULL
    $correo = $correo !== "" ? $correo : null;

    if (!empty($usuario) && !empty($clave) && !empty($rut) && is_numeric($rol)) {
        $clave_hash = password_hash($clave, PASSWORD_DEFAULT);

        // Verificar si el usuario ya existe por nombre o rut
        $sql_check = "SELECT id FROM usuarios WHERE nombre_usuario = ? OR rut_usuario = ?";
        $stmt_check = $conn->prepare($sql_check);
        $stmt_check->bind_param("ss", $usuario, $rut);
        $stmt_check->execute();
        $stmt_check->store_result();

        if ($stmt_check->num_rows > 0) {
            $mensaje = "⚠️ El nombre de usuario o RUT ya existe.";
        } else {
            // Insertar nuevo usuario (sin curso_id)
            $sql = "INSERT INTO usuarios (nombre_usuario, rut_usuario, correo, contraseña, id_rol) VALUES (?, ?, ?, ?, ?)";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("ssssi", $usuario, $rut, $correo, $clave_hash, $rol);

            if ($stmt->execute()) {
                header("Location: registro_usuarios.php?registro=ok");
                exit();
            } else {
                $mensaje = "❌ Error al registrar usuario.";
            }
        }

        $stmt_check->close();
    } else {
        $mensaje = "⚠️ Por favor, completa los campos obligatorios.";
    }
}

// Obtener usuarios registrados
$sql_usuarios = "SELECT * FROM usuarios";
$resultado = $conn->query($sql_usuarios);
$usuarios = $resultado->fetch_all(MYSQLI_ASSOC);

// Obtener cursos desde la base de datos (si lo necesitas en el futuro)
$sql_cursos = "SELECT * FROM cursos";
$resultado_cursos = $conn->query($sql_cursos);
$cursos = $resultado_cursos->fetch_all(MYSQLI_ASSOC);
?>


<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Registrar Usuario</title>
    <link rel="stylesheet" href="/css/registro_usuarios.css">
</head>
<body>

<div class="registro-container">
    <img src="/img/INSIGNIA SF.png" alt="Logo" class="logo">
    <h2>Registrar Nuevo Usuario</h2>

    <?php if ($mensaje): ?>
        <div class="mensaje"><?php echo $mensaje; ?></div>
    <?php endif; ?>

    <!-- Formulario de registro -->
    <form method="POST">
        <input type="hidden" name="action" value="register">

        <label for="rut_usuario">RUT del Usuario:</label>
        <input type="text" name="rut_usuario" id="rut_usuario" required>

        <label for="nombre_usuario">Nombre de Usuario:</label>
        <input type="text" name="nombre_usuario" id="nombre_usuario" required>

        <label for="correo">Correo Electrónico del Usuario (opcional):</label>
        <input type="email" name="correo" id="correo">

        <label for="contraseña">Contraseña:</label>
        <input type="password" name="contraseña" id="contraseña" required>

        <label for="id_rol">Rol:</label>
        <select name="id_rol" id="id_rol" required>
            <option value="">Selecciona un rol</option>
            <option value="1">Admin</option>
            <option value="2">Funcionario</option>
        </select>

        <button type="submit">Registrar Usuario</button>

        <div class="botones-container">
            <a href="../controllers/lista_usuarios.php" class="btn-ver-usuarios">👥 Usuarios Registrados</a>
            <a href="../controllers/registro_alumnos.php" class="btn-registar-alumnos">👤 Registrar Alumnos</a>
            <a href="../controllers/registro_docentes.php" class="btn-registar-alumnos">👤 Registrar Docentes</a>
            <a href="/index.php" class="volver-btn">🏠 Volver al Inicio</a>
        </div>
    </form>
</div>

<script src="/js/notificacion_registro.js"></script>

</body>
</html>