<?php
session_start();

require_once "../config/conexion.php";
require_once __DIR__ . '/../vendor/autoload.php'; // Autoload Composer

use PhpOffice\PhpSpreadsheet\IOFactory;

mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

$mensaje = "";

// Registro manual
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['action']) && $_POST['action'] == 'register') {
    $titulo = trim($_POST['titulo']);
    $autor = trim($_POST['autor']);
    $fecha_publicacion = $_POST['fecha_publicacion'];

    // Manejar imagen
    $imagen_nombre = null;
    if (!empty($_FILES['imagen']['name'])) {
        $nombre_tmp = $_FILES['imagen']['tmp_name'];
        $imagen_nombre = basename($_FILES['imagen']['name']);
        $destino = "../img/" . $imagen_nombre;

        if (!is_dir("../img")) {
            mkdir("../img", 0777, true);
        }

        move_uploaded_file($nombre_tmp, $destino);
    }

    if (!empty($titulo) && !empty($autor) && !empty($fecha_publicacion)) {
        $sql_check = "SELECT id FROM libros WHERE titulo = ? AND autor = ?";
        $stmt_check = $conn->prepare($sql_check);
        $stmt_check->bind_param("ss", $titulo, $autor);
        $stmt_check->execute();
        $stmt_check->store_result();

        if ($stmt_check->num_rows > 0) {
            $mensaje = "⚠️ El libro ya está registrado.";
        } else {
            // Para registro manual asumimos stock inicial 1 (o ajusta según prefieras)
            $stock = 1;
            $sql = "INSERT INTO libros (titulo, autor, fecha_publicacion, imagen, stock) VALUES (?, ?, ?, ?, ?)";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("ssssi", $titulo, $autor, $fecha_publicacion, $imagen_nombre, $stock);

            if ($stmt->execute()) {
                header("Location: registro_libros.php?registro=ok");
                exit();
            } else {
                $mensaje = "❌ Error al registrar el libro.";
            }
        }
        $stmt_check->close();
    } else {
        $mensaje = "⚠️ Por favor, completa todos los campos.";
    }
}

// Importación desde archivo Excel (sin imagen)
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['action']) && $_POST['action'] == 'import_excel' && isset($_FILES['excel_file']) && $_FILES['excel_file']['error'] == 0) {
    try {
        $archivoExcel = $_FILES['excel_file']['tmp_name'];
        $spreadsheet = IOFactory::load($archivoExcel);
        $hoja = $spreadsheet->getActiveSheet();
        $filas = $hoja->toArray();

        $importados = 0;

        foreach ($filas as $index => $fila) {
            // Saltar la fila de encabezado
            if ($index == 0 && strtolower(trim($fila[0])) == 'titulo') continue;

            $titulo = trim($fila[0] ?? '');
            $autor = trim($fila[1] ?? '');
            $fecha_raw = trim($fila[2] ?? '');
            $stock_excel = trim($fila[3] ?? '0');

            if ($titulo && $autor && $fecha_raw) {
                $fecha_publicacion = date('Y-m-d', strtotime($fecha_raw));

                // Validar stock: si no es numérico o menor a 0, poner 0
                $stock = (is_numeric($stock_excel) && (int)$stock_excel > 0) ? (int)$stock_excel : 0;

                // Buscar si libro ya existe
                $sql_check = "SELECT id, stock FROM libros WHERE titulo = ? AND autor = ?";
                $stmt_check = $conn->prepare($sql_check);
                $stmt_check->bind_param("ss", $titulo, $autor);
                $stmt_check->execute();
                $resultado_check = $stmt_check->get_result();

                if ($resultado_check->num_rows == 0) {
                    // No existe, insertar nuevo libro con stock
                    $sql_insert = "INSERT INTO libros (titulo, autor, fecha_publicacion, stock) VALUES (?, ?, ?, ?)";
                    $stmt_insert = $conn->prepare($sql_insert);
                    $stmt_insert->bind_param("sssi", $titulo, $autor, $fecha_publicacion, $stock);
                    if ($stmt_insert->execute()) {
                        $importados++;
                    }
                    $stmt_insert->close();
                } else {
                    // Existe, actualizar sumando stock
                    $row = $resultado_check->fetch_assoc();
                    $nuevo_stock = $row['stock'] + $stock;

                    $sql_update = "UPDATE libros SET stock = ? WHERE id = ?";
                    $stmt_update = $conn->prepare($sql_update);
                    $stmt_update->bind_param("ii", $nuevo_stock, $row['id']);
                    if ($stmt_update->execute()) {
                        $importados++;
                    }
                    $stmt_update->close();
                }
                $stmt_check->close();
            }
        }

        $mensaje = "✅ Se importaron y actualizaron $importados libros desde el archivo Excel.";
    } catch (Exception $e) {
        $mensaje = "❌ Error al procesar el archivo: " . $e->getMessage();
    }
}

// Obtener libros registrados
$sql_libros = "SELECT * FROM libros";
$resultado = $conn->query($sql_libros);
$libros = $resultado->fetch_all(MYSQLI_ASSOC);

// Definir URL para "Volver al Inicio" según rol
$volver_url = "/index.php"; // Por defecto
if (isset($_SESSION['id_rol'])) {
    if ($_SESSION['id_rol'] == 1) {
        $volver_url = "/index.php";
    } elseif ($_SESSION['id_rol'] == 2) {
        $volver_url = "/views/dashboard_funcionario.php";
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Registro de Libros</title>
    <link rel="stylesheet" href="/css/registro_libros.css">
</head>
<body>

<div class="registro-container">
    <img src="/img/INSIGNIA SF.png" alt="Logo" class="logo">
    <h2>Registrar Nuevo Libro</h2>

    <?php if ($mensaje): ?>
        <div class="mensaje"><?php echo htmlspecialchars($mensaje); ?></div>
    <?php endif; ?>

    <!-- Formulario para registrar manualmente -->
    <form method="POST" enctype="multipart/form-data">
        <input type="hidden" name="action" value="register">

        <label for="titulo">Título:</label>
        <input type="text" name="titulo" id="titulo" required>

        <label for="autor">Autor:</label>
        <input type="text" name="autor" id="autor" required>

        <label for="fecha_publicacion">Fecha de Publicación:</label>
        <input type="date" name="fecha_publicacion" id="fecha_publicacion" required>

        <label for="imagen">Imagen del Libro:</label>
        <input type="file" name="imagen" id="imagen" accept="image/*">

        <button type="submit">Registrar Libro</button>
    </form>

    <!-- Formulario separado para importar desde Excel -->
    <form method="POST" enctype="multipart/form-data" style="margin-top: 20px;">
        <input type="hidden" name="action" value="import_excel">

        <label for="excel_file">Importar desde archivo Excel:</label>
        <input type="file" name="excel_file" id="excel_file" accept=".xlsx, .xls" required>

        <button type="submit">📥 Importar Archivo</button>

        <p style="margin-top: 10px;">
            📄 ¿No tienes el formato? <a href="../files/Plantilla de Biblioteca.xlsx" download style="color: #2563eb; font-weight: 500;">Descargar Plantilla Excel</a>
        </p>
    </form>

    <div class="botones-container">
        <a href="<?php echo htmlspecialchars($volver_url); ?>" class="volver-btn">🏠 Volver al Inicio</a>
    </div>
</div>

<script src="../public/js/notificacion_registro.js"></script>

</body>
</html>